/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.VolumeDataInterface;

public class VolumeData
implements VolumeDataInterface {
    public final Point3f volumetricOrigin = new Point3f();
    public final float[] origin = new float[3];
    public final Vector3f[] volumetricVectors = new Vector3f[3];
    public final int[] voxelCounts = new int[3];
    public int nPoints;
    public float[][][] voxelData;
    public final float[] volumetricVectorLengths = new float[3];
    public final Vector3f[] unitVolumetricVectors = new Vector3f[3];
    private final Matrix3f volumetricMatrix = new Matrix3f();
    private Point4f thePlane;
    private float thePlaneNormalMag;
    private final Point3f ptXyzTemp = new Point3f();
    private final Vector3f pointVector = new Vector3f();

    public VolumeData() {
        this.volumetricVectors[0] = new Vector3f();
        this.volumetricVectors[1] = new Vector3f();
        this.volumetricVectors[2] = new Vector3f();
        this.unitVolumetricVectors[0] = new Vector3f();
        this.unitVolumetricVectors[1] = new Vector3f();
        this.unitVolumetricVectors[2] = new Vector3f();
    }

    public void setVolumetricOrigin(float x, float y, float z) {
        this.volumetricOrigin.set(x, y, z);
    }

    public float[] getOriginFloat() {
        return this.origin;
    }

    public float[] getVolumetricVectorLengths() {
        return this.volumetricVectorLengths;
    }

    public void setVolumetricVector(int i, float x, float y, float z) {
        this.volumetricVectors[i].x = x;
        this.volumetricVectors[i].y = y;
        this.volumetricVectors[i].z = z;
    }

    public int[] getVoxelCounts() {
        return this.voxelCounts;
    }

    public int setVoxelCounts(int nPointsX, int nPointsY, int nPointsZ) {
        this.voxelCounts[0] = nPointsX;
        this.voxelCounts[1] = nPointsY;
        this.voxelCounts[2] = nPointsZ;
        this.nPoints = nPointsX * nPointsY * nPointsZ;
        return this.nPoints;
    }

    public float[][][] getVoxelData() {
        return this.voxelData;
    }

    public void setVoxelData(float[][][] voxelData) {
        this.voxelData = voxelData;
    }

    public void setMatrix() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricMatrix.setColumn(i, this.volumetricVectors[i]);
        }
    }

    public void transform(Vector3f v1, Vector3f v2) {
        this.volumetricMatrix.transform(v1, v2);
    }

    public void setPlaneParameters(Point4f plane) {
        this.thePlane = plane;
        this.thePlaneNormalMag = new Vector3f(plane.x, plane.y, plane.z).length();
    }

    public float calcVoxelPlaneDistance(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
        return (this.thePlane.x * this.ptXyzTemp.x + this.thePlane.y * this.ptXyzTemp.y + this.thePlane.z * this.ptXyzTemp.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public float distancePointToPlane(Point3f pt) {
        return (this.thePlane.x * pt.x + this.thePlane.y * pt.y + this.thePlane.z * pt.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public void voxelPtToXYZ(int x, int y, int z, Point3f pt) {
        pt.scaleAdd(x, this.volumetricVectors[0], this.volumetricOrigin);
        pt.scaleAdd(y, this.volumetricVectors[1], pt);
        pt.scaleAdd(z, this.volumetricVectors[2], pt);
    }

    public void setUnitVectors() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            this.unitVolumetricVectors[i].normalize(this.volumetricVectors[i]);
        }
        this.origin[0] = this.volumetricOrigin.x;
        this.origin[1] = this.volumetricOrigin.y;
        this.origin[2] = this.volumetricOrigin.z;
    }

    private float scaleByVoxelVector(Vector3f vector, int voxelVectorIndex) {
        return vector.dot(this.unitVolumetricVectors[voxelVectorIndex]) / this.volumetricVectorLengths[voxelVectorIndex];
    }

    public void xyzToVoxelPt(float x, float y, float z, Point3i pt3i) {
        this.pointVector.set(x, y, z);
        this.setVoxelPoint();
        pt3i.set((int)this.ptXyzTemp.x, (int)this.ptXyzTemp.y, (int)this.ptXyzTemp.z);
    }

    private void setVoxelPoint() {
        this.pointVector.sub(this.volumetricOrigin);
        this.ptXyzTemp.x = this.scaleByVoxelVector(this.pointVector, 0);
        this.ptXyzTemp.y = this.scaleByVoxelVector(this.pointVector, 1);
        this.ptXyzTemp.z = this.scaleByVoxelVector(this.pointVector, 2);
    }

    public float lookupInterpolatedVoxelValue(Point3f point) {
        this.pointVector.set(point);
        this.setVoxelPoint();
        return this.getInterpolatedVoxelValue(this.ptXyzTemp);
    }

    private float getInterpolatedVoxelValue(Point3f pt) {
        int iMax = this.voxelCounts[0] - 1;
        int xDown = VolumeData.indexDown(pt.x, iMax);
        int xUp = xDown + (pt.x < 0.0f || xDown == iMax ? 0 : 1);
        iMax = this.voxelCounts[1] - 1;
        int yDown = VolumeData.indexDown(pt.y, iMax);
        int yUp = yDown + (pt.y < 0.0f || yDown == iMax ? 0 : 1);
        iMax = this.voxelCounts[2] - 1;
        int zDown = VolumeData.indexDown(pt.z, iMax);
        int zUp = zDown + (pt.z < 0.0f || zDown == iMax ? 0 : 1);
        float v1 = VolumeData.getFractional2DValue(pt.x - (float)xDown, pt.y - (float)yDown, this.voxelData[xDown][yDown][zDown], this.voxelData[xUp][yDown][zDown], this.voxelData[xDown][yUp][zDown], this.voxelData[xUp][yUp][zDown]);
        float v2 = VolumeData.getFractional2DValue(pt.x - (float)xDown, pt.y - (float)yDown, this.voxelData[xDown][yDown][zUp], this.voxelData[xUp][yDown][zUp], this.voxelData[xDown][yUp][zUp], this.voxelData[xUp][yUp][zUp]);
        return v1 + (pt.z - (float)zDown) * (v2 - v1);
    }

    public static float getFractional2DValue(float fx, float fy, float x11, float x12, float x21, float x22) {
        float v1 = x11 + fx * (x12 - x11);
        float v2 = x21 + fx * (x22 - x21);
        return v1 + fy * (v2 - v1);
    }

    private static int indexDown(float value, int iMax) {
        if (value < 0.0f) {
            return 0;
        }
        int floor = (int)value;
        return floor > iMax ? iMax : floor;
    }

    void offsetCenter(Point3f center) {
        Point3f pt = new Point3f();
        pt.scaleAdd((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], pt);
        pt.scaleAdd((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], pt);
        pt.scaleAdd((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], pt);
        this.volumetricOrigin.sub(center, pt);
    }

    public void setDataDistanceToPlane(Point4f plane) {
        this.setPlaneParameters(plane);
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        this.voxelData = new float[nx][ny][nz];
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                for (int z = 0; z < nz; ++z) {
                    this.voxelData[x][y][z] = this.calcVoxelPlaneDistance(x, y, z);
                }
            }
        }
    }

    public void filterData(boolean isSquared, float invertCutoff) {
        int z;
        int y;
        int x;
        boolean doInvert = !Float.isNaN(invertCutoff);
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        if (isSquared) {
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        this.voxelData[x][y][z] = this.voxelData[x][y][z] * this.voxelData[x][y][z];
                    }
                }
            }
        }
        if (doInvert) {
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        this.voxelData[x][y][z] = invertCutoff - this.voxelData[x][y][z];
                    }
                }
            }
        }
    }

    public void capData(Point4f plane, float cutoff) {
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        Vector3f normal = new Vector3f(plane.x, plane.y, plane.z);
        normal.normalize();
        float f = 1.0f;
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                for (int z = 0; z < nz; ++z) {
                    float value = this.voxelData[x][y][z] - cutoff;
                    this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
                    float d = (this.ptXyzTemp.x * normal.x + this.ptXyzTemp.y * normal.y + this.ptXyzTemp.z * normal.z + plane.w - cutoff) / f;
                    if (!(d >= 0.0f) && !(d > value)) continue;
                    this.voxelData[x][y][z] = d;
                }
            }
        }
    }
}

