/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Date;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

abstract class AtomDataReader
extends VolumeDataReader {
    protected AtomDataServer atomDataServer;
    protected String fileName;
    protected String fileDotModel;
    protected int modelIndex;
    protected AtomData atomData = new AtomData();
    protected Point3f[] atomXyz;
    protected float[] atomRadius;
    protected float[] atomProp;
    protected int[] atomNo;
    protected int[] atomIndex;
    protected int[] myIndex;
    protected int atomCount;
    protected int myAtomCount;
    protected int nearbyAtomCount;
    protected int firstNearbyAtom;
    protected BitSet bsMySelected;
    protected BitSet bsMyIgnored;
    private Point3f xyzMin;
    private Point3f xyzMax;
    protected boolean doAddHydrogens;
    protected boolean doUsePlane;
    protected boolean doUseIterator;

    AtomDataReader(SurfaceGenerator sg) {
        super(sg);
        this.precalculateVoxelData = true;
        this.atomDataServer = sg.getAtomDataServer();
    }

    protected void setup() {
        this.params.iUseBitSets = true;
        this.doAddHydrogens = this.atomDataServer != null && this.params.addHydrogens;
        this.modelIndex = this.params.modelIndex;
        this.xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.bsMySelected = new BitSet();
        this.bsMyIgnored = this.params.bsIgnore == null ? new BitSet() : this.params.bsIgnore;
        boolean bl = this.doUsePlane = this.params.thePlane != null;
        if (this.doUsePlane) {
            this.volumeData.setPlaneParameters(this.params.thePlane);
        }
    }

    protected void getAtoms(float marginAtoms, boolean doGetAllAtoms, boolean addNearbyAtoms) {
        int i;
        this.atomData.useIonic = this.params.useIonic;
        this.atomData.modelIndex = this.modelIndex;
        this.atomData.bsSelected = this.doUseIterator ? null : this.params.bsSelected;
        this.atomData.bsIgnored = this.bsMyIgnored;
        this.atomDataServer.fillAtomData(this.atomData, 2);
        this.atomCount = this.atomData.atomCount;
        this.modelIndex = this.atomData.firstModelIndex;
        int nSelected = 0;
        boolean needRadius = false;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            if ((this.params.bsSelected == null || this.params.bsSelected.get(i2)) && !this.bsMyIgnored.get(i2)) {
                if (this.doUsePlane) {
                    float f;
                    this.atomData.atomRadius[i2] = this.getWorkingRadius(i2, marginAtoms);
                    if (Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[i2])) > 2.0f * f) continue;
                }
                this.bsMySelected.set(i2);
                ++nSelected;
                boolean bl = needRadius = !this.doUsePlane;
            }
            if (!addNearbyAtoms && !needRadius) continue;
            this.atomData.atomRadius[i2] = this.getWorkingRadius(i2, marginAtoms);
        }
        float rH = this.doAddHydrogens ? this.getWorkingRadius(-1, marginAtoms) : 0.0f;
        BitSet atomSet = new BitSet();
        int firstSet = -1;
        int lastSet = 0;
        this.myAtomCount = 0;
        for (int i3 = 0; i3 < this.atomCount; ++i3) {
            if (!this.bsMySelected.get(i3)) continue;
            ++this.myAtomCount;
            atomSet.set(i3);
            if (firstSet == -1) {
                firstSet = i3;
            }
            lastSet = i3;
        }
        int nH = 0;
        this.atomProp = null;
        if (this.myAtomCount > 0) {
            Point3f[] hAtoms = null;
            if (this.doAddHydrogens) {
                this.atomData.bsSelected = atomSet;
                this.atomDataServer.fillAtomData(this.atomData, 3);
                nH = this.atomData.hydrogenAtomCount;
                hAtoms = new Point3f[nH];
                for (int i4 = 0; i4 < this.atomData.hAtoms.length; ++i4) {
                    if (this.atomData.hAtoms[i4] == null) continue;
                    int j = this.atomData.hAtoms[i4].length;
                    while (--j >= 0) {
                        hAtoms[--nH] = this.atomData.hAtoms[i4][j];
                    }
                }
                nH = hAtoms.length;
                Logger.info(nH + " attached hydrogens added");
            }
            int n = nH + this.myAtomCount;
            this.atomRadius = new float[n];
            this.atomXyz = new Point3f[n];
            if (this.params.theProperty != null) {
                this.atomProp = new float[n];
            }
            this.atomNo = new int[n];
            if (this.doUseIterator) {
                this.atomIndex = new int[n];
                this.myIndex = new int[this.atomCount];
            }
            for (int i5 = 0; i5 < nH; ++i5) {
                this.atomRadius[i5] = rH;
                this.atomXyz[i5] = hAtoms[i5];
                this.atomNo[i5] = -1;
                if (this.atomProp == null) continue;
                this.atomProp[i5] = Float.NaN;
            }
            this.myAtomCount = nH;
            float[] props = this.params.theProperty;
            for (i = firstSet; i <= lastSet; ++i) {
                if (!atomSet.get(i)) continue;
                if (this.atomProp != null) {
                    this.atomProp[this.myAtomCount] = props != null && i < props.length ? props[i] : Float.NaN;
                }
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[i];
                this.atomNo[this.myAtomCount] = this.atomData.atomicNumber[i];
                if (this.doUseIterator) {
                    this.atomIndex[this.myAtomCount] = i;
                    this.myIndex[i] = this.myAtomCount;
                }
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[i];
            }
        }
        this.firstNearbyAtom = this.myAtomCount;
        Logger.info(this.myAtomCount + " atoms will be used in the surface calculation");
        for (int i6 = 0; i6 < this.myAtomCount; ++i6) {
            Point3f pt = this.atomXyz[i6];
            float rA = this.atomRadius[i6];
            if (pt.x - rA < this.xyzMin.x) {
                this.xyzMin.x = pt.x - rA;
            }
            if (pt.x + rA > this.xyzMax.x) {
                this.xyzMax.x = pt.x + rA;
            }
            if (pt.y - rA < this.xyzMin.y) {
                this.xyzMin.y = pt.y - rA;
            }
            if (pt.y + rA > this.xyzMax.y) {
                this.xyzMax.y = pt.y + rA;
            }
            if (pt.z - rA < this.xyzMin.z) {
                this.xyzMin.z = pt.z - rA;
            }
            if (!(pt.z + rA > this.xyzMax.z)) continue;
            this.xyzMax.z = pt.z + rA;
        }
        Logger.info("surface range " + this.xyzMin + " to " + this.xyzMax);
        if (!Float.isNaN(this.params.scale)) {
            Vector3f v = new Vector3f(this.xyzMax);
            v.sub(this.xyzMin);
            v.scale(0.5f);
            this.xyzMin.add(v);
            v.scale(this.params.scale);
            this.xyzMax.set(this.xyzMin);
            this.xyzMax.add(v);
            this.xyzMin.sub(v);
        }
        if (!addNearbyAtoms) {
            return;
        }
        Point3f pt = new Point3f();
        BitSet bsNearby = new BitSet();
        firstSet = -1;
        lastSet = 0;
        for (int i7 = 0; i7 < this.atomCount; ++i7) {
            if (atomSet.get(i7) || this.bsMyIgnored.get(i7)) continue;
            float rA = this.atomData.atomRadius[i7];
            if (this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[i7])) > 2.0f * rA) continue;
            pt = this.atomData.atomXyz[i7];
            if (!(pt.x + rA > this.xyzMin.x) || !(pt.x - rA < this.xyzMax.x) || !(pt.y + rA > this.xyzMin.y) || !(pt.y - rA < this.xyzMax.y) || !(pt.z + rA > this.xyzMin.z) || !(pt.z - rA < this.xyzMax.z)) continue;
            if (firstSet == -1) {
                firstSet = i7;
            }
            lastSet = i7;
            bsNearby.set(i7);
            ++this.nearbyAtomCount;
        }
        int nAtoms = this.myAtomCount;
        if (this.nearbyAtomCount != 0) {
            this.atomRadius = ArrayUtil.setLength(this.atomRadius, nAtoms += this.nearbyAtomCount);
            this.atomXyz = (Point3f[])ArrayUtil.setLength(this.atomXyz, nAtoms);
            for (i = firstSet; i <= lastSet; ++i) {
                if (!bsNearby.get(i)) continue;
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[i];
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[i];
            }
        }
    }

    private float getWorkingRadius(int i, float marginAtoms) {
        if (!Float.isNaN(marginAtoms)) {
            return (i < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[i]) + marginAtoms;
        }
        float r = this.params.solventAtomRadiusAbsolute > 0.0f ? this.params.solventAtomRadiusAbsolute : (i < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[i]);
        r *= this.params.solventAtomRadiusFactor;
        if ((double)(r += this.params.solventExtendedAtomRadius + this.params.solventAtomRadiusOffset) < 0.1) {
            r = 0.1f;
        }
        return r;
    }

    protected void setHeader(String calcType, String line2) {
        Logger.info(calcType + " range " + this.xyzMin + " to " + this.xyzMax);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        if (this.atomData.programInfo != null) {
            this.jvxlFileHeaderBuffer.append("#created by ").append(this.atomData.programInfo).append(" on ").append(new Date()).append("\n");
        }
        this.jvxlFileHeaderBuffer.append(calcType).append(" range ").append(this.xyzMin).append(" to ").append(this.xyzMax).append("\n").append(line2).append("\n");
    }

    protected void setRangesAndAddAtoms(float ptsPerAngstrom, int maxGrid, int nWritten) {
        this.setVoxelRange(0, this.xyzMin.x, this.xyzMax.x, ptsPerAngstrom, maxGrid);
        this.setVoxelRange(1, this.xyzMin.y, this.xyzMax.y, ptsPerAngstrom, maxGrid);
        this.setVoxelRange(2, this.xyzMin.z, this.xyzMax.z, ptsPerAngstrom, maxGrid);
        JvxlReader.jvxlCreateHeader(this.volumeData, nWritten, this.atomXyz, this.atomNo, this.jvxlFileHeaderBuffer);
    }

    protected boolean fixTitleLine(int iLine) {
        if (this.params.title == null) {
            return false;
        }
        String line = this.params.title[iLine];
        if (line.indexOf("%F") > 0) {
            line = this.params.title[iLine] = TextFormat.formatString(line, "F", this.atomData.fileName);
        }
        if (line.indexOf("%M") > 0) {
            this.params.title[iLine] = TextFormat.formatString(line, "M", this.atomData.modelName);
        }
        return true;
    }
}

