/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.Interface;
import org.jmol.api.MOCalculationInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class IsoMOReader
extends AtomDataReader {
    IsoMOReader(SurfaceGenerator sg) {
        super(sg);
    }

    protected void setup() {
        super.setup();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.qm_marginAngstroms, true, false);
        this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        this.setRangesAndAddAtoms(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, this.myAtomCount);
        int i = this.params.title.length;
        while (--i >= 0) {
            this.fixTitleLine(i, this.params.mo);
        }
    }

    private void fixTitleLine(int iLine, Hashtable mo) {
        if (!this.fixTitleLine(iLine)) {
            return;
        }
        String line = this.params.title[iLine];
        int pt = line.indexOf("%");
        if (line.length() == 0 || pt < 0) {
            return;
        }
        int rep = 0;
        if (line.indexOf("%F") >= 0) {
            line = TextFormat.formatString(line, "F", this.params.fileName);
        }
        if (line.indexOf("%I") >= 0) {
            line = TextFormat.formatString(line, "I", "" + this.params.qm_moNumber);
        }
        if (line.indexOf("%N") >= 0) {
            line = TextFormat.formatString(line, "N", "" + this.params.qmOrbitalCount);
        }
        if (line.indexOf("%E") >= 0) {
            line = TextFormat.formatString(line, "E", "" + mo.get("energy"));
        }
        if (line.indexOf("%U") >= 0) {
            line = TextFormat.formatString(line, "U", this.params.moData.containsKey("energyUnits") && ++rep != 0 ? (String)this.params.moData.get("energyUnits") : "");
        }
        if (line.indexOf("%S") >= 0) {
            line = TextFormat.formatString(line, "S", mo.containsKey("symmetry") && ++rep != 0 ? "" + mo.get("symmetry") : "");
        }
        if (line.indexOf("%O") >= 0) {
            line = TextFormat.formatString(line, "O", mo.containsKey("occupancy") && ++rep != 0 ? "" + mo.get("occupancy") : "");
        }
        if (line.indexOf("%T") >= 0) {
            line = TextFormat.formatString(line, "T", mo.containsKey("type") && ++rep != 0 ? "" + mo.get("type") : "");
        }
        boolean isOptional = line.indexOf("?") == 0;
        this.params.title[iLine] = !isOptional ? line : (rep > 0 ? line.substring(1) : "");
    }

    protected void generateCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.voxelData = this.voxelData;
        MOCalculationInterface q = (MOCalculationInterface)Interface.getOptionInterface("quantum.MOCalculation");
        Hashtable moData = this.params.moData;
        float[] coef = this.params.moCoefficients;
        if (coef == null) {
            Vector mos = (Vector)moData.get("mos");
            int i = this.params.qm_moNumber;
            while (--i >= 0) {
                Logger.info(" generating isosurface data for MO " + (i + 1));
                Hashtable mo = (Hashtable)mos.get(i);
                coef = (float[])mo.get("coefficients");
                this.getData(q, moData, coef, this.params.theProperty);
            }
        } else {
            this.getData(q, moData, coef, null);
        }
    }

    private void getData(MOCalculationInterface q, Hashtable moData, float[] coef, float[] nuclearCharges) {
        switch (this.params.qmOrbitalType) {
            case 1: {
                q.calculate(this.volumeData, this.bsMySelected, (String)moData.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, (Vector)moData.get("shells"), (float[][])moData.get("gaussians"), (Hashtable)moData.get("atomicOrbitalOrder"), null, null, coef, nuclearCharges);
                break;
            }
            case 2: {
                q.calculate(this.volumeData, this.bsMySelected, (String)moData.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, null, null, null, (int[][])moData.get("slaterInfo"), (float[][])moData.get("slaterData"), coef, nuclearCharges);
                break;
            }
        }
    }
}

