/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;

class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private float psi_Znuc = 1.0f;
    private float sphere_radiusAngstroms;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private static final double A0 = (double)0.52918f;
    private static final double ROOT2 = 1.414214;
    private float radius;
    private float ppa;
    private int maxGrid;
    private static final float[] fact = new float[20];
    private final Point3f ptPsi = new Point3f();

    IsoShapeReader(SurfaceGenerator sg, float radius) {
        super(sg);
        this.sphere_radiusAngstroms = radius;
    }

    IsoShapeReader(SurfaceGenerator sg, int n, int l, int m, float z_eff) {
        super(sg);
        this.psi_n = n;
        this.psi_l = l;
        this.psi_m = m;
        this.psi_Znuc = z_eff;
        this.sphere_radiusAngstroms = 0.0f;
    }

    protected void setup() {
        this.precalculateVoxelData = false;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        String type = "sphere";
        switch (this.dataType) {
            case 14: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.radius = this.autoScaleOrbital();
                this.ppa = 5.0f;
                this.maxGrid = 40;
                type = "hydrogen-like orbital";
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.radius = 1.1f * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
                    this.radius /= this.eccentricityScale;
                }
                this.ppa = 10.0f;
                this.maxGrid = 21;
                type = "lobe";
                break;
            }
            case 67: {
                type = "ellipsoid(thermal)";
                this.radius = 3.0f * this.sphere_radiusAngstroms;
                this.ppa = 10.0f;
                this.maxGrid = 22;
                break;
            }
            case 66: {
                type = "ellipsoid";
            }
            default: {
                this.radius = 1.2f * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ppa = 10.0f;
                this.maxGrid = 22;
            }
        }
        this.setVoxelRange(0, -this.radius, this.radius, this.ppa, this.maxGrid);
        this.setVoxelRange(1, -this.radius, this.radius, this.ppa, this.maxGrid);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ppa, this.maxGrid);
        } else {
            this.setVoxelRange(2, 0.0f, this.radius / this.eccentricityRatio, this.ppa, this.maxGrid);
        }
        this.setHeader(type + "\n");
    }

    public float getValue(int x, int y, int z) {
        this.volumeData.voxelPtToXYZ(x, y, z, this.ptPsi);
        this.ptPsi.sub(this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.transform(this.ptPsi);
        }
        if (this.isAnisotropic) {
            this.ptPsi.x /= this.anisotropy[0];
            this.ptPsi.y /= this.anisotropy[1];
            this.ptPsi.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0f) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptPsi.x * this.ptPsi.x + this.ptPsi.y * this.ptPsi.y + this.ptPsi.z * this.ptPsi.z) / (float)Math.sqrt(this.params.anisoB[0] * this.ptPsi.x * this.ptPsi.x + this.params.anisoB[1] * this.ptPsi.y * this.ptPsi.y + this.params.anisoB[2] * this.ptPsi.z * this.ptPsi.z + this.params.anisoB[3] * this.ptPsi.x * this.ptPsi.y + this.params.anisoB[4] * this.ptPsi.x * this.ptPsi.z + this.params.anisoB[5] * this.ptPsi.y * this.ptPsi.z);
            }
            return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptPsi.x * this.ptPsi.x + this.ptPsi.y * this.ptPsi.y + this.ptPsi.z * this.ptPsi.z);
        }
        float value = (float)this.hydrogenAtomPsiAt(this.ptPsi, this.psi_n, this.psi_l, this.psi_m);
        return this.allowNegative || value >= 0.0f ? value : 0.0f;
    }

    private void setHeader(String line1) {
        this.jvxlFileHeaderBuffer = new StringBuffer(line1);
        if (this.sphere_radiusAngstroms > 0.0f) {
            this.jvxlFileHeaderBuffer.append(" rad=").append(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").append(this.psi_n).append(", l=").append(this.psi_l).append(", m=").append(this.psi_m).append(" Znuc=").append(this.psi_Znuc).append(" res=").append(this.ppa).append(" rad=").append(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private float autoScaleOrbital() {
        float w = ((float)(this.psi_n * (this.psi_n + 3)) - 5.0f) / this.psi_Znuc;
        if (w < 1.0f) {
            w = 1.0f;
        }
        if (this.psi_n < 3) {
            w += 1.0f;
        }
        float aMax = 0.0f;
        if (!this.isAnisotropic) {
            return w;
        }
        int i = 3;
        while (--i >= 0) {
            if (!(this.anisotropy[i] > aMax)) continue;
            aMax = this.anisotropy[i];
        }
        return w * aMax;
    }

    private void calcFactors(int n, int el, int m) {
        int p;
        int abm = Math.abs(m);
        double Nnl = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / (double)0.52918f, 1.5) * Math.sqrt((double)(fact[n - el - 1] / 2.0f / (float)n) / Math.pow(fact[n + el], 3.0));
        double Lnl = fact[n + el] * fact[n + el];
        double Plm = Math.pow(2.0, -el) * (double)fact[el] * (double)fact[el + abm] * Math.sqrt((float)(2 * el + 1) * fact[el - abm] / 2.0f / fact[el + abm]);
        for (p = 0; p <= n - el - 1; ++p) {
            this.rfactor[p] = Nnl * Lnl / (double)fact[p] / (double)fact[n - el - p - 1] / (double)fact[2 * el + p + 1];
        }
        for (p = abm; p <= el; ++p) {
            this.pfactor[p] = Math.pow(-1.0, el - p) * Plm / (double)fact[p] / (double)fact[el + abm - p] / (double)fact[el - p] / (double)fact[p - abm];
        }
    }

    private double hydrogenAtomPsiAt(Point3f pt, int n, int el, int m) {
        int abm = Math.abs(m);
        double x2y2 = pt.x * pt.x + pt.y * pt.y;
        double r2 = x2y2 + (double)(pt.z * pt.z);
        double r = Math.sqrt(r2);
        double rho = 2.0 * (double)this.psi_Znuc * r / (double)n / (double)0.52918f;
        double theta_lm = 0.0;
        double phi_m = 0.0;
        double sum = 0.0;
        for (int p = 0; p <= n - el - 1; ++p) {
            sum += Math.pow(-rho, p) * this.rfactor[p];
        }
        double rnl = Math.exp(-rho / 2.0) * Math.pow(rho, el) * sum;
        double ph = Math.atan2(pt.y, pt.x);
        double th = Math.atan2(Math.sqrt(x2y2), pt.z);
        double cth = Math.cos(th);
        double sth = Math.sin(th);
        sum = 0.0;
        for (int p = abm; p <= el; ++p) {
            sum += Math.pow(1.0 + cth, p - abm) * Math.pow(1.0 - cth, el - p) * this.pfactor[p];
        }
        theta_lm = Math.abs(Math.pow(sth, abm)) * sum;
        phi_m = m == 0 ? 1.0 : (m > 0 ? Math.cos((double)m * ph) * 1.414214 : Math.sin((double)(-m) * ph) * 1.414214);
        if (Math.abs(phi_m) < 1.0E-10) {
            phi_m = 0.0;
        }
        return rnl * theta_lm * phi_m;
    }

    static {
        IsoShapeReader.fact[0] = 1.0f;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (float)i;
        }
    }
}

