/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

class MrcBinaryReader
extends VolumeFileReader {
    MrcHeader mrcHeader;
    byte[] b2 = new byte[2];
    byte[] b4 = new byte[4];

    MrcBinaryReader(SurfaceGenerator sg, String fileName, boolean isBigEndian) {
        super(sg, null);
        this.binarydoc = new BinaryDocument();
        this.binarydoc.setStream(sg.getAtomDataServer().getBufferedInputStream(fileName), isBigEndian);
        this.jvxlData.wasCubic = true;
        this.mrcHeader = new MrcHeader();
        this.canDownsample = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(this.mrcHeader.labels[0]).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
        this.isAngstroms = true;
    }

    protected void readAtomCountAndOrigin() {
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, "0", "0 " + -this.mrcHeader.originX + " " + -this.mrcHeader.originY + " " + -this.mrcHeader.originZ, this.jvxlFileHeaderBuffer);
        this.volumetricOrigin.set(-this.mrcHeader.originX, -this.mrcHeader.originY, -this.mrcHeader.originZ);
    }

    protected void readVoxelVector(int voxelVectorIndex) {
        switch (voxelVectorIndex) {
            case 0: {
                this.voxelCounts[this.mrcHeader.maps - 1] = this.mrcHeader.nx;
                this.volumetricVectors[this.mrcHeader.maps - 1].set(this.mrcHeader.a / (float)this.mrcHeader.mx, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.voxelCounts[this.mrcHeader.mapr - 1] = this.mrcHeader.ny;
                this.volumetricVectors[this.mrcHeader.mapr - 1].set(0.0f, this.mrcHeader.b / (float)this.mrcHeader.my, 0.0f);
                break;
            }
            case 2: {
                this.voxelCounts[this.mrcHeader.mapc - 1] = this.mrcHeader.nz;
                this.volumetricVectors[this.mrcHeader.mapc - 1].set(0.0f, 0.0f, this.mrcHeader.c / (float)this.mrcHeader.mz);
            }
        }
    }

    protected float nextVoxel() throws Exception {
        float voxelValue;
        switch (this.mrcHeader.mode) {
            case 0: {
                voxelValue = this.binarydoc.readByte();
                ++this.nBytes;
                break;
            }
            case 1: {
                voxelValue = this.binarydoc.readShort();
                this.nBytes += 2;
                break;
            }
            case 3: {
                voxelValue = this.binarydoc.readShort();
                this.binarydoc.readShort();
                this.nBytes += 4;
                break;
            }
            case 4: {
                voxelValue = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                this.nBytes += 8;
                break;
            }
            case 6: {
                voxelValue = this.binarydoc.readUnsignedShort();
                this.nBytes += 2;
                break;
            }
            default: {
                voxelValue = this.binarydoc.readFloat();
                this.nBytes += 4;
            }
        }
        return voxelValue;
    }

    protected void skipData(int nPoints) throws Exception {
        block5: for (int i = 0; i < nPoints; ++i) {
            switch (this.mrcHeader.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(this.b2);
                    continue block5;
                }
                case 4: {
                    this.binarydoc.readByteArray(this.b4);
                    this.binarydoc.readByteArray(this.b4);
                    continue block5;
                }
                default: {
                    this.binarydoc.readByteArray(this.b4);
                }
            }
        }
    }

    private class MrcHeader {
        int nx;
        int ny;
        int nz;
        int mode;
        int nxStart;
        int nyStart;
        int nzStart;
        int mx;
        int my;
        int mz;
        float a;
        float b;
        float c;
        float alpha;
        float beta;
        float gamma;
        int mapc;
        int mapr;
        int maps;
        float dmin;
        float dmax;
        float dmean;
        int ispg;
        int nsymbt;
        byte[] extra = new byte[100];
        float originX;
        float originY;
        float originZ;
        byte[] map = new byte[4];
        byte[] machst = new byte[4];
        float rms;
        int nlabel;
        String[] labels = new String[10];
        SymmetryInterface unitCell;

        MrcHeader() {
            try {
                this.nx = MrcBinaryReader.this.binarydoc.readInt();
                this.ny = MrcBinaryReader.this.binarydoc.readInt();
                this.nz = MrcBinaryReader.this.binarydoc.readInt();
                this.mode = MrcBinaryReader.this.binarydoc.readInt();
                this.nxStart = MrcBinaryReader.this.binarydoc.readInt();
                this.nyStart = MrcBinaryReader.this.binarydoc.readInt();
                this.nzStart = MrcBinaryReader.this.binarydoc.readInt();
                this.mx = MrcBinaryReader.this.binarydoc.readInt();
                this.my = MrcBinaryReader.this.binarydoc.readInt();
                this.mz = MrcBinaryReader.this.binarydoc.readInt();
                this.a = MrcBinaryReader.this.binarydoc.readFloat();
                this.b = MrcBinaryReader.this.binarydoc.readFloat();
                this.c = MrcBinaryReader.this.binarydoc.readFloat();
                this.alpha = MrcBinaryReader.this.binarydoc.readFloat();
                this.beta = MrcBinaryReader.this.binarydoc.readFloat();
                this.gamma = MrcBinaryReader.this.binarydoc.readFloat();
                this.unitCell = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                this.unitCell.setUnitCell(new float[]{this.a, this.b, this.c, this.alpha, this.beta, this.gamma});
                this.mapc = MrcBinaryReader.this.binarydoc.readInt();
                this.mapr = MrcBinaryReader.this.binarydoc.readInt();
                this.maps = MrcBinaryReader.this.binarydoc.readInt();
                this.dmin = MrcBinaryReader.this.binarydoc.readFloat();
                this.dmax = MrcBinaryReader.this.binarydoc.readFloat();
                this.dmean = MrcBinaryReader.this.binarydoc.readFloat();
                this.ispg = MrcBinaryReader.this.binarydoc.readInt();
                this.nsymbt = MrcBinaryReader.this.binarydoc.readInt();
                MrcBinaryReader.this.binarydoc.readByteArray(this.extra);
                this.originX = MrcBinaryReader.this.binarydoc.readFloat();
                this.originY = MrcBinaryReader.this.binarydoc.readFloat();
                this.originZ = MrcBinaryReader.this.binarydoc.readFloat();
                MrcBinaryReader.this.binarydoc.readByteArray(this.map);
                MrcBinaryReader.this.binarydoc.readByteArray(this.machst);
                this.rms = MrcBinaryReader.this.binarydoc.readFloat();
                this.nlabel = MrcBinaryReader.this.binarydoc.readInt();
                byte[] temp = new byte[80];
                for (int i = 0; i < 10; ++i) {
                    MrcBinaryReader.this.binarydoc.readByteArray(temp);
                    StringBuffer s = new StringBuffer();
                    for (int j = 0; j < 80; ++j) {
                        s.append((char)temp[j]);
                    }
                    this.labels[i] = s.toString().trim();
                }
            }
            catch (Exception e) {
                Logger.error("Error reading " + MrcBinaryReader.this.sg.getParams().fileName + " " + e.getMessage());
            }
        }
    }
}

