/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class ObjReader
extends PolygonFileReader {
    private int nPolygons;
    String pmeshError;
    Point3f pt = new Point3f();

    ObjReader(SurfaceGenerator sg, String fileName, BufferedReader br) {
        super(sg, br);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("pmesh file format\nvertices and triangles only\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    void getSurfaceData() throws Exception {
        if (this.readPmesh()) {
            Logger.info("obj file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading obj data " : this.pmeshError));
        }
    }

    private boolean readPmesh() {
        block3: {
            try {
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception e) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = "pmesh ERROR: " + e;
            }
        }
        return false;
    }

    private boolean readVertices() throws Exception {
        this.pmeshError = "pmesh ERROR: invalid vertex list";
        Point3f pt = new Point3f();
        while ((this.line = this.br.readLine()) != null) {
            if (this.line.length() == 0 || this.nVertices == 0 && this.line.indexOf("v ") != 0) continue;
            if (this.line.indexOf("v ") != 0) break;
            this.next[0] = 2;
            pt.set(Parser.parseFloat(this.line, this.next), Parser.parseFloat(this.line, this.next), Parser.parseFloat(this.line, this.next));
            this.addVertexCopy(pt, 0.0f, ++this.nVertices);
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readPolygons() {
        block12: {
            this.nPolygons = 0;
            int color = 0;
            try {
                if (!this.params.readAllData) {
                    for (int i = 0; i < this.params.fileIndex; ++i) {
                        while (this.line != null && this.line.indexOf("g ") != 0) {
                            this.line = this.br.readLine();
                        }
                        if (this.line == null) break;
                        color = Graphics3D.getArgbFromString("[x" + this.line.substring(3) + "]");
                        this.line = this.br.readLine();
                    }
                }
                while (this.line != null) {
                    if (this.line.indexOf("f ") == 0) {
                        int vertexCount;
                        ++this.nPolygons;
                        this.next[0] = 2;
                        int ia = Parser.parseInt(this.line, this.next);
                        int ib = Parser.parseInt(this.line, this.next);
                        int ic = Parser.parseInt(this.line, this.next);
                        int id = Parser.parseInt(this.line, this.next);
                        int n = vertexCount = id == Integer.MIN_VALUE ? 3 : 4;
                        if (vertexCount == 4) {
                            this.nTriangles += 2;
                            this.addTriangleCheck(ia - 1, ib - 1, ic - 1, 5, false, color);
                            this.addTriangleCheck(ib - 1, ic - 1, id - 1, 3, false, color);
                        } else {
                            ++this.nTriangles;
                            this.addTriangleCheck(ia - 1, ib - 1, ic - 1, 7, false, color);
                        }
                    } else if (this.line.indexOf("g ") == 0) {
                        if (!this.params.readAllData) break;
                        color = Graphics3D.getArgbFromString("[x" + this.line.substring(3) + "]");
                    }
                    this.line = this.br.readLine();
                }
            }
            catch (Exception e) {
                if (this.line == null) break block12;
                this.pmeshError = "problem reading OBJ file at: " + this.line;
            }
        }
        return true;
    }
}

