/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Parameters {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_DATA_READ = 2;
    public static final int STATE_DATA_COLORED = 3;
    int state = 0;
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    boolean isSilent = false;
    float assocCutoff = 0.3f;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    static final int CAN_CONTOUR = 512;
    int dataType;
    int surfaceType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID2 = 66;
    static final int SURFACE_ELLIPSOID3 = 67;
    static final int SURFACE_LOBE = 68;
    static final int SURFACE_LCAOCARTOON = 69;
    static final int SURFACE_FUNCTIONXY = 518;
    static final int SURFACE_FUNCTIONXYZ = 7;
    static final int SURFACE_SOLVENT = 171;
    static final int SURFACE_SASURFACE = 172;
    static final int SURFACE_MOLECULARORBITAL = 301;
    static final int SURFACE_ATOMICORBITAL = 14;
    static final int SURFACE_MEP = 304;
    static final int SURFACE_FILE = 529;
    static final int SURFACE_INFO = 530;
    static final int SURFACE_MOLECULAR = 179;
    static final int SURFACE_NOMAP = 180;
    static final int SURFACE_PROPERTY = 181;
    String calculationType = "";
    boolean addHydrogens;
    float solventRadius;
    float solventExtendedAtomRadius;
    float solventAtomRadiusFactor;
    float solventAtomRadiusAbsolute;
    float solventAtomRadiusOffset;
    boolean propertySmoothing;
    boolean useIonic;
    float envelopeRadius;
    float cavityRadius;
    boolean isCavity;
    Boolean pocket;
    int minSet;
    Point4f cappingPlane;
    boolean doCapIsosurface;
    float[] theProperty;
    float solvent_ptsPerAngstrom = 4.0f;
    int solvent_gridMax = 60;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    static final float defaultOrbitalCutoff = 0.14f;
    public static final float defaultQMOrbitalCutoff = 0.05f;
    static final float defaultQMElectronDensityCutoff = 0.01f;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = -65536;
    static final int defaultColorPositive = -16776961;
    static final int defaultColorNegativeLCAO = -8388480;
    static final int defaultColorPositiveLCAO = -23296;
    static final float defaultSolventRadius = 1.2f;
    static final float defaultMepCutoff = 0.05f;
    static final float defaultMepMin = -0.05f;
    static final float defaultMepMax = 0.05f;
    boolean colorBySign;
    boolean colorByPhase;
    boolean colorBySets;
    int colorNeg;
    int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPhase;
    boolean iAddGridPoints;
    boolean remappable;
    int atomIndex;
    boolean isAngstroms;
    float scale;
    float[] anisotropy = new float[3];
    boolean isAnisotropic;
    Matrix3f eccentricityMatrix;
    Matrix3f eccentricityMatrixInverse;
    boolean isEccentric;
    float eccentricityScale;
    float eccentricityRatio;
    float[] aniosU;
    float[] anisoB;
    String lcaoType;
    public Vector functionXYinfo;
    int psi_n = 2;
    int psi_l = 1;
    int psi_m = 1;
    float psi_Znuc = 1.0f;
    float psi_ptsPerAngstrom = 5.0f;
    public static final int MEP_MAX_GRID = 40;
    int mep_gridMax = 40;
    float mep_ptsPerAngstrom = 3.0f;
    float mep_marginAngstroms = 1.0f;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    Hashtable moData;
    Hashtable mo;
    float[] moCoefficients;
    public static final int MO_MAX_GRID = 80;
    int qm_gridMax = 80;
    float qm_ptsPerAngstrom = 10.0f;
    float qm_marginAngstroms = 1.0f;
    int qm_nAtoms;
    int qm_moNumber = Integer.MAX_VALUE;
    Point3f center;
    Point3f point;
    float distance;
    String script;
    BitSet bsSelected;
    BitSet bsIgnore;
    BitSet bsSolvent;
    boolean iUseBitSets = false;
    String[] title;
    boolean blockCubeData;
    boolean readAllData;
    int fileIndex;
    String fileName;
    int modelIndex;
    boolean isXLowToHigh;
    boolean insideOut;
    float cutoff = Float.MAX_VALUE;
    boolean isCutoffAbsolute;
    boolean isPositiveOnly;
    boolean rangeAll;
    public boolean rangeDefined;
    float valueMappedToRed;
    float valueMappedToBlue;
    float mappedDataMin;
    float mappedDataMax;
    boolean isColorReversed;
    boolean isBicolorMap;
    boolean isSquared;
    Point4f thePlane;
    boolean isContoured;
    int nContours;
    int thisContour;
    boolean contourFromZero;
    float resolution;
    int downsampleFactor;
    int maxSet;

    void initialize() {
        this.addHydrogens = false;
        this.atomIndex = -1;
        this.blockCubeData = false;
        this.bsIgnore = null;
        this.bsSelected = null;
        this.bsSolvent = null;
        this.calculationType = "";
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.cappingPlane = null;
        this.colorBySets = false;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.colorNeg = -65536;
        this.colorNegLCAO = -8388480;
        this.colorPos = -16776961;
        this.colorPosLCAO = -23296;
        this.cutoff = Float.MAX_VALUE;
        this.distance = Float.MAX_VALUE;
        this.doCapIsosurface = false;
        this.envelopeRadius = 10.0f;
        this.fileIndex = 1;
        this.readAllData = true;
        this.fileName = "";
        this.functionXYinfo = null;
        this.iAddGridPoints = false;
        this.insideOut = false;
        this.isAngstroms = false;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.isCavity = false;
        this.isColorReversed = false;
        this.isSquared = false;
        this.isContoured = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.isSilent = false;
        this.iUseBitSets = false;
        this.logCompression = false;
        this.logCube = false;
        this.logMessages = Logger.debugging;
        this.mappedDataMin = Float.MAX_VALUE;
        this.minSet = 0;
        this.nContours = 0;
        this.pocket = null;
        this.rangeDefined = false;
        this.resolution = Float.MAX_VALUE;
        this.scale = Float.NaN;
        this.solventAtomRadiusAbsolute = 0.0f;
        this.solventAtomRadiusFactor = 1.0f;
        this.solventAtomRadiusOffset = 0.0f;
        this.solventExtendedAtomRadius = 0.0f;
        this.state = 1;
        this.thePlane = null;
        this.theProperty = null;
        this.thisContour = -1;
        this.contourFromZero = true;
        this.title = null;
        this.useIonic = false;
        this.rangeAll = false;
    }

    void setAnisotropy(Point3f pt) {
        this.anisotropy[0] = pt.x;
        this.anisotropy[1] = pt.y;
        this.anisotropy[2] = pt.z;
        this.isAnisotropic = true;
    }

    void setEccentricity(Point4f info) {
        Vector3f ecc = new Vector3f(info.x, info.y, info.z);
        float c = this.scale > 0.0f ? this.scale : (info.w < 0.0f ? 1.0f : ecc.length());
        float fab_c = Math.abs(info.w);
        ecc.normalize();
        Vector3f z = new Vector3f(0.0f, 0.0f, 1.0f);
        ecc.add(z);
        ecc.normalize();
        if (Float.isNaN(ecc.x)) {
            ecc.set(1.0f, 0.0f, 0.0f);
        }
        this.eccentricityMatrix = new Matrix3f();
        this.eccentricityMatrix.setIdentity();
        this.eccentricityMatrix.set(new AxisAngle4f(ecc, (float)Math.PI));
        this.eccentricityMatrixInverse = new Matrix3f();
        this.eccentricityMatrixInverse.invert(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = c;
        this.eccentricityRatio = fab_c;
        if (fab_c > 1.0f) {
            this.eccentricityScale *= fab_c;
        }
        this.anisotropy[0] = fab_c * c;
        this.anisotropy[1] = fab_c * c;
        this.anisotropy[2] = c;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setPlane(Point4f plane) {
        this.thePlane = plane;
        if (this.thePlane.x == 0.0f && this.thePlane.y == 0.0f && this.thePlane.z == 0.0f) {
            this.thePlane.z = 1.0f;
        }
        this.isContoured = true;
    }

    void setSphere(float radius) {
        this.dataType = 65;
        this.distance = radius;
        this.setEccentricity(new Point4f(0.0f, 0.0f, 1.0f, 1.0f));
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    void setEllipsoid(Point4f v) {
        this.dataType = 66;
        this.distance = 1.0f;
        this.setEccentricity(v);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    public void setEllipsoid(float[] bList) {
        this.anisoB = bList;
        for (int i = 0; i < 6; ++i) {
            System.out.print(bList[i] + " ");
        }
        System.out.println(" in Parameters setEllipsoid" + this.center);
        this.dataType = 67;
        this.distance = 0.3f * (Float.isNaN(this.scale) ? 1.0f : this.scale);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        boolean bl = this.isSilent = !this.logMessages;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        if (this.resolution == Float.MAX_VALUE) {
            this.resolution = 6.0f;
        }
    }

    void setLobe(Point4f v) {
        this.dataType = 68;
        this.setEccentricity(v);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.escape(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " LOBE {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    void setLcao(String type, int colorPtr) {
        this.lcaoType = type;
        if (colorPtr == 1) {
            this.colorPosLCAO = this.colorNegLCAO;
        }
        this.isSilent = !this.logMessages;
    }

    void setRadius(boolean useIonic, float radius) {
        this.useIonic = useIonic;
        if (radius >= 100.0f) {
            this.solventAtomRadiusFactor = (radius - 100.0f) / 100.0f;
        } else if (radius > 10.0f) {
            this.solventAtomRadiusAbsolute = radius - 10.0f;
        } else {
            this.solventAtomRadiusOffset = radius;
        }
    }

    void setSolvent(String propertyName, float radius) {
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.solventRadius = radius;
        if (this.solventRadius < 0.0f) {
            this.solventRadius = 1.2f;
        }
        this.dataType = "nomap" == propertyName ? 180 : ("molecular" == propertyName ? 179 : ("sasurface" == propertyName || this.solventRadius == 0.0f ? 172 : 171));
        switch (this.dataType) {
            case 180: {
                this.calculationType = "unmapped plane";
                break;
            }
            case 179: {
                this.calculationType = "molecular surface with radius " + this.solventRadius;
                break;
            }
            case 171: {
                this.calculationType = "solvent-excluded surface with radius " + this.solventRadius;
                break;
            }
            case 172: {
                this.calculationType = "solvent-accessible surface with radius " + this.solventRadius;
            }
        }
        switch (this.dataType) {
            case 180: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                this.isContoured = false;
                break;
            }
            case 179: {
                this.solventExtendedAtomRadius = 0.0f;
                break;
            }
            case 171: {
                this.solventExtendedAtomRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
                break;
            }
            case 172: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
            }
        }
    }

    void setFunctionXY(Vector value) {
        this.dataType = 518;
        this.functionXYinfo = value;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    void setFunctionXYZ(Vector value) {
        this.dataType = 7;
        this.functionXYinfo = value;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    boolean setAtomicOrbital(float[] nlmZ) {
        this.dataType = 14;
        this.psi_n = (int)nlmZ[0];
        this.psi_l = (int)nlmZ[1];
        this.psi_m = (int)nlmZ[2];
        this.psi_Znuc = nlmZ[3];
        this.psi_ptsPerAngstrom = 10.0f;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = true;
        if (this.state < 2 && this.thePlane == null) {
            if (this.colorBySign) {
                this.isBicolorMap = true;
            }
            if (this.resolution == Float.MAX_VALUE) {
                this.resolution = 6.0f;
            }
        }
        return this.psi_Znuc > 0.0f && Math.abs(this.psi_m) <= this.psi_l && this.psi_l < this.psi_n;
    }

    void setMep(float[] charges, boolean isRangeDefined) {
        this.dataType = 304;
        this.theProperty = charges;
        this.isAnisotropic = false;
        this.isEccentric = false;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.05f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        this.contourFromZero = false;
        if (this.state >= 2 || this.thePlane != null) {
            if (!this.rangeDefined && !this.rangeAll) {
                this.valueMappedToRed = -0.05f;
                this.valueMappedToBlue = 0.05f;
                this.rangeDefined = true;
            }
        } else {
            this.colorBySign = true;
            this.isBicolorMap = true;
        }
    }

    void setMO(int iMo, boolean isRangeDefined) {
        boolean isElectronDensity;
        this.iUseBitSets = true;
        this.qm_moNumber = Math.abs(iMo);
        this.qmOrbitalType = this.moData.containsKey("gaussians") ? 1 : (this.moData.containsKey("slaterInfo") ? 2 : 0);
        boolean bl = isElectronDensity = iMo <= 0;
        if (this.qmOrbitalType == 0) {
            Logger.error("MO ERROR: No basis functions found in file for MO calculation. (GAUSSIAN 'gfprint' keyword may be missing?)");
            this.mo = null;
            this.title = new String[]{"no basis functions found in file"};
        } else {
            Vector mos = (Vector)this.moData.get("mos");
            this.qmOrbitalCount = mos.size();
            this.calculationType = (String)this.moData.get("calculationType");
            this.calculationType = "Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + (this.calculationType == null ? "" : this.calculationType);
            if (!isElectronDensity) {
                if (this.title == null) {
                    this.title = new String[5];
                    this.title[0] = "%F";
                    this.title[1] = "Model %M  MO %I/%N %T";
                    this.title[2] = "Energy = %E %U";
                    this.title[3] = "?Symmetry = %S";
                    this.title[4] = "?Occupancy = %O";
                }
                this.mo = (Hashtable)mos.get(this.qm_moNumber - 1);
                this.moCoefficients = (float[])this.mo.get("coefficients");
            }
        }
        this.dataType = 301;
        if (this.cutoff == Float.MAX_VALUE) {
            float f = this.cutoff = isElectronDensity ? 0.01f : 0.05f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
        boolean bl2 = this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        if (this.state >= 2 || this.thePlane != null) {
            return;
        }
        this.colorBySign = true;
        if (this.colorByPhase && this.colorPhase == 0) {
            this.colorByPhase = false;
        }
        this.isBicolorMap = true;
    }

    void setMapRanges(SurfaceReader surfaceReader) {
        if (this.colorByPhase || this.colorBySign || (this.thePlane != null || this.isBicolorMap) && !this.isContoured) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (this.mappedDataMin == Float.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            this.mappedDataMin = surfaceReader.getMinMappedValue();
            this.mappedDataMax = surfaceReader.getMaxMappedValue();
        }
        if (this.mappedDataMin == 0.0f && this.mappedDataMax == 0.0f) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
    }
}

