/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Logger;

class VolumeDataReader
extends SurfaceReader {
    protected int dataType;
    protected boolean precalculateVoxelData;
    protected boolean allowMapData;
    protected Point3f center;
    protected Point3f point;
    protected float[] anisotropy;
    protected boolean isAnisotropic;
    protected Matrix3f eccentricityMatrix;
    protected Matrix3f eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected float eccentricityScale;
    protected float eccentricityRatio;

    VolumeDataReader(SurfaceGenerator sg) {
        super(sg);
        this.dataType = this.params.dataType;
        this.precalculateVoxelData = true;
        this.allowMapData = true;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
    }

    void setup() {
        this.jvxlFileHeaderBuffer = new StringBuffer("volume data read from file\n\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    boolean readVolumeParameters() {
        this.setup();
        this.initializeVolumetricData();
        return true;
    }

    boolean readVolumeData(boolean isMapData) {
        try {
            this.readSurfaceData(isMapData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void readVoxelDataIndividually(boolean isMapData) throws Exception {
        if (isMapData && !this.allowMapData) {
            return;
        }
        this.voxelData = isMapData ? new float[this.nPointsX][this.nPointsY][this.nPointsZ] : (float[][][])null;
        this.volumeData.setVoxelData(this.voxelData);
        if (!isMapData) {
            return;
        }
        for (int x = 0; x < this.nPointsX; ++x) {
            float[][] plane = new float[this.nPointsY][];
            this.voxelData[x] = plane;
            for (int y = 0; y < this.nPointsY; ++y) {
                plane[y] = new float[this.nPointsZ];
                float[] strip = plane[y];
                for (int z = 0; z < this.nPointsZ; ++z) {
                    strip[z] = this.getValue(x, y, z);
                }
            }
        }
    }

    protected int setVoxelRange(int index, float min, float max, float ptsPerAngstrom, int gridMax) {
        int nGrid;
        if (min >= max) {
            min = -10.0f;
            max = 10.0f;
        }
        float range = max - min;
        float resolution = this.params.resolution;
        if (resolution != Float.MAX_VALUE) {
            ptsPerAngstrom = resolution;
        }
        if ((nGrid = (int)(range * ptsPerAngstrom) + 1) > gridMax) {
            if ((this.dataType & 0x100) > 0) {
                if (resolution != Float.MAX_VALUE) {
                    Logger.info("Maximum number of voxels for index=" + index);
                }
                nGrid = gridMax;
            } else if (resolution == Float.MAX_VALUE) {
                nGrid = gridMax;
            }
        }
        ptsPerAngstrom = (float)(nGrid - 1) / range;
        this.voxelCounts[index] = nGrid;
        float d = this.volumeData.volumetricVectorLengths[index] = 1.0f / ptsPerAngstrom;
        switch (index) {
            case 0: {
                this.volumetricVectors[0].set(d, 0.0f, 0.0f);
                this.volumetricOrigin.x = min;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, d, 0.0f);
                this.volumetricOrigin.y = min;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, d);
                this.volumetricOrigin.z = min;
                if (this.isEccentric) {
                    this.eccentricityMatrix.transform(this.volumetricOrigin);
                }
                if (this.center.x == Float.MAX_VALUE) break;
                this.volumetricOrigin.add(this.center);
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.transform(this.volumetricVectors[index]);
        }
        return this.voxelCounts[index];
    }

    protected void readSurfaceData(boolean isMapData) throws Exception {
        if (this.precalculateVoxelData) {
            this.generateCube();
        } else {
            this.readVoxelDataIndividually(isMapData);
        }
    }

    protected void generateCube() {
        Logger.info("data type: user volumeData");
        Logger.info("voxel grid origin:" + this.volumetricOrigin);
        for (int i = 0; i < 3; ++i) {
            Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
        }
        Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
    }
}

