/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    private int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;

    VolumeFileReader(SurfaceGenerator sg, BufferedReader br) {
        super(sg, br);
    }

    boolean readVolumeParameters() {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces);
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    boolean readVolumeData(boolean isMapData) {
        if (!this.gotoAndReadVoxelData(isMapData)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
        }
        return true;
    }

    protected int readVolumetricHeader() {
        try {
            int i;
            this.readTitleLines();
            Logger.info(this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            if (this.atomCount == Integer.MIN_VALUE) {
                return 0;
            }
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            int downsampleFactor = this.params.downsampleFactor;
            boolean downsampling = this.canDownsample && downsampleFactor > 0;
            for (i = 0; i < 3; ++i) {
                this.readVoxelVector(i);
            }
            if (downsampling) {
                this.downsampleRemainders = new int[3];
                Logger.info("downsample factor = " + downsampleFactor);
                for (i = 0; i < 3; ++i) {
                    int n = this.voxelCounts[i];
                    this.downsampleRemainders[i] = n % downsampleFactor;
                    int n2 = i;
                    this.voxelCounts[n2] = this.voxelCounts[n2] / downsampleFactor;
                    this.volumetricVectors[i].scale(downsampleFactor);
                    Logger.info("downsampling axis " + (i + 1) + " from " + n + " to " + this.voxelCounts[i]);
                }
            }
            for (i = 0; i < 3; ++i) {
                this.line = this.voxelCounts[i] + " " + this.volumetricVectors[i].x + " " + this.volumetricVectors[i].y + " " + this.volumetricVectors[i].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info("voxel grid count/vector:" + this.line);
                if (this.isAngstroms) continue;
                this.volumetricVectors[i].scale(0.5291772f);
            }
            JvxlReader.jvxlReadAtoms(this.br, this.jvxlFileHeaderBuffer, this.atomCount, this.volumeData);
            return this.readExtraLine();
        }
        catch (Exception e) {
            Logger.error(e.toString());
            return 0;
        }
    }

    protected void readTitleLines() throws Exception {
    }

    protected String skipComments(boolean allowBlankLines) throws Exception {
        StringBuffer sb = new StringBuffer();
        while ((this.line = this.br.readLine()) != null && (allowBlankLines && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            sb.append(this.line).append('\n');
        }
        return sb.toString();
    }

    protected void readAtomCountAndOrigin() throws Exception {
    }

    protected void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.line = this.br.readLine();
        Vector3f voxelVector = this.volumetricVectors[voxelVectorIndex];
        this.voxelCounts[voxelVectorIndex] = this.parseInt(this.line);
        if (this.voxelCounts[voxelVectorIndex] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        voxelVector.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
    }

    protected int readExtraLine() throws Exception {
        if (!this.negativeAtomCount) {
            return 1;
        }
        this.line = this.br.readLine();
        Logger.info("Reading extra CUBE information line: " + this.line);
        return this.parseInt(this.line);
    }

    protected void readSurfaceData(boolean isMapData) throws Exception {
        boolean isDownsampled;
        this.next[0] = 0;
        int downsampleFactor = this.params.downsampleFactor;
        boolean bl = isDownsampled = this.canDownsample && downsampleFactor > 0;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
        if (this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            this.voxelData = null;
        } else {
            this.voxelData = new float[this.nPointsX][][];
            int nSkipX = 0;
            int nSkipY = 0;
            int nSkipZ = 0;
            if (isDownsampled) {
                nSkipX = downsampleFactor - 1;
                nSkipZ = this.nPointsZ * downsampleFactor + this.downsampleRemainders[2];
                nSkipY = this.downsampleRemainders[2] + (downsampleFactor - 1) * nSkipZ;
                nSkipZ = this.downsampleRemainders[1] * nSkipZ + (downsampleFactor - 1) * nSkipZ * (this.nPointsY * downsampleFactor + this.downsampleRemainders[1]);
            }
            for (int x = 0; x < this.nPointsX; ++x) {
                float[][] plane = new float[this.nPointsY][];
                this.voxelData[x] = plane;
                for (int y = 0; y < this.nPointsY; ++y) {
                    float[] strip = new float[this.nPointsZ];
                    plane[y] = strip;
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        strip[z] = this.getNextVoxelValue();
                        if (!isDownsampled) continue;
                        this.skipVoxels(nSkipX);
                    }
                    if (!isDownsampled) continue;
                    this.skipVoxels(nSkipY);
                }
                if (!isDownsampled) continue;
                this.skipVoxels(nSkipZ);
            }
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    private void skipVoxels(int n) throws Exception {
        int i = n;
        while (--i >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BitSet getVoxelBitSet(int nPoints) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float voxelValue = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int i;
            for (i = 1; i < this.params.fileIndex; ++i) {
                this.nextVoxel();
            }
            voxelValue = this.nextVoxel();
            for (i = this.params.fileIndex; i < this.nSurfaces; ++i) {
                this.nextVoxel();
            }
        } else {
            voxelValue = this.nextVoxel();
        }
        return voxelValue;
    }

    protected float nextVoxel() throws Exception {
        float voxelValue = this.parseFloat();
        if (Float.isNaN(voxelValue)) {
            while ((this.line = this.br.readLine()) != null && Float.isNaN(voxelValue = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
            this.nBytes += this.line.length() + 1;
        }
        return voxelValue;
    }

    protected void gotoData(int n, int nPoints) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + nPoints + " points each");
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(nPoints);
        }
    }

    protected void skipData(int nPoints) throws Exception {
        for (int iV = 0; iV < nPoints; iV += this.countData(this.line)) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String str) {
        int count = 0;
        int ich = 0;
        int ichMax = str.length();
        while (ich < ichMax) {
            char ch;
            while (ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t')) {
                ++ich;
            }
            if (ich < ichMax) {
                ++count;
            }
            while (ich < ichMax && (ch = str.charAt(ich)) != ' ' && ch != '\t') {
                ++ich;
            }
        }
        return count;
    }
}

