/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Vector;
import org.jmol.minimize.MinBond;
import org.jmol.modelset.Atom;

public class MinAtom {
    int index;
    public Atom atom;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    public Vector bonds = new Vector();
    public int nBonds;
    public String type;
    int[] bondedAtoms;

    MinAtom(int index, Atom atom, double[] coord, String type) {
        this.index = index;
        this.atom = atom;
        this.coord = coord;
        this.type = type;
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int iAtom) {
        this.getBondedAtomIndexes();
        for (int i = 0; i < this.nBonds; ++i) {
            if (this.bondedAtoms[i] != iAtom) continue;
            return (MinBond)this.bonds.elementAt(i);
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int i = this.nBonds;
            while (--i >= 0) {
                this.bondedAtoms[i] = ((MinBond)this.bonds.elementAt(i)).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }
}

