/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3d;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;

abstract class Calculations {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double KCAL_TO_KJ = 4.1868;
    static final int CALC_DISTANCE = 0;
    static final int CALC_ANGLE = 1;
    static final int CALC_TORSION = 2;
    static final int CALC_OOP = 3;
    static final int CALC_VDW = 4;
    static final int CALC_ES = 5;
    static final int CALC_MAX = 6;
    ForceField ff;
    Vector[] calculations = new Vector[6];
    public Hashtable ffParams;
    int atomCount;
    int bondCount;
    MinAtom[] atoms;
    MinBond[] bonds;
    int[][] angles;
    int[][] torsions;
    double[] partialCharges;
    boolean havePartialCharges;
    Vector constraints;
    boolean isPreliminary;
    boolean gradients;
    boolean silent;
    StringBuffer logData = new StringBuffer();
    boolean logging;
    boolean loggingEnabled;
    final Vector3d da = new Vector3d();
    final Vector3d db = new Vector3d();
    final Vector3d dc = new Vector3d();
    final Vector3d dd = new Vector3d();
    int ia;
    int ib;
    int ic;
    int id;
    final Vector3d v1 = new Vector3d();
    final Vector3d v2 = new Vector3d();
    final Vector3d v3 = new Vector3d();
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    public void setConstraints(Vector constraints) {
        this.constraints = constraints;
    }

    Calculations(ForceField ff, MinAtom[] minAtoms, MinBond[] minBonds, int[][] angles, int[][] torsions, double[] partialCharges, Vector constraints) {
        this.ff = ff;
        this.atoms = minAtoms;
        this.bonds = minBonds;
        this.angles = angles;
        this.torsions = torsions;
        this.constraints = constraints;
        this.atomCount = this.atoms.length;
        this.bondCount = this.bonds.length;
        if (partialCharges != null && partialCharges.length == this.atomCount) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (partialCharges[i] == 0.0) continue;
                this.havePartialCharges = true;
                break;
            }
        }
        if (!this.havePartialCharges) {
            partialCharges = null;
        }
        this.partialCharges = partialCharges;
    }

    boolean haveParams() {
        return this.ffParams != null;
    }

    void setParams(Hashtable temp) {
        this.ffParams = temp;
    }

    static FFParam getParameter(String a, Hashtable ffParams) {
        return (FFParam)ffParams.get(a);
    }

    abstract boolean setupCalculations();

    abstract String getAtomList(String var1);

    abstract boolean setupElectrostatics();

    abstract String getDebugHeader(int var1);

    abstract String getDebugFooter(int var1, double var2);

    abstract String getUnit();

    abstract double compute(int var1, Object[] var2);

    void addForce(Vector3d v, int i, double dE) {
        this.atoms[i].force[0] = this.atoms[i].force[0] + v.x * dE;
        this.atoms[i].force[1] = this.atoms[i].force[1] + v.y * dE;
        this.atoms[i].force[2] = this.atoms[i].force[2] + v.z * dE;
    }

    public void setSilent(boolean TF) {
        this.silent = TF;
    }

    public String getLogData() {
        return this.logData.toString();
    }

    void appendLogData(String s) {
        this.logData.append(s).append("\n");
    }

    void setLoggingEnabled(boolean TF) {
        this.loggingEnabled = TF;
        if (this.loggingEnabled) {
            this.logData = new StringBuffer();
        }
    }

    void setPreliminary(boolean TF) {
        this.isPreliminary = TF;
    }

    private double calc(int iType, boolean gradients) {
        int nCalc;
        this.logging = this.loggingEnabled && !this.silent;
        this.gradients = gradients;
        Vector calc = this.calculations[iType];
        double energy = 0.0;
        if (calc == null || (nCalc = calc.size()) == 0) {
            return 0.0;
        }
        if (this.logging) {
            this.appendLogData(this.getDebugHeader(iType));
        }
        for (int ii = 0; ii < nCalc; ++ii) {
            energy += this.compute(iType, (Object[])this.calculations[iType].get(ii));
        }
        if (this.logging) {
            this.appendLogData(this.getDebugFooter(iType, energy));
        }
        if (this.constraints != null && iType <= 2) {
            energy += this.constraintEnergy(iType);
        }
        return energy;
    }

    double energyStrBnd(boolean gradients) {
        return 0.0;
    }

    double energyBond(boolean gradients) {
        return this.calc(0, gradients);
    }

    double energyAngle(boolean gradients) {
        return this.calc(1, gradients);
    }

    double energyTorsion(boolean gradients) {
        return this.calc(2, gradients);
    }

    double energyOOP(boolean gradients) {
        return this.calc(3, gradients);
    }

    double energyVDW(boolean gradients) {
        return this.calc(4, gradients);
    }

    double energyES(boolean gradients) {
        return this.calc(5, gradients);
    }

    private double constraintEnergy(int iType) {
        double value = 0.0;
        double k = 0.0;
        double energy = 0.0;
        int i = this.constraints.size();
        while (--i >= 0) {
            Object[] c = (Object[])this.constraints.elementAt(i);
            int nAtoms = ((int[])c[0])[0];
            if (nAtoms != iType + 2) continue;
            int[] minList = (int[])c[1];
            double targetValue = ((Float)c[2]).doubleValue();
            switch (iType) {
                case 2: {
                    this.id = minList[3];
                    if (this.gradients) {
                        this.dd.set(this.atoms[this.id].coord);
                    }
                }
                case 1: {
                    this.ic = minList[2];
                    if (this.gradients) {
                        this.dc.set(this.atoms[this.ic].coord);
                    }
                }
                case 0: {
                    this.ib = minList[1];
                    this.ia = minList[0];
                    if (!this.gradients) break;
                    this.db.set(this.atoms[this.ib].coord);
                    this.da.set(this.atoms[this.ia].coord);
                }
            }
            k = 10000.0;
            switch (iType) {
                case 2: {
                    targetValue *= Math.PI / 180;
                    double d = value = this.gradients ? Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd) : Util.getTorsionAngleRadians(this.atoms[this.ia].coord, this.atoms[this.ib].coord, this.atoms[this.ic].coord, this.atoms[this.id].coord, this.v1, this.v2, this.v3);
                    if (value < 0.0 && targetValue >= 1.5707963267948966) {
                        value += Math.PI * 2;
                        break;
                    }
                    if (!(value > 0.0) || !(targetValue <= -1.5707963267948966)) break;
                    targetValue += Math.PI * 2;
                    break;
                }
                case 1: {
                    targetValue *= Math.PI / 180;
                    value = this.gradients ? Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc) : Util.getAngleRadiansABC(this.atoms[this.ia].coord, this.atoms[this.ib].coord, this.atoms[this.ic].coord);
                    break;
                }
                case 0: {
                    value = this.gradients ? Util.restorativeForceAndDistance(this.da, this.db, this.dc) : Math.sqrt(Util.distance2(this.atoms[this.ia].coord, this.atoms[this.ib].coord));
                }
            }
            energy += this.constrainQuadratic(value, targetValue, k, iType);
        }
        return energy;
    }

    private double constrainQuadratic(double value, double targetValue, double k, int iType) {
        if (!Util.isFinite(value)) {
            return 0.0;
        }
        double delta = value - targetValue;
        if (this.gradients) {
            double dE = 2.0 * k * delta;
            switch (iType) {
                case 2: {
                    this.addForce(this.dd, this.id, dE);
                }
                case 1: {
                    this.addForce(this.dc, this.ic, dE);
                }
                case 0: {
                    this.addForce(this.db, this.ib, dE);
                    this.addForce(this.da, this.ia, dE);
                }
            }
        }
        return k * delta * delta;
    }
}

