/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Vector;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.TextFormat;

class CalculationsUFF
extends Calculations {
    public static final int PAR_R = 0;
    public static final int PAR_THETA = 1;
    public static final int PAR_X = 2;
    public static final int PAR_D = 3;
    public static final int PAR_ZETA = 4;
    public static final int PAR_Z = 5;
    public static final int PAR_V = 6;
    public static final int PAR_U = 7;
    public static final int PAR_XI = 8;
    public static final int PAR_HARD = 9;
    public static final int PAR_RADIUS = 10;
    DistanceCalc bondCalc = new DistanceCalc();
    AngleCalc angleCalc = new AngleCalc();
    TorsionCalc torsionCalc = new TorsionCalc();
    OOPCalc oopCalc = new OOPCalc();
    VDWCalc vdwCalc = new VDWCalc();
    ESCalc esCalc = new ESCalc();
    static final double KCAL644 = 2696.8016159999997;
    static final double KCAL6 = 25.1208;
    static final double KCAL22 = 92.1096;
    static final double KCAL44 = 184.2192;
    static final double KCAL332 = 1390.2842991599998;

    CalculationsUFF(ForceField ff, MinAtom[] minAtoms, MinBond[] minBonds, int[][] angles, int[][] torsions, double[] partialCharges, Vector constraints) {
        super(ff, minAtoms, minBonds, angles, torsions, partialCharges, constraints);
    }

    String getUnit() {
        return "kJ/mol";
    }

    boolean setupCalculations() {
        DistanceCalc distanceCalc = new DistanceCalc();
        Vector calc = this.calculations[0] = new Vector();
        for (int i = 0; i < this.bondCount; ++i) {
            MinBond bond = this.bonds[i];
            double bondOrder = bond.atomIndexes[2];
            if (bond.isAromatic) {
                bondOrder = 1.5;
            }
            if (bond.isAmide) {
                bondOrder = 1.41;
            }
            distanceCalc.setData(calc, bond.atomIndexes[0], bond.atomIndexes[1], bondOrder);
        }
        this.calculations[1] = new Vector();
        calc = this.calculations[1];
        AngleCalc angleCalc = new AngleCalc();
        int i = this.angles.length;
        while (--i >= 0) {
            angleCalc.setData(calc, i);
        }
        this.calculations[2] = new Vector();
        calc = this.calculations[2];
        TorsionCalc torsionCalc = new TorsionCalc();
        int i2 = this.torsions.length;
        while (--i2 >= 0) {
            torsionCalc.setData(calc, i2);
        }
        this.calculations[3] = new Vector();
        calc = this.calculations[3];
        OOPCalc oopCalc = new OOPCalc();
        for (int i3 = 0; i3 < this.atomCount; ++i3) {
            short elemNo;
            MinAtom a = this.atoms[i3];
            if (a.nBonds != 3 || !this.isInvertible(elemNo = a.atom.getElementNumber())) continue;
            oopCalc.setData(calc, i3, elemNo);
        }
        this.calculations[4] = new Vector();
        this.pairSearch(this.calculations[4], new VDWCalc());
        return true;
    }

    private boolean isInvertible(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 33: 
            case 51: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    private void pairSearch(Vector calc, PairCalc type) {
        for (int i = 0; i < this.atomCount - 1; ++i) {
            MinAtom atomA = this.atoms[i];
            int[] atomList1 = atomA.getBondedAtomIndexes();
            block1: for (int j = i + 1; j < this.atomCount; ++j) {
                MinAtom atomB = this.atoms[j];
                int k = atomList1.length;
                while (--k >= 0) {
                    MinAtom nbrA = this.atoms[atomList1[k]];
                    if (nbrA == atomB) continue block1;
                    if (nbrA.nBonds == 1) continue;
                    int[] atomList2 = nbrA.getBondedAtomIndexes();
                    int l = atomList2.length;
                    while (--l >= 0) {
                        MinAtom nbrAA = this.atoms[atomList2[l]];
                        if (nbrAA != atomB) continue;
                        continue block1;
                    }
                }
                type.setData(calc, i, j);
            }
        }
    }

    boolean setupElectrostatics() {
        if (this.partialCharges == null) {
            return true;
        }
        this.calculations[5] = new Vector();
        this.pairSearch(this.calculations[5], new ESCalc());
        return true;
    }

    static double calculateR0(double ri, double rj, double chiI, double chiJ, double bondorder) {
        double rbo = -0.1332 * (ri + rj) * Math.log(bondorder);
        double dchi = Math.sqrt(chiI) - Math.sqrt(chiJ);
        double ren = ri * rj * dchi * dchi / (chiI * ri + chiJ * rj);
        return ri + rj + rbo - ren;
    }

    double compute(int iType, Object[] dataIn) {
        switch (iType) {
            case 0: {
                return this.bondCalc.compute(dataIn);
            }
            case 1: {
                return this.angleCalc.compute(dataIn);
            }
            case 2: {
                return this.torsionCalc.compute(dataIn);
            }
            case 3: {
                return this.oopCalc.compute(dataIn);
            }
            case 4: {
                return this.vdwCalc.compute(dataIn);
            }
            case 5: {
                return this.esCalc.compute(dataIn);
            }
        }
        return 0.0;
    }

    String getAtomList(String title) {
        String trailer = "-----------------------------------------------------------------------------------------------\n";
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + title + "\n\n" + " ATOM    X        Y        Z    TYPE     GRADX    GRADY    GRADZ  " + "---------BONDED ATOMS--------\n" + trailer);
        for (int i = 0; i < this.atomCount; ++i) {
            MinAtom atom = this.atoms[i];
            int[] others = atom.getBondedAtomIndexes();
            int[] iVal = new int[others.length + 1];
            iVal[0] = atom.atom.getAtomNumber();
            String s = "   ";
            for (int j = 0; j < others.length; ++j) {
                s = s + " %3d";
                iVal[j + 1] = this.atoms[others[j]].atom.getAtomNumber();
            }
            sb.append(TextFormat.sprintf("%3d %8.3f %8.3f %8.3f  %-5s %8.3f %8.3f %8.3f" + s + "\n", new Object[]{atom.type, new float[]{(float)atom.coord[0], (float)atom.coord[1], (float)atom.coord[2], (float)atom.force[0], (float)atom.force[1], (float)atom.force[2]}, iVal}));
        }
        sb.append(trailer + "\n\n");
        return sb.toString();
    }

    String getDebugHeader(int iType) {
        switch (iType) {
            case -1: {
                return "Universal Force Field -- Rappe, A. K., et. al.; J. Am. Chem. Soc. (1992) 114(25) p. 10024-10035\n";
            }
            case 0: {
                return "\nB O N D   S T R E T C H I N G (" + this.bondCount + " bonds)\n\n" + "  ATOMS  ATOM TYPES   BOND    BOND       IDEAL      FORCE\n" + "  I   J   I     J     TYPE   LENGTH     LENGTH    CONSTANT      DELTA     ENERGY\n" + "--------------------------------------------------------------------------------";
            }
            case 1: {
                return "\nA N G L E   B E N D I N G (" + this.angles.length + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 2: {
                return "\nT O R S I O N A L (" + this.torsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES             FORCE      TORSION\n" + "  I   J   K   L   I     J     K     L       CONSTANT     ANGLE        ENERGY\n" + "----------------------------------------------------------------------------";
            }
            case 3: {
                return "\nO U T - O F - P L A N E   B E N D I N G\n\n      ATOMS           ATOM TYPES             OOP        FORCE \n  I   J   K   L   I     J     K     L       ANGLE     CONSTANT      ENERGY\n--------------------------------------------------------------------------";
            }
            case 4: {
                return "\nV A N   D E R   W A A L S\n\n  ATOMS  ATOM TYPES\n  I   J   I     J      Rij       kij     ENERGY\n-----------------------------------------------";
            }
            case 5: {
                return "\nE L E C T R O S T A T I C   I N T E R A C T I O N S\n\n  ATOMS  ATOM TYPES            QiQj\n  I   J   I     J      Rij    *332.17    ENERGY\n-----------------------------------------------";
            }
        }
        return "";
    }

    String getDebugLine(int iType, Calculation c) {
        switch (iType) {
            case 0: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s  %4.2f%8.3f   %8.3f     %8.3f   %8.3f   %8.3f", new Object[]{this.atoms[c.ia].type, this.atoms[c.ib].type, new float[]{(float)c.dData[2], (float)c.rab, (float)c.dData[0], (float)c.dData[1], (float)c.delta, (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber()}});
            }
            case 1: {
                return TextFormat.sprintf("%3d %3d %3d  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", new Object[]{this.atoms[c.ia].type, this.atoms[c.ib].type, this.atoms[c.ic].type, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[4], (float)c.dData[0], (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber(), this.atoms[c.ic].atom.getAtomNumber()}});
            }
            case 2: {
                return TextFormat.sprintf("%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f     %8.3f     %8.3f", new Object[]{this.atoms[c.ia].type, this.atoms[c.ib].type, this.atoms[c.ic].type, this.atoms[c.id].type, new float[]{(float)c.dData[0], (float)(c.theta * 57.29577951308232), (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber(), this.atoms[c.ic].atom.getAtomNumber(), this.atoms[c.id].atom.getAtomNumber()}});
            }
            case 3: {
                return TextFormat.sprintf("%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f   %8.3f     %8.3f", new Object[]{this.atoms[c.ia].type, this.atoms[c.ib].type, this.atoms[c.ic].type, this.atoms[c.id].type, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[0], (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber(), this.atoms[c.ic].atom.getAtomNumber(), this.atoms[c.id].atom.getAtomNumber()}});
            }
            case 4: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", new Object[]{this.atoms[c.iData[0]].type, this.atoms[c.iData[1]].type, new float[]{(float)c.rab, (float)c.dData[0], (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber()}});
            }
            case 5: {
                return TextFormat.sprintf("%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", new Object[]{this.atoms[c.iData[0]].type, this.atoms[c.iData[1]].type, new float[]{(float)c.rab, (float)c.dData[0], (float)c.energy}, new int[]{this.atoms[c.ia].atom.getAtomNumber(), this.atoms[c.ib].atom.getAtomNumber()}});
            }
        }
        return "";
    }

    String getDebugFooter(int iType, double energy) {
        String s = "";
        switch (iType) {
            case 0: {
                s = "BOND STRETCHING";
                break;
            }
            case 1: {
                s = "ANGLE BENDING";
                break;
            }
            case 2: {
                s = "TORSIONAL";
                break;
            }
            case 3: {
                s = "OUT-OF-PLANE BENDING";
                break;
            }
            case 4: {
                s = "VAN DER WAALS";
                break;
            }
            case 5: {
                s = "ELECTROSTATIC ENERGY";
            }
        }
        return TextFormat.sprintf("\n     TOTAL %s ENERGY = %8.3f %s\n", new Object[]{s, this.getUnit(), new Float(energy)});
    }

    class ESCalc
    extends PairCalc {
        ESCalc() {
        }

        void setData(Vector calc, int ia, int ib) {
            this.a = CalculationsUFF.this.atoms[ia];
            this.b = CalculationsUFF.this.atoms[ib];
            double qq = 1390.2842991599998 * CalculationsUFF.this.partialCharges[ia] * CalculationsUFF.this.partialCharges[ib];
            if (qq != 0.0) {
                calc.addElement(new Object[]{new int[]{ia, ib}, new double[]{qq}});
            }
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            double qq = this.dData[0];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            if (Util.isNearZero(this.rab, 0.001)) {
                this.rab = 0.001;
            }
            this.energy = qq / this.rab;
            if (CalculationsUFF.this.gradients) {
                this.dE = -qq / (this.rab * this.rab);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(5, this));
            }
            return this.energy;
        }
    }

    class VDWCalc
    extends PairCalc {
        VDWCalc() {
        }

        void setData(Vector calc, int ia, int ib) {
            this.a = CalculationsUFF.this.atoms[ia];
            this.b = CalculationsUFF.this.atoms[ib];
            FFParam parA = Calculations.getParameter(this.a.type, CalculationsUFF.this.ffParams);
            FFParam parB = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            double Xa = parA.dVal[2];
            double Da = parA.dVal[3];
            double Xb = parB.dVal[2];
            double Db = parB.dVal[3];
            double Dab = 4.1868 * Math.sqrt(Da * Db);
            double Xab = Math.sqrt(Xa * Xb);
            calc.addElement(new Object[]{new int[]{ia, ib}, new double[]{Xab, Dab}});
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            double Xab = this.dData[0];
            double Dab = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            if (Util.isNearZero(this.rab, 0.001)) {
                this.rab = 0.001;
            }
            double term = Xab / this.rab;
            double term6 = term * term * term;
            term6 *= term6;
            this.energy = Dab * term6 * (term6 - 2.0);
            if (CalculationsUFF.this.gradients) {
                this.dE = Dab * 12.0 * (1.0 - term6) * term6 * term / Xab;
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(4, this));
            }
            return this.energy;
        }
    }

    abstract class PairCalc
    extends Calculation {
        PairCalc() {
        }

        abstract void setData(Vector var1, int var2, int var3);
    }

    class OOPCalc
    extends Calculation {
        OOPCalc() {
        }

        void setData(Vector calc, int ib, int elemNo) {
            this.b = CalculationsUFF.this.atoms[ib];
            int[] atomList = this.b.getBondedAtomIndexes();
            this.ia = atomList[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ic = atomList[1];
            this.c = CalculationsUFF.this.atoms[this.ic];
            this.id = atomList[2];
            this.d = CalculationsUFF.this.atoms[this.id];
            double a0 = 1.0;
            double a1 = -1.0;
            double a2 = 0.0;
            double koop = 25.1208;
            switch (elemNo) {
                case 6: {
                    if ((this.a.type + this.c.type + this.d.type).indexOf("O_2") != 0) break;
                    koop += 184.2192;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    koop = 92.1096;
                    double phi = Math.PI / 180;
                    switch (elemNo) {
                        case 15: {
                            phi *= 84.4339;
                            break;
                        }
                        case 33: {
                            phi *= 86.9735;
                            break;
                        }
                        case 51: {
                            phi *= 87.7047;
                            break;
                        }
                        case 83: {
                            phi *= 90.0;
                        }
                    }
                    double cosPhi = Math.cos(phi);
                    a0 = cosPhi * cosPhi;
                    a1 = -2.0 * cosPhi;
                    a2 = 1.0;
                }
            }
            calc.addElement(new Object[]{new int[]{this.ia, ib, this.ic, this.id}, new double[]{koop /= 3.0, a0, a1, a2, koop * 10.0}});
            calc.addElement(new Object[]{new int[]{this.ic, ib, this.id, this.ia}, new double[]{koop, a0, a1, a2, koop * 10.0}});
            calc.addElement(new Object[]{new int[]{this.id, ib, this.ia, this.ic}, new double[]{koop, a0, a1, a2, koop * 10.0}});
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            double koop = CalculationsUFF.this.isPreliminary ? this.dData[4] : this.dData[0];
            double a0 = this.dData[1];
            double a1 = this.dData[2];
            double a2 = this.dData[3];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            this.id = this.iData[3];
            CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
            CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
            CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
            CalculationsUFF.this.dd.set(CalculationsUFF.this.atoms[this.id].coord);
            this.theta = CalculationsUFF.this.gradients ? Util.restorativeForceAndOutOfPlaneAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3) : Util.pointPlaneAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3);
            if (!Util.isFinite(this.theta)) {
                this.theta = 0.0;
            }
            double cosTheta = Math.cos(this.theta);
            this.energy = koop * (a0 + a1 * cosTheta + a2 * cosTheta * cosTheta);
            if (CalculationsUFF.this.gradients) {
                this.dE = koop * (a1 * Math.sin(this.theta) + a2 * 2.0 * Math.sin(this.theta) * cosTheta);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dd, this.id, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(3, this));
            }
            return this.energy;
        }
    }

    class TorsionCalc
    extends Calculation {
        TorsionCalc() {
        }

        void setData(Vector calc, int i) {
            int[] t = CalculationsUFF.this.torsions[i];
            double cosNPhi0 = -1.0;
            int n = 0;
            double V = 0.0;
            this.ia = t[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ib = t[1];
            this.b = CalculationsUFF.this.atoms[this.ib];
            this.ic = t[2];
            this.c = CalculationsUFF.this.atoms[this.ic];
            this.id = t[3];
            this.d = CalculationsUFF.this.atoms[this.id];
            MinBond bc = this.c.getBondTo(this.ib);
            double bondOrder = bc.atomIndexes[2];
            if (bc.isAromatic) {
                bondOrder = 1.5;
            }
            if (bc.isAmide) {
                bondOrder = 1.41;
            }
            this.parB = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            this.parC = Calculations.getParameter(this.c.type, CalculationsUFF.this.ffParams);
            switch (this.parB.iVal[0] * this.parC.iVal[0]) {
                case 9: {
                    n = 3;
                    double vi = this.parB.dVal[6];
                    double vj = this.parC.dVal[6];
                    double viNew = 0.0;
                    switch (this.b.atom.getElementNumber()) {
                        case 8: {
                            viNew = 2.0;
                            break;
                        }
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            viNew = 6.8;
                        }
                    }
                    if (viNew != 0.0) {
                        switch (this.c.atom.getElementNumber()) {
                            case 8: {
                                vi = viNew;
                                vj = 2.0;
                                n = 2;
                                break;
                            }
                            case 16: 
                            case 34: 
                            case 52: 
                            case 84: {
                                vi = viNew;
                                vj = 6.8;
                                n = 2;
                            }
                        }
                    }
                    V = 2.0934 * Math.sqrt(vi * vj);
                    break;
                }
                case 4: {
                    cosNPhi0 = 1.0;
                    n = 2;
                    V = 10.466999999999999 * Math.sqrt(this.parB.dVal[7] * this.parC.dVal[7]) * (1.0 + 4.18 * Math.log(bondOrder));
                    break;
                }
                case 6: {
                    cosNPhi0 = 1.0;
                    n = 6;
                    boolean sp3C = this.parC.iVal[0] == 3;
                    block13 : switch ((sp3C ? this.c : this.b).atom.getElementNumber()) {
                        case 8: 
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            switch ((sp3C ? this.b : this.c).atom.getElementNumber()) {
                                case 8: 
                                case 16: 
                                case 34: 
                                case 52: 
                                case 84: {
                                    break block13;
                                }
                            }
                            n = 2;
                            cosNPhi0 = -1.0;
                        }
                    }
                    V = 2.0934;
                }
            }
            if (Util.isNearZero(V)) {
                return;
            }
            calc.addElement(new Object[]{new int[]{this.ia, this.ib, this.ic, this.id, n}, new double[]{V, cosNPhi0}});
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            double V = this.dData[0];
            double cosNPhi0 = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            this.id = this.iData[3];
            int n = this.iData[4];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
                CalculationsUFF.this.dd.set(CalculationsUFF.this.atoms[this.id].coord);
                this.theta = Util.restorativeForceAndTorsionAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc, CalculationsUFF.this.dd);
                if (!Util.isFinite(this.theta)) {
                    this.theta = 1.7453292519943296E-5;
                }
            } else {
                this.theta = Util.getTorsionAngleRadians(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord, CalculationsUFF.this.atoms[this.ic].coord, CalculationsUFF.this.atoms[this.id].coord, CalculationsUFF.this.v1, CalculationsUFF.this.v2, CalculationsUFF.this.v3);
            }
            this.energy = V * (1.0 - cosNPhi0 * Math.cos(this.theta * (double)n));
            if (CalculationsUFF.this.gradients) {
                this.dE = V * (double)n * cosNPhi0 * Math.sin((double)n * this.theta);
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dd, this.id, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(2, this));
            }
            return this.energy;
        }
    }

    class AngleCalc
    extends Calculation {
        AngleCalc() {
        }

        void setData(Vector calc, int i) {
            double c0;
            double c1;
            double c2;
            int[] angle = CalculationsUFF.this.angles[i];
            this.ia = angle[0];
            this.a = CalculationsUFF.this.atoms[this.ia];
            this.ib = angle[1];
            this.b = CalculationsUFF.this.atoms[this.ib];
            this.ic = angle[2];
            this.c = CalculationsUFF.this.atoms[this.ic];
            boolean isHXH = this.a.type.equals("H_") && this.c.type.equals("H_");
            this.parA = Calculations.getParameter(this.a.type, CalculationsUFF.this.ffParams);
            this.parB = Calculations.getParameter(this.b.type, CalculationsUFF.this.ffParams);
            this.parC = Calculations.getParameter(this.c.type, CalculationsUFF.this.ffParams);
            int coordination = this.parB.iVal[0];
            double zi = this.parA.dVal[5];
            double zk = this.parC.dVal[5];
            double theta0 = this.parB.dVal[1];
            double cosT0 = Math.cos(theta0);
            double sinT0 = Math.sin(theta0);
            switch (coordination) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    c2 = 0.0;
                    c1 = 0.0;
                    c0 = 0.0;
                    break;
                }
                default: {
                    c2 = 1.0 / (4.0 * sinT0 * sinT0);
                    c1 = -4.0 * c2 * cosT0;
                    c0 = c2 * (2.0 * cosT0 * cosT0 + 1.0);
                }
            }
            MinBond bond = this.a.getBondTo(this.ib);
            double bondorder = bond.atomIndexes[2];
            if (bond.isAromatic) {
                bondorder = 1.5;
            }
            if (bond.isAmide) {
                bondorder = 1.41;
            }
            this.rab = CalculationsUFF.calculateR0(this.parA.dVal[0], this.parB.dVal[0], this.parA.dVal[8], this.parB.dVal[8], bondorder);
            bond = this.c.getBondTo(this.ib);
            bondorder = bond.atomIndexes[2];
            if (bond.isAromatic) {
                bondorder = 1.5;
            }
            if (bond.isAmide) {
                bondorder = 1.41;
            }
            double rbc = CalculationsUFF.calculateR0(this.parB.dVal[0], this.parC.dVal[0], this.parB.dVal[8], this.parC.dVal[8], bondorder);
            double rac = Math.sqrt(this.rab * this.rab + rbc * rbc - 2.0 * this.rab * rbc * cosT0);
            double ka = 2696.8016159999997 * (zi * zk / Math.pow(rac, 5.0)) * (3.0 * this.rab * rbc * (1.0 - cosT0 * cosT0) - rac * rac * cosT0);
            calc.addElement(new Object[]{new int[]{this.ia, this.ib, this.ic, coordination}, new double[]{ka, c0 - c2, c1, 2.0 * c2, theta0 * 57.29577951308232, isHXH ? ka * 10.0 : ka}});
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            this.ic = this.iData[2];
            int coordination = this.iData[3];
            double ka = CalculationsUFF.this.isPreliminary ? this.dData[4] : this.dData[0];
            double a0 = this.dData[1];
            double a1 = this.dData[2];
            double a2 = this.dData[3];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                CalculationsUFF.this.dc.set(CalculationsUFF.this.atoms[this.ic].coord);
                this.theta = Util.restorativeForceAndAngleRadians(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.theta = Util.getAngleRadiansABC(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord, CalculationsUFF.this.atoms[this.ic].coord);
            }
            if (!Util.isFinite(this.theta)) {
                this.theta = 0.0;
            }
            if ((coordination == 4 || coordination == 6) && (this.theta > 2.35619 || this.theta < 0.785398)) {
                coordination = 1;
            }
            double cosT = Math.cos(this.theta);
            double sinT = Math.sin(this.theta);
            switch (coordination) {
                case 0: 
                case 1: {
                    this.energy = ka * (1.0 + cosT) * (1.0 + cosT) / 4.0;
                    break;
                }
                case 2: {
                    this.energy = ka * (1.0 + 4.0 * cosT * (1.0 + cosT)) / 9.0;
                    break;
                }
                case 4: 
                case 6: {
                    this.energy = ka * cosT * cosT;
                    break;
                }
                default: {
                    this.energy = ka * (a0 + a1 * cosT + a2 * cosT * cosT);
                }
            }
            if (CalculationsUFF.this.gradients) {
                switch (coordination) {
                    case 0: 
                    case 1: {
                        this.dE = -0.5 * ka * sinT * (1.0 + cosT);
                        break;
                    }
                    case 2: {
                        this.dE = -4.0 * sinT * ka * (1.0 - 2.0 * cosT) / 9.0;
                        break;
                    }
                    case 4: 
                    case 6: {
                        this.dE = -ka * sinT * cosT;
                        break;
                    }
                    default: {
                        this.dE = -ka * (a1 * sinT - 2.0 * a2 * cosT * sinT);
                    }
                }
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.dc, this.ic, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(1, this));
            }
            return this.energy;
        }
    }

    class DistanceCalc
    extends Calculation {
        double r0;
        double kb;

        DistanceCalc() {
        }

        void setData(Vector calc, int ia, int ib, double bondOrder) {
            this.parA = Calculations.getParameter(CalculationsUFF.this.atoms[ia].type, CalculationsUFF.this.ffParams);
            this.parB = Calculations.getParameter(CalculationsUFF.this.atoms[ib].type, CalculationsUFF.this.ffParams);
            this.r0 = CalculationsUFF.calculateR0(this.parA.dVal[0], this.parB.dVal[0], this.parA.dVal[8], this.parB.dVal[8], bondOrder);
            this.kb = 1390.2842991599998 * this.parA.dVal[5] * this.parB.dVal[5] / (this.r0 * this.r0 * this.r0);
            calc.addElement(new Object[]{new int[]{ia, ib}, new double[]{this.r0, this.kb, bondOrder}});
        }

        double compute(Object[] dataIn) {
            this.getPointers(dataIn);
            this.r0 = this.dData[0];
            this.kb = this.dData[1];
            this.ia = this.iData[0];
            this.ib = this.iData[1];
            if (CalculationsUFF.this.gradients) {
                CalculationsUFF.this.da.set(CalculationsUFF.this.atoms[this.ia].coord);
                CalculationsUFF.this.db.set(CalculationsUFF.this.atoms[this.ib].coord);
                this.rab = Util.restorativeForceAndDistance(CalculationsUFF.this.da, CalculationsUFF.this.db, CalculationsUFF.this.dc);
            } else {
                this.rab = Math.sqrt(Util.distance2(CalculationsUFF.this.atoms[this.ia].coord, CalculationsUFF.this.atoms[this.ib].coord));
            }
            this.delta = this.rab - this.r0;
            this.energy = this.kb * this.delta * this.delta;
            if (CalculationsUFF.this.gradients) {
                this.dE = 2.0 * this.kb * this.delta;
                CalculationsUFF.this.addForce(CalculationsUFF.this.da, this.ia, this.dE);
                CalculationsUFF.this.addForce(CalculationsUFF.this.db, this.ib, this.dE);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(0, this));
            }
            return this.energy;
        }
    }
}

