/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public abstract class ForceField {
    static final int ENERGY = 1;
    static final int EBOND = 2;
    static final int EANGLE = 4;
    static final int ESTRBND = 8;
    static final int ETORSION = 16;
    static final int EOOP = 32;
    static final int EVDW = 64;
    static final int EELECTROSTATIC = 128;
    Calculations calc;
    private double criterion;
    private double e0;
    private double dE;
    private int currentStep;
    private int stepMax;
    private double[][] coordSaved;
    int atomCount;
    int bondCount;
    Viewer viewer;
    MinAtom[] atoms;
    MinBond[] bonds;
    BitSet bsFixed;

    private String getUnits() {
        return this.calc.getUnit();
    }

    public abstract Vector getAtomTypes();

    protected abstract Hashtable getFFParameters();

    public void setModel(Minimizer m) {
        this.viewer = m.viewer;
        this.atoms = m.minAtoms;
        this.bonds = m.minBonds;
        this.bsFixed = m.bsMinFixed;
        this.atomCount = this.atoms.length;
        this.bondCount = this.bonds.length;
    }

    public void setConstraints(Minimizer m) {
        this.bsFixed = m.bsMinFixed;
        this.calc.setConstraints(m.constraints);
    }

    public boolean setup() {
        if (this.calc.haveParams()) {
            return true;
        }
        Hashtable temp = this.getFFParameters();
        if (temp == null) {
            return false;
        }
        this.calc.setParams(temp);
        return this.calc.setupCalculations();
    }

    public void steepestDescentInitialize(int stepMax, double criterion) {
        this.stepMax = stepMax;
        this.criterion = criterion;
        this.currentStep = 0;
        this.clearForces();
        this.calc.setLoggingEnabled(true);
        this.calc.setLoggingEnabled(stepMax == 0 || Logger.isActiveLevel(6));
        String s = this.calc.getDebugHeader(-1) + "Jmol Minimization Version " + Viewer.getJmolVersion() + "\n";
        this.calc.appendLogData(s);
        Logger.info(s);
        if (this.calc.loggingEnabled) {
            this.calc.appendLogData(this.calc.getAtomList("S T E E P E S T   D E S C E N T"));
        }
        this.dE = 0.0;
        this.calc.setPreliminary(stepMax > 0);
        this.e0 = this.energyFull(false, false);
        s = TextFormat.sprintf(" Initial E = %10.3f " + this.calc.getUnit() + " criterion = %8.6f max steps = " + stepMax, new Object[]{new Float(this.e0), new Float(criterion)});
        this.viewer.showString(s, false);
        this.calc.appendLogData(s);
    }

    private void clearForces() {
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].force[2] = 0.0;
            this.atoms[i].force[1] = 0.0;
            this.atoms[i].force[0] = 0.0;
        }
    }

    public boolean steepestDescentTakeNSteps(int n) {
        if (this.stepMax == 0) {
            return false;
        }
        boolean isPreliminary = true;
        for (int iStep = 1; iStep <= n; ++iStep) {
            String s;
            ++this.currentStep;
            this.calc.setSilent(true);
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.bsFixed != null && this.bsFixed.get(i)) continue;
                this.setForcesUsingNumericalDerivative(this.atoms[i], 1);
            }
            this.linearSearch();
            this.calc.setSilent(false);
            if (this.calc.loggingEnabled) {
                this.calc.appendLogData(this.calc.getAtomList("S T E P    " + this.currentStep));
            }
            double e1 = this.energyFull(false, false);
            this.dE = e1 - this.e0;
            boolean done = Util.isNear(e1, this.e0, this.criterion);
            if (done || this.currentStep % 10 == 0 || this.stepMax <= this.currentStep) {
                s = TextFormat.sprintf(" Step %-4d E = %10.6f    dE = %8.6f", new Object[]{new float[]{(float)e1, (float)this.dE, (float)this.criterion}, new Integer(this.currentStep)});
                this.viewer.showString(s, false);
                this.calc.appendLogData(s);
            }
            this.e0 = e1;
            if (done || this.stepMax <= this.currentStep) {
                if (this.calc.loggingEnabled) {
                    this.calc.appendLogData(this.calc.getAtomList("F I N A L  G E O M E T R Y"));
                }
                if (done) {
                    s = TextFormat.formatString("\n   STEEPEST DESCENT HAS CONVERGED: E = %8.5f " + this.getUnits() + " after " + this.currentStep + " steps", "f", (float)e1);
                    this.calc.appendLogData(s);
                    this.viewer.scriptEcho(s);
                    Logger.info(s);
                }
                return false;
            }
            if (!isPreliminary || !(this.getNormalizedDE() >= 2.0)) continue;
            isPreliminary = false;
            this.calc.setPreliminary(false);
            this.e0 = this.energyFull(false, false);
        }
        return true;
    }

    private double getEnergy(int terms, boolean gradients) {
        if ((terms & 1) != 0) {
            return this.energyFull(gradients, true);
        }
        double e = 0.0;
        if ((terms & 2) != 0) {
            e += this.energyBond(gradients);
        }
        if ((terms & 4) != 0) {
            e += this.energyAngle(gradients);
        }
        if ((terms & 8) != 0) {
            e += this.energyStrBnd(gradients);
        }
        if ((terms & 0x10) != 0) {
            e += this.energyTorsion(gradients);
        }
        if ((terms & 0x20) != 0) {
            e += this.energyOOP(gradients);
        }
        if ((terms & 0x40) != 0) {
            e += this.energyVDW(gradients);
        }
        if ((terms & 0x80) != 0) {
            e += this.energyES(gradients);
        }
        return e;
    }

    private void setForcesUsingNumericalDerivative(MinAtom atom, int terms) {
        double delta = 1.0E-5;
        atom.force[0] = -this.getDE(atom, terms, 0, delta);
        atom.force[1] = -this.getDE(atom, terms, 1, delta);
        atom.force[2] = -this.getDE(atom, terms, 2, delta);
    }

    private double getDE(MinAtom atom, int terms, int i, double delta) {
        int n = i;
        atom.coord[n] = atom.coord[n] + delta;
        double e = this.getEnergy(terms, false);
        int n2 = i;
        atom.coord[n2] = atom.coord[n2] - delta;
        return (e - this.e0) / delta;
    }

    public double energyFull(boolean gradients, boolean isSilent) {
        if (gradients) {
            this.clearForces();
        }
        double energy = this.energyBond(gradients) + this.energyAngle(gradients) + this.energyTorsion(gradients) + this.energyOOP(gradients) + this.energyVDW(gradients) + this.energyES(gradients);
        if (!isSilent && this.calc.loggingEnabled) {
            this.calc.appendLogData(TextFormat.sprintf("\nTOTAL ENERGY = %8.3f %s\n", new Object[]{new Float(energy), this.getUnits()}));
        }
        return energy;
    }

    double energyStrBnd(boolean gradients) {
        return 0.0;
    }

    double energyBond(boolean gradients) {
        return this.calc.energyBond(gradients);
    }

    double energyAngle(boolean gradients) {
        return this.calc.energyAngle(gradients);
    }

    double energyTorsion(boolean gradients) {
        return this.calc.energyTorsion(gradients);
    }

    double energyOOP(boolean gradients) {
        return this.calc.energyOOP(gradients);
    }

    double energyVDW(boolean gradients) {
        return this.calc.energyVDW(gradients);
    }

    double energyES(boolean gradients) {
        return this.calc.energyES(gradients);
    }

    private void linearSearch() {
        double alpha = 0.0;
        double step = 0.23;
        double trustRadius = 0.3;
        double trustRadius2 = trustRadius * trustRadius;
        double e1 = this.energyFull(false, true);
        for (int iStep = 0; iStep < 10; ++iStep) {
            this.saveCoordinates();
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.bsFixed != null && this.bsFixed.get(i)) continue;
                double[] force = this.atoms[i].force;
                double[] coord = this.atoms[i].coord;
                double f2 = force[0] * force[0] + force[1] * force[1] + force[2] * force[2];
                if (f2 > trustRadius2 / step / step) {
                    f2 = trustRadius / Math.sqrt(f2) / step;
                    force[0] = force[0] * f2;
                    force[1] = force[1] * f2;
                    force[2] = force[2] * f2;
                }
                for (int j = 0; j < 3; ++j) {
                    if (!Util.isFinite(force[j])) continue;
                    double tempStep = force[j] * step;
                    if (tempStep > trustRadius) {
                        int n = j;
                        coord[n] = coord[n] + trustRadius;
                        continue;
                    }
                    if (tempStep < -trustRadius) {
                        int n = j;
                        coord[n] = coord[n] - trustRadius;
                        continue;
                    }
                    int n = j;
                    coord[n] = coord[n] + tempStep;
                }
            }
            double e2 = this.energyFull(false, true);
            if (Util.isNear(e2, e1, 0.001)) break;
            if (e2 > e1) {
                step *= 0.1;
                this.restoreCoordinates();
                continue;
            }
            if (!(e2 < e1)) continue;
            e1 = e2;
            alpha += step;
            if (!((step *= 2.15) > 1.0)) continue;
            step = 1.0;
        }
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.atomCount][3];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.atoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.atoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
    }

    public boolean detectExplosion() {
        int i;
        for (i = 0; i < this.atomCount; ++i) {
            MinAtom atom = this.atoms[i];
            for (int j = 0; j < 3; ++j) {
                if (Util.isFinite(atom.coord[j])) continue;
                return true;
            }
        }
        for (i = 0; i < this.bondCount; ++i) {
            MinBond bond = this.bonds[i];
            if (!(Util.distance2(this.atoms[bond.atomIndexes[0]].coord, this.atoms[bond.atomIndexes[1]].coord) > 900.0)) continue;
            return true;
        }
        return false;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public double getEnergy() {
        return this.e0;
    }

    public String getAtomList(String title) {
        return this.calc.getAtomList(title);
    }

    public double getEnergyDiff() {
        return this.dE;
    }

    public String getLogData() {
        return this.calc.getLogData();
    }

    double getNormalizedDE() {
        return Math.abs(this.dE / this.criterion);
    }
}

