/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class ForceFieldUFF
extends ForceField {
    public void setModel(Minimizer m) {
        super.setModel(m);
        this.calc = new CalculationsUFF(this, m.minAtoms, m.minBonds, m.angles, m.torsions, m.partialCharges, m.constraints);
    }

    protected Hashtable getFFParameters() {
        Hashtable<String, FFParam> temp = new Hashtable<String, FFParam>();
        URL url = null;
        String fileName = "UFF.txt";
        BufferedReader br = null;
        try {
            String line;
            url = this.getClass().getResource(fileName);
            if (url == null) {
                System.err.println("Couldn't find file: " + fileName);
                throw new NullPointerException();
            }
            br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                String[] vs = Parser.getTokens(line);
                if (vs.length < 13) continue;
                if (Logger.debugging) {
                    Logger.info(line);
                }
                if (!line.substring(0, 5).equals("param")) continue;
                FFParam ffParam = new FFParam();
                temp.put(vs[1], ffParam);
                ffParam.dVal = new double[11];
                ffParam.sVal = new String[1];
                ffParam.sVal[0] = vs[1];
                ffParam.dVal[0] = Parser.parseFloat(vs[2]);
                ffParam.dVal[1] = (double)Parser.parseFloat(vs[3]) * (Math.PI / 180);
                ffParam.dVal[2] = Parser.parseFloat(vs[4]);
                ffParam.dVal[3] = Parser.parseFloat(vs[5]);
                ffParam.dVal[4] = Parser.parseFloat(vs[6]);
                ffParam.dVal[5] = Parser.parseFloat(vs[7]);
                ffParam.dVal[6] = Parser.parseFloat(vs[8]);
                ffParam.dVal[7] = Parser.parseFloat(vs[9]);
                ffParam.dVal[8] = Parser.parseFloat(vs[10]);
                ffParam.dVal[9] = Parser.parseFloat(vs[11]);
                ffParam.dVal[10] = Parser.parseFloat(vs[12]);
                ffParam.iVal = new int[1];
                int coord = vs[1].length() > 2 ? (int)vs[1].charAt(2) : 49;
                switch (coord) {
                    case 82: {
                        coord = 50;
                        break;
                    }
                    default: {
                        coord = 49;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                }
                ffParam.iVal[0] = coord - 48;
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage() + " in getResource " + fileName);
            try {
                br.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            return null;
        }
        Logger.info(temp.size() + " atom types read from " + fileName);
        return temp;
    }

    public Vector getAtomTypes() {
        Vector<String[]> types = new Vector<String[]>();
        URL url = null;
        String fileName = "UFF.txt";
        try {
            String line;
            url = this.getClass().getResource(fileName);
            if (url == null) {
                System.err.println("Couldn't find file: " + fileName);
                throw new NullPointerException();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
            while ((line = br.readLine()) != null) {
                if (line.length() <= 4 || !line.substring(0, 4).equals("atom")) continue;
                String[] vs = Parser.getTokens(line);
                String[] info = new String[]{vs[1], vs[2]};
                types.addElement(info);
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage() + " in getResource " + fileName);
        }
        Logger.info(types.size() + " force field parameters read");
        return types.size() > 0 ? types : null;
    }
}

