/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi {
    private static final byte VIBRATION_VECTOR_FLAG = 1;
    private static final byte IS_HETERO_FLAG = 2;
    private static final byte FLAG_MASK = 3;
    public static final int RADIUS_MAX = 16;
    private static final int MAD_MAX = 32000;
    Group group;
    int atomIndex;
    BitSet atomSymmetry;
    int atomSite;
    private float userDefinedVanDerWaalRadius;
    short modelIndex;
    private short atomicAndIsotopeNumber;
    private byte formalChargeAndFlags;
    private byte valence;
    char alternateLocationID;
    short madAtom;
    short colixAtom;
    byte paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;
    boolean isSimple = false;

    public int getScreenRadius() {
        return this.screenDiameter / 2;
    }

    public short getMadAtom() {
        return this.madAtom;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Atom(Point3f pt) {
        this.isSimple = true;
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
    }

    Atom(Viewer viewer, int modelIndex, int atomIndex, BitSet atomSymmetry, int atomSite, short atomicAndIsotopeNumber, int size, int formalCharge, float x, float y, float z, boolean isHetero, char chainID, char alternateLocationID, float radius) {
        this.modelIndex = (short)modelIndex;
        this.atomSymmetry = atomSymmetry;
        this.atomSite = atomSite;
        this.atomIndex = atomIndex;
        this.atomicAndIsotopeNumber = atomicAndIsotopeNumber;
        if (isHetero) {
            this.formalChargeAndFlags = (byte)2;
        }
        this.setFormalCharge(formalCharge);
        this.alternateLocationID = alternateLocationID;
        this.userDefinedVanDerWaalRadius = radius;
        this.setMadAtom(viewer, size, Float.NaN);
        this.set(x, y, z);
    }

    public final void setShapeVisibilityFlags(int flag) {
        this.shapeVisibilityFlags = flag;
    }

    public final void setShapeVisibility(int shapeVisibilityFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= shapeVisibilityFlag) : (this.shapeVisibilityFlags &= ~shapeVisibilityFlag);
    }

    public boolean isBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(this) != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(atomOther) == null) continue;
                return this.bonds[i];
            }
        }
        return null;
    }

    void addDisplayedBond(int stickVisibilityFlag, boolean isVisible) {
        this.nBondsDisplayed += isVisible ? 1 : -1;
        this.setShapeVisibility(stickVisibilityFlag, isVisible);
    }

    public void addDisplayedBackbone(int backboneVisibilityFlag, boolean isVisible) {
        this.nBackbonesDisplayed += isVisible ? 1 : -1;
        this.setShapeVisibility(backboneVisibilityFlag, isVisible);
    }

    void deleteBond(Bond bond) {
        int i = this.bonds.length;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.deleteBond(i);
            return;
        }
    }

    private void deleteBond(int i) {
        int j;
        int newLength = this.bonds.length - 1;
        if (newLength == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondsNew = new Bond[newLength];
        for (j = 0; j < i; ++j) {
            bondsNew[j] = this.bonds[j];
        }
        while (j < newLength) {
            bondsNew[j] = this.bonds[j + 1];
            ++j;
        }
        this.bonds = bondsNew;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int bondIndex) {
        return this.bonds[bondIndex].getOtherAtom((Atom)this).atomIndex;
    }

    public void setMadAtom(Viewer viewer, int size, float fsize) {
        this.madAtom = this.convertEncodedMad(viewer, size, fsize);
    }

    public short convertEncodedMad(Viewer viewer, int size, float fsize) {
        short mad;
        if (Float.isNaN(fsize)) {
            switch (size) {
                case 0: {
                    return 0;
                }
                case -1000: {
                    int diameter = this.getBfactor100() * 10 * 2;
                    if (diameter > 4000) {
                        diameter = 4000;
                    }
                    size = diameter;
                    break;
                }
                case -1001: {
                    size = this.getBondingMar() * 2;
                    break;
                }
                case -100: {
                    size = this.getVanderwaalsMad(viewer);
                }
                default: {
                    if (size <= Short.MIN_VALUE) {
                        float d = 2000.0f * this.getADPMinMax(false);
                        if (size < Short.MIN_VALUE) {
                            size = (int)(d * (float)(Short.MIN_VALUE - size) / 100.0f);
                            break;
                        }
                        size = (int)d;
                        break;
                    }
                    if (size < -2000) {
                        int iMode = -size / 1000 - 2;
                        size = -size % 1000;
                        size = (int)((float)size / 50.0f * (float)viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128, iMode));
                        break;
                    }
                    if (size < 0) {
                        if ((size = -size) > 200) {
                            size = 200;
                        }
                        size = (int)((float)size / 100.0f * (float)this.getVanderwaalsMad(viewer));
                        break;
                    }
                    if (size >= Short.MAX_VALUE) {
                        float d = 2000.0f * this.getADPMinMax(true);
                        if (size > Short.MAX_VALUE) {
                            size = (int)(d * (float)(size - Short.MAX_VALUE) / 100.0f);
                            break;
                        }
                        size = (int)d;
                        break;
                    }
                    if (size >= 10000) {
                        size = size - 10000 + this.getVanderwaalsMad(viewer);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if ((size = (int)(fsize * 2000.0f) + (size == 1 ? this.getVanderwaalsMad(viewer) : 0)) > 32000) {
            size = 32000;
        }
        if ((mad = (short)size) < 0) {
            mad = 0;
        }
        if (mad == 1) {
            System.out.println("testing Atom");
        }
        return mad;
    }

    public float getADPMinMax(boolean isMax) {
        Object[] ellipsoid = this.getEllipsoid();
        if (ellipsoid == null) {
            return 0.0f;
        }
        return ((float[])ellipsoid[1])[isMax ? 5 : 3];
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 0x3FF) == 0) continue;
            ++n;
        }
        return n;
    }

    int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 0x3FF) == 0 || this.bonds[i].getOtherAtom(this).getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setColixAtom(short colixAtom) {
        this.colixAtom = colixAtom;
    }

    public void setPaletteID(byte paletteID) {
        this.paletteID = paletteID;
    }

    public void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colixAtom = Graphics3D.getColixTranslucent(this.colixAtom, isTranslucent, translucentLevel);
    }

    public boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colixAtom);
    }

    public short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    public short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    public short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || n % 128 >= JmolConstants.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbol(boolean withIsotope) {
        return JmolConstants.elementSymbolFromNumber(withIsotope ? this.atomicAndIsotopeNumber : this.atomicAndIsotopeNumber % 128);
    }

    public String getElementSymbol() {
        return this.getElementSymbol(true);
    }

    public char getAlternateLocationID() {
        return this.alternateLocationID;
    }

    boolean isAlternateLocationMatch(String strPattern) {
        if (strPattern == null) {
            return this.alternateLocationID == '\u0000';
        }
        if (strPattern.length() != 1) {
            return false;
        }
        char ch = strPattern.charAt(0);
        return ch == '*' || ch == '?' && this.alternateLocationID != '\u0000' || this.alternateLocationID == ch;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    void setFormalCharge(int charge) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 3 | (charge == Integer.MIN_VALUE ? 0 : (charge > 7 ? 7 : (charge < -3 ? -3 : charge))) << 2);
    }

    void setVibrationVector() {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 1);
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 2;
    }

    public int getOccupancy100() {
        byte[] occupancies = this.group.chain.modelSet.occupancies;
        return occupancies == null ? 100 : occupancies[this.atomIndex];
    }

    public int getBfactor100() {
        short[] bfactor100s = this.group.chain.modelSet.bfactor100s;
        if (bfactor100s == null) {
            return 0;
        }
        return bfactor100s[this.atomIndex];
    }

    public boolean setRadius(float radius) {
        this.userDefinedVanDerWaalRadius = radius > 0.0f ? radius : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void setValence(int nBonds) {
        this.valence = (byte)(nBonds < 0 ? 0 : (nBonds < 239 ? nBonds : 239));
    }

    public int getValence() {
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                n += this.bonds[i].getValence();
            }
        }
        return n;
    }

    public float getDimensionValue(int dimension) {
        return dimension == 0 ? this.x : (dimension == 1 ? this.y : this.z);
    }

    private int getVanderwaalsMad(Viewer viewer) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) * 2 : (int)(this.userDefinedVanDerWaalRadius * 2000.0f);
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, this.getFormalCharge());
    }

    public float getVanderwaalsRadiusFloat() {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)this.group.chain.modelSet.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    public float getCovalentRadiusFloat() {
        return (float)JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, 0) / 1000.0f;
    }

    public float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Viewer viewer) {
        if ((this.formalChargeAndFlags & 1) == 0) ** GOTO lbl-1000
        vibrationVectors = this.group.chain.modelSet.vibrationVectors;
        if (this.group.chain.modelSet.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            screen = viewer.transformPoint(this);
        } else {
            screen = viewer.transformPoint((Point3f)this, vibrationVectors[this.atomIndex]);
        }
        this.screenX = screen.x;
        this.screenY = screen.y;
        this.screenZ = screen.z;
        this.screenDiameter = viewer.scaleToScreen(this.screenZ, Math.abs(this.madAtom));
    }

    public String getAtomName() {
        return this.group.chain.modelSet.atomNames[this.atomIndex];
    }

    public String getAtomType() {
        String[] atomTypes = this.group.chain.modelSet.atomTypes;
        String type = atomTypes == null ? null : atomTypes[this.atomIndex];
        return type == null ? this.group.chain.modelSet.atomNames[this.atomIndex] : type;
    }

    public int getAtomNumber() {
        int[] atomSerials = this.group.chain.modelSet.atomSerials;
        return atomSerials != null ? atomSerials[this.atomIndex] : this.atomIndex;
    }

    public boolean isModelVisible() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    public boolean isShapeVisible(int shapeVisibilityFlag) {
        return this.isModelVisible() && (this.shapeVisibilityFlags & shapeVisibilityFlag) != 0;
    }

    public float getPartialCharge() {
        float[] partialCharges = this.group.chain.modelSet.partialCharges;
        return partialCharges == null ? 0.0f : partialCharges[this.atomIndex];
    }

    public float getStraightness() {
        return this.group.getStraightness();
    }

    public Object[] getEllipsoid() {
        return this.group.chain.modelSet.getEllipsoid(this.atomIndex);
    }

    public int getSymmetryTranslation(int symop, int[] cellRange, int nOps) {
        int pt = symop;
        for (int i = 0; i < cellRange.length; ++i) {
            if (!this.atomSymmetry.get(pt += nOps)) continue;
            return cellRange[i];
        }
        return 0;
    }

    public int getCellTranslation(int cellNNN, int[] cellRange, int nOps) {
        int pt = nOps;
        for (int i = 0; i < cellRange.length; ++i) {
            int j = 0;
            while (j < nOps) {
                if (this.atomSymmetry.get(pt) && cellRange[i] == cellNNN) {
                    return cellRange[i];
                }
                ++j;
                ++pt;
            }
        }
        return 0;
    }

    String getSymmetryOperatorList() {
        int nOps;
        String str = "";
        ModelSet f = this.group.chain.modelSet;
        if (this.atomSymmetry == null || f.unitCells == null || f.unitCells[this.modelIndex] == null) {
            return "";
        }
        int[] cellRange = f.getModelCellRange(this.modelIndex);
        if (cellRange == null) {
            return "";
        }
        int pt = nOps = f.getModelSymmetryCount(this.modelIndex);
        for (int i = 0; i < cellRange.length; ++i) {
            for (int j = 0; j < nOps; ++j) {
                if (!this.atomSymmetry.get(pt++)) continue;
                str = str + "," + (j + 1) + "" + cellRange[i];
            }
        }
        return str.substring(1);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getMoleculeNumber() {
        return this.group.chain.modelSet.getMoleculeIndex(this.atomIndex) + 1;
    }

    String getClientAtomStringProperty(String propertyName) {
        Object[] clientAtomReferences = this.group.chain.modelSet.clientAtomReferences;
        return clientAtomReferences == null || clientAtomReferences.length <= this.atomIndex ? null : this.group.chain.modelSet.viewer.getClientAtomStringProperty(clientAtomReferences[this.atomIndex], propertyName);
    }

    public byte getSpecialAtomID() {
        byte[] specialAtomIDs = this.group.chain.modelSet.specialAtomIDs;
        return specialAtomIDs == null ? (byte)0 : specialAtomIDs[this.atomIndex];
    }

    public float getFractionalCoord(char ch) {
        Point3f pt = this.getFractionalCoord();
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    public float getFractionalUnitCoord(char ch) {
        Point3f pt = this.getFractionalUnitCoord(false);
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    public Point3f getFractionalCoord() {
        SymmetryInterface[] c = this.group.chain.modelSet.unitCells;
        Point3f pt = new Point3f(this);
        if (c != null) {
            c[this.modelIndex].toFractional(pt);
        }
        return pt;
    }

    public Point3f getFractionalUnitCoord(boolean asCartesian) {
        SymmetryInterface[] c = this.group.chain.modelSet.unitCells;
        Point3f pt = new Point3f(this);
        if (c != null) {
            c[this.modelIndex].toUnitCell(pt, null);
            if (!asCartesian) {
                c[this.modelIndex].toFractional(pt);
            }
        }
        return pt;
    }

    public float getFractionalUnitDistance(Point3f pt, Point3f ptTemp1, Point3f ptTemp2) {
        SymmetryInterface[] c = this.group.chain.modelSet.unitCells;
        if (c == null) {
            return this.distance(pt);
        }
        ptTemp1.set(this);
        c[this.modelIndex].toUnitCell(ptTemp1, null);
        ptTemp2.set(pt);
        c[this.modelIndex].toUnitCell(ptTemp2, null);
        return ptTemp1.distance(ptTemp2);
    }

    void setFractionalCoord(int tok, float fValue) {
        SymmetryInterface[] c = this.group.chain.modelSet.unitCells;
        if (c != null) {
            c[this.modelIndex].toFractional(this);
        }
        switch (tok) {
            case 38797574: {
                this.x = fValue;
                break;
            }
            case 38797575: {
                this.y = fValue;
                break;
            }
            case 38797576: {
                this.z = fValue;
            }
        }
        if (c != null) {
            c[this.modelIndex].toCartesian(this);
        }
    }

    void setFractionalCoord(Point3f ptNew) {
        this.set(ptNew);
        SymmetryInterface[] c = this.group.chain.modelSet.unitCells;
        if (c != null) {
            c[this.modelIndex].toCartesian(this);
        }
    }

    boolean isCursorOnTopOf(int xCursor, int yCursor, int minRadius, Atom competitor) {
        int r2;
        int dx;
        int dx2;
        int r = this.screenDiameter / 2;
        if (r < minRadius) {
            r = minRadius;
        }
        if ((dx2 = (dx = this.screenX - xCursor) * dx) > (r2 = r * r)) {
            return false;
        }
        int dy = this.screenY - yCursor;
        int dy2 = dy * dy;
        int dz2 = r2 - (dx2 + dy2);
        if (dz2 < 0) {
            return false;
        }
        if (competitor == null) {
            return true;
        }
        int z = this.screenZ;
        int zCompetitor = competitor.screenZ;
        int rCompetitor = competitor.screenDiameter / 2;
        if (z < zCompetitor - rCompetitor) {
            return true;
        }
        int dxCompetitor = competitor.screenX - xCursor;
        int dx2Competitor = dxCompetitor * dxCompetitor;
        int dyCompetitor = competitor.screenY - yCursor;
        int dy2Competitor = dyCompetitor * dyCompetitor;
        int r2Competitor = rCompetitor * rCompetitor;
        int dz2Competitor = r2Competitor - (dx2Competitor + dy2Competitor);
        return (double)z - Math.sqrt(dz2) < (double)zCompetitor - Math.sqrt(dz2Competitor);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    String getInfoXYZ(boolean useChimeFormat) {
        if (useChimeFormat) {
            String group3 = this.getGroup3(true);
            char chainID = this.getChainID();
            Point3f pt = this.group.chain.modelSet.unitCells == null ? null : this.getFractionalCoord();
            return "Atom: " + (group3 == null ? this.getElementSymbol() : this.getAtomName()) + " " + this.getAtomNumber() + (group3 != null && group3.length() > 0 ? (this.isHetero() ? " Hetero: " : " Group: ") + group3 + " " + this.getResno() + (chainID != '\u0000' && chainID != ' ' ? " Chain: " + chainID : "") : "") + " Model: " + this.getModelNumber() + " Coordinates: " + this.x + " " + this.y + " " + this.z + (pt == null ? "" : " Fractional: " + pt.x + " " + pt.y + " " + pt.z);
        }
        return this.getIdentity(true) + " " + this.x + " " + this.y + " " + this.z;
    }

    String getIdentityXYZ() {
        return this.getIdentity(false) + " " + this.x + " " + this.y + " " + this.z;
    }

    String getIdentity(boolean allInfo) {
        StringBuffer info = new StringBuffer();
        String group3 = this.getGroup3(true);
        String seqcodeString = this.getSeqcodeString();
        char chainID = this.getChainID();
        if (group3 != null && group3.length() > 0) {
            info.append("[");
            info.append(group3);
            info.append("]");
        }
        if (seqcodeString != null) {
            info.append(seqcodeString);
        }
        if (chainID != '\u0000' && chainID != ' ') {
            info.append(":");
            info.append(chainID);
        }
        if (!allInfo) {
            return info.toString();
        }
        if (info.length() > 0) {
            info.append(".");
        }
        info.append(this.getAtomName());
        if (info.length() == 0) {
            info.append(this.getElementSymbol(false));
            info.append(" ");
            info.append(this.getAtomNumber());
        }
        if (this.alternateLocationID != '\u0000') {
            info.append("%");
            info.append(this.alternateLocationID);
        }
        if (this.group.chain.modelSet.getModelCount() > 1) {
            info.append("/");
            info.append(this.getModelNumberForLabel());
        }
        info.append(" #");
        info.append(this.getAtomNumber());
        return info.toString();
    }

    public int getGroupIndex() {
        return this.group.getGroupIndex();
    }

    public String getGroup3(boolean allowNull) {
        String group3 = this.group.getGroup3();
        return allowNull || group3 != null || group3.length() > 0 ? group3 : "UNK";
    }

    public String getGroup1(char c0) {
        char c = this.group.getGroup1();
        return c != '\u0000' ? "" + c : (c0 != '\u0000' ? "" + c0 : "");
    }

    boolean isGroup3(String group3) {
        return this.group.isGroup3(group3);
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.getSeqcode();
    }

    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        if (!this.isVisible()) {
            return false;
        }
        int flags = this.shapeVisibilityFlags | this.group.shapeVisibilityFlags;
        return (flags & this.clickabilityFlags) != 0;
    }

    public int getClickabilityFlags() {
        return this.clickabilityFlags;
    }

    public void setClickable(int flag) {
        this.clickabilityFlags = flag == 0 ? 0 : (this.clickabilityFlags |= flag);
    }

    public boolean isVisible() {
        if (!this.isModelVisible() || this.group.chain.modelSet.isAtomHidden(this.atomIndex)) {
            return false;
        }
        int flags = this.shapeVisibilityFlags;
        return ((flags |= this.group.shapeVisibilityFlags) & 0xFFFFFFFE) != 0;
    }

    public float getGroupPhi() {
        return this.group.phi;
    }

    public float getGroupPsi() {
        return this.group.psi;
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getSurfaceDistance100() {
        return this.group.chain.modelSet.getSurfaceDistance100(this.atomIndex);
    }

    public Vector3f getVibrationVector() {
        return this.group.chain.modelSet.getVibrationVector(this.atomIndex, false);
    }

    public float getVibrationCoord(char ch) {
        Point3f pt = this.getFractionalUnitCoord(false);
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    public Quaternion getQuaternion(char qtype) {
        return this.group.getQuaternion(qtype);
    }

    int getPolymerIndex() {
        return this.group.getBioPolymerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    Chain getChain() {
        return this.group.chain;
    }

    String getModelNumberForLabel() {
        return this.group.chain.modelSet.getModelNumberForAtomLabel(this.modelIndex);
    }

    public int getModelNumber() {
        return this.group.chain.modelSet.getModelNumber(this.modelIndex) % 1000000;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.modelSet.getModelFileNumber(this.modelIndex);
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public int getProteinStructureID() {
        return this.group.getProteinStructureID();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        return this.group.getSeqNumber();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.atomIndex;
    }

    public Atom findAromaticNeighbor(BitSet notAtoms) {
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bondT = this.bonds[i];
            Atom a = bondT.getOtherAtom(this);
            if (!bondT.isAromatic() || notAtoms != null && notAtoms.get(a.atomIndex)) continue;
            return a;
        }
        return null;
    }

    public Atom findAromaticNeighbor(int notAtomIndex) {
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bondT = this.bonds[i];
            Atom a = bondT.getOtherAtom(this);
            if (!bondT.isAromatic() || a.atomIndex == notAtomIndex) continue;
            return a;
        }
        return null;
    }

    public static int atomPropertyInt(Atom atom, int tokWhat) {
        switch (tokWhat) {
            case 0x1500001: {
                return atom.getAtomNumber();
            }
            case 22020098: {
                return atom.getSpecialAtomID();
            }
            case 22020099: {
                return atom.getAtomIndex();
            }
            case 22020100: {
                return atom.getCovalentBondCount();
            }
            case 558895366: {
                return atom.group.chain.modelSet.viewer.getColixArgb(atom.getColix());
            }
            case 13631749: 
            case 22020359: {
                return atom.getElementNumber();
            }
            case 156242439: {
                return atom.getModelFileIndex() + 1;
            }
            case 558891272: {
                return atom.getFormalCharge();
            }
            case 22020105: {
                return atom.getGroupID();
            }
            case 22020106: {
                return atom.getGroupIndex();
            }
            case 22024203: {
                return atom.getModelNumber();
            }
            case -22024203: {
                return atom.getModelFileNumber();
            }
            case 22020108: {
                return atom.modelIndex;
            }
            case 22020109: {
                return atom.getMoleculeNumber();
            }
            case 55574786: {
                return atom.getOccupancy100();
            }
            case 22020110: {
                return atom.getPolymerLength();
            }
            case 592445697: {
                return atom.getRasMolRadius();
            }
            case 22020111: {
                return atom.getResno();
            }
            case 0x1500010: {
                return atom.getAtomSite();
            }
            case 30412803: {
                return atom.getProteinStructureType();
            }
            case 22020114: {
                return atom.getProteinStructureID();
            }
            case 22020372: {
                return atom.getValence();
            }
        }
        return 0;
    }

    public static float atomPropertyFloat(Atom atom, int tokWhat) {
        switch (tokWhat) {
            case 592445697: {
                return atom.getRadius();
            }
            case 38797328: {
                atom.group.chain.modelSet.getSurfaceDistanceMax();
                return (float)atom.getSurfaceDistance100() / 100.0f;
            }
            case 38797585: {
                return (float)atom.getBfactor100() / 100.0f;
            }
            case 38797313: {
                return atom.getADPMinMax(true);
            }
            case 0x2500002: {
                return atom.getADPMinMax(false);
            }
            case 38797571: {
                return atom.x;
            }
            case 38797572: {
                return atom.y;
            }
            case 38797573: {
                return atom.z;
            }
            case 0x2500005: {
                return atom.getCovalentRadiusFloat();
            }
            case 38797574: {
                return atom.getFractionalCoord('X');
            }
            case 38797575: {
                return atom.getFractionalCoord('Y');
            }
            case 38797576: {
                return atom.getFractionalCoord('Z');
            }
            case 38797321: {
                return atom.getBondingRadiusFloat();
            }
            case 55574786: {
                return (float)atom.getOccupancy100() / 100.0f;
            }
            case 38797578: {
                return atom.getPartialCharge();
            }
            case 38797323: {
                return atom.getGroupPhi();
            }
            case 38797324: {
                return atom.getGroupPsi();
            }
            case 39325966: {
                return atom.getRadius();
            }
            case 38797327: {
                return atom.getStraightness();
            }
            case 38797330: {
                return atom.getFractionalUnitCoord('X');
            }
            case 38797331: {
                return atom.getFractionalUnitCoord('Y');
            }
            case 38797332: {
                return atom.getFractionalUnitCoord('Z');
            }
            case 38797589: {
                return atom.getVanderwaalsRadiusFloat();
            }
            case 38797590: {
                return atom.getVibrationCoord('X');
            }
            case 38797591: {
                return atom.getVibrationCoord('Y');
            }
            case 38797592: {
                return atom.getVibrationCoord('Z');
            }
        }
        return Atom.atomPropertyInt(atom, tokWhat);
    }

    public static String atomPropertyString(Atom atom, int tokWhat) {
        switch (tokWhat) {
            case 0xD00003: {
                char ch = atom.getAlternateLocationID();
                return ch == '\u0000' ? "" : "" + ch;
            }
            case 13631746: {
                return atom.getAtomName();
            }
            case 0xD00101: {
                return atom.getAtomType();
            }
            case 0xD00004: {
                char ch = atom.getChainID();
                return ch == '\u0000' ? "" : "" + ch;
            }
            case 0xD00008: {
                return atom.getGroup1('?');
            }
            case 0xD00007: {
                return atom.getGroup1('\u0000');
            }
            case 0xD00006: {
                return atom.getGroup3(false);
            }
            case 13631749: {
                return atom.getElementSymbol(true);
            }
            case 0xD00009: {
                return atom.getIdentity(true);
            }
            case 0xD0000A: {
                char ch = atom.getInsertionCode();
                return ch == '\u0000' ? "" : "" + ch;
            }
            case 214958338: 
            case 752374019: {
                String s = atom.group.chain.modelSet.getAtomLabel(atom.getAtomIndex());
                if (s == null) {
                    s = "";
                }
                return s;
            }
            case 30412803: {
                return JmolConstants.getProteinStructureName(atom.getProteinStructureType());
            }
            case 13631755: {
                return atom.getElementSymbol(false);
            }
            case 0xF0000C: {
                return atom.getSymmetryOperatorList();
            }
        }
        return "";
    }

    public static Tuple3f atomPropertyTuple(Atom atom, int tok) {
        switch (tok) {
            case 72352011: {
                return atom.getFractionalCoord();
            }
            case 72351756: {
                return atom.getFractionalUnitCoord(false);
            }
            case 72352013: {
                Vector3f v = atom.getVibrationVector();
                if (v == null) {
                    v = new Vector3f();
                }
                return v;
            }
            case 72352010: {
                return atom;
            }
            case 558895366: {
                return Graphics3D.colorPointFromInt2(atom.group.chain.modelSet.viewer.getColixArgb(atom.getColix()));
            }
        }
        return null;
    }
}

