/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.awt.Rectangle;
import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.bspt.Bspf;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

public abstract class AtomCollection {
    public Viewer viewer;
    protected Graphics3D g3d;
    public Atom[] atoms;
    int atomCount;
    String[] atomNames;
    String[] atomTypes;
    int[] atomSerials;
    byte[] specialAtomIDs;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    protected Object[][] ellipsoids;
    protected int[] surfaceDistance100s;
    protected boolean haveStraightness;
    private BitSet bsHidden = new BitSet();
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private int surfaceDistanceMax;
    private BitSet bsSurface;
    private int nSurfaceAtoms;
    protected Bspf bspf;
    public static final byte TAINT_ATOMNAME = 0;
    public static final byte TAINT_ATOMTYPE = 1;
    public static final byte TAINT_COORD = 2;
    private static final byte TAINT_ELEMENT = 3;
    private static final byte TAINT_FORMALCHARGE = 4;
    private static final byte TAINT_OCCUPANCY = 5;
    private static final byte TAINT_PARTIALCHARGE = 6;
    private static final byte TAINT_TEMPERATURE = 7;
    private static final byte TAINT_VALENCE = 8;
    private static final byte TAINT_VANDERWAALS = 9;
    private static final byte TAINT_VIBRATION = 10;
    public static final byte TAINT_MAX = 11;
    private static final String[] userSettableValues = new String[]{"atomName", "atomType", "coord", "element", "formalCharge", "occupany", "partialCharge", "temperature", "valence", "vanderWaals", "vibrationVector"};
    protected BitSet[] tainted;
    private static final int minimumPixelSelectionRadius = 6;
    private final BitSet bsEmpty = new BitSet();
    private final BitSet bsFoundRectangle = new BitSet();

    protected void releaseModelSet() {
        this.atoms = null;
        this.viewer = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomTypes = null;
        this.atomSerials = null;
        this.clientAtomReferences = null;
        this.vibrationVectors = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.partialCharges = null;
        this.specialAtomIDs = null;
        this.ellipsoids = null;
    }

    protected void merge(AtomCollection mergeModelSet) {
        this.tainted = mergeModelSet.tainted;
        this.atomNames = mergeModelSet.atomNames;
        this.atomTypes = mergeModelSet.atomTypes;
        this.atomSerials = mergeModelSet.atomSerials;
        this.clientAtomReferences = mergeModelSet.clientAtomReferences;
        this.vibrationVectors = mergeModelSet.vibrationVectors;
        this.occupancies = mergeModelSet.occupancies;
        this.bfactor100s = mergeModelSet.bfactor100s;
        this.partialCharges = mergeModelSet.partialCharges;
        this.ellipsoids = mergeModelSet.ellipsoids;
        this.specialAtomIDs = mergeModelSet.specialAtomIDs;
        this.setHaveStraightness(false);
    }

    public void setHaveStraightness(boolean TF) {
        this.haveStraightness = TF;
    }

    protected boolean getHaveStraightness() {
        return this.haveStraightness;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtomAt(int atomIndex) {
        return this.atoms[atomIndex];
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrationVectors != null;
    }

    public String[] getAtomNames() {
        return this.atomNames;
    }

    public String[] getAtomTypes() {
        return this.atomTypes;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public void setBsHidden(BitSet bs) {
        this.bsHidden = bs;
    }

    public boolean isAtomHidden(int iAtom) {
        return this.bsHidden.get(iAtom);
    }

    public String getAtomInfo(int i, String format) {
        return format == null ? this.atoms[i].getInfo() : LabelToken.formatLabel(this.atoms[i], format);
    }

    public String getAtomInfoXYZ(int i, boolean useChimeFormat) {
        return this.atoms[i].getInfoXYZ(useChimeFormat);
    }

    public String getElementSymbol(int i) {
        return this.atoms[i].getElementSymbol();
    }

    public int getElementNumber(int i) {
        return this.atoms[i].getElementNumber();
    }

    String getElementName(int i) {
        return JmolConstants.elementNameFromNumber(this.atoms[i].getAtomicAndIsotopeNumber());
    }

    public String getAtomName(int i) {
        return this.atoms[i].getAtomName();
    }

    public int getAtomNumber(int i) {
        return this.atoms[i].getAtomNumber();
    }

    public float getAtomX(int i) {
        return this.atoms[i].x;
    }

    public float getAtomY(int i) {
        return this.atoms[i].y;
    }

    public float getAtomZ(int i) {
        return this.atoms[i].z;
    }

    public Point3f getAtomPoint3f(int i) {
        return this.atoms[i];
    }

    public float getAtomRadius(int i) {
        return this.atoms[i].getRadius();
    }

    public float getAtomVdwRadius(int i) {
        return this.atoms[i].getVanderwaalsRadiusFloat();
    }

    public short getAtomColix(int i) {
        return this.atoms[i].getColix();
    }

    public String getAtomChain(int i) {
        return "" + this.atoms[i].getChainID();
    }

    public String getAtomSequenceCode(int i) {
        return this.atoms[i].getSeqcodeString();
    }

    public int getAtomModelIndex(int i) {
        return this.atoms[i].getModelIndex();
    }

    public Object[] getEllipsoid(int i) {
        return i < 0 || this.ellipsoids == null || i >= this.ellipsoids.length ? null : this.ellipsoids[i];
    }

    public Quaternion getQuaternion(int i, char qtype) {
        return this.atoms[i].group.getQuaternion(qtype);
    }

    public Object getHelixData(BitSet bs, int tokType) {
        int iatom = BitSetUtil.firstSetBit(bs);
        return iatom < 0 ? "null" : this.atoms[iatom].group.getHelixData(tokType, this.viewer.getQuaternionFrame());
    }

    protected int getAtomCountInModel(int modelIndex) {
        int n = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    public int getAtomIndexFromAtomNumber(int atomNumber, BitSet bsVisibleFrames) {
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.atoms[i];
            if (atom.getAtomNumber() != atomNumber || !bsVisibleFrames.get(atom.modelIndex)) continue;
            return i;
        }
        return -1;
    }

    public void setFormalCharges(BitSet bs, int formalCharge) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            this.atoms[i].setFormalCharge(formalCharge);
            this.taint(i, (byte)4);
        }
    }

    public float[] getAtomicCharges() {
        float[] charges = new float[this.atomCount];
        int i = this.atomCount;
        while (--i >= 0) {
            charges[i] = this.atoms[i].getElementNumber();
        }
        return charges;
    }

    protected float getRadiusVdwJmol(Atom atom) {
        return (float)JmolConstants.getVanderwaalsMar(atom.getElementNumber(), 0) / 1000.0f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int i = this.atomCount;
        while (--i >= 0) {
            float vdwRadius;
            Atom atom = this.atoms[i];
            float bondingRadius = atom.getBondingRadiusFloat();
            if (bondingRadius > this.maxBondingRadius) {
                this.maxBondingRadius = bondingRadius;
            }
            if (!((vdwRadius = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = vdwRadius;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BitSet bs) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int i = this.atomCount;
            while (--i > 0) {
                if (bs != null && !bs.get(i)) continue;
                int bf = this.atoms[i].getBfactor100();
                if (bf < this.bfactor100Lo) {
                    this.bfactor100Lo = bf;
                    continue;
                }
                if (bf <= this.bfactor100Hi) continue;
                this.bfactor100Hi = bf;
            }
            this.hasBfactorRange = true;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    int getSurfaceDistance100(int atomIndex) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[atomIndex];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public Point3f[] calculateSurface(BitSet bsSelected, float envelopeRadius) {
        if (envelopeRadius < 0.0f) {
            envelopeRadius = 3.0f;
        }
        EnvelopeCalculation ec = new EnvelopeCalculation(this.viewer, this.atomCount, null);
        ec.calculate(Float.MAX_VALUE, envelopeRadius, 1.0f, Float.MAX_VALUE, bsSelected, BitSetUtil.copyInvert(bsSelected, this.atomCount), true, false, false, false, true);
        Point3f[] points = ec.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = ec.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.atomCount];
        this.nSurfaceAtoms = BitSetUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || points == null || points.length == 0) {
            return points;
        }
        float radiusAdjust = envelopeRadius == Float.MAX_VALUE ? 0.0f : envelopeRadius;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float dMin = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int j = points.length;
            while (--j >= 0) {
                float d = Math.abs(points[j].distance(atom) - radiusAdjust);
                if (d < 0.0f && Logger.debugging) {
                    Logger.debug("draw d" + j + " " + Escape.escape(points[j]) + " \"" + d + " ? " + atom.getInfo() + "\"");
                }
                dMin = Math.min(d, dMin);
            }
            int d = this.surfaceDistance100s[i] = (int)(dMin * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, d);
        }
        return points;
    }

    public void setAtomCoord(BitSet bs, int tokType, Object xyzValues) {
        Point3f xyz = null;
        Point3f[] values = null;
        if (xyzValues instanceof Point3f) {
            xyz = (Point3f)xyzValues;
        } else {
            values = (Point3f[])xyzValues;
        }
        if (xyz == null && (values == null || values.length == 0)) {
            return;
        }
        int n = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            if (values != null) {
                if (n >= values.length) {
                    return;
                }
                xyz = values[n++];
            }
            switch (tokType) {
                case 72352010: {
                    this.setAtomCoord(i, xyz.x, xyz.y, xyz.z);
                    continue block5;
                }
                case 72352011: {
                    this.atoms[i].setFractionalCoord(xyz);
                    this.taint(i, (byte)2);
                    continue block5;
                }
                case 72352013: {
                    this.setAtomVibrationVector(i, xyz.x, xyz.y, xyz.z);
                }
            }
        }
    }

    private void setAtomVibrationVector(int atomIndex, float x, float y, float z) {
        this.setVibrationVector(atomIndex, x, y, z);
        this.taint(atomIndex, (byte)10);
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[atomIndex].x = x;
        this.atoms[atomIndex].y = y;
        this.atoms[atomIndex].z = z;
        this.taint(atomIndex, (byte)2);
    }

    public void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[atomIndex].x += x;
        this.atoms[atomIndex].y += y;
        this.atoms[atomIndex].z += z;
        this.taint(atomIndex, (byte)2);
    }

    protected void setAtomCoordRelative(BitSet atomSet, float x, float y, float z) {
        this.bspf = null;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!atomSet.get(i)) continue;
            this.setAtomCoordRelative(i, x, y, z);
        }
    }

    public void setAtomProperty(BitSet bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        int n = 0;
        if (values != null && values.length == 0) {
            return;
        }
        block18: for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            if (values != null) {
                if (n >= values.length) {
                    return;
                }
                fValue = values[n++];
                iValue = (int)fValue;
            } else if (list != null) {
                if (n >= list.length) {
                    return;
                }
                sValue = list[n++];
            }
            Atom atom = this.atoms[i];
            switch (tok) {
                case 13631746: {
                    this.taint(i, (byte)0);
                    this.setAtomName(i, sValue);
                    continue block18;
                }
                case 0xD00101: {
                    this.taint(i, (byte)1);
                    this.setAtomType(i, sValue);
                    continue block18;
                }
                case 38797571: {
                    this.setAtomCoord(i, fValue, atom.y, atom.z);
                    continue block18;
                }
                case 38797572: {
                    this.setAtomCoord(i, atom.x, fValue, atom.z);
                    continue block18;
                }
                case 38797573: {
                    this.setAtomCoord(i, atom.x, atom.y, fValue);
                    continue block18;
                }
                case 38797590: 
                case 38797591: 
                case 38797592: {
                    this.setVibrationVector(i, tok, fValue);
                    continue block18;
                }
                case 38797574: 
                case 38797575: 
                case 38797576: {
                    atom.setFractionalCoord(tok, fValue);
                    this.taint(i, (byte)2);
                    continue block18;
                }
                case 13631749: 
                case 22020359: {
                    this.taint(i, (byte)3);
                    atom.setAtomicAndIsotopeNumber(iValue);
                    atom.setPaletteID((byte)1);
                    atom.setColixAtom(this.viewer.getColixAtomPalette(atom, (byte)1));
                    continue block18;
                }
                case 558891272: {
                    atom.setFormalCharge(iValue);
                    this.taint(i, (byte)4);
                    continue block18;
                }
                case 214958338: 
                case 752374019: {
                    ((ModelSet)this).setAtomLabel(sValue, i);
                    continue block18;
                }
                case 55574786: {
                    if (iValue < 2) {
                        iValue = (int)(100.0f * fValue);
                    }
                    if (!this.setOccupancy(i, iValue)) continue block18;
                    this.taint(i, (byte)5);
                    continue block18;
                }
                case 38797578: {
                    if (!this.setPartialCharge(i, fValue)) continue block18;
                    this.taint(i, (byte)6);
                    continue block18;
                }
                case 39325966: 
                case 592445697: {
                    if (fValue < 0.0f) {
                        fValue = 0.0f;
                    } else if (fValue > 16.0f) {
                        fValue = 16.0f;
                    }
                    atom.setMadAtom(this.viewer, 0, fValue);
                    continue block18;
                }
                case 38797585: {
                    if (!this.setBFactor(i, fValue)) continue block18;
                    this.taint(i, (byte)7);
                    continue block18;
                }
                case 22020372: {
                    atom.setValence(iValue);
                    this.taint(i, (byte)8);
                    continue block18;
                }
                case 38797589: {
                    if (atom.setRadius(fValue)) {
                        this.taint(i, (byte)9);
                        continue block18;
                    }
                    this.untaint(i, (byte)9);
                    continue block18;
                }
                default: {
                    Logger.error("unsettable atom property: " + Token.nameOf(tok));
                }
            }
        }
    }

    public float getVibrationCoord(int atomIndex, char c) {
        if (this.vibrationVectors == null || this.vibrationVectors[atomIndex] == null) {
            return 0.0f;
        }
        switch (c) {
            case 'x': {
                return this.vibrationVectors[atomIndex].x;
            }
            case 'y': {
                return this.vibrationVectors[atomIndex].y;
            }
        }
        return this.vibrationVectors[atomIndex].z;
    }

    public Vector3f getVibrationVector(int atomIndex, boolean forceNew) {
        Vector3f v = this.vibrationVectors == null ? null : this.vibrationVectors[atomIndex];
        return v == null && forceNew ? new Vector3f() : v;
    }

    protected void setVibrationVector(int atomIndex, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (this.vibrationVectors == null) {
            this.vibrationVectors = new Vector3f[this.atoms.length];
        }
        this.vibrationVectors[atomIndex] = new Vector3f(x, y, z);
        this.atoms[atomIndex].setVibrationVector();
    }

    private void setVibrationVector(int atomIndex, int tok, float fValue) {
        Vector3f v = this.getVibrationVector(atomIndex, true);
        if (v == null) {
            v = new Vector3f();
        }
        switch (tok) {
            case 38797590: {
                v.x = fValue;
                break;
            }
            case 38797591: {
                v.y = fValue;
                break;
            }
            case 38797592: {
                v.z = fValue;
            }
        }
        this.setAtomVibrationVector(atomIndex, v.x, v.y, v.z);
    }

    protected void setAtomName(int atomIndex, String name) {
        if (this.atomNames == null) {
            this.atomNames = new String[this.atoms.length];
        }
        this.atomNames[atomIndex] = name;
    }

    protected void setAtomType(int atomIndex, String type) {
        if (this.atomTypes == null) {
            this.atomTypes = new String[this.atoms.length];
        }
        this.atomTypes[atomIndex] = type;
    }

    protected boolean setOccupancy(int atomIndex, int occupancy) {
        if (this.occupancies == null) {
            if (occupancy == 100) {
                return false;
            }
            this.occupancies = new byte[this.atoms.length];
        }
        this.occupancies[atomIndex] = (byte)(occupancy > 255 ? 255 : (occupancy < 0 ? 0 : occupancy));
        return true;
    }

    protected boolean setPartialCharge(int atomIndex, float partialCharge) {
        if (Float.isNaN(partialCharge)) {
            return false;
        }
        if (this.partialCharges == null) {
            if (partialCharge == 0.0f) {
                return false;
            }
            this.partialCharges = new float[this.atoms.length];
        }
        this.partialCharges[atomIndex] = partialCharge;
        return true;
    }

    protected boolean setBFactor(int atomIndex, float bfactor) {
        if (Float.isNaN(bfactor)) {
            return false;
        }
        if (this.bfactor100s == null) {
            if (bfactor == 0.0f && this.bfactor100s == null) {
                return false;
            }
            this.bfactor100s = new short[this.atoms.length];
        }
        this.bfactor100s[atomIndex] = (short)((bfactor < -327.68f ? (double)-327.68f : ((double)bfactor > 327.67 ? 327.67 : (double)bfactor)) * 100.0);
        return true;
    }

    protected void setEllipsoid(int atomIndex, Object[] ellipsoid) {
        if (ellipsoid == null) {
            return;
        }
        if (this.ellipsoids == null) {
            this.ellipsoids = new Object[this.atoms.length][];
        }
        this.ellipsoids[atomIndex] = ellipsoid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAtomData(int type, String name, String dataString) {
        float[] fData = null;
        BitSet bs = null;
        switch (type) {
            case 2: {
                this.loadCoordinates(dataString, false);
                return;
            }
            case 10: {
                this.loadCoordinates(dataString, true);
                return;
            }
            case 11: {
                fData = new float[this.atomCount];
                bs = new BitSet(this.atomCount);
                break;
            }
        }
        int[] lines = Parser.markLines(dataString, ';');
        int n = 0;
        try {
            int nData = Parser.parseInt(dataString.substring(0, lines[0] - 1));
            int i = 1;
            while (true) {
                block21: {
                    if (i > nData) {
                        if (type != 11) return;
                        if (n <= 0) return;
                        this.viewer.setData(name, new Object[]{name, fData, bs}, 0, 0, 0, 0, 0);
                        return;
                    }
                    String[] tokens = Parser.getTokens(Parser.parseTrimmed(dataString.substring(lines[i], lines[i + 1] - 1)));
                    int atomIndex = Parser.parseInt(tokens[0]) - 1;
                    if (atomIndex >= 0 && atomIndex < this.atomCount) {
                        Atom atom = this.atoms[atomIndex];
                        ++n;
                        int pt = tokens.length - 1;
                        float x = Parser.parseFloat(tokens[pt]);
                        switch (type) {
                            case 11: {
                                fData[atomIndex] = x;
                                bs.set(atomIndex);
                                break block21;
                            }
                            case 0: {
                                this.setAtomName(atomIndex, tokens[pt]);
                                break;
                            }
                            case 1: {
                                this.setAtomType(atomIndex, tokens[pt]);
                                break;
                            }
                            case 3: {
                                atom.setAtomicAndIsotopeNumber((int)x);
                                atom.setPaletteID((byte)1);
                                atom.setColixAtom(this.viewer.getColixAtomPalette(atom, (byte)1));
                                break;
                            }
                            case 4: {
                                atom.setFormalCharge((int)x);
                                break;
                            }
                            case 6: {
                                this.setPartialCharge(atomIndex, x);
                                break;
                            }
                            case 7: {
                                this.setBFactor(atomIndex, x);
                                break;
                            }
                            case 8: {
                                atom.setValence((int)x);
                                break;
                            }
                            case 9: {
                                atom.setRadius(x);
                            }
                        }
                        this.taint(atomIndex, (byte)type);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.error("AtomCollection.loadData error: " + e);
        }
    }

    private void loadCoordinates(String data, boolean isVibrationVectors) {
        if (!isVibrationVectors) {
            this.bspf = null;
        }
        int[] lines = Parser.markLines(data, ';');
        try {
            int nData = Parser.parseInt(data.substring(0, lines[0] - 1));
            for (int i = 1; i <= nData; ++i) {
                String[] tokens = Parser.getTokens(Parser.parseTrimmed(data.substring(lines[i], lines[i + 1])));
                int atomIndex = Parser.parseInt(tokens[0]) - 1;
                float x = Parser.parseFloat(tokens[3]);
                float y = Parser.parseFloat(tokens[4]);
                float z = Parser.parseFloat(tokens[5]);
                if (isVibrationVectors) {
                    this.setAtomVibrationVector(atomIndex, x, y, z);
                    continue;
                }
                this.setAtomCoord(atomIndex, x, y, z);
            }
        }
        catch (Exception e) {
            Logger.error("Frame.loadCoordinate error: " + e);
        }
    }

    public static int getUserSettableType(String dataType) {
        boolean isExplicit = dataType.indexOf("property_") == 0;
        String check = isExplicit ? dataType.substring(9) : dataType;
        for (int i = 0; i < 11; ++i) {
            if (!userSettableValues[i].equalsIgnoreCase(check)) continue;
            return i;
        }
        return isExplicit ? 11 : -1;
    }

    public BitSet getTaintedAtoms(byte type) {
        return this.tainted == null ? null : this.tainted[type];
    }

    protected void taint(int atomIndex, byte type) {
        if (this.tainted == null) {
            this.tainted = new BitSet[11];
        }
        if (this.tainted[type] == null) {
            this.tainted[type] = new BitSet(this.atomCount);
        }
        this.tainted[type].set(atomIndex);
    }

    private void untaint(int i, byte type) {
        if (this.tainted == null || this.tainted[type] == null) {
            return;
        }
        this.tainted[type].clear(i);
    }

    public void setTaintedAtoms(BitSet bs, byte type) {
        if (bs == null) {
            if (this.tainted == null) {
                return;
            }
            this.tainted[type] = null;
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BitSet[11];
        }
        if (this.tainted[type] == null) {
            this.tainted[type] = new BitSet(this.atomCount);
        }
        BitSetUtil.copy(bs, this.tainted[type]);
    }

    public String getAtomicPropertyState(int taintWhat, BitSet bsSelected) {
        StringBuffer commands = new StringBuffer();
        for (byte i = 0; i < 11; i = (byte)(i + 1)) {
            BitSet bs;
            if (taintWhat >= 0 && i != taintWhat || (bs = bsSelected != null ? bsSelected : this.getTaintedAtoms(i)) == null) continue;
            AtomCollection.getAtomicPropertyState(commands, this.atoms, this.atomCount, i, bs, null, null);
        }
        return commands.toString();
    }

    public static void getAtomicPropertyState(StringBuffer commands, Atom[] atoms, int atomCount, byte type, BitSet bs, String label, float[] fData) {
        StringBuffer s = new StringBuffer();
        String dataLabel = (label == null ? userSettableValues[type] : label) + " set";
        int n = 0;
        for (int i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            s.append(i + 1).append(" ").append(atoms[i].getElementSymbol()).append(" ").append(atoms[i].getInfo().replace(' ', '_')).append(" ");
            switch (type) {
                case 11: {
                    if (i >= fData.length) break;
                    s.append(fData[i]);
                    break;
                }
                case 0: {
                    s.append(atoms[i].getAtomName());
                    break;
                }
                case 1: {
                    s.append(atoms[i].getAtomType());
                    break;
                }
                case 2: {
                    s.append(atoms[i].x).append(" ").append(atoms[i].y).append(" ").append(atoms[i].z);
                    break;
                }
                case 10: {
                    Vector3f v = atoms[i].getVibrationVector();
                    if (v == null) {
                        v = new Vector3f();
                    }
                    s.append(v.x).append(" ").append(v.y).append(" ").append(v.z);
                }
                case 3: {
                    s.append(atoms[i].getAtomicAndIsotopeNumber());
                    break;
                }
                case 4: {
                    s.append(atoms[i].getFormalCharge());
                    break;
                }
                case 5: {
                    s.append(atoms[i].getOccupancy100());
                    break;
                }
                case 6: {
                    s.append(atoms[i].getPartialCharge());
                    break;
                }
                case 7: {
                    s.append((float)atoms[i].getBfactor100() / 100.0f);
                    break;
                }
                case 8: {
                    s.append(atoms[i].getValence());
                    break;
                }
                case 9: {
                    s.append(atoms[i].getVanderwaalsRadiusFloat());
                }
            }
            s.append(" ;\n");
            ++n;
        }
        if (n == 0) {
            return;
        }
        commands.append("\n  DATA \"" + dataLabel + "\"\n").append(n).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        commands.append(s);
        commands.append("  end \"" + dataLabel + "\";\n");
    }

    protected void findNearestAtomIndex(int x, int y, Atom[] closest) {
        Atom champion = null;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom contender = this.atoms[i];
            if (!contender.isClickable() || !this.isCursorOnTopOf(contender, x, y, 6, champion)) continue;
            champion = contender;
        }
        closest[0] = champion;
    }

    boolean isCursorOnTopOf(Atom contender, int x, int y, int radius, Atom champion) {
        return contender.screenZ > 1 && !this.g3d.isClippedZ(contender.screenZ) && this.g3d.isInDisplayRange(contender.screenX, contender.screenY) && contender.isCursorOnTopOf(x, y, radius, champion);
    }

    public BitSet findAtomsInRectangle(Rectangle rect, BitSet bsModels) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if (!bsModels.get(atom.modelIndex) || !atom.isVisible() || !rect.contains(atom.screenX, atom.screenY)) continue;
            this.bsFoundRectangle.set(i);
        }
        return this.bsFoundRectangle;
    }

    protected void fillAtomData(AtomData atomData, int mode) {
        boolean includeRadii;
        atomData.atomXyz = this.atoms;
        atomData.atomCount = this.atomCount;
        atomData.atomicNumber = new int[this.atomCount];
        boolean bl = includeRadii = mode == 2;
        if (includeRadii) {
            atomData.atomRadius = new float[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomData.modelIndex >= 0 && this.atoms[i].modelIndex != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BitSet();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = this.atoms[i].getElementNumber();
            atomData.lastModelIndex = this.atoms[i].modelIndex;
            if (!includeRadii) continue;
            atomData.atomRadius[i] = atomData.adpMode == 1 ? this.atoms[i].getADPMinMax(true) : (atomData.adpMode == -1 ? this.atoms[i].getADPMinMax(false) : (atomData.useIonic ? this.atoms[i].getBondingRadiusFloat() : this.atoms[i].getVanderwaalsRadiusFloat()));
        }
    }

    protected Point3f[][] getAdditionalHydrogens(BitSet atomSet, int[] nTotal) {
        Vector3f z = new Vector3f();
        Vector3f x = new Vector3f();
        Point3f[][] hAtoms = new Point3f[this.atomCount][];
        int nH = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            String hybridization;
            int nBonds;
            if (!atomSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            int n = 0;
            Atom atom = this.atoms[i];
            int n2 = nBonds = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            if (!(nBonds != 3 && nBonds != 2 || (hybridization = this.getHybridizationAndAxes(i, z, x, "sp3", true)) != null && !hybridization.equals("sp"))) {
                nBonds = 0;
            }
            if (nBonds > 0 && nBonds <= 4) {
                n += 4 - nBonds;
            }
            hAtoms[i] = new Point3f[n];
            nH += n;
            n = 0;
            switch (nBonds) {
                case 1: {
                    this.getHybridizationAndAxes(i, z, x, "sp3a", false);
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                    this.getHybridizationAndAxes(i, z, x, "sp3b", false);
                    pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                    this.getHybridizationAndAxes(i, z, x, "sp3c", false);
                    pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                    continue block5;
                }
                case 2: {
                    hybridization = this.getHybridizationAndAxes(i, z, x, "sp3", true);
                    if (hybridization == null || hybridization.equals("sp")) continue block5;
                    this.getHybridizationAndAxes(i, z, x, "lpa", false);
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                    this.getHybridizationAndAxes(i, z, x, "lpb", false);
                    pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                    continue block5;
                }
                case 3: {
                    if (this.getHybridizationAndAxes(i, z, x, "sp3", true) == null) continue block5;
                    Point3f pt = new Point3f(z);
                    pt.scaleAdd(1.1f, atom);
                    hAtoms[i][n++] = pt;
                }
            }
        }
        nTotal[0] = nH;
        return hAtoms;
    }

    public String getHybridizationAndAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoTypeRaw, boolean hybridizationCompatible) {
        String lcaoType = lcaoTypeRaw.length() > 0 && lcaoTypeRaw.charAt(0) == '-' ? lcaoTypeRaw.substring(1) : lcaoTypeRaw;
        Atom atom = this.atoms[atomIndex];
        String hybridization = "";
        z.set(0.0f, 0.0f, 0.0f);
        x.set(0.0f, 0.0f, 0.0f);
        Atom atom1 = atom;
        Atom atom2 = atom;
        int nBonds = 0;
        float _180 = 2.984513f;
        Vector3f n = new Vector3f();
        Vector3f x2 = new Vector3f();
        Vector3f x3 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f x4 = new Vector3f();
        Vector3f y1 = new Vector3f();
        Vector3f y2 = new Vector3f();
        if (atom.bonds != null) {
            int i = atom.bonds.length;
            block11: while (--i >= 0) {
                if (!atom.bonds[i].isCovalent()) continue;
                atom1 = atom.bonds[i].getOtherAtom(atom);
                n.sub(atom, atom1);
                n.normalize();
                z.add(n);
                switch (++nBonds) {
                    case 1: {
                        x.set(n);
                        atom2 = atom1;
                        continue block11;
                    }
                    case 2: {
                        x2.set(n);
                        continue block11;
                    }
                    case 3: {
                        x3.set(n);
                        x4.set(-z.x, -z.y, -z.z);
                        continue block11;
                    }
                    case 4: {
                        x4.set(n);
                        continue block11;
                    }
                }
                i = -1;
            }
        }
        switch (nBonds) {
            case 0: {
                z.set(0.0f, 0.0f, 1.0f);
                x.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (lcaoType.indexOf("sp3") == 0) {
                    hybridization = "sp3";
                    x.cross(x3, z);
                    y1.cross(z, x);
                    x.normalize();
                    y1.normalize();
                    y2.set(x);
                    z.normalize();
                    x.scaleAdd(2.828f, x, z);
                    if (!lcaoType.equals("sp3a") && !lcaoType.equals("sp3")) {
                        x.normalize();
                        AxisAngle4f a = new AxisAngle4f(z.x, z.y, z.z, (float)(lcaoType.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f m = new Matrix3f();
                        m.setIdentity();
                        m.set(a);
                        m.transform(x);
                    }
                    z.set(x);
                    x.cross(y1, z);
                    break;
                }
                hybridization = "sp";
                if (atom1.getCovalentBondCount() == 3) {
                    this.getHybridizationAndAxes(atom1.atomIndex, z, x3, lcaoType, false);
                    x3.set(x);
                    if (lcaoType.indexOf("sp2") == 0) {
                        hybridization = "sp2";
                        z.scale(-1.0f);
                    }
                }
                x.cross(x3, z);
                break;
            }
            case 2: {
                if ((double)z.length() < 0.1) {
                    hybridization = "sp";
                    if (!lcaoType.equals("pz")) {
                        if (atom1.getCovalentBondCount() != 3) {
                            atom1 = atom2;
                        }
                        if (atom1.getCovalentBondCount() == 3) {
                            this.getHybridizationAndAxes(atom1.atomIndex, x, z, "pz", false);
                            if (lcaoType.equals("px")) {
                                x.scale(-1.0f);
                            }
                            z.set(x2);
                            break;
                        }
                    }
                    z.set(x);
                    x.cross(x3, z);
                    break;
                }
                hybridization = lcaoType.indexOf("sp3") == 0 ? "sp3" : "sp2";
                x3.cross(z, x);
                if (lcaoType.indexOf("sp") == 0) {
                    if (lcaoType.equals("sp2a") || lcaoType.equals("sp2b")) {
                        z.set(lcaoType.indexOf("b") >= 0 ? x2 : x);
                        z.scale(-1.0f);
                    }
                    x.cross(z, x3);
                    break;
                }
                if (lcaoType.indexOf("lp") == 0) {
                    hybridization = "lp";
                    x3.normalize();
                    z.normalize();
                    y1.scaleAdd(1.2f, x3, z);
                    y2.scaleAdd(-1.2f, x3, z);
                    if (!lcaoType.equals("lp")) {
                        z.set(lcaoType.indexOf("b") >= 0 ? y2 : y1);
                    }
                    x.cross(z, x3);
                    break;
                }
                hybridization = lcaoType;
                x.cross(z, x3);
                z.set(x3);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
                break;
            }
            default: {
                if (x.angle(x2) < _180) {
                    y1.cross(x, x2);
                } else {
                    y1.cross(x, x3);
                }
                y1.normalize();
                if (x2.angle(x3) < _180) {
                    y2.cross(x2, x3);
                } else {
                    y2.cross(x, x3);
                }
                y2.normalize();
                if (Math.abs(y2.dot(y1)) < 0.95f) {
                    hybridization = "sp3";
                    if (lcaoType.indexOf("sp") == 0) {
                        z.set(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x)));
                        z.scale(-1.0f);
                        x.set(y1);
                        break;
                    }
                    if (lcaoType.indexOf("lp") == 0 && nBonds == 3) {
                        hybridization = "lp";
                    }
                    x.cross(z, x);
                    break;
                }
                hybridization = "sp2";
                if (lcaoType.indexOf("sp") == 0) {
                    z.set(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x)));
                    z.scale(-1.0f);
                    x.set(y1);
                    break;
                }
                z.set(y1);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
            }
        }
        x.normalize();
        z.normalize();
        if (Logger.debugging) {
            Logger.debug(atom.getInfo() + " nBonds=" + nBonds + " " + hybridization);
        }
        if (hybridizationCompatible) {
            if (hybridization == "") {
                return null;
            }
            if (lcaoType.indexOf("p") == 0 ? hybridization == "sp3" : lcaoType.indexOf(hybridization) < 0) {
                return null;
            }
        }
        return hybridization;
    }

    protected String getChimeInfo(int tok, BitSet bs) {
        StringBuffer info = new StringBuffer("\n");
        String s = "";
        Chain clast = null;
        Group glast = null;
        int modelLast = -1;
        int n = 0;
        block8: for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            char id = this.atoms[i].getChainID();
            s = id == '\u0000' ? " " : "" + id;
            switch (tok) {
                case 0xD00004: {
                    break;
                }
                case 0x30000A: {
                    s = this.atoms[i].getInfo();
                    break;
                }
                case 0x4100001: {
                    s = "" + this.atoms[i].getAtomNumber();
                    break;
                }
                case 0xD00006: {
                    s = this.atoms[i].getGroup3(false);
                    break;
                }
                case 1073741870: {
                    s = "[" + this.atoms[i].getGroup3(false) + "]" + this.atoms[i].getSeqcodeString() + ":" + s;
                    break;
                }
                case 0xD00008: {
                    Group g;
                    if (this.atoms[i].getModelIndex() != modelLast) {
                        info.append('\n');
                        n = 0;
                        modelLast = this.atoms[i].getModelIndex();
                        info.append("Model " + this.atoms[i].getModelNumber());
                        glast = null;
                        clast = null;
                    }
                    if (this.atoms[i].getChain() != clast) {
                        info.append('\n');
                        n = 0;
                        clast = this.atoms[i].getChain();
                        info.append("Chain " + s + ":\n");
                        glast = null;
                    }
                    if ((g = this.atoms[i].getGroup()) == glast) continue block8;
                    if (n++ % 5 == 0 && n > 1) {
                        info.append('\n');
                    }
                    TextFormat.lFill(info, "          ", "[" + this.atoms[i].getGroup3(false) + "]" + this.atoms[i].getResno() + " ");
                    glast = g;
                    continue block8;
                }
                default: {
                    return "";
                }
            }
            if (info.indexOf("\n" + s + "\n") >= 0) continue;
            info.append(s).append('\n');
        }
        if (tok == 0xD00008) {
            info.append('\n');
        }
        return info.toString().substring(1);
    }

    protected BitSet getAtomBits(int tokType, Object specInfo) {
        BitSet bs = new BitSet();
        switch (tokType) {
            case 0x1500001: {
                int iSpec = (Integer)specInfo;
                int i = this.atomCount;
                while (--i >= 0) {
                    if (this.atoms[i].getAtomNumber() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 13631746: {
                String names = "," + specInfo + ",";
                int i = this.atomCount;
                while (--i >= 0) {
                    String name = this.atoms[i].getAtomName();
                    if (names.indexOf(name) < 0 || names.indexOf("," + name + ",") < 0) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0xD00101: {
                String types = "," + specInfo + ",";
                int i = this.atomCount;
                while (--i >= 0) {
                    String type = this.atoms[i].getAtomType();
                    if (types.indexOf(type) < 0 || types.indexOf("," + type + ",") < 0) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1048613: {
                int iSpec = (Integer)specInfo;
                int i = this.atomCount;
                while (--i >= 0) {
                    if (this.atoms[i].getGroupID() != iSpec) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x100021: {
                return this.getChainBits((char)((Integer)specInfo).intValue());
            }
            case 1048614: {
                return this.getSeqcodeBits((Integer)specInfo, true);
            }
            case 0x20300003: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isHetero()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 540016644: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (this.atoms[i].getElementNumber() != 1) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300006: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isProtein()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 3145749: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isCarbohydrate()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300005: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isNucleic()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300002: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isDna()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300009: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isRna()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300007: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isPurine()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x300008: {
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isPyrimidine()) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x1500005: {
                int[] info = (int[])specInfo;
                Point3f cell = new Point3f((float)info[0] / 1000.0f, (float)info[1] / 1000.0f, (float)info[2] / 1000.0f);
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.isInLatticeCell(i, cell)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0xD00006: {
                BitSet bsInfo = (BitSet)specInfo;
                Group groupLast = null;
                int i = this.atomCount;
                while (--i >= 0) {
                    Atom atom;
                    Group group;
                    if (!bsInfo.get(i) || (group = (atom = this.atoms[i]).getGroup()) == groupLast) continue;
                    group.selectAtoms(bs);
                    groupLast = group;
                }
                return bs;
            }
            case 0xD00004: {
                BitSet bsInfo = (BitSet)specInfo;
                Chain chainLast = null;
                int i = this.atomCount;
                while (--i >= 0) {
                    Chain chain;
                    if (!bsInfo.get(i) || (chain = this.atoms[i].getChain()) == chainLast) continue;
                    int j = this.atomCount;
                    while (--j >= 0) {
                        if (this.atoms[j].getChain() != chain) continue;
                        bs.set(j);
                    }
                    chainLast = chain;
                }
                return bs;
            }
            case 30412803: {
                BitSet bsInfo = (BitSet)specInfo;
                Object structureLast = null;
                int i = this.atomCount;
                while (--i >= 0) {
                    Object structure;
                    if (!bsInfo.get(i) || (structure = this.atoms[i].getGroup().getStructure()) == null || structure == structureLast) continue;
                    int j = this.atomCount;
                    while (--j >= 0) {
                        if (this.atoms[j].getGroup().getStructure() != structure) continue;
                        bs.set(j);
                    }
                    structureLast = structure;
                }
                return bs;
            }
            case 22024203: {
                BitSet bsInfo = (BitSet)specInfo;
                BitSet bsTemp = new BitSet();
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsInfo.get(i)) continue;
                    bsTemp.set(this.atoms[i].modelIndex);
                }
                i = this.atomCount;
                while (--i >= 0) {
                    if (!bsTemp.get(this.atoms[i].modelIndex)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 13631749: {
                BitSet bsInfo = (BitSet)specInfo;
                BitSet bsTemp = new BitSet();
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsInfo.get(i)) continue;
                    bsTemp.set(this.getElementNumber(i));
                }
                i = this.atomCount;
                while (--i >= 0) {
                    if (!bsTemp.get(this.getElementNumber(i))) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x1500010: {
                BitSet bsInfo = (BitSet)specInfo;
                BitSet bsTemp = new BitSet();
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!bsInfo.get(i)) continue;
                    bsTemp.set(this.atoms[i].atomSite);
                }
                i = this.atomCount;
                while (--i >= 0) {
                    if (!bsTemp.get(this.atoms[i].atomSite)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1: {
                return this.getIdentifierOrNull((String)specInfo);
            }
            case 0x100020: {
                String atomSpec = ((String)specInfo).toUpperCase();
                if (atomSpec.indexOf("\\?") >= 0) {
                    atomSpec = TextFormat.simpleReplace(atomSpec, "\\?", "\u0001");
                }
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.isAtomNameMatch(this.atoms[i], atomSpec, false)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 0x10001F: {
                String spec = (String)specInfo;
                int i = this.atomCount;
                while (--i >= 0) {
                    if (!this.atoms[i].isAlternateLocationMatch(spec)) continue;
                    bs.set(i);
                }
                return bs;
            }
            case 1048612: {
                return this.getSpecName((String)specInfo);
            }
        }
        Logger.error("MISSING getAtomBits entry for " + Token.nameOf(tokType));
        return null;
    }

    protected boolean isInLatticeCell(int i, Point3f cell) {
        Point3f pt = this.atoms[i].getFractionalCoord();
        float slop = 0.02f;
        if (pt.x < cell.x - 1.0f - slop || pt.x > cell.x + slop) {
            return false;
        }
        if (pt.y < cell.y - 1.0f - slop || pt.y > cell.y + slop) {
            return false;
        }
        return !(pt.z < cell.z - 1.0f - slop) && !(pt.z > cell.z + slop);
    }

    private BitSet getIdentifierOrNull(String identifier) {
        int seqcode;
        BitSet bsInsert;
        int pt;
        BitSet bs = this.getSpecNameOrNull(identifier, false);
        if (identifier.indexOf("\\?") >= 0) {
            identifier = TextFormat.simpleReplace(identifier, "\\?", "\u0001");
        }
        if (bs != null || identifier.indexOf("?") > 0) {
            return bs;
        }
        if (identifier.indexOf("*") > 0) {
            return this.getSpecNameOrNull(identifier, true);
        }
        int len = identifier.length();
        for (pt = 0; pt < len && Character.isLetter(identifier.charAt(pt)); ++pt) {
        }
        bs = this.getSpecNameOrNull(identifier.substring(0, pt), false);
        if (pt == len) {
            return bs;
        }
        if (bs == null) {
            bs = new BitSet();
        }
        int pt0 = pt;
        while (pt < len && Character.isDigit(identifier.charAt(pt))) {
            ++pt;
        }
        int seqNumber = 0;
        try {
            seqNumber = Integer.parseInt(identifier.substring(pt0, pt));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        char insertionCode = ' ';
        if (pt < len && identifier.charAt(pt) == '^' && ++pt < len) {
            insertionCode = identifier.charAt(pt);
        }
        if ((bsInsert = this.getSeqcodeBits(seqcode = Group.getSeqcode(seqNumber, insertionCode), false)) == null) {
            if (insertionCode != ' ') {
                bsInsert = this.getSeqcodeBits(Character.toUpperCase(identifier.charAt(pt)), false);
            }
            if (bsInsert == null) {
                return null;
            }
            ++pt;
        }
        bs.and(bsInsert);
        if (pt >= len) {
            return bs;
        }
        char chainID = identifier.charAt(pt++);
        bs.and(this.getChainBits(chainID));
        if (pt == len) {
            return bs;
        }
        return null;
    }

    private BitSet getSpecName(String name) {
        BitSet bs = this.getSpecNameOrNull(name, false);
        if (bs != null) {
            return bs;
        }
        if (name.indexOf("*") > 0) {
            bs = this.getSpecNameOrNull(name, true);
        }
        return bs == null ? new BitSet() : bs;
    }

    private BitSet getSpecNameOrNull(String name, boolean checkStar) {
        BitSet bs = null;
        if ((name = name.toUpperCase()).indexOf("\\?") >= 0) {
            name = TextFormat.simpleReplace(name, "\\?", "\u0001");
        }
        int i = this.atomCount;
        while (--i >= 0) {
            String g3 = this.atoms[i].getGroup3(true);
            if (g3 != null && g3.length() > 0) {
                if (!TextFormat.isMatch(g3, name, checkStar, true)) continue;
                if (bs == null) {
                    bs = new BitSet(i + 1);
                }
                bs.set(i);
                while (--i >= 0 && this.atoms[i].getGroup3(true).equals(g3)) {
                    bs.set(i);
                }
                ++i;
                continue;
            }
            if (!this.isAtomNameMatch(this.atoms[i], name, checkStar)) continue;
            if (bs == null) {
                bs = new BitSet(i + 1);
            }
            bs.set(i);
        }
        return bs;
    }

    private boolean isAtomNameMatch(Atom atom, String strPattern, boolean checkStar) {
        return TextFormat.isMatch(atom.getAtomName().toUpperCase(), strPattern, checkStar, false);
    }

    protected BitSet getSeqcodeBits(int seqcode, boolean returnEmpty) {
        BitSet bs = new BitSet();
        int seqNum = Group.getSequenceNumber(seqcode);
        boolean haveSeqNumber = seqNum != Integer.MAX_VALUE;
        boolean isEmpty = true;
        char insCode = Group.getInsertionCode(seqcode);
        switch (insCode) {
            case '?': {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (haveSeqNumber && (seqNum != Group.getSequenceNumber(atomSeqcode) || Group.getInsertionCodeValue(atomSeqcode) == 0)) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break;
            }
            default: {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (seqcode != atomSeqcode && (haveSeqNumber || seqcode != Group.getInsertionCodeValue(atomSeqcode)) && (insCode != '*' || seqNum != Group.getSequenceNumber(atomSeqcode))) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break block0;
            }
        }
        return !isEmpty || returnEmpty ? bs : null;
    }

    protected BitSet getChainBits(char chain) {
        boolean caseSensitive = this.viewer.getChainCaseSensitive();
        if (!caseSensitive) {
            chain = Character.toUpperCase(chain);
        }
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            char ch = this.atoms[i].getChainID();
            if (!caseSensitive) {
                ch = Character.toUpperCase(ch);
            }
            if (chain != ch) continue;
            bs.set(i);
        }
        return bs;
    }

    public int[] getAtomIndices(BitSet bs) {
        int len = bs.size();
        int n = 0;
        int[] indices = new int[this.atomCount];
        for (int j = 0; j < len; ++j) {
            if (!bs.get(j)) continue;
            indices[j] = ++n;
        }
        return indices;
    }

    public BitSet getAtomsWithin(float distance, Point4f plane) {
        BitSet bsResult = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            float d = Graphics3D.distanceToPlane(plane, atom);
            if (!(distance > 0.0f && (double)d >= -0.1 && d <= distance || distance < 0.0f && (double)d <= 0.1 && d >= distance) && (distance != 0.0f || !((double)Math.abs(d) < 0.01))) continue;
            bsResult.set(atom.atomIndex);
        }
        return bsResult;
    }

    public BitSet getVisibleSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isVisible()) continue;
            bs.set(i);
        }
        return bs;
    }

    public BitSet getClickableSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isClickable()) continue;
            bs.set(i);
        }
        return bs;
    }

    protected void deleteModelAtoms(int firstAtomIndex, int nAtoms, BitSet bs) {
        BitSetUtil.deleteBits(this.bsHidden, bs);
        BitSetUtil.deleteBits(this.viewer.getSelectionSet(), bs);
        BitSetUtil.deleteBits(this.viewer.getSelectionSubset(), bs);
        BitSetUtil.deleteBits(this.viewer.getFrameOffsets(), bs);
        this.viewer.setFrameOffsets(this.viewer.getFrameOffsets());
        this.atoms = (Atom[])ArrayUtil.deleteElements(this.atoms, firstAtomIndex, nAtoms);
        this.atomCount = this.atoms.length;
        for (int j = firstAtomIndex; j < this.atomCount; ++j) {
            this.atoms[j].atomIndex = j;
            this.atoms[j].modelIndex = (short)(this.atoms[j].modelIndex - 1);
        }
        this.atomNames = (String[])ArrayUtil.deleteElements(this.atomNames, firstAtomIndex, nAtoms);
        this.atomTypes = (String[])ArrayUtil.deleteElements(this.atomTypes, firstAtomIndex, nAtoms);
        this.atomSerials = (int[])ArrayUtil.deleteElements(this.atomSerials, firstAtomIndex, nAtoms);
        this.bfactor100s = (short[])ArrayUtil.deleteElements(this.bfactor100s, firstAtomIndex, nAtoms);
        this.hasBfactorRange = false;
        this.occupancies = (byte[])ArrayUtil.deleteElements(this.occupancies, firstAtomIndex, nAtoms);
        this.partialCharges = (float[])ArrayUtil.deleteElements(this.partialCharges, firstAtomIndex, nAtoms);
        this.ellipsoids = (Object[][])ArrayUtil.deleteElements(this.ellipsoids, firstAtomIndex, nAtoms);
        this.specialAtomIDs = (byte[])ArrayUtil.deleteElements(this.specialAtomIDs, firstAtomIndex, nAtoms);
        this.vibrationVectors = (Vector3f[])ArrayUtil.deleteElements(this.vibrationVectors, firstAtomIndex, nAtoms);
        this.clientAtomReferences = (Object[])ArrayUtil.deleteElements(this.clientAtomReferences, firstAtomIndex, nAtoms);
        this.nSurfaceAtoms = 0;
        this.bsSurface = null;
        this.surfaceDistance100s = null;
        if (this.tainted != null) {
            for (int i = 0; i < 11; ++i) {
                BitSetUtil.deleteBits(this.tainted[i], bs);
            }
        }
    }

    static {
        if (userSettableValues.length != 11) {
            Logger.error("AtomCollection.java userSettableValues is not length TAINT_MAX!");
        }
    }
}

