/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;

class AtomIteratorWithinSet
implements AtomIndexIterator {
    CubeIterator bsptIter;
    BitSet bsSelected;
    boolean isGreaterOnly;
    int atomIndex;
    int zerobase;
    int iNext;

    AtomIteratorWithinSet() {
    }

    void initialize(Bspf bspf, int bsptIndex, int atomIndex, Point3f center, float distance, BitSet bsSelected, boolean isGreaterOnly, int zerobase) {
        this.bsptIter = bspf.getCubeIterator(bsptIndex);
        this.bsptIter.initialize(center, distance);
        this.atomIndex = atomIndex;
        this.bsSelected = bsSelected;
        this.isGreaterOnly = isGreaterOnly;
        this.zerobase = zerobase;
    }

    public boolean hasNext() {
        while (this.bsptIter.hasMoreElements()) {
            Atom atom = (Atom)this.bsptIter.nextElement();
            this.iNext = atom.atomIndex;
            if (this.iNext == this.atomIndex || this.iNext <= (this.isGreaterOnly ? this.atomIndex : -1) || this.bsSelected != null && !this.bsSelected.get(this.iNext)) continue;
            return true;
        }
        this.iNext = -1;
        return false;
    }

    public int next() {
        return this.iNext - this.zerobase;
    }

    public float foundDistance2() {
        return this.bsptIter.foundDistance2();
    }

    public void release() {
        this.bsptIter.release();
        this.bsptIter = null;
    }
}

