/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.viewer.JmolConstants;

public class Bond {
    Atom atom1;
    Atom atom2;
    short order;
    short mad;
    short colix;
    int index = -1;
    int shapeVisibilityFlags;
    static final int myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(1);

    public short getMad() {
        return this.mad;
    }

    public short getColix() {
        return this.colix;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    Bond(Atom atom1, Atom atom2, short order, short mad, short colix) {
        if (atom1 == null || atom2 == null) {
            throw new NullPointerException();
        }
        this.atom1 = atom1;
        this.atom2 = atom2;
        if (atom1.getElementNumber() == 16 && atom2.getElementNumber() == 16) {
            order = (short)(order | 0x100);
        }
        if (order == 512) {
            order = (short)515;
        }
        this.order = order;
        this.colix = colix;
        this.setMad(mad);
    }

    public String getIdentity() {
        return this.index + 1 + " " + this.getOrderNumberAsString() + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    boolean isHydrogen() {
        return (this.order & 0x7800) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x400) != 0;
    }

    boolean isPartial() {
        return (this.order & 0xE0) != 0;
    }

    boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    int getValence() {
        return !this.isCovalent() ? 0 : (this.isPartial() || this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setMad(short mad) {
        boolean isVisible;
        boolean wasVisible = this.mad != 0;
        boolean bl = isVisible = mad != 0;
        if (wasVisible != isVisible) {
            this.atom1.addDisplayedBond(myVisibilityFlag, isVisible);
            this.atom2.addDisplayedBond(myVisibilityFlag, isVisible);
        }
        this.mad = mad;
        this.setShapeVisibility(myVisibilityFlag, isVisible);
    }

    final void setShapeVisibility(int shapeVisibilityFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= shapeVisibilityFlag) : (this.shapeVisibilityFlags &= ~shapeVisibilityFlag);
    }

    public void setColix(short colix) {
        this.colix = colix;
    }

    public void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, isTranslucent, translucentLevel);
    }

    boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colix);
    }

    public void setOrder(short order) {
        this.order = (short)(order | this.order & Short.MIN_VALUE);
    }

    public Atom getAtom1() {
        return this.atom1;
    }

    public Atom getAtom2() {
        return this.atom2;
    }

    public int getAtomIndex1() {
        return this.atom1.atomIndex;
    }

    public int getAtomIndex2() {
        return this.atom2.atomIndex;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    public short getOrder() {
        return this.order;
    }

    String getOrderName() {
        return JmolConstants.getBondOrderNameFromOrder(this.order);
    }

    String getOrderNumberAsString() {
        return JmolConstants.getBondOrderNumberFromOrder(this.order);
    }

    short getColix1() {
        return Graphics3D.getColixInherited(this.colix, this.atom1.colixAtom);
    }

    int getArgb1() {
        return this.atom1.group.chain.modelSet.viewer.getColixArgb(this.getColix1());
    }

    short getColix2() {
        return Graphics3D.getColixInherited(this.colix, this.atom2.colixAtom);
    }

    int getArgb2() {
        return this.atom1.group.chain.modelSet.viewer.getColixArgb(this.getColix2());
    }

    public Atom getOtherAtom(Atom thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom ? this.atom1 : null);
    }

    public void setShapeVisibilityFlags(int shapeVisibilityFlags) {
        this.shapeVisibilityFlags = shapeVisibilityFlags;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public boolean is(int bondType) {
        return (this.order & Short.MAX_VALUE) == bondType;
    }

    public static class BondSet
    extends BitSet {
        private int[] associatedAtoms;

        public int[] getAssociatedAtoms() {
            return this.associatedAtoms;
        }

        public BondSet(BitSet bs) {
            int i = bs.size();
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.set(i);
            }
        }

        public BondSet(BitSet bs, int[] atoms) {
            this(bs);
            this.associatedAtoms = atoms;
        }
    }
}

