/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.HBond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;

public abstract class BondCollection
extends AtomCollection {
    protected Bond[] bonds;
    protected int bondCount;
    protected static final boolean showRebondTimes = true;
    private static final int bondGrowthIncrement = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;
    protected int[] numCached = new int[5];
    protected Bond[][][] freeBonds = new Bond[5][][];
    protected BitSet bsPseudoHBonds;
    private boolean haveWarned;
    protected short defaultCovalentMad;
    private BitSet bsAromaticSingle;
    private BitSet bsAromaticDouble;
    protected BitSet bsAromatic;

    public BondCollection() {
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.haveWarned = false;
        this.bsAromatic = new BitSet();
    }

    protected void releaseModelSet() {
        this.bonds = null;
        this.freeBonds = null;
        super.releaseModelSet();
    }

    protected void merge(ModelSet modelSet) {
        super.merge(modelSet);
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBondAt(int bondIndex) {
        return this.bonds[bondIndex];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public BondIterator getBondIterator(short bondType, BitSet bsSelected) {
        return new BondIteratorSelected(this.bonds, this.bondCount, bondType, bsSelected, this.viewer.getBondSelectionModeOr());
    }

    public BondIterator getBondIterator(BitSet bsSelected) {
        return new BondIteratorSelected(this.bonds, this.bondCount, bsSelected);
    }

    public Atom getBondAtom1(int i) {
        return this.bonds[i].atom1;
    }

    public Atom getBondAtom2(int i) {
        return this.bonds[i].atom2;
    }

    public float getBondRadius(int i) {
        return this.bonds[i].getRadius();
    }

    public short getBondOrder(int i) {
        return this.bonds[i].getOrder();
    }

    public short getBondColix1(int i) {
        return this.bonds[i].getColix1();
    }

    public short getBondColix2(int i) {
        return this.bonds[i].getColix2();
    }

    public int getBondModelIndex(int i) {
        return this.bonds[i].atom1.atomIndex;
    }

    protected int getBondCountInModel(int modelIndex) {
        int n = 0;
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bonds[i].atom1.modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    public BitSet getBondsForSelectedAtoms(BitSet bsAtoms, boolean bondSelectionModeOr) {
        BitSet bs = new BitSet();
        for (int iBond = 0; iBond < this.bondCount; ++iBond) {
            boolean isSelected2;
            boolean isSelected1;
            Bond bond = this.bonds[iBond];
            if (!(!bondSelectionModeOr & (isSelected1 = bsAtoms.get(bond.atom1.atomIndex)) & (isSelected2 = bsAtoms.get(bond.atom2.atomIndex))) && !(bondSelectionModeOr & (isSelected1 | isSelected2))) continue;
            bs.set(iBond);
        }
        return bs;
    }

    public Bond bondAtoms(Atom atom1, Atom atom2, short order, short mad, BitSet bsBonds) {
        Bond bond = this.getOrAddBond(atom1, atom2, order, mad, bsBonds);
        bond.order = (short)(bond.order | Short.MIN_VALUE);
        return bond;
    }

    protected Bond getOrAddBond(Atom atom, Atom atomOther, short order, short mad, BitSet bsBonds) {
        int i;
        if (atom.isBonded(atomOther)) {
            i = atom.getBond((Atom)atomOther).index;
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
            }
            if (order == Short.MAX_VALUE || order == 16383) {
                order = 1;
            }
            i = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atomOther, (short)order, (short)mad)).index;
        }
        if (bsBonds != null) {
            bsBonds.set(i);
        }
        return this.bonds[i];
    }

    private Bond getOrAddHBond(Atom atom, Atom atomOther, short order, short mad, BitSet bsBonds, float energy) {
        int i;
        if (atom.isBonded(atomOther)) {
            i = atom.getBond((Atom)atomOther).index;
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
            }
            if (order == Short.MAX_VALUE || order == 16383) {
                order = 1;
            }
            i = this.setBond((int)this.bondCount++, (Bond)this.hBondMutually((Atom)atom, (Atom)atomOther, (short)order, (short)mad, (float)energy)).index;
        }
        if (bsBonds != null) {
            bsBonds.set(i);
        }
        return this.bonds[i];
    }

    protected Bond setBond(int index, Bond bond) {
        bond.index = index;
        this.bonds[bond.index] = bond;
        return this.bonds[bond.index];
    }

    protected Bond hBondMutually(Atom atom, Atom atomOther, short order, short mad, float energy) {
        HBond bond = new HBond(atom, atomOther, order, mad, 0, energy);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atomOther, bond);
        return bond;
    }

    protected Bond bondMutually(Atom atom, Atom atomOther, short order, short mad) {
        Bond bond = new Bond(atom, atomOther, order, mad, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atomOther, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond newBond, Bond[] oldBonds) {
        Bond[] newBonds;
        if (oldBonds == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                newBonds = this.freeBonds[1][this.numCached[1]];
            } else {
                newBonds = new Bond[]{newBond};
            }
        } else {
            int oldLength = oldBonds.length;
            int newLength = oldLength + 1;
            if (newLength < 5 && this.numCached[newLength] > 0) {
                int n = newLength;
                int n2 = this.numCached[n] - 1;
                this.numCached[n] = n2;
                newBonds = this.freeBonds[newLength][n2];
            } else {
                newBonds = new Bond[newLength];
            }
            newBonds[oldLength] = newBond;
            int i = oldLength;
            while (--i >= 0) {
                newBonds[i] = oldBonds[i];
            }
            if (oldLength < 5 && this.numCached[oldLength] < 200) {
                int n = oldLength;
                int n3 = this.numCached[n];
                this.numCached[n] = n3 + 1;
                this.freeBonds[oldLength][n3] = oldBonds;
            }
        }
        return newBonds;
    }

    void addHydrogenBond(Atom atom1, Atom atom2, short order, BitSet bsA, BitSet bsB, float energy) {
        boolean atom2InSetB;
        if (atom1 == null || atom2 == null) {
            return;
        }
        boolean atom1InSetA = bsA == null || bsA.get(atom1.atomIndex);
        boolean atom1InSetB = bsB == null || bsB.get(atom1.atomIndex);
        boolean atom2InSetA = bsA == null || bsA.get(atom2.atomIndex);
        boolean bl = atom2InSetB = bsB == null || bsB.get(atom2.atomIndex);
        if (atom1InSetA && atom2InSetB || atom1InSetB && atom2InSetA) {
            this.getOrAddHBond(atom1, atom2, order, (short)1, this.bsPseudoHBonds, energy);
        }
    }

    protected short getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2, float minBondDistance2, float bondTolerance) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f || distance2 < minBondDistance2) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        return distance2 > maxAcceptable2 ? (short)0 : 1;
    }

    protected boolean checkValencesAndBond(Atom atomA, Atom atomB, short order, short mad, BitSet bsBonds) {
        if (atomA.getCurrentBondCount() > 20 || atomB.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.haveWarned = true;
            return false;
        }
        int formalChargeA = atomA.getFormalCharge();
        if (formalChargeA != 0) {
            int formalChargeB = atomB.getFormalCharge();
            if (formalChargeA < 0 && formalChargeB < 0 || formalChargeA > 0 && formalChargeB > 0) {
                return false;
            }
        }
        if (atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != '\u0000' && atomB.alternateLocationID != '\u0000') {
            return false;
        }
        this.getOrAddBond(atomA, atomB, order, mad, bsBonds);
        return true;
    }

    protected void deleteAllBonds() {
        this.viewer.setShapeProperty(1, "reset", null);
        int i = this.bondCount;
        while (--i >= 0) {
            this.bonds[i].deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = 0;
    }

    protected short getDefaultMadFromOrder(short order) {
        return (order & 0x7800) > 0 ? (short)1 : this.defaultCovalentMad;
    }

    protected int[] deleteConnections(float minDistance, float maxDistance, short order, BitSet bsA, BitSet bsB, boolean isBonds, boolean matchNull, float minDistanceSquared, float maxDistanceSquared) {
        BitSet bsDelete = new BitSet();
        int nDeleted = 0;
        short newOrder = order = (short)(order | Short.MIN_VALUE);
        if (!matchNull && (order & 0x7800) != 0) {
            order = (short)30720;
        }
        int i = this.bondCount;
        while (--i >= 0) {
            float distanceSquared;
            Bond bond = this.bonds[i];
            Atom atom1 = bond.atom1;
            Atom atom2 = bond.atom2;
            if (!(!isBonds && (bsA.get(atom1.atomIndex) && bsB.get(atom2.atomIndex) || bsA.get(atom2.atomIndex) && bsB.get(atom1.atomIndex))) && (!isBonds || !bsA.get(i)) || !bond.atom1.isBonded(bond.atom2) || !((distanceSquared = atom1.distanceSquared(atom2)) >= minDistanceSquared) || !(distanceSquared <= maxDistanceSquared) || !matchNull && newOrder != (bond.order & 0xFFFFFEFF | Short.MIN_VALUE) && (order & bond.order & 0x7800) == 0) continue;
            bsDelete.set(i);
            ++nDeleted;
        }
        if (nDeleted > 0) {
            this.deleteBonds(bsDelete);
        }
        return new int[]{0, nDeleted};
    }

    protected void deleteBonds(BitSet bs) {
        int iDst = 0;
        for (int iSrc = 0; iSrc < this.bondCount; ++iSrc) {
            Bond bond = this.bonds[iSrc];
            if (!bs.get(iSrc)) {
                this.setBond(iDst++, bond);
                continue;
            }
            bond.deleteAtomReferences();
        }
        int i = this.bondCount;
        while (--i >= iDst) {
            this.bonds[i] = null;
        }
        this.bondCount = iDst;
        BitSet[] sets = (BitSet[])this.viewer.getShapeProperty(1, "sets");
        for (int i2 = 0; i2 < sets.length; ++i2) {
            BitSetUtil.deleteBits(sets[i2], bs);
        }
        BitSetUtil.deleteBits(this.bsPseudoHBonds, bs);
        BitSetUtil.deleteBits(this.bsAromatic, bs);
    }

    public void resetAromatic() {
        int i = this.bondCount;
        while (--i >= 0) {
            Bond bond = this.bonds[i];
            if (!bond.isAromatic()) continue;
            bond.setOrder((short)515);
        }
    }

    public void assignAromaticBonds() {
        this.assignAromaticBonds(true, null);
    }

    protected void assignAromaticBonds(boolean isUserCalculation, BitSet bsBonds) {
        if (!isUserCalculation) {
            this.bsAromatic = new BitSet();
        }
        this.bsAromaticSingle = new BitSet();
        this.bsAromaticDouble = new BitSet();
        int i = this.bondCount;
        while (--i >= 0) {
            if (bsBonds != null && !bsBonds.get(i)) continue;
            Bond bond = this.bonds[i];
            if (this.bsAromatic.get(i)) {
                bond.setOrder((short)515);
            }
            switch (bond.order & Short.MAX_VALUE) {
                case 515: {
                    this.bsAromatic.set(i);
                    break;
                }
                case 513: {
                    this.bsAromaticSingle.set(i);
                    break;
                }
                case 514: {
                    this.bsAromaticDouble.set(i);
                }
            }
        }
        int i2 = this.bondCount;
        while (--i2 >= 0) {
            Bond bond;
            if (bsBonds != null && !bsBonds.get(i2) || !(bond = this.bonds[i2]).is(515) || this.bsAromaticDouble.get(i2) || this.bsAromaticSingle.get(i2) || this.assignAromaticDouble(bond)) continue;
            this.assignAromaticSingle(bond);
        }
        i2 = this.bondCount;
        while (--i2 >= 0) {
            if (bsBonds != null && !bsBonds.get(i2)) continue;
            Bond bond = this.bonds[i2];
            if (this.bsAromaticDouble.get(i2)) {
                if (bond.is(514)) continue;
                this.bsAromatic.set(i2);
                bond.setOrder((short)514);
                continue;
            }
            if (!this.bsAromaticSingle.get(i2) && !bond.isAromatic() || bond.is(513)) continue;
            this.bsAromatic.set(i2);
            bond.setOrder((short)513);
        }
        this.assignAromaticNandO(bsBonds);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int bondIndex = bond.index;
        if (this.bsAromaticSingle.get(bondIndex)) {
            return false;
        }
        if (this.bsAromaticDouble.get(bondIndex)) {
            return true;
        }
        this.bsAromaticDouble.set(bondIndex);
        if (!this.assignAromaticSingle(bond.atom1, bondIndex) || !this.assignAromaticSingle(bond.atom2, bondIndex)) {
            this.bsAromaticDouble.clear(bondIndex);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int bondIndex = bond.index;
        if (this.bsAromaticDouble.get(bondIndex)) {
            return false;
        }
        if (this.bsAromaticSingle.get(bondIndex)) {
            return true;
        }
        this.bsAromaticSingle.set(bondIndex);
        if (!this.assignAromaticDouble(bond.atom1) || !this.assignAromaticDouble(bond.atom2)) {
            this.bsAromaticSingle.clear(bondIndex);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Atom atom, int notBondIndex) {
        Bond[] bonds = atom.bonds;
        if (this.assignAromaticSingleHetero(atom)) {
            return false;
        }
        int i = bonds.length;
        while (--i >= 0) {
            Bond bond = bonds[i];
            int bondIndex = bond.index;
            if (bondIndex == notBondIndex || !bond.isAromatic() || this.bsAromaticSingle.get(bondIndex) || !this.bsAromaticDouble.get(bondIndex) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDouble(Atom atom) {
        Bond[] bonds = atom.bonds;
        boolean haveDouble = this.assignAromaticSingleHetero(atom);
        int lastBond = -1;
        int i = bonds.length;
        while (--i >= 0) {
            if (this.bsAromaticDouble.get(bonds[i].index)) {
                haveDouble = true;
            }
            if (!bonds[i].isAromatic()) continue;
            lastBond = i;
        }
        i = bonds.length;
        while (--i >= 0) {
            Bond bond = bonds[i];
            int bondIndex = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(bondIndex) || this.bsAromaticSingle.get(bondIndex)) continue;
            if (!haveDouble && this.assignAromaticDouble(bond)) {
                haveDouble = true;
                continue;
            }
            if (!haveDouble && i >= lastBond || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return haveDouble;
    }

    private boolean assignAromaticSingleHetero(Atom atom) {
        short n = atom.getElementNumber();
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int nAtoms = atom.getValence();
        switch (n) {
            case 6: {
                return nAtoms == 4;
            }
            case 7: 
            case 8: {
                return nAtoms == 10 - n && atom.getFormalCharge() < 1;
            }
            case 16: {
                return nAtoms == 18 - n && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BitSet bsSelected) {
        int i = this.bondCount;
        while (--i >= 0) {
            Atom atom1;
            short n1;
            Bond bond;
            if (bsSelected != null && !bsSelected.get(i) || !(bond = this.bonds[i]).is(513)) continue;
            Atom atom2 = bond.atom2;
            short n2 = atom2.getElementNumber();
            if (n2 == 7 || n2 == 8) {
                n1 = n2;
                atom1 = atom2;
                atom2 = bond.atom1;
                n2 = atom2.getElementNumber();
            } else {
                atom1 = bond.atom1;
                n1 = atom1.getElementNumber();
            }
            if (n1 != 7 && n1 != 8) continue;
            int valence = atom1.getValence();
            int bondorder = atom1.getCovalentBondCount();
            int charge = atom1.getFormalCharge();
            switch (n1) {
                case 7: {
                    if (valence != 3 || bondorder != 3 || charge >= 1 || n2 != 6 || atom2.getValence() != 3) break;
                    bond.setOrder((short)514);
                    break;
                }
                case 8: {
                    if (valence != 1 || charge != 0 || n2 != 14 && n2 != 16) break;
                    bond.setOrder((short)514);
                }
            }
        }
    }

    protected BitSet getAtomBits(int tokType, Object specInfo) {
        switch (tokType) {
            case 0x100009: {
                BitSet bs = new BitSet();
                int i = this.bondCount;
                while (--i >= 0) {
                    if (!this.bonds[i].isAromatic()) continue;
                    bs.set(this.bonds[i].atom1.atomIndex);
                    bs.set(this.bonds[i].atom2.atomIndex);
                }
                return bs;
            }
            case 605028354: {
                BitSet bs = new BitSet();
                BitSet bsBonds = (BitSet)specInfo;
                int i = this.bondCount;
                while (--i >= 0) {
                    if (!bsBonds.get(i)) continue;
                    bs.set(this.bonds[i].atom1.atomIndex);
                    bs.set(this.bonds[i].atom2.atomIndex);
                }
                return bs;
            }
        }
        return super.getAtomBits(tokType, specInfo);
    }
}

