/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class BoxInfo {
    private final Point3f bbCorner0 = new Point3f(-10.0f, -10.0f, -10.0f);
    private final Point3f bbCorner1 = new Point3f(10.0f, 10.0f, 10.0f);
    private final Point3f bbCenter = new Point3f();
    private final Vector3f bbVector = new Vector3f();
    private final Point3f[] bbVertices = new Point3f[8];
    private static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};

    public BoxInfo() {
        int i = 8;
        while (--i >= 0) {
            this.bbVertices[i] = new Point3f();
        }
    }

    public Point3f getBoundBoxCenter() {
        return this.bbCenter;
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.bbVector;
    }

    public Point3f[] getBoundBoxPoints() {
        return new Point3f[]{this.bbCenter, new Point3f(this.bbVector), this.bbCorner0, this.bbCorner1};
    }

    Point3f[] getBboxVertices() {
        return this.bbVertices;
    }

    Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> info = new Hashtable<String, Tuple3f>();
        info.put("center", new Point3f(this.bbCenter));
        info.put("vector", new Vector3f(this.bbVector));
        info.put("corner0", new Point3f(this.bbCorner0));
        info.put("corner1", new Point3f(this.bbCorner1));
        return info;
    }

    void setBoundBox(Point3f pt1, Point3f pt2, boolean byCorner) {
        if (pt1.distance(pt2) == 0.0f) {
            return;
        }
        if (byCorner) {
            this.bbCorner0.set(Math.min(pt1.x, pt2.x), Math.min(pt1.y, pt2.y), Math.min(pt1.z, pt2.z));
            this.bbCorner1.set(Math.max(pt1.x, pt2.x), Math.max(pt1.y, pt2.y), Math.max(pt1.z, pt2.z));
        } else {
            this.bbCorner0.set(pt1.x - pt2.x, pt1.y - pt2.y, pt1.z - pt2.z);
            this.bbCorner1.set(pt1.x + pt2.x, pt1.y + pt2.y, pt1.z + pt2.z);
        }
        this.setBbcage();
    }

    void reset() {
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    void addBoundBoxPoint(Point3f pt) {
        float t = pt.x;
        if (t < this.bbCorner0.x) {
            this.bbCorner0.x = t;
        }
        if (t > this.bbCorner1.x) {
            this.bbCorner1.x = t;
        }
        if ((t = pt.y) < this.bbCorner0.y) {
            this.bbCorner0.y = t;
        }
        if (t > this.bbCorner1.y) {
            this.bbCorner1.y = t;
        }
        if ((t = pt.z) < this.bbCorner0.z) {
            this.bbCorner0.z = t;
        }
        if (t > this.bbCorner1.z) {
            this.bbCorner1.z = t;
        }
    }

    void setBbcage() {
        this.bbCenter.add(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub(this.bbCorner1, this.bbCenter);
        int i = 8;
        while (--i >= 0) {
            Point3f pt = this.bbVertices[i];
            pt.set(unitBboxPoints[i]);
            pt.x *= this.bbVector.x;
            pt.y *= this.bbVector.y;
            pt.z *= this.bbVector.z;
            pt.add(this.bbCenter);
        }
    }

    boolean isWithin(Point3f pt) {
        return pt.x >= this.bbCorner0.x && pt.x <= this.bbCorner1.x && pt.y >= this.bbCorner0.y && pt.y <= this.bbCorner1.y && pt.z >= this.bbCorner0.z && pt.z <= this.bbCorner1.z;
    }
}

