/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Molecule;
import org.jmol.modelset.Polymer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class ModelCollection
extends BondCollection {
    protected BitSet bsSymmetry;
    protected String modelSetName;
    protected Model[] models = new Model[1];
    protected int modelCount;
    SymmetryInterface[] unitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    protected String[] frameTitles = new String[1];
    protected BitSet[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    private Properties modelSetProperties;
    private Hashtable modelSetAuxiliaryInfo;
    protected Group[] groups;
    protected int groupCount;
    protected int baseGroupIndex = 0;
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];
    protected boolean haveBioClasses = true;
    protected JmolBioResolver jbr = null;
    protected BitSet structuresDefinedInFile = new BitSet();
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    protected Molecule[] molecules = new Molecule[4];
    protected int moleculeCount;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Point3f ptTemp = new Point3f();
    private final Point3f averageAtomPoint = new Point3f();
    private boolean isBbcageDefault;
    private BitSet bboxModels;
    private BitSet bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    protected Vector stateScripts;
    private int thisStateModel;
    protected Vector trajectorySteps;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private BitSet bsTemp;
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private AtomIteratorWithinModel withinModelIterator;
    private AtomIteratorWithinSet withinAtomSetIterator;
    protected BitSet bsAll;
    private static float defaultHbondMax = 3.25f;
    private static float hbondMin = 2.5f;
    boolean proteinStructureTainted;
    private SymmetryInterface symTemp;

    public ModelCollection() {
        this.boxInfo.setBbcage();
        this.stateScripts = new Vector();
        this.thisStateModel = 0;
        this.bsTemp = new BitSet();
        this.selectedMolecules = new BitSet();
        this.proteinStructureTainted = false;
    }

    protected void merge(ModelSet modelSet) {
        for (int i = 0; i < modelSet.modelCount; ++i) {
            Model m = this.models[i] = modelSet.models[i];
            m.bsAtoms = null;
            m.modelSet = (ModelSet)this;
            for (int j = 0; j < m.chainCount; ++j) {
                m.chains[j].setModelSet(m.modelSet);
            }
            this.stateScripts = modelSet.stateScripts;
            this.proteinStructureTainted = modelSet.proteinStructureTainted;
            this.thisStateModel = -1;
        }
        super.merge(modelSet);
    }

    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        this.withinModelIterator = null;
        this.withinAtomSetIterator = null;
        super.releaseModelSet();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public SymmetryInterface[] getCellInfos() {
        return this.unitCells;
    }

    public SymmetryInterface getUnitCell(int modelIndex) {
        return this.unitCells != null && modelIndex >= 0 && modelIndex < this.unitCells.length ? this.unitCells[modelIndex] : null;
    }

    public String getModelName(int modelIndex) {
        return this.modelCount < 1 ? "" : (modelIndex >= 0 ? this.modelNames[modelIndex] : this.modelNumbersForAtomLabel[-1 - modelIndex]);
    }

    public String getModelTitle(int modelIndex) {
        return (String)this.getModelAuxiliaryInfo(modelIndex, "title");
    }

    public String getModelFileName(int modelIndex) {
        return (String)this.getModelAuxiliaryInfo(modelIndex, "fileName");
    }

    public void setFrameTitle(int modelIndex, String title) {
        if (modelIndex >= 0 && modelIndex < this.modelCount) {
            this.frameTitles[modelIndex] = title;
        }
    }

    public String getFrameTitle(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.modelCount ? this.frameTitles[modelIndex] : "";
    }

    public String getModelNumberForAtomLabel(int modelIndex) {
        return this.modelNumbersForAtomLabel[modelIndex];
    }

    protected void calculatePolymers(BitSet alreadyDefined) {
        if (this.jbr == null) {
            return;
        }
        if (alreadyDefined != null) {
            this.jbr.clearBioPolymers(this.groups, this.groupCount, alreadyDefined);
        }
        boolean checkPolymerConnections = !this.viewer.getPdbLoadInfo(1);
        for (int i = this.baseGroupIndex; i < this.groupCount; ++i) {
            Polymer bp = this.jbr.buildBioPolymer(this.groups[i], this.groups, i, checkPolymerConnections);
            if (bp == null) continue;
            this.addBioPolymerToModel(bp, this.groups[i].getModel());
        }
    }

    protected void addBioPolymerToModel(Polymer polymer, Model model) {
        if (model.bioPolymers.length == 0 || polymer == null) {
            model.bioPolymers = new Polymer[8];
        }
        if (polymer == null) {
            model.bioPolymerCount = 0;
            return;
        }
        if (model.bioPolymerCount == model.bioPolymers.length) {
            model.bioPolymers = (Polymer[])ArrayUtil.doubleLength(model.bioPolymers);
        }
        model.bioPolymers[model.bioPolymerCount++] = polymer;
    }

    public float[] getNotionalUnitcell() {
        return this.unitCells == null || this.unitCells[0] == null ? null : this.unitCells[0].getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public Point3f getBoundBoxCenter(int modelIndex) {
        if (this.isJmolDataFrame(modelIndex)) {
            return new Point3f();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3f[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Hashtable getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(Point3f pt1, Point3f pt2, boolean byCorner) {
        if (pt1.distance(pt2) == 0.0f) {
            return;
        }
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(pt1, pt2, byCorner);
    }

    public String getBoundBoxCommand(boolean withOptions) {
        if (!withOptions && this.bboxAtoms != null) {
            return "boundbox " + Escape.escape(this.bboxAtoms);
        }
        this.ptTemp.set(this.boxInfo.getBoundBoxCenter());
        Vector3f bbVector = this.boxInfo.getBoundBoxCornerVector();
        String s = withOptions ? "boundbox " + Escape.escape(this.ptTemp) + " " + Escape.escape(bbVector) + "\n#or\n" : "";
        this.ptTemp.sub(bbVector);
        s = s + "boundbox corners " + Escape.escape(this.ptTemp) + " ";
        this.ptTemp.scaleAdd(2.0f, bbVector, this.ptTemp);
        float v = Math.abs(8.0f * bbVector.x * bbVector.y * bbVector.z);
        s = s + Escape.escape(this.ptTemp) + " # volume = " + v;
        return s;
    }

    public boolean setRotationRadius(int modelIndex, float angstroms) {
        if (!this.isJmolDataFrame(modelIndex)) {
            return false;
        }
        this.models[modelIndex].defaultRotationRadius = angstroms;
        return true;
    }

    public float calcRotationRadius(int modelIndex, Point3f center) {
        if (this.isJmolDataFrame(modelIndex)) {
            float r = this.models[modelIndex].defaultRotationRadius;
            return r == 0.0f ? 10.0f : r;
        }
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.isJmolDataFrame(this.atoms[i])) {
                modelIndex = this.atoms[i].modelIndex;
                while (i >= 0 && this.atoms[i].modelIndex == modelIndex) {
                    --i;
                }
                continue;
            }
            Atom atom = this.atoms[i];
            float distAtom = center.distance(atom);
            float outerVdw = distAtom + this.getRadiusVdwJmol(atom);
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius == 0.0f ? 10.0f : maxRadius;
    }

    public void calcBoundBoxDimensions(BitSet bs) {
        if (BitSetUtil.firstSetBit(bs) < 0) {
            bs = null;
        }
        if (bs == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BitSetUtil.copy(bs);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bs, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bs == null) {
            this.averageAtomPoint.set(this.getAtomSetCenter(null));
            if (this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage();
    }

    public BoxInfo getBoxInfo(BitSet bs) {
        if (bs == null) {
            return this.boxInfo;
        }
        BoxInfo bi = new BoxInfo();
        this.calcAtomsMinMax(bs, bi);
        bi.setBbcage();
        return bi;
    }

    private int calcAtomsMinMax(BitSet bs, BoxInfo boxInfo) {
        boxInfo.reset();
        int nAtoms = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (bs != null && !bs.get(i)) continue;
            ++nAtoms;
            if (this.isJmolDataFrame(this.atoms[i])) continue;
            boxInfo.addBoundBoxPoint(this.atoms[i]);
        }
        return nAtoms;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            Point3f[] vertices = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(vertices[j]);
            }
        }
    }

    public float calcRotationRadius(BitSet bs) {
        Point3f center = this.getAtomSetCenter(bs);
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom;
            float distAtom;
            float outerVdw;
            if (!bs.get(i) || !((outerVdw = (distAtom = center.distance(atom = this.atoms[i])) + this.getRadiusVdwJmol(atom)) > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius == 0.0f ? 10.0f : maxRadius;
    }

    public Point3f getAtomSetCenter(BitSet bs) {
        Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
        if (bs == null || BitSetUtil.firstSetBit(bs) < 0) {
            return ptCenter;
        }
        int nPoints = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (bs != null && !bs.get(i) || this.isJmolDataFrame(this.atoms[i])) continue;
            ++nPoints;
            ptCenter.add(this.atoms[i]);
        }
        ptCenter.scale(1.0f / (float)nPoints);
        return ptCenter;
    }

    public void setAtomProperty(BitSet bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        super.setAtomProperty(bs, tok, iValue, fValue, sValue, values, list);
        if ((tok == 22020372 || tok == 558891272) && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds();
        }
    }

    public void addStateScript(String script1, BitSet bsBonds, BitSet bsAtoms1, BitSet bsAtoms2, String script2, boolean addFrameNumber, boolean postDefinitions) {
        if (addFrameNumber) {
            int iModel = this.viewer.getCurrentModelIndex();
            if (this.thisStateModel != iModel) {
                script1 = "frame " + (iModel < 0 ? "" + iModel : this.getModelNumberDotted(iModel)) + ";\n  " + script1;
            }
            this.thisStateModel = iModel;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, script1, bsBonds, bsAtoms1, bsAtoms2, script2, postDefinitions);
        if (stateScript.isValid()) {
            this.stateScripts.addElement(stateScript);
        }
    }

    protected void defineStructure(int modelIndex, String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(modelIndex, structureType, startChainID, Group.getSeqcode(startSequenceNumber, startInsertionCode), endChainID, Group.getSeqcode(endSequenceNumber, endInsertionCode));
    }

    protected void calculateStructuresAllExcept(BitSet alreadyDefined, boolean addFileData) {
        this.freezeModels();
        int i = this.modelCount;
        while (--i >= 0) {
            if (!this.models[i].isPDB || alreadyDefined.get(i)) continue;
            this.models[i].calculateStructures();
        }
        this.setStructureIds();
        if (addFileData) {
            this.propagateSecondaryStructure();
        }
    }

    public void setProteinType(BitSet bs, byte iType) {
        int monomerIndexCurrent = -1;
        int iLast = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            if (iLast != i - 1) {
                monomerIndexCurrent = -1;
            }
            iLast = i;
            monomerIndexCurrent = this.atoms[i].group.setProteinStructureType(iType, monomerIndexCurrent);
            this.models[this.atoms[i].modelIndex].structureTainted = true;
            this.proteinStructureTainted = true;
        }
    }

    private void freezeModels() {
        int iModel = this.modelCount;
        while (--iModel >= 0) {
            int i;
            Model m = this.models[iModel];
            m.chains = (Chain[])ArrayUtil.setLength(m.chains, m.chainCount);
            m.groupCount = -1;
            m.getGroupCount();
            for (i = 0; i < m.chainCount; ++i) {
                m.chains[i].groups = (Group[])ArrayUtil.setLength(m.chains[i].groups, m.chains[i].groupCount);
            }
            m.bioPolymers = (Polymer[])ArrayUtil.setLength(m.bioPolymers, m.bioPolymerCount);
            i = m.bioPolymerCount;
            while (--i >= 0) {
                m.bioPolymers[i].freeze();
            }
        }
    }

    public BitSet setConformation(int modelIndex, BitSet bsConformation) {
        int i = this.modelCount;
        while (--i >= 0) {
            if (i != modelIndex && modelIndex >= 0) continue;
            this.models[i].setConformation(bsConformation);
        }
        return bsConformation;
    }

    public BitSet setConformation(int modelIndex, int conformationIndex) {
        BitSet bs = new BitSet();
        String altLocs = this.getAltLocListInModel(modelIndex);
        if (altLocs.length() > 0) {
            BitSet bsConformation = this.getModelAtomBitSet(modelIndex, true);
            if (conformationIndex >= 0) {
                int c = this.models[modelIndex].nAltLocs;
                while (--c >= 0) {
                    if (c == conformationIndex) continue;
                    BitSetUtil.andNot(bsConformation, this.getAtomBits(0x10001F, altLocs.substring(c, c + 1)));
                }
            }
            if (BitSetUtil.length(bsConformation) > 0) {
                this.setConformation(modelIndex, bsConformation);
                bs.or(bsConformation);
            }
        }
        return bs;
    }

    public Hashtable getHeteroList(int modelIndex) {
        Hashtable htFull = new Hashtable();
        boolean ok = false;
        int i = this.modelCount;
        while (--i >= 0) {
            Hashtable ht;
            if (modelIndex >= 0 && i != modelIndex || (ht = (Hashtable)this.getModelAuxiliaryInfo(i, "hetNames")) == null) continue;
            ok = true;
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                htFull.put(key, ht.get(key));
            }
        }
        return ok ? htFull : (Hashtable)this.getModelSetAuxiliaryInfo("hetNames");
    }

    protected void setModelSetProperties(Properties modelSetProperties) {
        this.modelSetProperties = modelSetProperties;
    }

    protected void setModelSetAuxiliaryInfo(Hashtable modelSetAuxiliaryInfo) {
        this.modelSetAuxiliaryInfo = modelSetAuxiliaryInfo;
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String propertyName) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(propertyName);
    }

    public Object getModelSetAuxiliaryInfo(String keyName) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(keyName);
    }

    protected boolean getModelSetAuxiliaryInfoBoolean(String keyName) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(keyName) && (Boolean)this.modelSetAuxiliaryInfo.get(keyName) != false;
    }

    protected int getTrajectoryCount() {
        return this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
    }

    public int getTrajectoryIndex(int modelIndex) {
        return this.models[modelIndex].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int modelIndex) {
        return this.models[modelIndex].isTrajectory;
    }

    public boolean isTrajectory(int[] countPlusIndices) {
        if (countPlusIndices == null) {
            return false;
        }
        int count = countPlusIndices[0];
        for (int i = 1; i <= count; ++i) {
            int atomIndex = countPlusIndices[i];
            if (atomIndex < 0 || !this.models[this.atoms[atomIndex].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelBitSet(BitSet atomList, boolean allTrajectories) {
        BitSet bs = new BitSet();
        short lastModel = -1;
        short modelIndex = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomList != null && !atomList.get(i)) continue;
            modelIndex = this.atoms[i].modelIndex;
            bs.set(modelIndex);
            if (!allTrajectories || modelIndex == lastModel) continue;
            lastModel = modelIndex;
            for (int j = 0; j < this.modelCount; ++j) {
                if (this.models[j].trajectoryBaseIndex != this.models[modelIndex].trajectoryBaseIndex) continue;
                bs.set(j);
            }
        }
        return bs;
    }

    public BitSet getIterativeModels(boolean allowJmolData) {
        BitSet bs = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!allowJmolData && this.isJmolDataFrame(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bs.set(i);
        }
        return bs;
    }

    public void selectDisplayedTrajectories(BitSet bs) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bs.clear(i);
        }
    }

    public String getModelNumberDotted(int modelIndex) {
        return this.modelCount < 1 || modelIndex < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[modelIndex]);
    }

    public int getModelNumber(int modelIndex) {
        return this.modelNumbers[modelIndex];
    }

    public int getModelFileNumber(int modelIndex) {
        return this.modelFileNumbers[modelIndex];
    }

    public Properties getModelProperties(int modelIndex) {
        return this.models[modelIndex].properties;
    }

    public String getModelProperty(int modelIndex, String property) {
        Properties props = this.models[modelIndex].properties;
        return props == null ? null : props.getProperty(property);
    }

    public Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return modelIndex < 0 ? null : this.models[modelIndex].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int modelIndex, Object key, Object value) {
        this.models[modelIndex].auxiliaryInfo.put(key, value);
    }

    public Object getModelAuxiliaryInfo(int modelIndex, String key) {
        if (modelIndex < 0) {
            return null;
        }
        return this.models[modelIndex].auxiliaryInfo.get(key);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int modelIndex, String keyName) {
        Hashtable info = this.models[modelIndex].auxiliaryInfo;
        return info != null && info.containsKey(keyName) && (Boolean)info.get(keyName) != false;
    }

    protected int getModelAuxiliaryInfoInt(int modelIndex, String keyName) {
        Hashtable info = this.models[modelIndex].auxiliaryInfo;
        if (info != null && info.containsKey(keyName)) {
            return (Integer)info.get(keyName);
        }
        return Integer.MIN_VALUE;
    }

    protected Model getModel(int modelIndex) {
        return this.models[modelIndex];
    }

    public int getInsertionCountInModel(int modelIndex) {
        return this.models[modelIndex].nInsertions;
    }

    public String getModelFileType(int modelIndex) {
        return (String)this.getModelAuxiliaryInfo(modelIndex, "fileType");
    }

    public static int modelFileNumberFromFloat(float fDotM) {
        int model;
        int file = (int)fDotM;
        for (model = (int)(((double)(fDotM - (float)file) + 1.0E-5) * 10000.0); model != 0 && model % 10 == 0; model /= 10) {
        }
        return file * 1000000 + model;
    }

    public int getAltLocCountInModel(int modelIndex) {
        return this.models[modelIndex].nAltLocs;
    }

    private void propagateSecondaryStructure() {
        int i = this.structureCount;
        while (--i >= 0) {
            Structure structure = this.structures[i];
            this.models[structure.modelIndex].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
        }
    }

    public int getChainCount(boolean addWater) {
        int chainCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            chainCount += this.models[i].getChainCount(addWater);
        }
        return chainCount;
    }

    public int getBioPolymerCount() {
        int polymerCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            if (this.models[i].isTrajectory && this.models[i].trajectoryBaseIndex != i) continue;
            polymerCount += this.models[i].getBioPolymerCount();
        }
        return polymerCount;
    }

    public int getBioPolymerCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            return this.getBioPolymerCount();
        }
        if (this.models[modelIndex].isTrajectory && this.models[modelIndex].trajectoryBaseIndex != modelIndex) {
            return 0;
        }
        return this.models[modelIndex].getBioPolymerCount();
    }

    public void getPolymerPointsAndVectors(BitSet bs, Vector vList) {
        boolean isTraceAlpha = this.viewer.getTraceAlpha();
        float sheetSmoothing = this.viewer.getSheetSmoothing();
        int last = 0x7FFFFFFE;
        for (int i = 0; i < this.modelCount; ++i) {
            int polymerCount = this.models[i].getBioPolymerCount();
            for (int ip = 0; ip < polymerCount; ++ip) {
                last = this.models[i].getBioPolymer(ip).getPolymerPointsAndVectors(last, bs, vList, isTraceAlpha, sheetSmoothing);
            }
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int modelIndex) {
        if (modelIndex < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                this.recalculateLeadMidpointsAndWingVectors(i);
            }
            return;
        }
        int polymerCount = this.models[modelIndex].getBioPolymerCount();
        for (int ip = 0; ip < polymerCount; ++ip) {
            this.models[modelIndex].getBioPolymer(ip).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public Point3f[] getPolymerLeadMidPoints(int iModel, int iPolymer) {
        return this.models[iModel].getBioPolymer(iPolymer).getLeadMidpoints();
    }

    public int getChainCountInModel(int modelIndex, boolean countWater) {
        if (modelIndex < 0) {
            return this.getChainCount(countWater);
        }
        return this.models[modelIndex].getChainCount(countWater);
    }

    public int getGroupCount() {
        int groupCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            groupCount += this.models[i].getGroupCount();
        }
        return groupCount;
    }

    public int getGroupCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            return this.getGroupCount();
        }
        return this.models[modelIndex].getGroupCount();
    }

    public void calcSelectedGroupsCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    public void calcSelectedMonomersCount(BitSet bsSelected) {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcSelectedMonomersCount(bsSelected);
        }
    }

    public void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
        int i = this.modelCount;
        while (--i >= 0) {
            if (this.models[i].trajectoryBaseIndex != i) continue;
            this.clearCalculatedHydrogenBonds(i, bsA);
            this.models[i].calcHydrogenBonds(bsA, bsB);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char ctype = this.viewer.getTestFlag3() ? (char)'s' : 'S';
        char qtype = this.viewer.getQuaternionFrame();
        int i = this.modelCount;
        while (--i >= 0) {
            Model model = this.models[i];
            int nPoly = model.getBioPolymerCount();
            for (int p = 0; p < nPoly; ++p) {
                model.bioPolymers[p].getPdbData(ctype, qtype, 2, false, null, null, null, null, false, new BitSet());
            }
        }
        this.setHaveStraightness(true);
    }

    public String getPdbAtomData(BitSet bs) {
        if (this.atomCount == 0) {
            return "";
        }
        short iModel = this.atoms[0].modelIndex;
        short iModelLast = -1;
        StringBuffer sb = new StringBuffer();
        boolean showModels = iModel != this.atoms[this.atomCount - 1].modelIndex;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            Atom a = this.atoms[i];
            if (showModels && a.modelIndex != iModelLast) {
                if (iModelLast != -1) {
                    sb.append("ENDMDL\n");
                }
                iModelLast = a.modelIndex;
                sb.append("MODEL     " + (iModelLast + 1) + "\n");
            }
            if (!this.models[a.modelIndex].isPDB) {
                sb.append(LabelToken.formatLabel(a, "HETATM%5i %-4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
                continue;
            }
            if (a.isHetero()) {
                sb.append(LabelToken.formatLabel(a, "HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
                continue;
            }
            sb.append(LabelToken.formatLabel(a, "ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
        }
        if (showModels) {
            sb.append("ENDMDL\n");
        }
        return sb.toString();
    }

    public String getPdbData(int modelIndex, String type, BitSet bsSelected, boolean addHeader) {
        int qtype;
        char ctype;
        if (this.isJmolDataFrame(modelIndex)) {
            modelIndex = this.getJmolDataSourceFrame(modelIndex);
        }
        if (modelIndex < 0) {
            return "";
        }
        if (!this.models[modelIndex].isPDB) {
            return null;
        }
        Model model = this.models[modelIndex];
        char c = ctype = type.length() > 11 && type.indexOf("quaternion ") >= 0 ? (char)type.charAt(11) : (char)'R';
        int n = ctype != 'R' ? this.viewer.getQuaternionFrame() : (qtype = type.length() > 13 && type.indexOf("ramachandran ") >= 0 ? (int)type.charAt(13) : 82);
        int derivType = type.indexOf("diff") < 0 ? 0 : (type.indexOf("2") < 0 ? 1 : 2);
        boolean isDraw = type.indexOf("draw") >= 0;
        BitSet bsAtoms = this.getModelAtomBitSet(modelIndex, false);
        int nPoly = model.getBioPolymerCount();
        StringBuffer pdbATOM = new StringBuffer();
        StringBuffer pdbCONECT = new StringBuffer();
        BitSet bsWritten = new BitSet();
        for (int p = 0; p < nPoly; ++p) {
            model.bioPolymers[p].getPdbData(ctype, (char)qtype, derivType, isDraw, bsAtoms, pdbATOM, pdbCONECT, bsSelected, p == 0, bsWritten);
        }
        pdbATOM.append(pdbCONECT);
        String s = pdbATOM.toString();
        if (isDraw || s.length() == 0) {
            return s;
        }
        String remark = "REMARK   6 Jmol PDB-encoded data: " + type + ";";
        if (ctype != 'R') {
            remark = remark + "  quaternionFrame = \"" + (char)qtype + "\"";
        }
        remark = remark + "\nREMARK   6 Jmol Version " + Viewer.getJmolVersion();
        bsSelected.and(bsAtoms);
        remark = remark + "\n\n" + this.getProteinStructureState(bsWritten, false, ctype == 'R');
        return remark + s;
    }

    public boolean isJmolDataFrame(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.modelCount && this.models[modelIndex].jmolData != null;
    }

    private boolean isJmolDataFrame(Atom atom) {
        return this.models[atom.modelIndex].jmolData != null;
    }

    public void setJmolDataFrame(String type, int modelIndex, int modelDataIndex) {
        Model model = this.models[type == null ? this.models[modelDataIndex].dataSourceFrame : modelIndex];
        if (type == null) {
            type = this.models[modelDataIndex].jmolFrameType;
        }
        if (modelIndex >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable();
            }
            this.models[modelDataIndex].dataSourceFrame = modelIndex;
            this.models[modelDataIndex].jmolFrameType = type;
            model.dataFrames.put(type, new Integer(modelDataIndex));
        }
        if (type.startsWith("quaternion") && type.indexOf("deriv") < 0) {
            type = type.substring(0, type.indexOf(" "));
            model.dataFrames.put(type, new Integer(modelDataIndex));
        }
    }

    public int getJmolDataFrameIndex(int modelIndex, String type) {
        if (this.models[modelIndex].dataFrames == null) {
            return -1;
        }
        Integer index = (Integer)this.models[modelIndex].dataFrames.get(type);
        return index == null ? -1 : index;
    }

    protected void clearDataFrameReference(int modelIndex) {
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable df = this.models[i].dataFrames;
            if (df == null) continue;
            Enumeration e = df.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                if ((Integer)df.get(key) != modelIndex) continue;
                df.remove(key);
            }
        }
    }

    public String getJmolFrameType(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.modelCount ? this.models[modelIndex].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int modelIndex) {
        return modelIndex >= 0 && modelIndex < this.modelCount ? this.models[modelIndex].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int modelIndex, StateManager.Orientation orientation) {
        this.models[modelIndex].orientation = orientation;
    }

    public StateManager.Orientation getModelOrientation(int modelIndex) {
        return this.models[modelIndex].orientation;
    }

    private String getFullPDBHeader(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        String info = (String)this.getModelAuxiliaryInfo(modelIndex, "fileHeader");
        if (info != null) {
            return info;
        }
        info = this.viewer.getCurrentFileAsString();
        int ichMin = info.length();
        int i = pdbRecords.length;
        block4: while (--i >= 0) {
            String strRecord = pdbRecords[i];
            int ichFound = info.startsWith(strRecord) ? 0 : info.indexOf("\n" + strRecord);
            switch (ichFound) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.setModelAuxiliaryInfo(modelIndex, "fileHeader", "");
                    return "";
                }
            }
            if (ichFound >= ichMin) continue;
            ichMin = ++ichFound;
        }
        info = info.substring(0, ichMin);
        this.setModelAuxiliaryInfo(modelIndex, "fileHeader", info);
        return info;
    }

    public String getPDBHeader(int modelIndex) {
        return this.isPDB ? this.getFullPDBHeader(modelIndex) : this.getFileHeader(modelIndex);
    }

    public String getFileHeader(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        if (this.isPDB) {
            return this.getFullPDBHeader(modelIndex);
        }
        String info = (String)this.getModelAuxiliaryInfo(modelIndex, "fileHeader");
        if (info == null) {
            info = this.modelSetName;
        }
        if (info != null) {
            return info;
        }
        return "no header information found";
    }

    public Hashtable getModelInfo(BitSet bsModels) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("modelSetName", this.modelSetName);
        info.put("modelCount", new Integer(this.modelCount));
        info.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        if (this.modelSetProperties != null) {
            info.put("modelSetProperties", this.modelSetProperties);
        }
        info.put("modelCountSelected", new Integer(BitSetUtil.cardinalityOf(bsModels)));
        info.put("modelsSelected", bsModels);
        Vector vModels = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bsModels.get(i)) continue;
            Hashtable<String, Object> model = new Hashtable<String, Object>();
            model.put("_ipt", new Integer(i));
            model.put("num", new Integer(this.getModelNumber(i)));
            model.put("file_model", this.getModelNumberDotted(i));
            model.put("name", this.getModelName(i));
            String s = this.getModelTitle(i);
            if (s != null) {
                model.put("title", s);
            }
            if ((s = this.getModelFileName(i)) != null) {
                model.put("file", s);
            }
            model.put("vibrationVectors", this.modelHasVibrationVectors(i));
            model.put("atomCount", new Integer(this.getAtomCountInModel(i)));
            model.put("bondCount", new Integer(this.getBondCountInModel(i)));
            model.put("groupCount", new Integer(this.getGroupCountInModel(i)));
            model.put("polymerCount", new Integer(this.models[i].getBioPolymerCount()));
            model.put("chainCount", new Integer(this.getChainCountInModel(i, true)));
            if (this.models[i].properties != null) {
                model.put("modelProperties", this.models[i].properties);
            }
            vModels.addElement(model);
        }
        info.put("models", vModels);
        return info;
    }

    public int getAltLocIndexInModel(int modelIndex, char alternateLocationID) {
        if (alternateLocationID == '\u0000') {
            return 0;
        }
        String altLocList = this.getAltLocListInModel(modelIndex);
        if (altLocList.length() == 0) {
            return 0;
        }
        return altLocList.indexOf(alternateLocationID) + 1;
    }

    public int getInsertionCodeIndexInModel(int modelIndex, char insertionCode) {
        if (insertionCode == '\u0000') {
            return 0;
        }
        String codeList = this.getInsertionListInModel(modelIndex);
        if (codeList.length() == 0) {
            return 0;
        }
        return codeList.indexOf(insertionCode) + 1;
    }

    public String getAltLocListInModel(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        String str = (String)this.getModelAuxiliaryInfo(modelIndex, "altLocs");
        return str == null ? "" : str;
    }

    private String getInsertionListInModel(int modelIndex) {
        String str = (String)this.getModelAuxiliaryInfo(modelIndex, "insertionCodes");
        return str == null ? "" : str;
    }

    private String getModelSymmetryList(int modelIndex) {
        if (this.unitCells == null || this.unitCells[modelIndex] == null) {
            return "";
        }
        String[] list = this.unitCells[modelIndex].getSymmetryOperations();
        if (list == null) {
            return "\n no symmetry operations employed";
        }
        String str = "\n" + list.length + " symmetry operations employed:";
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                str = str + "\n" + list[i];
            }
        }
        return str;
    }

    public int getModelSymmetryCount(int modelIndex) {
        String[] operations;
        if (this.unitCells == null || this.unitCells[modelIndex] == null || (operations = this.unitCells[modelIndex].getSymmetryOperations()) == null) {
            return this.models[modelIndex].biosymmetryCount;
        }
        return operations.length;
    }

    public int[] getModelCellRange(int modelIndex) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[modelIndex].getCellRange();
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        if (this.vibrationVectors != null) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (modelIndex >= 0 && this.atoms[i].modelIndex != modelIndex || this.vibrationVectors[i] == null || !(this.vibrationVectors[i].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BitSet getElementsPresentBitSet(int modelIndex) {
        if (modelIndex >= 0) {
            return this.elementsPresent[modelIndex];
        }
        BitSet bs = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bs.or(this.elementsPresent[i]);
        }
        return bs;
    }

    private String getSymmetryInfoAsString(int modelIndex) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        return unitCell == null ? "no symmetry information" : unitCell.getSymmetryInfoString();
    }

    public void toCartesian(int modelIndex, Point3f pt) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        if (unitCell != null) {
            unitCell.toCartesian(pt);
        }
    }

    public void toFractional(int modelIndex, Point3f pt) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        if (unitCell != null) {
            unitCell.toFractional(pt);
        }
    }

    public void toUnitCell(int modelIndex, Point3f pt, Point3f offset) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        if (unitCell != null) {
            this.unitCells[modelIndex].toUnitCell(pt, offset);
        }
    }

    public boolean setUnitCellOffset(int modelIndex, Point3f pt) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        if (unitCell == null) {
            return false;
        }
        unitCell.setUnitCellOffset(pt);
        return true;
    }

    public boolean setUnitCellOffset(int modelIndex, int nnn) {
        SymmetryInterface unitCell = this.getUnitCell(modelIndex);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(nnn);
        return true;
    }

    public Vector getMoleculeInfo(BitSet bsAtoms) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> V = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = BitSetUtil.copy(bsAtoms);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length(this.bsTemp) <= 0) continue;
            V.addElement(this.molecules[i].getInfo());
        }
        return V;
    }

    public int getMoleculeIndex(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    public void rotateAtoms(Matrix3f mNew, Matrix3f matrixRotate, BitSet bsAtoms, boolean fullMolecule, Point3f center, boolean isInternal) {
        this.bspf = null;
        BitSet bs = fullMolecule ? this.getMoleculeBitSet(bsAtoms) : bsAtoms;
        this.matInv.set(matrixRotate);
        this.matInv.invert();
        this.ptTemp.set(0.0f, 0.0f, 0.0f);
        this.matTemp.mul(mNew, matrixRotate);
        this.matTemp.mul(this.matInv, this.matTemp);
        int n = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            if (isInternal) {
                this.atoms[i].sub(center);
                this.matTemp.transform(this.atoms[i]);
                this.atoms[i].add(center);
            } else {
                this.ptTemp.add(this.atoms[i]);
                this.matTemp.transform(this.atoms[i]);
                this.ptTemp.sub(this.atoms[i]);
            }
            this.taint(i, (byte)2);
            ++n;
        }
        if (n == 0) {
            return;
        }
        if (!isInternal) {
            this.ptTemp.scale(1.0f / (float)n);
            i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.atoms[i].add(this.ptTemp);
            }
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public BitSet getMoleculeBitSet(BitSet bs) {
        int iLastBit;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bsResult = BitSetUtil.copy(bs);
        BitSet bsInitial = BitSetUtil.copy(bs);
        while ((iLastBit = BitSetUtil.length(bsInitial)) > 0) {
            this.bsTemp = this.getMoleculeBitSet(iLastBit - 1);
            BitSetUtil.andNot(bsInitial, this.bsTemp);
            bsResult.or(this.bsTemp);
        }
        return bsResult;
    }

    public BitSet getMoleculeBitSet(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public void invertSelected(Point3f pt, Point4f plane, BitSet bs) {
        this.bspf = null;
        if (pt != null) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                float x = (pt.x - this.atoms[i].x) * 2.0f;
                float y = (pt.y - this.atoms[i].y) * 2.0f;
                float z = (pt.z - this.atoms[i].z) * 2.0f;
                this.setAtomCoordRelative(i, x, y, z);
            }
            return;
        }
        Vector3f norm = new Vector3f(plane.x, plane.y, plane.z);
        norm.normalize();
        float d = (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            float twoD = -Graphics3D.distanceToPlane(plane, d, (Point3f)this.atoms[i]) * 2.0f;
            float x = norm.x * twoD;
            float y = norm.y * twoD;
            float z = norm.z * twoD;
            this.setAtomCoordRelative(i, x, y, z);
        }
    }

    public Vector3f getModelDipole(int modelIndex) {
        if (modelIndex < 0) {
            return null;
        }
        Vector3f dipole = (Vector3f)this.getModelAuxiliaryInfo(modelIndex, "dipole");
        if (dipole == null) {
            dipole = (Vector3f)this.getModelAuxiliaryInfo(modelIndex, "DIPOLE_VEC");
        }
        return dipole;
    }

    public Vector3f calculateMolecularDipole(int modelIndex) {
        if (this.partialCharges == null || modelIndex < 0) {
            return null;
        }
        int nPos = 0;
        int nNeg = 0;
        float cPos = 0.0f;
        float cNeg = 0.0f;
        Vector3f pos = new Vector3f();
        Vector3f neg = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            float c = this.partialCharges[i];
            if (c < 0.0f) {
                ++nNeg;
                cNeg += c;
                neg.scaleAdd(c, this.atoms[i], neg);
                continue;
            }
            if (!(c > 0.0f)) continue;
            ++nPos;
            cPos += c;
            pos.scaleAdd(c, this.atoms[i], pos);
        }
        if (nNeg == 0 || nPos == 0) {
            return null;
        }
        pos.scale(1.0f / cPos);
        neg.scale(1.0f / cNeg);
        pos.sub(neg);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        pos.scale(cPos * 4.8f);
        return pos;
    }

    public int getMoleculeCountInModel(int modelIndex) {
        int n = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (modelIndex != i && modelIndex >= 0) continue;
            n += this.models[i].moleculeCount;
        }
        return n;
    }

    public void calcSelectedMoleculesCount(BitSet bsSelected) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy(bsSelected, this.bsTemp);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length(this.bsTemp) <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    private void getMolecules() {
        if (this.moleculeCount > 0) {
            return;
        }
        if (this.molecules == null) {
            this.molecules = new Molecule[4];
        }
        this.moleculeCount = 0;
        BitSet atomlist = new BitSet(this.atomCount);
        BitSet bs = new BitSet(this.atomCount);
        int thisModelIndex = -1;
        int modelIndex = -1;
        int indexInModel = -1;
        int moleculeCount0 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomlist.get(i) || bs.get(i)) continue;
            modelIndex = this.atoms[i].modelIndex;
            if (modelIndex != thisModelIndex) {
                indexInModel = -1;
                this.models[modelIndex].firstMolecule = this.moleculeCount;
                moleculeCount0 = this.moleculeCount - 1;
                thisModelIndex = modelIndex;
            }
            ++indexInModel;
            bs = this.getBranchBitSet(i, -1);
            atomlist.or(bs);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])ArrayUtil.setLength(this.molecules, this.moleculeCount * 2);
            }
            this.molecules[this.moleculeCount] = new Molecule((ModelSet)this, this.moleculeCount, bs, thisModelIndex, indexInModel);
            this.getModel((int)thisModelIndex).moleculeCount = this.moleculeCount - moleculeCount0;
            ++this.moleculeCount;
        }
    }

    public BitSet getBranchBitSet(int atomIndex, int atomIndexNot) {
        BitSet bs = new BitSet(this.atomCount);
        if (atomIndex < 0) {
            return bs;
        }
        BitSet bsToTest = this.getModelAtomBitSet(this.atoms[atomIndex].modelIndex, true);
        if (atomIndexNot >= 0) {
            bsToTest.clear(atomIndexNot);
        }
        this.getCovalentlyConnectedBitSet(this.atoms[atomIndex], bs, bsToTest);
        return bs;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bs, BitSet bsToTest) {
        int atomIndex = atom.atomIndex;
        if (!bsToTest.get(atomIndex)) {
            return;
        }
        bsToTest.clear(atomIndex);
        bs.set(atomIndex);
        if (atom.bonds == null) {
            return;
        }
        int i = atom.bonds.length;
        while (--i >= 0) {
            Bond bond = atom.bonds[i];
            if ((bond.order & 0x7800) != 0) continue;
            this.getCovalentlyConnectedBitSet(bond.getOtherAtom(atom), bs, bsToTest);
        }
    }

    public boolean hasCalculatedHBonds(BitSet bsAtoms) {
        int i = this.atomCount;
        while (--i >= 0) {
            if (bsAtoms.get(i) && this.models[this.atoms[i].modelIndex].hasCalculatedHBonds) {
                return true;
            }
            i = this.models[this.atoms[i].modelIndex].firstAtomIndex;
        }
        return false;
    }

    public void clearCalculatedHydrogenBonds(int baseIndex, BitSet bsAtoms) {
        BitSet bsDelete = new BitSet();
        int nDelete = 0;
        this.models[baseIndex].hasCalculatedHBonds = false;
        int i = this.bondCount;
        while (--i >= 0) {
            Bond bond = this.bonds[i];
            if (baseIndex >= 0 && this.models[bond.atom1.modelIndex].trajectoryBaseIndex != baseIndex || (bond.order & 0x7000) == 0) continue;
            if (bsAtoms != null && !bsAtoms.get(bond.atom1.atomIndex)) {
                this.models[baseIndex].hasCalculatedHBonds = true;
                continue;
            }
            bsDelete.set(i);
            ++nDelete;
        }
        if (nDelete > 0) {
            this.deleteBonds(bsDelete);
        }
    }

    protected void initializeBspf() {
        if (this.bspf == null) {
            if (Logger.debugging) {
                Logger.startTimer();
            }
            this.bspf = new Bspf(3);
            Logger.debug("sequential bspt order");
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                this.bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            }
            if (Logger.debugging) {
                Logger.checkTimer("Time to build bspf");
                this.bspf.stats();
            }
        }
    }

    protected void initializeBspt(int modelIndex) {
        if (this.bspf.isInitialized(modelIndex)) {
            return;
        }
        this.bspf.initialize(modelIndex, this.atoms, this.getModelAtomBitSet(modelIndex, false));
    }

    public AtomIndexIterator getWithinAtomSetIterator(int atomIndex, float distance, BitSet bsSelected, boolean isGreaterOnly, boolean modelZeroBased) {
        this.initializeBspf();
        int modelIndex = this.atoms[atomIndex].modelIndex;
        modelIndex = this.models[modelIndex].trajectoryBaseIndex;
        this.initializeBspt(modelIndex);
        if (this.withinAtomSetIterator == null) {
            this.withinAtomSetIterator = new AtomIteratorWithinSet();
        }
        this.withinAtomSetIterator.initialize(this.bspf, modelIndex, atomIndex, this.atoms[atomIndex], distance, bsSelected, isGreaterOnly, modelZeroBased ? this.models[modelIndex].firstAtomIndex : 0);
        return this.withinAtomSetIterator;
    }

    public AtomIndexIterator getWithinModelIterator(Atom atomCenter, float radius) {
        return this.getWithinModelIterator(atomCenter.modelIndex, atomCenter, radius);
    }

    private AtomIndexIterator getWithinModelIterator(int modelIndex, Point3f center, float radius) {
        this.initializeBspf();
        modelIndex = this.models[modelIndex].trajectoryBaseIndex;
        this.initializeBspt(modelIndex);
        if (this.withinModelIterator == null) {
            this.withinModelIterator = new AtomIteratorWithinModel();
        }
        this.withinModelIterator.initialize(this.bspf, modelIndex, center, radius);
        return this.withinModelIterator;
    }

    public int getBondCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            return this.bondCount;
        }
        int n = this.models[modelIndex].bondCount;
        if (n >= 0) {
            return n;
        }
        this.models[modelIndex].bondCount = super.getBondCountInModel(modelIndex);
        return this.models[modelIndex].bondCount;
    }

    public void setAtomCoordRelative(Point3f offset, BitSet bs) {
        this.setAtomCoordRelative(bs, offset.x, offset.y, offset.z);
        this.recalculatePositionDependentQuantities();
    }

    public void setAtomCoord(BitSet bs, int tokType, Object xyzValues) {
        super.setAtomCoord(bs, tokType, xyzValues);
        switch (tokType) {
            case 38797590: 
            case 38797591: 
            case 38797592: 
            case 72352013: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities();
            }
        }
    }

    private void recalculatePositionDependentQuantities() {
        if (this.getHaveStraightness()) {
            this.calculateStraightness();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public int getAtomCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            return this.atomCount;
        }
        int n = this.models[modelIndex].atomCount;
        if (n >= 0) {
            return n;
        }
        this.models[modelIndex].atomCount = super.getAtomCountInModel(modelIndex);
        return this.models[modelIndex].atomCount;
    }

    public BitSet getModelAtomBitSet(int modelIndex, boolean asCopy) {
        BitSet bs;
        BitSet bitSet = bs = modelIndex < 0 ? this.bsAll : this.models[modelIndex].bsAtoms;
        if (bs == null) {
            if (modelIndex < 0) {
                bs = this.bsAll = BitSetUtil.setAll(this.atomCount);
            } else {
                bs = new BitSet();
                for (int i = 0; i < this.atomCount; ++i) {
                    if (this.atoms[i].modelIndex != modelIndex) continue;
                    bs.set(i);
                }
                this.models[modelIndex].bsAtoms = bs;
            }
        }
        return asCopy ? BitSetUtil.copy(bs) : bs;
    }

    public BitSet getAtomBits(int tokType, Object specInfo) {
        switch (tokType) {
            default: {
                return super.getAtomBits(tokType, specInfo);
            }
            case 22020109: {
                return this.getMoleculeBitSet((BitSet)specInfo);
            }
            case 605556745: {
                BoxInfo boxInfo = this.getBoxInfo((BitSet)specInfo);
                BitSet bs = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                for (int i = 0; i < this.atomCount; ++i) {
                    if (!bs.get(i) || boxInfo.isWithin(this.atoms[i])) continue;
                    bs.clear(i);
                }
                return bs;
            }
            case 1048615: {
                int[] info = (int[])specInfo;
                int seqcodeA = info[0];
                int seqcodeB = info[1];
                char chainID = (char)info[2];
                BitSet bs = new BitSet();
                boolean caseSensitive = this.viewer.getChainCaseSensitive();
                if (!caseSensitive) {
                    chainID = Character.toUpperCase(chainID);
                }
                int i = this.modelCount;
                while (--i >= 0) {
                    this.models[i].selectSeqcodeRange(seqcodeA, seqcodeB, chainID, bs, caseSensitive);
                }
                return bs;
            }
            case 3145753: {
                BitSet bs = new BitSet(this.atomCount);
                short modelIndex = -1;
                int nOps = 0;
                int i = this.atomCount;
                block10: while (--i >= 0) {
                    Atom atom = this.atoms[i];
                    BitSet bsSym = atom.getAtomSymmetry();
                    if (bsSym == null) continue;
                    if (atom.modelIndex != modelIndex) {
                        modelIndex = atom.modelIndex;
                        if (this.getModelCellRange(modelIndex) == null) continue;
                        nOps = this.getModelSymmetryCount(modelIndex);
                    }
                    int n = 0;
                    int j = nOps;
                    while (--j >= 0) {
                        if (!bsSym.get(j) || ++n <= 1) continue;
                        bs.set(i);
                        continue block10;
                    }
                }
                return bs;
            }
            case 0xF0000C: {
                return BitSetUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry);
            }
            case 540545088: 
        }
        BitSet bs = new BitSet();
        SymmetryInterface unitcell = this.viewer.getCurrentUnitCell();
        if (unitcell == null) {
            return bs;
        }
        Point3f cell = new Point3f(unitcell.getFractionalOffset());
        cell.x += 1.0f;
        cell.y += 1.0f;
        cell.z += 1.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.isInLatticeCell(i, cell)) continue;
            bs.set(i);
        }
        return bs;
    }

    public BitSet getAtomsWithin(float distance, BitSet bs, boolean withinAllModels) {
        BitSet bsResult = new BitSet();
        BitSet bsCheck = this.getIterativeModels(false);
        float d2 = distance * distance;
        int iAtom = 0;
        if (withinAllModels) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                int iModel = this.modelCount;
                while (--iModel >= 0) {
                    if (!bsCheck.get(iModel)) continue;
                    if (distance < 0.0f) {
                        this.getAtomsWithin(-distance, this.atoms[i], bsResult, -1);
                        this.getAtomsWithin(distance, this.atoms[i].getFractionalUnitCoord(true), bsResult, -1);
                        continue;
                    }
                    AtomIndexIterator iterWithin = this.getWithinModelIterator(iModel, this.atoms[i], distance);
                    while (iterWithin.hasNext()) {
                        iAtom = iterWithin.next();
                        if (iAtom < 0 || !(iterWithin.foundDistance2() <= d2)) continue;
                        bsResult.set(iAtom);
                    }
                }
            }
        } else {
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (distance < 0.0f) {
                    this.getAtomsWithin(-distance, this.atoms[i], bsResult, this.atoms[i].modelIndex);
                    this.getAtomsWithin(distance, this.atoms[i], bsResult, this.atoms[i].modelIndex);
                    continue;
                }
                AtomIndexIterator iterWithin = this.getWithinModelIterator(this.atoms[i], distance);
                while (iterWithin.hasNext()) {
                    iAtom = iterWithin.next();
                    if (iAtom < 0 || !(iterWithin.foundDistance2() <= d2)) continue;
                    bsResult.set(iAtom);
                }
            }
        }
        return bsResult;
    }

    public BitSet getAtomsWithin(float distance, Point3f coord, BitSet bsResult, int modelIndex) {
        if (bsResult == null) {
            bsResult = new BitSet();
        }
        if (distance < 0.0f) {
            distance = -distance;
            Point3f ptTemp1 = new Point3f();
            Point3f ptTemp2 = new Point3f();
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                if (modelIndex >= 0 && this.atoms[i].modelIndex != modelIndex || bsResult.get(i) || !(atom.getFractionalUnitDistance(coord, ptTemp1, ptTemp2) <= distance)) continue;
                bsResult.set(atom.atomIndex);
            }
            return bsResult;
        }
        BitSet bsCheck = this.getIterativeModels(false);
        float d2 = distance * distance;
        int iModel = this.modelCount;
        while (--iModel >= 0) {
            if (!bsCheck.get(iModel)) continue;
            AtomIndexIterator iterWithin = this.getWithinModelIterator(iModel, coord, distance);
            while (iterWithin.hasNext()) {
                int iAtom = iterWithin.next();
                if (iAtom < 0 || !(iterWithin.foundDistance2() <= d2)) continue;
                bsResult.set(iAtom);
            }
        }
        return bsResult;
    }

    public BitSet getSequenceBits(String specInfo, BitSet bs) {
        String sequence = "";
        int lenInfo = specInfo.length();
        BitSet bsResult = new BitSet();
        if (lenInfo == 0) {
            return bsResult;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            int polymerCount = this.getBioPolymerCountInModel(i);
            block1: for (int ip = 0; ip < polymerCount; ++ip) {
                sequence = this.models[i].getBioPolymer(ip).getSequence();
                int j = -1;
                while (true) {
                    ++j;
                    if ((j = sequence.indexOf(specInfo, j)) < 0) continue block1;
                    this.models[i].getBioPolymer(ip).getPolymerSequenceAtoms(i, ip, j, lenInfo, bs, bsResult);
                }
            }
        }
        return bsResult;
    }

    protected int[] makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB, BitSet bsBonds, boolean isBonds) {
        boolean matchAny = order == 16383;
        boolean matchHbond = order == 2048;
        boolean matchNull = order == Short.MAX_VALUE;
        boolean identifyOnly = false;
        boolean modifyOnly = false;
        boolean createOnly = false;
        boolean autoAromatize = false;
        float minDistanceSquared = minDistance * minDistance;
        float maxDistanceSquared = maxDistance * maxDistance;
        switch (connectOperation) {
            case 0: {
                return this.deleteConnections(minDistance, maxDistance, order, bsA, bsB, isBonds, matchNull, minDistanceSquared, maxDistanceSquared);
            }
            case 4: {
                if (order != 515) {
                    return this.autoBond(order, bsA, bsB, bsBonds, isBonds, matchHbond);
                }
                modifyOnly = true;
                autoAromatize = true;
                break;
            }
            case 5: {
                identifyOnly = true;
                break;
            }
            case 1: {
                modifyOnly = true;
                break;
            }
            case 2: {
                createOnly = true;
            }
        }
        if (matchNull) {
            order = 1;
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        short mad = this.getDefaultMadFromOrder(order);
        int nNew = 0;
        int nModified = 0;
        Bond bondAB = null;
        int n = isBonds ? this.bondCount : this.atomCount;
        int m = isBonds ? 1 : this.atomCount;
        Atom atomA = null;
        Atom atomB = null;
        short newOrder = (short)(order | Short.MIN_VALUE);
        int iA = n;
        while (--iA >= 0) {
            if (!bsA.get(iA)) continue;
            if (isBonds) {
                bondAB = this.bonds[iA];
                atomA = bondAB.atom1;
                atomB = bondAB.atom2;
            } else {
                atomA = this.atoms[iA];
            }
            int iB = m;
            while (--iB >= 0) {
                float distanceSquared;
                if (!isBonds) {
                    if (iB == iA || !bsB.get(iB)) continue;
                    atomB = this.atoms[iB];
                    if (atomA.modelIndex != atomB.modelIndex || atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != '\u0000' && atomB.alternateLocationID != '\u0000') continue;
                    bondAB = atomA.getBond(atomB);
                }
                if (bondAB == null && (identifyOnly || modifyOnly) || bondAB != null && createOnly || (distanceSquared = atomA.distanceSquared(atomB)) < minDistanceSquared || distanceSquared > maxDistanceSquared) continue;
                if (bondAB != null) {
                    if (!identifyOnly && !matchAny) {
                        bondAB.setOrder(order);
                        this.bsAromatic.clear(bondAB.index);
                    }
                    if (identifyOnly && !matchAny && order != bondAB.order && newOrder != bondAB.order && (!matchHbond || !bondAB.isHydrogen())) continue;
                    bsBonds.set(bondAB.index);
                    ++nModified;
                    continue;
                }
                bsBonds.set(this.bondAtoms((Atom)atomA, (Atom)atomB, (short)order, (short)mad, (BitSet)bsBonds).index);
                ++nNew;
            }
        }
        if (autoAromatize) {
            this.assignAromaticBonds(true, bsBonds);
        }
        if (!identifyOnly) {
            ((ModelSet)this).setShapeSize(1, Integer.MIN_VALUE, Float.NaN, bsBonds);
        }
        return new int[]{nNew, nModified};
    }

    public int autoBond(BitSet bsA, BitSet bsB, BitSet bsExclude, BitSet bsBonds) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float bondTolerance = this.viewer.getBondTolerance();
        float minBondDistance = this.viewer.getMinBondDistance();
        float minBondDistance2 = minBondDistance * minBondDistance;
        short mad = this.viewer.getMadBond();
        int nNew = 0;
        this.initializeBspf();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        short lastModelIndex = -1;
        int i = this.atomCount;
        while (--i >= 0) {
            float myBondingRadius;
            boolean isAtomInSetB;
            boolean isAtomInSetA = bsA == null || bsA.get(i);
            boolean bl = isAtomInSetB = bsB == null || bsB.get(i);
            if (!isAtomInSetA && !isAtomInSetB) continue;
            Atom atom = this.atoms[i];
            short modelIndex = atom.modelIndex;
            if (modelIndex != lastModelIndex) {
                lastModelIndex = modelIndex;
                if (this.isJmolDataFrame(modelIndex)) {
                    while (--i >= 0 && this.atoms[i].modelIndex == modelIndex) {
                    }
                    ++i;
                    continue;
                }
            }
            if ((myBondingRadius = atom.getBondingRadiusFloat()) == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + bondTolerance;
            this.initializeBspt(modelIndex);
            CubeIterator iter = this.bspf.getCubeIterator(modelIndex);
            iter.initializeHemisphere(atom, searchRadius);
            while (iter.hasMoreElements()) {
                short order;
                boolean isNearInSetB;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom) continue;
                int atomIndexNear = atomNear.atomIndex;
                boolean isNearInSetA = bsA == null || bsA.get(atomIndexNear);
                boolean bl2 = isNearInSetB = bsB == null || bsB.get(atomIndexNear);
                if (!isNearInSetA && !isNearInSetB || bsExclude != null && bsExclude.get(atomIndexNear) && bsExclude.get(i) || (!isAtomInSetA || !isNearInSetB) && (!isAtomInSetB || !isNearInSetA) || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2(), minBondDistance2, bondTolerance)) <= 0 || !this.checkValencesAndBond(atom, atomNear, order, mad, bsBonds)) continue;
                ++nNew;
            }
            iter.release();
        }
        if (Logger.debugging) {
            Logger.checkTimer("Time to autoBond");
        }
        return nNew;
    }

    private int[] autoBond(short order, BitSet bsA, BitSet bsB, BitSet bsBonds, boolean isBonds, boolean matchHbond) {
        if (isBonds) {
            BitSet bs = bsA;
            bsA = new BitSet();
            bsB = new BitSet();
            int i = this.bondCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                bsA.set(this.bonds[i].atom1.atomIndex);
                bsB.set(this.bonds[i].atom2.atomIndex);
            }
        }
        if (matchHbond) {
            this.initializeBspf();
            return new int[]{this.autoHbond(bsA, bsB, bsBonds, 0.0f, 0.0f), 0};
        }
        return new int[]{this.autoBond(bsA, bsB, null, bsBonds), 0};
    }

    private static boolean checkMinAttachedAngle(Atom atom1, Atom atom2, float minAngle, Vector3f v1, Vector3f v2) {
        v1.sub(atom1, atom2);
        return ModelCollection.checkMinAttachedAngle(atom1, atom1.getBonds(), atom2, minAngle, v1, v2) && ModelCollection.checkMinAttachedAngle(atom2, atom2.getBonds(), atom1, minAngle, v1, v2);
    }

    private static boolean checkMinAttachedAngle(Atom atom1, Bond[] bonds1, Atom atom2, float minAngle, Vector3f v1, Vector3f v2) {
        if (bonds1 != null) {
            int i = bonds1.length;
            while (--i >= 0) {
                if (!bonds1[i].isCovalent()) continue;
                v2.sub(atom1, bonds1[i].getOtherAtom(atom1));
                if (!(v2.angle(v1) < minAngle)) continue;
                return false;
            }
        }
        v1.scale(-1.0f);
        return true;
    }

    protected int autoHbond(BitSet bsA, BitSet bsB, BitSet bsBonds, float maxXYDistance, float minAttachedAngle) {
        if (maxXYDistance <= 0.0f) {
            maxXYDistance = defaultHbondMax;
        }
        float hbondMax2 = maxXYDistance * maxXYDistance;
        float hbondMin2 = hbondMin * hbondMin;
        int nNew = 0;
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        short modelLast = -1;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            short elementNumber = atom.getElementNumber();
            if (elementNumber != 7 && elementNumber != 8) continue;
            if (atom.modelIndex != modelLast) {
                modelLast = atom.modelIndex;
                this.initializeBspt(modelLast);
            }
            CubeIterator iter = this.bspf.getCubeIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, maxXYDistance);
            while (iter.hasMoreElements()) {
                Atom atomNear = (Atom)iter.nextElement();
                short elementNumberNear = atomNear.getElementNumber();
                if (elementNumberNear != 7 && elementNumberNear != 8 || atomNear == atom || iter.foundDistance2() < hbondMin2 || iter.foundDistance2() > hbondMax2 || atom.isBonded(atomNear) || minAttachedAngle > 0.0f && !ModelCollection.checkMinAttachedAngle(atom, atomNear, minAttachedAngle, v1, v2)) continue;
                this.getOrAddBond(atom, atomNear, (short)2048, (short)1, this.bsPseudoHBonds);
                ++nNew;
            }
            iter.release();
        }
        ((ModelSet)this).setShapeSize(1, Integer.MIN_VALUE, Float.NaN, this.bsPseudoHBonds);
        if (Logger.debugging) {
            Logger.checkTimer("Time to hbond");
        }
        return nNew;
    }

    void setStructureIds() {
        int idnew = 0;
        int lastid = -1;
        int imodel = -1;
        int lastmodel = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            int id;
            int n = this.atoms[i].modelIndex;
            imodel = n;
            if (n != lastmodel) {
                idnew = 0;
                lastmodel = imodel;
                lastid = -1;
            }
            if ((id = this.atoms[i].getProteinStructureID()) == lastid || id == 0) continue;
            this.atoms[i].getGroup().setProteinStructureId(++idnew);
            lastid = idnew;
        }
    }

    public String getProteinStructureState(BitSet bsAtoms, boolean taintedOnly, boolean needPhiPsi) {
        int i;
        BitSet bs = null;
        StringBuffer cmd = new StringBuffer();
        StringBuffer sbTurn = new StringBuffer();
        StringBuffer sbHelix = new StringBuffer();
        StringBuffer sbSheet = new StringBuffer();
        int itype = 0;
        int id = 0;
        int iLastAtom = 0;
        int lastId = -1;
        int res1 = 0;
        int res2 = 0;
        String group1 = "";
        String group2 = "";
        String chain1 = "";
        String chain2 = "";
        int n = 0;
        int nHelix = 0;
        int nTurn = 0;
        int nSheet = 0;
        BitSet bsTainted = null;
        if (taintedOnly) {
            if (!this.proteinStructureTainted) {
                return "";
            }
            bsTainted = new BitSet();
            for (i = 0; i < this.atomCount; ++i) {
                if (!this.models[this.atoms[i].modelIndex].isStructureTainted()) continue;
                bsTainted.set(i);
            }
            bsTainted.set(this.atomCount);
        }
        for (i = 0; i <= this.atomCount; ++i) {
            char ch;
            if (i != this.atomCount && bsAtoms != null && !bsAtoms.get(i) || taintedOnly && !bsTainted.get(i)) continue;
            id = 0;
            if (i == this.atomCount || (id = this.atoms[i].getProteinStructureID()) != lastId) {
                if (bs != null) {
                    if (itype == 3 || itype == 1 || itype == 2) {
                        ++n;
                        if (bsAtoms == null) {
                            short iModel = this.atoms[iLastAtom].modelIndex;
                            cmd.append("  structure ").append(JmolConstants.getProteinStructureName(itype)).append(" ").append(Escape.escape(bs)).append("    \t# model=").append(this.getModelNumberDotted(iModel)).append(" & (").append(res1).append(" - ").append(res2).append(");\n");
                        } else {
                            StringBuffer sb;
                            String str;
                            String sid;
                            int nx;
                            switch (itype) {
                                case 3: {
                                    nx = ++nHelix;
                                    sid = "H" + nx;
                                    str = "HELIX  %3N %3ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB\n";
                                    sb = sbHelix;
                                    break;
                                }
                                case 2: {
                                    nx = ++nSheet;
                                    sid = "S" + nx;
                                    str = "SHEET  %3N %3ID 2 %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB\n";
                                    sb = sbSheet;
                                    break;
                                }
                                default: {
                                    nx = ++nTurn;
                                    sid = "T" + nx;
                                    str = "TURN   %3N %3ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB\n";
                                    sb = sbTurn;
                                }
                            }
                            str = TextFormat.formatString(str, "N", nx);
                            str = TextFormat.formatString(str, "ID", sid);
                            str = TextFormat.formatString(str, "GROUPA", group1);
                            str = TextFormat.formatString(str, "CA", chain1);
                            str = TextFormat.formatString(str, "RESA", res1);
                            str = TextFormat.formatString(str, "GROUPB", group2);
                            str = TextFormat.formatString(str, "CB", chain2);
                            str = TextFormat.formatString(str, "RESB", res2);
                            sb.append(str);
                        }
                    }
                    bs = null;
                }
                if (id == 0 || bsAtoms != null && needPhiPsi && (Float.isNaN(this.atoms[i].getGroupPhi()) || Float.isNaN(this.atoms[i].getGroupPsi()))) continue;
            }
            if ((ch = this.atoms[i].getChainID()) == '\u0000') {
                ch = ' ';
            }
            if (bs == null) {
                bs = new BitSet();
                res1 = this.atoms[i].getResno();
                group1 = this.atoms[i].getGroup3(false);
                chain1 = "" + ch;
            }
            itype = this.atoms[i].getProteinStructureType();
            bs.set(i);
            lastId = id;
            res2 = this.atoms[i].getResno();
            group2 = this.atoms[i].getGroup3(false);
            chain2 = "" + ch;
            iLastAtom = i;
        }
        if (n > 0) {
            cmd.append("\n");
        }
        return bsAtoms == null ? cmd.toString() : sbHelix.append(sbSheet).append(sbTurn).append(cmd).toString();
    }

    public String getModelInfoAsString() {
        StringBuffer sb = new StringBuffer("model count = ");
        sb.append(this.modelCount).append("\nmodelSetHasVibrationVectors:").append(this.modelSetHasVibrationVectors());
        if (this.modelSetProperties == null) {
            sb.append("\nProperties: null");
        } else {
            Enumeration<?> e = this.modelSetProperties.propertyNames();
            sb.append("\nProperties:");
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                sb.append("\n ").append(propertyName).append("=").append(this.modelSetProperties.getProperty(propertyName));
            }
        }
        for (int i = 0; i < this.modelCount; ++i) {
            sb.append("\n").append(i).append(":").append(this.getModelNumberDotted(i)).append(":").append(this.getModelName(i)).append(":").append(this.getModelTitle(i)).append("\nmodelHasVibrationVectors:").append(this.modelHasVibrationVectors(i));
        }
        return sb.toString();
    }

    public String getSymmetryInfoAsString() {
        StringBuffer sb = new StringBuffer("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            sb.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsString(i));
        }
        return sb.toString();
    }

    public BitSet getAtomsConnected(float min, float max, int intType, BitSet bs) {
        int i;
        BitSet bsResult = new BitSet();
        int[] nBonded = new int[this.atomCount];
        boolean ishbond = intType == 30720;
        boolean isall = intType == 16383;
        for (int ibond = 0; ibond < this.bondCount; ++ibond) {
            Bond bond = this.bonds[ibond];
            if (!isall && !bond.is(intType) && (!ishbond || !bond.isHydrogen())) continue;
            if (bs.get(bond.atom1.atomIndex)) {
                i = bond.atom2.atomIndex;
                nBonded[i] = nBonded[i] + 1;
                bsResult.set(i);
            }
            if (!bs.get(bond.atom2.atomIndex)) continue;
            i = bond.atom1.atomIndex;
            nBonded[i] = nBonded[i] + 1;
            bsResult.set(i);
        }
        boolean nonbonded = min == 0.0f && max == 0.0f;
        i = this.atomCount;
        while (--i >= 0) {
            int n = nBonded[i];
            if ((float)n < min || (float)n > max) {
                bsResult.clear(i);
                continue;
            }
            if (!nonbonded || n != 0) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    public String getModelExtract(BitSet bs) {
        int i;
        int nAtoms = 0;
        int nBonds = 0;
        int[] atomMap = new int[this.atomCount];
        StringBuffer mol = new StringBuffer();
        StringBuffer s = new StringBuffer();
        for (i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            atomMap[i] = ++nAtoms;
            this.getAtomRecordMOL(s, i);
        }
        for (i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (!bs.get(bond.atom1.atomIndex) || !bs.get(bond.atom2.atomIndex) || bond.isHydrogen()) continue;
            this.getBondRecordMOL(s, i, atomMap);
            ++nBonds;
        }
        if (nAtoms > 999 || nBonds > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        TextFormat.rFill(mol, "   ", "" + nAtoms);
        TextFormat.rFill(mol, "   ", "" + nBonds);
        mol.append("  0  0  0\n");
        mol.append(s);
        return mol.toString();
    }

    private void getAtomRecordMOL(StringBuffer s, int i) {
        TextFormat.rFill(s, "          ", TextFormat.safeTruncate(this.getAtomX(i), 9));
        TextFormat.rFill(s, "          ", TextFormat.safeTruncate(this.getAtomY(i), 9));
        TextFormat.rFill(s, "          ", TextFormat.safeTruncate(this.getAtomZ(i), 9));
        s.append(" ").append((this.getElementSymbol(i) + "  ").substring(0, 2)).append("\n");
    }

    private void getBondRecordMOL(StringBuffer s, int i, int[] atomMap) {
        Bond b = this.bonds[i];
        TextFormat.rFill(s, "   ", "" + atomMap[b.atom1.atomIndex]);
        TextFormat.rFill(s, "   ", "" + atomMap[b.atom2.atomIndex]);
        int order = b.getValence();
        if (order > 3) {
            order = 1;
        }
        switch (b.order & Short.MAX_VALUE) {
            case 515: {
                order = 4;
                break;
            }
            case 66: {
                order = 5;
                break;
            }
            case 513: {
                order = 6;
                break;
            }
            case 514: {
                order = 7;
            }
        }
        s.append("  ").append(order).append("\n");
    }

    public String getChimeInfo(int tok, BitSet bs) {
        if (tok != 1073741946) {
            return super.getChimeInfo(tok, bs);
        }
        int n = 0;
        StringBuffer sb = new StringBuffer();
        int nHetero = 0;
        if (this.models[0].isPDB) {
            sb.append("\nMolecule name ....... " + this.getModelSetAuxiliaryInfo("COMPND"));
            sb.append("\nSecondary Structure . PDB Data Records");
            sb.append("\nBrookhaven Code ..... " + this.modelSetName);
            int i = this.modelCount;
            while (--i >= 0) {
                n += this.models[i].getChainCount(false);
            }
            sb.append("\nNumber of Chains .... " + n);
            n = 0;
            i = this.modelCount;
            while (--i >= 0) {
                n += this.models[i].getGroupCount(false);
            }
            nHetero = 0;
            i = this.modelCount;
            while (--i >= 0) {
                nHetero += this.models[i].getGroupCount(true);
            }
            sb.append("\nNumber of Groups .... " + n);
            if (nHetero > 0) {
                sb.append(" (" + nHetero + ")");
            }
            i = this.atomCount;
            while (--i >= 0) {
                if (!this.atoms[i].isHetero()) continue;
                ++nHetero;
            }
        }
        sb.append("\nNumber of Atoms ..... " + (this.atomCount - nHetero));
        if (nHetero > 0) {
            sb.append(" (" + nHetero + ")");
        }
        sb.append("\nNumber of Bonds ..... " + this.bondCount);
        sb.append("\nNumber of Models ...... " + this.modelCount);
        if (this.models[0].isPDB) {
            int nH = 0;
            int nS = 0;
            int nT = 0;
            if (this.structures != null) {
                int i = this.structureCount;
                while (--i >= 0) {
                    switch (this.structures[i].type) {
                        case 3: {
                            ++nH;
                            break;
                        }
                        case 2: {
                            ++nS;
                            break;
                        }
                        case 1: {
                            ++nT;
                        }
                    }
                }
            }
            sb.append("\nNumber of Helices ... " + nH);
            sb.append("\nNumber of Strands ... " + nS);
            sb.append("\nNumber of Turns ..... " + nT);
        }
        return sb.append('\n').toString().substring(1);
    }

    public String getModelFileInfo(BitSet frames) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (frames != null && !frames.get(i)) continue;
            String file_model = this.getModelNumberDotted(i);
            sb.append("\n\nfile[\"").append(file_model).append("\"] = ").append(Escape.escape(this.getModelFileName(i))).append("\ntitle[\"").append(file_model).append("\"] = ").append(Escape.escape(this.getModelTitle(i))).append("\nname[\"").append(file_model).append("\"] = ").append(Escape.escape(this.getModelName(i)));
        }
        return sb.toString();
    }

    public Hashtable getAuxiliaryInfo(BitSet bsModels) {
        Hashtable info = this.getModelSetAuxiliaryInfo();
        if (info == null) {
            return info;
        }
        Vector<Hashtable> models = new Vector<Hashtable>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bsModels != null && !bsModels.get(i)) continue;
            Hashtable modelinfo = this.getModelAuxiliaryInfo(i);
            models.addElement(modelinfo);
        }
        info.put("models", models);
        return info;
    }

    public Vector getAllAtomInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            V.addElement(this.getAtomInfoLong(i));
        }
        return V;
    }

    public void getAtomIdentityInfo(int i, Hashtable info) {
        info.put("_ipt", new Integer(i));
        info.put("atomIndex", new Integer(i));
        info.put("atomno", new Integer(this.getAtomNumber(i)));
        info.put("info", this.getAtomInfo(i, null));
        info.put("sym", this.getElementSymbol(i));
    }

    private Hashtable getAtomInfoLong(int i) {
        Atom atom = this.atoms[i];
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(i, info);
        info.put("element", this.getElementName(i));
        info.put("elemno", new Integer(this.getElementNumber(i)));
        info.put("x", new Float(this.getAtomX(i)));
        info.put("y", new Float(this.getAtomY(i)));
        info.put("z", new Float(this.getAtomZ(i)));
        info.put("coord", new Point3f(atom));
        if (this.vibrationVectors != null && this.vibrationVectors[i] != null) {
            info.put("vibVector", new Vector3f(this.vibrationVectors[i]));
        }
        info.put("bondCount", new Integer(atom.getCovalentBondCount()));
        info.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        info.put("model", atom.getModelNumberForLabel());
        info.put("visible", this.atoms[i].isVisible());
        info.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        info.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        info.put("spacefill", new Float(atom.getRadius()));
        String strColor = this.viewer.getHexColorFromIndex(atom.colixAtom);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(atom.colixAtom));
        boolean isTranslucent = atom.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", isTranslucent);
        }
        info.put("formalCharge", new Integer(atom.getFormalCharge()));
        info.put("partialCharge", new Float(atom.getPartialCharge()));
        float d = (float)atom.getSurfaceDistance100() / 100.0f;
        if (d >= 0.0f) {
            info.put("surfaceDistance", new Float(d));
        }
        if (this.getModel((int)atom.modelIndex).isPDB) {
            info.put("resname", atom.getGroup3(false));
            int seqNum = atom.getSeqNumber();
            char insCode = atom.getInsertionCode();
            if (seqNum > 0) {
                info.put("resno", new Integer(seqNum));
            }
            if (insCode != '\u0000') {
                info.put("insertionCode", "" + insCode);
            }
            char chainID = atom.getChainID();
            info.put("name", this.getAtomName(i));
            info.put("chain", chainID == '\u0000' ? "" : "" + chainID);
            info.put("atomID", new Integer(atom.getSpecialAtomID()));
            info.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != '\u0000') {
                info.put("altLocation", "" + atom.alternateLocationID);
            }
            info.put("structure", new Integer(atom.getProteinStructureType()));
            info.put("polymerLength", new Integer(atom.getPolymerLength()));
            info.put("occupancy", new Integer(atom.getOccupancy100()));
            int temp = atom.getBfactor100();
            info.put("temp", new Integer(temp / 100));
        }
        return info;
    }

    public Vector getAllBondInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        int thisAtom = BitSetUtil.cardinalityOf(bs) == 1 ? BitSetUtil.firstSetBit(bs) : -1;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!(thisAtom >= 0 ? this.bonds[i].atom1.atomIndex == thisAtom || this.bonds[i].atom2.atomIndex == thisAtom : bs.get(this.bonds[i].atom1.atomIndex) && bs.get(this.bonds[i].atom2.atomIndex))) continue;
            V.addElement(this.getBondInfo(i));
        }
        return V;
    }

    private Hashtable getBondInfo(int i) {
        Bond bond = this.bonds[i];
        Atom atom1 = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("_bpt", new Integer(i));
        Hashtable infoA = new Hashtable();
        this.getAtomIdentityInfo(atom1.atomIndex, infoA);
        Hashtable infoB = new Hashtable();
        this.getAtomIdentityInfo(atom2.atomIndex, infoB);
        info.put("atom1", infoA);
        info.put("atom2", infoB);
        info.put("order", new Float(JmolConstants.getBondOrderNumberFromOrder(this.bonds[i].order)));
        info.put("radius", new Float((double)bond.mad / 2000.0));
        info.put("length_Ang", new Float(atom1.distance(atom2)));
        info.put("visible", bond.shapeVisibilityFlags != 0);
        String strColor = this.viewer.getHexColorFromIndex(bond.colix);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(bond.colix));
        boolean isTranslucent = bond.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", isTranslucent);
        }
        return info;
    }

    public Hashtable getAllChainInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector info = this.getChainInfo(i, bs);
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("chains", info);
            modelVector.addElement(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    private Vector getChainInfo(int modelIndex, BitSet bs) {
        Model model = this.models[modelIndex];
        int nChains = model.getChainCount(true);
        Vector infoChains = new Vector();
        for (int i = 0; i < nChains; ++i) {
            Chain chain = model.getChain(i);
            Vector infoChain = new Vector();
            int nGroups = chain.getGroupCount();
            Hashtable arrayName = new Hashtable();
            for (int igroup = 0; igroup < nGroups; ++igroup) {
                Group group = chain.getGroup(igroup);
                if (!bs.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> infoGroup = new Hashtable<String, Object>();
                infoGroup.put("groupIndex", new Integer(igroup));
                infoGroup.put("groupID", new Short(group.getGroupID()));
                String s = group.getSeqcodeString();
                if (s != null) {
                    infoGroup.put("seqCode", s);
                }
                infoGroup.put("_apt1", new Integer(group.firstAtomIndex));
                infoGroup.put("_apt2", new Integer(group.lastAtomIndex));
                infoGroup.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex, null));
                infoGroup.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex, null));
                infoGroup.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                infoChain.addElement(infoGroup);
            }
            if (infoChain.isEmpty()) continue;
            arrayName.put("residues", infoChain);
            infoChains.addElement(arrayName);
        }
        return infoChains;
    }

    public Hashtable getAllPolymerInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector<Hashtable> info = new Vector<Hashtable>();
            int polymerCount = this.models[i].getBioPolymerCount();
            for (int ip = 0; ip < polymerCount; ++ip) {
                Hashtable polyInfo = this.models[i].getBioPolymer(ip).getPolymerInfo(bs);
                if (polyInfo.isEmpty()) continue;
                info.addElement(polyInfo);
            }
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("polymers", info);
            modelVector.addElement(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    public String getUnitCellInfoText() {
        int modelIndex = this.viewer.getCurrentModelIndex();
        if (modelIndex < 0) {
            return "no single current model";
        }
        if (this.unitCells == null) {
            return "not applicable";
        }
        return this.unitCells[modelIndex].getUnitCellInfo();
    }

    public String getSpaceGroupInfoText(String spaceGroup) {
        String info;
        String strOperations = "";
        float[] unitCell = null;
        if (spaceGroup == null) {
            int modelIndex = this.viewer.getCurrentModelIndex();
            if (modelIndex < 0) {
                return "no single current model";
            }
            if (this.unitCells == null) {
                return "not applicable";
            }
            SymmetryInterface cellInfo = this.unitCells[modelIndex];
            spaceGroup = cellInfo.getSpaceGroupName();
            unitCell = cellInfo.getNotionalUnitCell();
            strOperations = this.getModelSymmetryList(modelIndex);
        }
        if (this.symTemp == null) {
            this.symTemp = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return (info = this.symTemp.getSpaceGroupInfo(spaceGroup, unitCell)) == null ? "could not identify space group from name: " + spaceGroup + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"" : info + strOperations;
    }

    protected void deleteModel(int modelIndex, int firstAtomIndex, int nAtoms, BitSet bsAtoms, BitSet bsBonds) {
        int i;
        if (modelIndex < 0) {
            this.bspf = null;
            this.bsAll = null;
            this.molecules = null;
            this.withinModelIterator = null;
            this.withinAtomSetIterator = null;
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null);
            return;
        }
        this.modelNumbers = (int[])ArrayUtil.deleteElements(this.modelNumbers, modelIndex, 1);
        this.modelFileNumbers = (int[])ArrayUtil.deleteElements(this.modelFileNumbers, modelIndex, 1);
        this.modelNumbersForAtomLabel = (String[])ArrayUtil.deleteElements(this.modelNumbersForAtomLabel, modelIndex, 1);
        this.modelNames = (String[])ArrayUtil.deleteElements(this.modelNames, modelIndex, 1);
        this.frameTitles = (String[])ArrayUtil.deleteElements(this.frameTitles, modelIndex, 1);
        this.thisStateModel = -1;
        int nDeleted = 0;
        int i2 = this.structureCount;
        while (--i2 >= 0) {
            if (this.structures[i2].modelIndex > modelIndex) {
                --this.structures[i2].modelIndex;
                continue;
            }
            if (this.structures[i2].modelIndex != modelIndex) break;
            this.structures = (Structure[])ArrayUtil.deleteElements(this.structures, i2, 1);
            ++nDeleted;
        }
        this.structureCount -= nDeleted;
        String[] group3Lists = (String[])this.getModelSetAuxiliaryInfo("group3Lists");
        int[][] group3Counts = (int[][])this.getModelSetAuxiliaryInfo("group3Counts");
        int ptm = modelIndex + 1;
        if (group3Lists != null && group3Lists[ptm] != null) {
            i = group3Lists[ptm].length() / 6;
            while (--i >= 0) {
                if (group3Counts[ptm][i] <= 0) continue;
                int[] nArray = group3Counts[0];
                int n = i;
                nArray[n] = nArray[n] - group3Counts[ptm][i];
                if (group3Counts[0][i] != 0) continue;
                group3Lists[0] = group3Lists[0].substring(0, i * 6) + ",[" + group3Lists[0].substring(i * 6 + 2);
            }
        }
        if (group3Lists != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", ArrayUtil.deleteElements(group3Lists, modelIndex, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", ArrayUtil.deleteElements(group3Counts, modelIndex, 1));
        }
        if (this.unitCells != null) {
            i = this.modelCount;
            while (--i > modelIndex) {
                this.unitCells[i].setModelIndex(this.unitCells[i].getModelIndex() - 1);
            }
            this.unitCells = (SymmetryInterface[])ArrayUtil.deleteElements(this.unitCells, modelIndex, 1);
        }
        i = this.stateScripts.size();
        while (--i >= 0) {
            if (((StateScript)this.stateScripts.get(i)).deleteAtoms(modelIndex, bsBonds, bsAtoms)) continue;
            this.stateScripts.removeElementAt(i);
        }
        this.deleteModelAtoms(firstAtomIndex, nAtoms, bsAtoms);
        this.viewer.deleteModelAtoms(firstAtomIndex, nAtoms, bsAtoms);
    }

    public Point3f[] getFrameOffsets(BitSet bsAtoms) {
        if (bsAtoms == null) {
            return null;
        }
        Point3f[] offsets = new Point3f[this.modelCount];
        for (int i = 0; i < this.modelCount; ++i) {
            offsets[i] = new Point3f();
        }
        short lastModel = 0;
        int n = 0;
        Point3f offset = offsets[0];
        for (int i = 0; i <= this.atomCount; ++i) {
            if (i == this.atomCount || this.atoms[i].modelIndex != lastModel) {
                if (n > 0) {
                    offset.scale(-1.0f / (float)n);
                    if (lastModel != 0) {
                        offset.sub(offsets[0]);
                    }
                    n = 0;
                }
                if (i == this.atomCount) break;
                lastModel = this.atoms[i].modelIndex;
                offset = offsets[lastModel];
            }
            if (!bsAtoms.get(i)) continue;
            offset.add(this.atoms[i]);
            ++n;
        }
        offsets[0].set(0.0f, 0.0f, 0.0f);
        return offsets;
    }

    public String getMoInfo(int modelIndex) {
        StringBuffer sb = new StringBuffer();
        for (int m = 0; m < this.modelCount; ++m) {
            int nOrb;
            Hashtable moData;
            if (modelIndex >= 0 && m != modelIndex || (moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(m, "moData")) == null) continue;
            Vector mos = (Vector)moData.get("mos");
            int n = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) continue;
            int i = nOrb;
            while (--i >= 0) {
                Float occ;
                String units;
                Hashtable mo = (Hashtable)mos.get(i);
                String type = (String)mo.get("type");
                if (type == null) {
                    type = "";
                }
                if ((units = (String)mo.get("energyUnits")) == null) {
                    units = "";
                }
                if ((occ = (Float)mo.get("occupancy")) != null) {
                    type = "occupancy " + occ.floatValue() + " " + type;
                }
                sb.append(TextFormat.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", new Object[]{this.getModelNumberDotted(m), new Integer(i + 1), mo.get("energy"), units, type}));
            }
        }
        return sb.toString();
    }

    private static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;

        Structure(int modelIndex, String typeName, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
            this.modelIndex = modelIndex;
            this.typeName = typeName;
            this.startChainID = startChainID;
            this.startSeqcode = startSeqcode;
            this.endChainID = endChainID;
            this.endSeqcode = endSeqcode;
            this.type = "helix".equals(typeName) ? (byte)3 : ("sheet".equals(typeName) ? (byte)2 : ("turn".equals(typeName) ? (byte)1 : 0));
        }
    }

    protected static class StateScript {
        int modelIndex;
        BitSet bsBonds;
        BitSet bsAtoms1;
        BitSet bsAtoms2;
        String script1;
        String script2;
        boolean postDefinitions;

        StateScript(int modelIndex, String script1, BitSet bsBonds, BitSet bsAtoms1, BitSet bsAtoms2, String script2, boolean postDefinitions) {
            this.modelIndex = modelIndex;
            this.script1 = script1;
            this.bsBonds = bsBonds;
            this.bsAtoms1 = bsAtoms1;
            this.bsAtoms2 = bsAtoms2;
            this.script2 = script2;
            this.postDefinitions = postDefinitions;
        }

        public boolean isValid() {
            return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && BitSetUtil.firstSetBit(this.bsBonds) < 0 || this.bsAtoms1 != null && BitSetUtil.firstSetBit(this.bsAtoms1) < 0 || this.bsAtoms2 != null && BitSetUtil.firstSetBit(this.bsAtoms2) < 0);
        }

        public String toString() {
            String s;
            if (!this.isValid()) {
                return "";
            }
            StringBuffer sb = new StringBuffer(this.script1);
            if (this.bsBonds != null) {
                sb.append(" ").append(Escape.escape(this.bsBonds, false));
            }
            if (this.bsAtoms1 != null) {
                sb.append(" ").append(Escape.escape(this.bsAtoms1));
            }
            if (this.bsAtoms2 != null) {
                sb.append(" ").append(Escape.escape(this.bsAtoms2));
            }
            if (this.script2 != null) {
                sb.append(" ").append(this.script2);
            }
            if (!(s = sb.toString()).endsWith(";")) {
                s = s + ";";
            }
            return s;
        }

        public boolean isConnect() {
            return this.script1.indexOf("connect") == 0;
        }

        public boolean deleteAtoms(int modelIndex, BitSet bsBonds, BitSet bsAtoms) {
            if (modelIndex <= this.modelIndex) {
                return this.modelIndex < modelIndex;
            }
            BitSetUtil.deleteBits(this.bsBonds, bsBonds);
            BitSetUtil.deleteBits(this.bsAtoms1, bsAtoms);
            BitSetUtil.deleteBits(this.bsAtoms2, bsAtoms);
            return this.isValid();
        }
    }
}

