/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected Shape[] shapes;
    protected final Atom[] closest = new Atom[1];
    private SymmetryInterface pointGroup;
    private static final boolean useRasMolHbondsCalculation = true;

    protected void releaseModelSet() {
        if (this.shapes != null) {
            for (int i = 0; i < 32; ++i) {
                this.shapes[i] = null;
            }
        }
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        if (this.selectionHaloEnabled != selectionHaloEnabled) {
            this.selectionHaloEnabled = selectionHaloEnabled;
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean TF) {
        this.echoShapeActive = TF;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    private Shape allocateShape(int shapeID) {
        if (shapeID == 2 || shapeID == 3) {
            return null;
        }
        String className = JmolConstants.getShapeClassName(shapeID);
        try {
            Class<?> shapeClass = Class.forName(className);
            Shape shape = (Shape)shapeClass.newInstance();
            this.viewer.setShapeErrorState(shapeID, "allocate");
            shape.initializeShape(this.viewer, this.g3d, this, shapeID);
            this.viewer.setShapeErrorState(-1, null);
            return shape;
        }
        catch (Exception e) {
            Logger.error("Could not instantiate shape:" + className, e);
            return null;
        }
    }

    public Shape getShape(int i) {
        return this.shapes[i];
    }

    public int getModelNumberIndex(int modelNumber, boolean useModelNumber, boolean doSetTrajectory) {
        if (useModelNumber) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != modelNumber) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != modelNumber) continue;
            if (doSetTrajectory && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getTrajectoryInfo() {
        String s = "";
        if (this.trajectorySteps == null) {
            return "";
        }
        int i = this.modelCount;
        while (--i >= 0) {
            if (this.models[i].selectedTrajectory < 0) continue;
            s = " or " + this.getModelNumberDotted(this.models[i].selectedTrajectory) + s;
            i = this.models[i].trajectoryBaseIndex;
        }
        if (s.length() > 0) {
            s = "set trajectory {" + s.substring(4) + "}";
        }
        return s;
    }

    public BitSet getBitSetTrajectories() {
        if (this.trajectorySteps == null) {
            return null;
        }
        BitSet bsModels = new BitSet();
        int i = this.modelCount;
        while (--i >= 0) {
            if (this.models[i].selectedTrajectory < 0) continue;
            bsModels.set(this.models[i].selectedTrajectory);
            i = this.models[i].trajectoryBaseIndex;
        }
        return bsModels;
    }

    public void setTrajectory(BitSet bsModels) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bsModels.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int modelIndex) {
        int m;
        int i;
        if (modelIndex < 0 || !this.models[modelIndex].isTrajectory) {
            return;
        }
        int iFirst = this.models[modelIndex].firstAtomIndex;
        if (this.atoms[iFirst].modelIndex == modelIndex) {
            return;
        }
        int baseModel = this.models[modelIndex].trajectoryBaseIndex;
        this.models[baseModel].selectedTrajectory = modelIndex;
        Point3f[] trajectory = (Point3f[])this.trajectorySteps.get(modelIndex);
        BitSet bs = new BitSet();
        int iMax = iFirst + this.getAtomCountInModel(modelIndex);
        int pt = 0;
        for (i = iFirst; i < iMax && pt < trajectory.length && trajectory[pt] != null; ++i) {
            this.atoms[i].setFractionalCoord(trajectory[pt++]);
            this.atoms[i].modelIndex = (short)modelIndex;
            bs.set(i);
        }
        this.initializeBspf();
        this.bspf.clearBspt(baseModel);
        this.recalculateLeadMidpointsAndWingVectors(baseModel);
        Integer Imodel = new Integer(baseModel);
        for (i = 0; i < 32; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapeProperty(i, "refreshTrajectories", Imodel, bs);
        }
        if (this.models[baseModel].hasCalculatedHBonds) {
            this.clearCalculatedHydrogenBonds(baseModel, null);
            this.models[baseModel].calcHydrogenBonds(bs, bs);
        }
        if ((m = this.viewer.getCurrentModelIndex()) >= 0 && m != modelIndex && this.models[m].fileIndex == this.models[modelIndex].fileIndex) {
            this.viewer.setCurrentModelIndex(modelIndex, false);
        }
    }

    public BitSet getAtomBits(int tokType, Object specInfo) {
        switch (tokType) {
            case 0x100022: {
                return this.getSpecModel((Integer)specInfo);
            }
        }
        return super.getAtomBits(tokType, specInfo);
    }

    public String getAtomLabel(int i) {
        return (String)this.getShapeProperty(4, "label", i);
    }

    private BitSet getSpecModel(int modelNumber) {
        int modelIndex = this.getModelNumberIndex(modelNumber, true, true);
        return modelIndex < 0 && modelNumber > 0 ? new BitSet() : this.getModelAtomBitSet(modelIndex, true);
    }

    public int findNearestAtomIndex(int x, int y) {
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        this.findNearestAtomIndex(x, y, this.closest);
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && this.closest[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(x, y, this.closest);
            }
        }
        int closestIndex = this.closest[0] == null ? -1 : this.closest[0].atomIndex;
        this.closest[0] = null;
        return closestIndex;
    }

    public void setShapeSize(int shapeID, int size, float fsize, BitSet bsSelected) {
        if (this.shapes == null) {
            return;
        }
        this.viewer.setShapeErrorState(shapeID, "set size");
        if (size != 0) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            if (Float.isNaN(fsize)) {
                this.shapes[shapeID].setSize(size, bsSelected);
            } else {
                this.shapes[shapeID].setSize(size, fsize, bsSelected);
            }
        }
        this.viewer.setShapeErrorState(-1, null);
    }

    public Shape loadShape(int shapeID) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[shapeID] == null) {
            this.shapes[shapeID] = this.allocateShape(shapeID);
        }
        return this.shapes[shapeID];
    }

    public void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bsSelected) {
        if (this.shapes == null || this.shapes[shapeID] == null) {
            return;
        }
        this.viewer.setShapeErrorState(shapeID, "set " + propertyName);
        this.shapes[shapeID].setProperty(propertyName.intern(), value, bsSelected);
        this.viewer.setShapeErrorState(-1, null);
    }

    public void releaseShape(int shapeID) {
        if (this.shapes != null) {
            this.shapes[shapeID] = null;
        }
    }

    public Object getShapeProperty(int shapeID, String propertyName, int index) {
        if (this.shapes == null || this.shapes[shapeID] == null) {
            return null;
        }
        this.viewer.setShapeErrorState(shapeID, "get " + propertyName);
        Object result = this.shapes[shapeID].getProperty(propertyName, index);
        this.viewer.setShapeErrorState(-1, null);
        return result;
    }

    public int getShapeIdFromObjectName(String objectName) {
        if (this.shapes != null) {
            for (int i = 16; i < 26; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(objectName) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void setModelVisibility() {
        int i;
        if (this.shapes == null) {
            return;
        }
        BitSet bs = this.viewer.getVisibleFramesBitSet();
        for (i = 1; i < 32; ++i) {
            if (this.shapes[i] == null) continue;
            this.shapes[i].setVisibilityFlags(bs);
        }
        this.shapes[0].setVisibilityFlags(bs);
        for (i = 0; i < 32; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void fillAtomData(AtomData atomData, int mode) {
        if (mode == 3) {
            int[] nH = new int[1];
            atomData.hAtomRadius = (float)this.viewer.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nH);
            atomData.hydrogenAtomCount = nH[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? Math.max(0, BitSetUtil.firstSetBit(atomData.bsSelected)) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, mode);
    }

    public boolean frankClicked(int x, int y) {
        Shape frankShape = this.shapes[31];
        return frankShape != null && frankShape.wasClicked(x, y);
    }

    public boolean checkObjectHovered(int x, int y, BitSet bsVisible) {
        Shape shape = this.shapes[26];
        if (shape != null && shape.checkObjectHovered(x, y, bsVisible)) {
            return true;
        }
        shape = this.shapes[22];
        if (shape != null && shape.checkObjectHovered(x, y, bsVisible)) {
            return true;
        }
        shape = this.shapes[21];
        return shape != null && this.viewer.getDrawHover() && shape.checkObjectHovered(x, y, bsVisible);
    }

    public Point3f checkObjectClicked(int x, int y, int modifiers, BitSet bsVisible) {
        Shape shape = this.shapes[26];
        Point3f pt = null;
        if (modifiers != 0 && this.viewer.getBondPicking() && (pt = this.shapes[1].checkObjectClicked(x, y, modifiers, bsVisible)) != null) {
            return pt;
        }
        if (shape != null && modifiers != 0 && (pt = shape.checkObjectClicked(x, y, modifiers, bsVisible)) != null) {
            return pt;
        }
        shape = this.shapes[21];
        return shape == null ? null : shape.checkObjectClicked(x, y, modifiers, bsVisible);
    }

    public void checkObjectDragged(int prevX, int prevY, int x, int y, int modifiers, BitSet bsVisible) {
        Shape shape;
        for (int i = 0; !(i >= 32 || (shape = this.shapes[i]) != null && shape.checkObjectDragged(prevX, prevY, x, y, modifiers, bsVisible)); ++i) {
        }
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        StringBuffer commands = new StringBuffer();
        if (this.shapes != null) {
            for (int i = 0; i < 32; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null) continue;
                String shapeType = JmolConstants.shapeClassBases[i];
                Vector shapeDetail = shape.getShapeDetail();
                if (shapeDetail == null) continue;
                Hashtable<String, Vector> shapeinfo = new Hashtable<String, Vector>();
                shapeinfo.put("obj", shapeDetail);
                info.put(shapeType, shapeinfo);
            }
        }
        if (commands.length() > 0) {
            info.put("shapeCommands", commands.toString());
        }
        return info;
    }

    public void calculateStructures(BitSet bsAtoms) {
        int i;
        BitSet bsAllAtoms = new BitSet();
        BitSet bsDefined = BitSetUtil.invertInPlace(this.modelsOf(bsAtoms, bsAllAtoms), this.modelCount);
        for (i = 0; i < this.modelCount; ++i) {
            if (bsDefined.get(i)) continue;
            this.addBioPolymerToModel(null, this.models[i]);
        }
        this.calculatePolymers(bsDefined);
        this.calculateStructuresAllExcept(bsDefined, false);
        if (this.shapes != null) {
            for (i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
                this.shapes[i].setSize(0, bsAllAtoms);
                this.shapes[i].setProperty("color", new Byte(1), bsAllAtoms);
            }
        }
        this.setStructureIds();
    }

    public String calculatePointGroup(BitSet bsAtoms) {
        return (String)this.calculatePointGroupForFirstModel(bsAtoms, false, false, false, null, 0, 0.0f);
    }

    public Hashtable getPointGroupInfo(BitSet bsAtoms) {
        return (Hashtable)this.calculatePointGroupForFirstModel(bsAtoms, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BitSet bsAtoms, boolean asDraw, String type, int index, float scale) {
        return (String)this.calculatePointGroupForFirstModel(bsAtoms, true, asDraw, false, type, index, scale);
    }

    private Object calculatePointGroupForFirstModel(BitSet bsAtoms, boolean doAll, boolean asDraw, boolean asInfo, String type, int index, float scale) {
        Object obj;
        int modelIndex = this.viewer.getCurrentModelIndex();
        int iAtom = BitSetUtil.firstSetBit(bsAtoms);
        if (modelIndex < 0 && iAtom >= 0) {
            modelIndex = this.atoms[iAtom].getModelIndex();
        }
        if (modelIndex < 0) {
            modelIndex = BitSetUtil.firstSetBit(this.viewer.getVisibleFramesBitSet());
            bsAtoms = null;
        }
        BitSet bs = this.getModelAtomBitSet(modelIndex, true);
        if (bsAtoms != null) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.atoms[i].modelIndex != modelIndex || bsAtoms.get(i)) continue;
                bs.clear(i);
            }
        }
        if ((iAtom = BitSetUtil.firstSetBit(bs)) < 0) {
            bs = this.getModelAtomBitSet(modelIndex, true);
            iAtom = BitSetUtil.firstSetBit(bs);
        }
        boolean haveVibration = (obj = this.getShapeProperty(17, "mad", iAtom)) != null && (Integer)obj != 0 || this.viewer.isVibrationOn();
        SymmetryInterface symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        this.pointGroup = symmetry.setPointGroup(this.pointGroup, this.atoms, bs, haveVibration, this.viewer.getPointGroupTolerance(0), this.viewer.getPointGroupTolerance(1));
        if (!doAll && !asInfo) {
            return this.pointGroup.getPointGroupName();
        }
        Object ret = this.pointGroup.getPointGroupInfo(modelIndex, asDraw, asInfo, type, index, scale);
        if (asInfo) {
            return ret;
        }
        return (this.modelCount > 1 ? "frame " + this.getModelNumberDotted(modelIndex) + "; " : "") + ret;
    }

    private BitSet modelsOf(BitSet bsAtoms, BitSet bsAllAtoms) {
        BitSet bsModels = new BitSet(this.modelCount);
        for (int i = 0; i < this.atomCount; ++i) {
            int modelIndex = this.models[this.atoms[i].modelIndex].trajectoryBaseIndex;
            if (bsAtoms != null && !bsAtoms.get(i) || this.isJmolDataFrame(modelIndex)) continue;
            bsModels.set(modelIndex);
            bsAllAtoms.set(i);
        }
        return bsModels;
    }

    public int autoHbond(BitSet bsA, BitSet bsB, BitSet bsBonds, float maxXYDistance, float minAttachedAngle) {
        this.bsPseudoHBonds = new BitSet();
        if (minAttachedAngle == 0.0f && this.bondCount > 0) {
            this.calcHydrogenBonds(bsA, bsB);
            bsBonds = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf(bsBonds);
        }
        this.initializeBspf();
        return super.autoHbond(bsA, bsB, bsBonds, maxXYDistance, minAttachedAngle);
    }

    protected void assignAromaticBonds(boolean isUserCalculation) {
        super.assignAromaticBonds(isUserCalculation, null);
        if (isUserCalculation) {
            this.setShapeSize(1, Integer.MIN_VALUE, Float.NaN, this.bsAromatic);
        }
    }

    public int[] makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB, BitSet bsBonds, boolean isBonds) {
        if (connectOperation == 0 || connectOperation == 4) {
            String stateScript = "connect ";
            if (minDistance != 0.1f) {
                stateScript = stateScript + minDistance + " ";
            }
            if (maxDistance != 1.0E8f) {
                stateScript = stateScript + maxDistance + " ";
            }
            this.addStateScript(stateScript, isBonds ? bsA : null, isBonds ? null : bsA, isBonds ? null : bsB, connectOperation == 0 ? " delete" : " auto", false, true);
        }
        return super.makeConnections(minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds);
    }

    public void setPdbConectBonding(int baseAtomIndex, int baseModelIndex, BitSet bsExclude) {
        short mad = this.viewer.getMadBond();
        for (int i = baseModelIndex; i < this.modelCount; ++i) {
            Vector vConnect = (Vector)this.getModelAuxiliaryInfo(i, "PDB_CONECT_bonds");
            if (vConnect == null) continue;
            int nConnect = vConnect.size();
            int[] atomInfo = (int[])this.getModelAuxiliaryInfo(i, "PDB_CONECT_firstAtom_count_max");
            int firstAtom = atomInfo[0] + baseAtomIndex;
            int atomMax = firstAtom + atomInfo[1];
            int max = atomInfo[2];
            int[] serialMap = new int[max + 1];
            for (int iAtom = firstAtom; iAtom < atomMax; ++iAtom) {
                int iSerial = this.atomSerials[iAtom];
                if (iSerial <= 0) continue;
                serialMap[iSerial] = iAtom + 1;
            }
            for (int iConnect = 0; iConnect < nConnect; ++iConnect) {
                int[] pair = (int[])vConnect.get(iConnect);
                int sourceSerial = pair[0];
                int targetSerial = pair[1];
                short order = (short)pair[2];
                if (sourceSerial < 0 || targetSerial < 0 || sourceSerial > max || targetSerial > max) continue;
                int sourceIndex = serialMap[sourceSerial] - 1;
                int targetIndex = serialMap[targetSerial] - 1;
                if (sourceIndex < 0 || targetIndex < 0) continue;
                if (bsExclude != null) {
                    if (this.atoms[sourceIndex].isHetero()) {
                        bsExclude.set(sourceIndex);
                    }
                    if (this.atoms[targetIndex].isHetero()) {
                        bsExclude.set(targetIndex);
                    }
                }
                this.checkValencesAndBond(this.atoms[sourceIndex], this.atoms[targetIndex], order, order == 2048 ? (short)1 : mad, null);
            }
        }
    }

    public void deleteAllBonds() {
        int i = this.stateScripts.size();
        while (--i >= 0) {
            if (!((ModelCollection.StateScript)this.stateScripts.get(i)).isConnect()) continue;
            this.stateScripts.removeElementAt(i);
        }
        super.deleteAllBonds();
    }

    public String getDefinedState(StringBuffer sfunc, boolean isAll) {
        String cmd;
        int len = this.stateScripts.size();
        if (len == 0) {
            return "";
        }
        boolean haveDefs = false;
        StringBuffer commands = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            ModelCollection.StateScript ss = (ModelCollection.StateScript)this.stateScripts.get(i);
            if (ss.postDefinitions || (cmd = ss.toString()).length() <= 0) continue;
            commands.append("  ").append(cmd).append("\n");
            haveDefs = true;
        }
        if (!haveDefs) {
            return "";
        }
        cmd = "";
        if (isAll && sfunc != null) {
            sfunc.append("  _setDefinedState;\n");
            cmd = "function _setDefinedState() {\n\n";
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return cmd + commands.toString();
    }

    public String getState(StringBuffer sfunc, boolean isAll) {
        int i;
        String cmd;
        StringBuffer commands = new StringBuffer();
        if (isAll && sfunc != null) {
            sfunc.append("  _setModelState;\n");
            commands.append("function _setModelState() {\n");
        }
        if (isAll) {
            int i2;
            int len = this.stateScripts.size();
            for (i2 = 0; i2 < len; ++i2) {
                ModelCollection.StateScript ss = (ModelCollection.StateScript)this.stateScripts.get(i2);
                if (!ss.postDefinitions || (cmd = ss.toString()).length() <= 0) continue;
                commands.append("  ").append(cmd).append("\n");
            }
            for (i2 = 0; i2 < this.bondCount; ++i2) {
                if ((this.bonds[i2].order & Short.MIN_VALUE) == 0 && !this.bonds[i2].isHydrogen()) continue;
                Bond bond = this.bonds[i2];
                commands.append("  connect ").append("({").append(bond.atom1.atomIndex).append("}) ").append("({").append(bond.atom2.atomIndex).append("}) ").append(JmolConstants.getBondOrderNameFromOrder(bond.order)).append(";\n");
            }
            commands.append("\n");
        }
        this.setModelVisibility();
        commands.append(this.getProteinStructureState(null, true, false));
        if (this.shapes != null) {
            for (i = 0; i < 32; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null || !isAll && !JmolConstants.isShapeSecondary(i) || (cmd = shape.getShapeState()) == null || cmd.length() <= 1) continue;
                commands.append(cmd);
            }
        }
        if (isAll) {
            for (i = 0; i < this.modelCount; ++i) {
                String t = this.frameTitles[i];
                if (t != null && t.length() > 0) {
                    commands.append("  frame " + this.getModelNumberDotted(i) + "; frame title " + Escape.escape(t) + ";\n");
                }
                if (this.models[i].orientation == null) continue;
                commands.append("  frame " + this.getModelNumberDotted(i) + "; " + this.models[i].orientation.getMoveToText() + "\n");
            }
            commands.append("  set fontScaling " + this.viewer.getFontScaling() + ";\n");
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return commands.toString();
    }

    public int getVanderwaalsMar(int i) {
        return this.viewer.getVanderwaalsMar(i);
    }

    private void includeAllRelatedFrames(BitSet bsModels) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (bsModels.get(i)) {
                int j;
                if (!this.isTrajectory(i) || bsModels.get(j = this.models[i].trajectoryBaseIndex)) continue;
                bsModels.set(j);
                this.includeAllRelatedFrames(bsModels);
                return;
            }
            if ((!this.isTrajectory(i) || !bsModels.get(this.models[i].trajectoryBaseIndex)) && (!this.isJmolDataFrame(i) || !bsModels.get(this.models[i].dataSourceFrame))) continue;
            bsModels.set(i);
        }
    }

    public BitSet deleteModels(BitSet bsAtoms) {
        BitSet bsModels = this.getModelBitSet(bsAtoms, false);
        this.includeAllRelatedFrames(bsModels);
        int nAtomsDeleted = 0;
        int nModelsDeleted = BitSetUtil.cardinalityOf(bsModels);
        if (nModelsDeleted == 0) {
            return null;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bsModels.get(i)) continue;
            this.clearDataFrameReference(i);
        }
        if (nModelsDeleted == this.modelCount) {
            BitSet bsDeleted = this.getModelAtomBitSet(-1, true);
            this.viewer.zap(true, false);
            return bsDeleted;
        }
        this.bspf = null;
        Model[] newModels = new Model[this.modelCount - nModelsDeleted];
        Model[] oldModels = this.models;
        BitSet bsDeleted = new BitSet();
        int mpt = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            if (bsModels.get(i)) {
                this.getAtomCountInModel(i);
                bsDeleted.or(this.getModelAtomBitSet(i, false));
                continue;
            }
            this.models[i].modelIndex = mpt;
            newModels[mpt++] = this.models[i];
        }
        this.models = newModels;
        int oldModelCount = this.modelCount;
        BitSet bsBonds = this.getBondsForSelectedAtoms(bsDeleted, true);
        this.deleteBonds(bsBonds);
        int mpt2 = 0;
        for (int i = 0; i < oldModelCount; ++i) {
            if (!bsModels.get(i)) {
                ++mpt2;
                continue;
            }
            int nAtoms = oldModels[i].atomCount;
            if (nAtoms == 0) continue;
            nAtomsDeleted += nAtoms;
            BitSet bs = oldModels[i].bsAtoms;
            int firstAtomIndex = oldModels[i].firstAtomIndex;
            BitSetUtil.deleteBits(this.bsSymmetry, bs);
            this.deleteModel(mpt2, firstAtomIndex, nAtoms, bs, bsBonds);
            int j = oldModelCount;
            while (--j > i) {
                oldModels[j].fixIndices(mpt2, nAtoms, bs);
            }
            Object[] value = new Object[]{newModels, this.atoms, new int[]{mpt2, firstAtomIndex, nAtoms}};
            if (this.shapes != null) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    if (this.shapes[j2] == null) continue;
                    this.setShapeProperty(j2, "deleteModelAtoms", value, bs);
                }
            }
            --this.modelCount;
        }
        this.deleteModel(-1, 0, 0, null, null);
        return bsDeleted;
    }

    public void setLabel(String strLabel, BitSet bsSelection) {
        if (strLabel != null) {
            this.loadShape(4);
            this.setShapeSize(4, 0, Float.NaN, bsSelection);
        }
        this.setShapeProperty(4, "label", strLabel, bsSelection);
    }

    public void setAtomLabel(String strLabel, int i) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(4);
        this.shapes[4].setProperty("label:" + strLabel, new Integer(i), null);
    }
}

