/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

class Molecule {
    ModelSet modelSet;
    int moleculeIndex;
    int modelIndex;
    int indexInModel;
    int nAtoms;
    int nElements;
    int[] elementCounts = new int[JmolConstants.elementNumberMax];
    int[] altElementCounts = new int[JmolConstants.altElementMax];
    int elementNumberMax;
    int altElementMax;
    String mf;
    BitSet atomList;

    Molecule(ModelSet modelSet, int moleculeIndex, BitSet atomList, int modelIndex, int indexInModel) {
        this.modelSet = modelSet;
        this.atomList = atomList;
        this.moleculeIndex = moleculeIndex;
        this.modelIndex = modelIndex;
        this.indexInModel = indexInModel;
        this.getElementAndAtomCount(atomList);
        this.mf = this.getMolecularFormula();
        if (Logger.debugging) {
            Logger.debug("new Molecule (" + this.mf + ") " + (indexInModel + 1) + "/" + (modelIndex + 1));
        }
    }

    void getElementAndAtomCount(BitSet atomList) {
        for (int i = 0; i < this.modelSet.atomCount; ++i) {
            if (!atomList.get(i)) continue;
            ++this.nAtoms;
            int n = this.modelSet.atoms[i].getAtomicAndIsotopeNumber();
            if (n < JmolConstants.elementNumberMax) {
                int n2 = n;
                this.elementCounts[n2] = this.elementCounts[n2] + 1;
                if (this.elementCounts[n] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n);
                continue;
            }
            int n3 = n = JmolConstants.altElementIndexFromNumber(n);
            this.altElementCounts[n3] = this.altElementCounts[n3] + 1;
            if (this.altElementCounts[n] == 1) {
                ++this.nElements;
            }
            this.altElementMax = Math.max(this.altElementMax, n);
        }
    }

    String getMolecularFormula() {
        int nX;
        int i;
        String mf = "";
        String sep = "";
        for (i = 1; i <= this.elementNumberMax; ++i) {
            nX = this.elementCounts[i];
            if (nX == 0) continue;
            mf = mf + sep + JmolConstants.elementSymbolFromNumber(i) + " " + nX;
            sep = " ";
        }
        for (i = 1; i <= this.altElementMax; ++i) {
            nX = this.altElementCounts[i];
            if (nX == 0) continue;
            mf = mf + sep + JmolConstants.elementSymbolFromNumber(JmolConstants.altElementNumberFromIndex(i)) + " " + nX;
            sep = " ";
        }
        return mf;
    }

    Hashtable getInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("number", new Integer(this.moleculeIndex + 1));
        info.put("modelNumber", this.modelSet.getModelNumberDotted(this.modelIndex));
        info.put("numberInModel", new Integer(this.indexInModel + 1));
        info.put("nAtoms", new Integer(this.nAtoms));
        info.put("nElements", new Integer(this.nElements));
        info.put("mf", this.mf);
        return info;
    }
}

