/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

public class AminoPolymer
extends AlphaPolymer {
    private boolean hasOAtoms;
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;

    AminoPolymer(Monomer[] monomers) {
        super(monomers);
        this.type = 1;
    }

    boolean hasWingPoints() {
        return this.hasOAtoms;
    }

    public void calcHydrogenBonds(Polymer polymer, BitSet bsA, BitSet bsB) {
        this.calcProteinMainchainHydrogenBonds((AminoPolymer)polymer, bsA, bsB);
    }

    private void calcProteinMainchainHydrogenBonds(AminoPolymer polymer, BitSet bsA, BitSet bsB) {
        boolean intraChain;
        Point3f pt = new Point3f();
        Vector3f vNH = new Vector3f();
        boolean bl = intraChain = polymer == null;
        if (intraChain) {
            polymer = this;
        }
        for (int i = 1; i < polymer.monomerCount; ++i) {
            AminoMonomer source = (AminoMonomer)polymer.monomers[i];
            if (!source.getNHPoint(pt, vNH)) continue;
            this.bondAminoHydrogen(source, intraChain ? i : -100, pt, bsA, bsB);
        }
    }

    private void bondAminoHydrogen(AminoMonomer source, int indexDonor, Point3f hydrogenPoint, BitSet bsA, BitSet bsB) {
        Point3f sourceAlphaPoint = source.getLeadAtomPoint();
        Point3f sourceNitrogenPoint = source.getNitrogenAtomPoint();
        int energyMin1 = 0;
        int energyMin2 = 0;
        int indexMin1 = -1;
        int indexMin2 = -1;
        int i = this.monomerCount;
        while (--i >= 0) {
            AminoMonomer target;
            Point3f targetAlphaPoint;
            float dist2;
            if (i == indexDonor || i + 1 == indexDonor || i - 1 == indexDonor || (dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint = (target = (AminoMonomer)this.monomers[i]).getLeadAtomPoint())) > 81.0f) continue;
            int energy = this.calcHbondEnergy(source.getNitrogenAtom(), sourceNitrogenPoint, hydrogenPoint, target);
            if (energy < energyMin1) {
                energyMin2 = energyMin1;
                indexMin2 = indexMin1;
                energyMin1 = energy;
                indexMin1 = i;
                continue;
            }
            if (energy >= energyMin2) continue;
            energyMin2 = energy;
            indexMin2 = i;
        }
        if (indexMin1 >= 0) {
            this.createResidueHydrogenBond(source, indexDonor, indexMin1, bsA, bsB, (float)(-energyMin1) / 1000.0f);
            if (indexMin2 >= 0) {
                this.createResidueHydrogenBond(source, indexDonor, indexMin2, bsA, bsB, (float)(-energyMin2) / 1000.0f);
            }
        }
    }

    private int calcHbondEnergy(Atom nitrogen, Point3f nitrogenPoint, Point3f hydrogenPoint, AminoMonomer target) {
        boolean isHbond;
        Point3f targetOxygenPoint = target.getCarbonylOxygenAtomPoint();
        if (targetOxygenPoint == null) {
            return 0;
        }
        float distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
        if (distON2 < 0.5f) {
            return 0;
        }
        float distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
        if (distOH2 < 0.5f) {
            return 0;
        }
        Point3f targetCarbonPoint = target.getCarbonylCarbonAtomPoint();
        float distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
        if (distCH2 < 0.5f) {
            return 0;
        }
        float distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
        if (distCN2 < 0.5f) {
            return 0;
        }
        double distOH = Math.sqrt(distOH2);
        double distCH = Math.sqrt(distCH2);
        double distCN = Math.sqrt(distCN2);
        double distON = Math.sqrt(distON2);
        int energy = (int)(-27888.0 / distOH - -27888.0 / distCH + -27888.0 / distCN - -27888.0 / distON);
        boolean bl = isHbond = distCN2 > distCH2 && distOH <= 3.0 && energy <= -500;
        return !isHbond ? 0 : (energy < -9900 ? -9900 : energy);
    }

    private void createResidueHydrogenBond(AminoMonomer donor, int indexAminoGroup, int indexCarbonylGroup, BitSet bsA, BitSet bsB, float energy) {
        short order;
        int aminoBackboneHbondOffset = indexAminoGroup - indexCarbonylGroup;
        switch (aminoBackboneHbondOffset) {
            case 2: {
                order = 6144;
                break;
            }
            case 3: {
                order = 8192;
                break;
            }
            case 4: {
                order = 10240;
                break;
            }
            case 5: {
                order = 12288;
                break;
            }
            case -3: {
                order = 14336;
                break;
            }
            case -4: {
                order = 16384;
                break;
            }
            default: {
                order = 4096;
            }
        }
        Atom nitrogen = donor.getNitrogenAtom();
        AminoMonomer recipient = (AminoMonomer)this.monomers[indexCarbonylGroup];
        Atom oxygen = recipient.getCarbonylOxygenAtom();
        this.model.addHydrogenBond(nitrogen, oxygen, order, bsA, bsB, energy);
    }

    public void calculateStructures() {
        int start;
        char[] structureTags = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            AminoMonomer leadingResidue = (AminoMonomer)this.monomers[i];
            AminoMonomer trailingResidue = (AminoMonomer)this.monomers[i + 1];
            float phi = trailingResidue.getPhi();
            float psi = leadingResidue.getPsi();
            structureTags[i] = AminoPolymer.isHelix(psi, phi) ? (phi < 0.0f && psi < 25.0f ? 52 : 51) : (AminoPolymer.isSheet(psi, phi) ? 115 : (AminoPolymer.isTurn(psi, phi) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + i + " " + trailingResidue.getPhi() + "," + leadingResidue.getPsi() + " " + structureTags[i]);
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '4') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '4'; ++end) {
            }
            if (--end >= start + 3) {
                this.addSecondaryStructure((byte)3, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '3') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '3'; ++end) {
            }
            if (--end >= start + 3) {
                this.addSecondaryStructure((byte)3, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 's') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 's'; ++end) {
            }
            if (--end >= start + 2) {
                this.addSecondaryStructure((byte)2, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 't') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 't'; ++end) {
            }
            if (--end >= start + 2) {
                this.addSecondaryStructure((byte)1, start, end);
            }
            start = end;
        }
    }

    private boolean checkWingAtoms() {
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)this.monomers[i]).hasOAtom()) continue;
            return false;
        }
        return true;
    }

    public void freeze() {
        this.hasOAtoms = this.checkWingAtoms();
        this.calcPhiPsiAngles();
    }

    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles(AminoMonomer leadingResidue, AminoMonomer trailingResidue) {
        Point3f nitrogen1 = leadingResidue.getNitrogenAtomPoint();
        Point3f alphacarbon1 = leadingResidue.getLeadAtomPoint();
        Point3f carbon1 = leadingResidue.getCarbonylCarbonAtomPoint();
        Point3f nitrogen2 = trailingResidue.getNitrogenAtomPoint();
        Point3f alphacarbon2 = trailingResidue.getLeadAtomPoint();
        Point3f carbon2 = trailingResidue.getCarbonylCarbonAtomPoint();
        trailingResidue.setPhi(Measure.computeTorsion(carbon1, nitrogen2, alphacarbon2, carbon2, true));
        leadingResidue.setPsi(Measure.computeTorsion(nitrogen1, alphacarbon1, carbon1, nitrogen2, true));
        leadingResidue.setOmega(Measure.computeTorsion(alphacarbon1, carbon1, nitrogen2, alphacarbon2, true));
    }

    private static boolean isHelix(float psi, float phi) {
        return phi >= -160.0f && phi <= 0.0f && psi >= -100.0f && psi <= 45.0f;
    }

    private static boolean isSheet(float psi, float phi) {
        return phi >= -180.0f && phi <= -10.0f && psi >= 70.0f && psi <= 180.0f || phi >= -180.0f && phi <= -45.0f && psi >= -180.0f && psi <= -130.0f || phi >= 140.0f && phi <= 180.0f && psi >= 90.0f && psi <= 180.0f;
    }

    private static boolean isTurn(float psi, float phi) {
        return phi >= 30.0f && phi <= 90.0f && psi >= -15.0f && psi <= 95.0f;
    }

    public void getPdbData(char ctype, char qtype, int derivType, boolean isDraw, BitSet bsAtoms, StringBuffer pdbATOM, StringBuffer pdbCONECT, BitSet bsSelected, boolean addHeader, BitSet bsWritten) {
        AminoPolymer.getPdbData(this, ctype, qtype, derivType, isDraw, bsAtoms, pdbATOM, pdbCONECT, bsSelected, addHeader, bsWritten);
    }
}

