/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

public abstract class BioPolymer
extends Polymer {
    Monomer[] monomers;
    int monomerCount;
    protected Model model;
    private float sheetSmoothing;
    private final Vector3f unitVectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BitSet bsSelectedMonomers;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};

    public Monomer[] getMonomers() {
        return this.monomers;
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    BioPolymer(Monomer[] monomers) {
        this.monomers = monomers;
        int i = this.monomerCount = monomers.length;
        while (--i >= 0) {
            monomers[i].setBioPolymer(this, i);
        }
        this.model = monomers[0].getModel();
    }

    static BioPolymer allocateBioPolymer(Group[] groups, int firstGroupIndex, boolean checkConnections) {
        Group group;
        Object previous = null;
        int count = 0;
        for (int i = firstGroupIndex; i < groups.length && (group = groups[i]) instanceof Monomer; ++i) {
            Monomer current = (Monomer)group;
            if (current.bioPolymer != null || previous != null && previous.getClass() != current.getClass() || checkConnections && !current.isConnectedAfter((Monomer)previous)) break;
            previous = current;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (Monomer)groups[firstGroupIndex + j];
        }
        if (previous instanceof AminoMonomer) {
            return new AminoPolymer(monomers);
        }
        if (previous instanceof AlphaMonomer) {
            return new AlphaPolymer(monomers);
        }
        if (previous instanceof NucleicMonomer) {
            return new NucleicPolymer(monomers);
        }
        if (previous instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomers);
        }
        if (previous instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomers);
        }
        Logger.error("Polymer.allocatePolymer() ... no matching polymer for monomor " + previous);
        throw new NullPointerException();
    }

    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    void removeProteinStructure(int monomerIndex, int count) {
        int i = 0;
        for (int pt = monomerIndex; i < count && pt < this.monomerCount; ++i, ++pt) {
            this.monomers[pt].setStructure(null);
        }
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            int i = this.monomerCount;
            while (--i >= 0) {
                this.leadAtomIndices[i] = this.monomers[i].getLeadAtomIndex();
            }
        }
        return this.leadAtomIndices;
    }

    int getIndex(char chainID, int seqcode) {
        int i = this.monomerCount;
        while (--i >= 0 && (this.monomers[i].getChainID() != chainID || this.monomers[i].getSeqcode() != seqcode)) {
        }
        return i;
    }

    final Point3f getLeadPoint(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtomPoint();
    }

    final Point3f getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    final Point3f getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int groupIndex, Point3f midPoint) {
        if (groupIndex == this.monomerCount) {
            --groupIndex;
        } else if (groupIndex > 0) {
            midPoint.set(this.getLeadPoint(groupIndex));
            midPoint.add(this.getLeadPoint(groupIndex - 1));
            midPoint.scale(0.5f);
            return;
        }
        midPoint.set(this.getLeadPoint(groupIndex));
    }

    void getLeadPoint(int groupIndex, Point3f midPoint) {
        if (groupIndex == this.monomerCount) {
            --groupIndex;
        }
        midPoint.set(this.getLeadPoint(groupIndex));
    }

    boolean hasWingPoints() {
        return false;
    }

    final Point3f getWingPoint(int polymerIndex) {
        return this.monomers[polymerIndex].getWingAtomPoint();
    }

    final Point3f getPointPoint(int polymerIndex) {
        return this.monomers[polymerIndex].getPointAtomPoint();
    }

    public void setConformation(BitSet bsSelected, int nAltLocsInModel) {
        int i = this.monomerCount;
        while (--i >= 0) {
            this.monomers[i].updateOffsetsForAlternativeLocations(bsSelected, nAltLocsInModel);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.leadAtomIndices = null;
        this.sheetPoints = null;
        this.getLeadAtomIndices();
        ProteinStructure psLast = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure ps = this.getProteinStructure(i);
            if (ps != null && ps != psLast) {
                psLast = ps;
                psLast.resetAxes();
            }
            this.monomers[i].resetHydrogenPoint();
        }
        this.calcLeadMidpointsAndWingVectors(false);
    }

    public Point3f[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadMidpoints;
    }

    Point3f[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadPoints;
    }

    public Point3f[] getControlPoints(boolean isTraceAlpha, float sheetSmoothing, boolean invalidate) {
        if (invalidate) {
            this.sheetPoints = null;
        }
        if (!isTraceAlpha) {
            return this.leadMidpoints;
        }
        if (sheetSmoothing == 0.0f) {
            return this.leadPoints;
        }
        return this.getSheetPoints(sheetSmoothing);
    }

    private Point3f[] getSheetPoints(float sheetSmoothing) {
        if (this.sheetPoints != null && sheetSmoothing == this.sheetSmoothing) {
            return this.sheetPoints;
        }
        this.sheetPoints = new Point3f[this.monomerCount + 1];
        this.getLeadPoints();
        for (int i = 0; i < this.monomerCount; ++i) {
            this.sheetPoints[i] = new Point3f();
        }
        Vector3f v = new Vector3f();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (this.monomers[i].isSheet()) {
                v.sub(this.leadMidpoints[i], this.leadPoints[i]);
                v.scale(sheetSmoothing);
                this.sheetPoints[i].add(this.leadPoints[i], v);
                continue;
            }
            this.sheetPoints[i] = this.leadPoints[i];
        }
        this.sheetPoints[this.monomerCount] = this.sheetPoints[this.monomerCount - 1];
        this.sheetSmoothing = sheetSmoothing;
        return this.sheetPoints;
    }

    public final Vector3f[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors(boolean getNewPoints) {
        Point3f leadPoint;
        int count = this.monomerCount;
        if (this.leadMidpoints == null || getNewPoints) {
            this.leadMidpoints = new Point3f[count + 1];
            this.leadPoints = new Point3f[count + 1];
            this.wingVectors = new Vector3f[count + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        boolean hasWingPoints = this.hasWingPoints();
        Vector3f vectorA = new Vector3f();
        Vector3f vectorB = new Vector3f();
        Vector3f vectorC = new Vector3f();
        Vector3f vectorD = new Vector3f();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = leadPoint = this.getLeadPoint(0);
        Vector3f previousVectorD = null;
        for (int i = 1; i < count; ++i) {
            Point3f leadPointPrev = leadPoint;
            this.leadPoints[i] = leadPoint = this.getLeadPoint(i);
            Point3f midpoint = new Point3f(leadPoint);
            midpoint.add(leadPointPrev);
            midpoint.scale(0.5f);
            this.leadMidpoints[i] = midpoint;
            if (!hasWingPoints) continue;
            vectorA.sub(leadPoint, leadPointPrev);
            vectorB.sub(leadPointPrev, this.getWingPoint(i - 1));
            vectorC.cross(vectorA, vectorB);
            vectorD.cross(vectorA, vectorC);
            vectorD.normalize();
            if (previousVectorD != null && (double)previousVectorD.angle(vectorD) > 1.5707963267948966) {
                vectorD.scale(-1.0f);
            }
            previousVectorD = this.wingVectors[i] = new Vector3f(vectorD);
        }
        this.leadPoints[count] = this.leadMidpoints[count] = this.getTerminatorPoint();
        if (!hasWingPoints) {
            if (count < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                Vector3f previousVectorC = null;
                for (int i = 1; i < count; ++i) {
                    vectorA.sub(this.leadMidpoints[i], this.leadPoints[i]);
                    vectorB.sub(this.leadPoints[i], this.leadMidpoints[i + 1]);
                    vectorC.cross(vectorA, vectorB);
                    vectorC.normalize();
                    if (previousVectorC != null && (double)previousVectorC.angle(vectorC) > 1.5707963267948966) {
                        vectorC.scale(-1.0f);
                    }
                    previousVectorC = this.wingVectors[i] = new Vector3f(vectorC);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[count] = this.wingVectors[count - 1];
    }

    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest, short[] mads, int myVisibilityFlag) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if ((this.monomers[i].shapeVisibilityFlags & myVisibilityFlag) == 0 || !this.monomers[i].getLeadAtom().isVisible() || mads[i] <= 0 && mads[i + 1] <= 0) continue;
            this.monomers[i].findNearestAtomIndex(xMouse, yMouse, closest, mads[i], mads[i + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BitSet bsSelected) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BitSet();
        }
        BitSetUtil.clear(this.bsSelectedMonomers);
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bsSelected)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int i) {
        return i >= 0 && this.bsSelectedMonomers.get(i);
    }

    public int getPolymerPointsAndVectors(int last, BitSet bs, Vector vList, boolean isTraceAlpha, float sheetSmoothing) {
        Point3f[] points = this.getControlPoints(isTraceAlpha, sheetSmoothing, false);
        Vector3f[] vectors = this.getWingVectors();
        int count = this.monomerCount;
        for (int j = 0; j < count; ++j) {
            if (bs.get(this.monomers[j].getLeadAtomIndex())) {
                vList.addElement(new Point3f[]{points[j], new Point3f(vectors[j])});
                last = j;
                continue;
            }
            if (last == 0x7FFFFFFE) continue;
            vList.addElement(new Point3f[]{points[j], new Point3f(vectors[j])});
            last = 0x7FFFFFFE;
        }
        if (last + 1 < count) {
            vList.addElement(new Point3f[]{points[last + 1], new Point3f(vectors[last + 1])});
        }
        return last;
    }

    public String getSequence() {
        char[] buf = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            buf[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(buf);
    }

    public Hashtable getPolymerInfo(BitSet bs) {
        Hashtable<String, Object> returnInfo = new Hashtable<String, Object>();
        Vector<Hashtable> info = new Vector<Hashtable>();
        Vector<Hashtable<String, Integer>> structureInfo = null;
        ProteinStructure psLast = null;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!bs.get(this.monomers[i].getLeadAtomIndex())) continue;
            Hashtable monomerInfo = this.monomers[i].getMyInfo();
            monomerInfo.put("monomerIndex", new Integer(i));
            info.addElement(monomerInfo);
            ProteinStructure ps = this.getProteinStructure(i);
            if (ps == null || ps == psLast) continue;
            Hashtable<String, Integer> psInfo = new Hashtable<String, Integer>();
            psLast = ps;
            psLast.getInfo(psInfo);
            if (structureInfo == null) {
                structureInfo = new Vector<Hashtable<String, Integer>>();
            }
            psInfo.put("index", new Integer(n++));
            structureInfo.addElement(psInfo);
        }
        if (info.size() > 0) {
            returnInfo.put("sequence", this.getSequence());
            returnInfo.put("monomers", info);
            if (structureInfo != null) {
                returnInfo.put("structures", structureInfo);
            }
        }
        return returnInfo;
    }

    public void getPolymerSequenceAtoms(int iModel, int iPolymer, int group1, int nGroups, BitSet bsInclude, BitSet bsResult) {
        int max = group1 + nGroups;
        for (int i = group1; i < this.monomerCount && i < max; ++i) {
            this.monomers[i].getMonomerSequenceAtoms(bsInclude, bsResult);
        }
    }

    public ProteinStructure getProteinStructure(int monomerIndex) {
        return this.monomers[monomerIndex].getProteinStructure();
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    public static final void getPdbData(BioPolymer p, char ctype, char qtype, int derivType, boolean isDraw, BitSet bsAtoms, StringBuffer pdbATOM, StringBuffer pdbCONECT, BitSet bsSelected, boolean addHeader, BitSet bsWritten) {
        boolean useQuaternionStraightness;
        boolean straightness;
        boolean isRamachandran;
        int atomno = Integer.MIN_VALUE;
        boolean bl = isRamachandran = ctype == 'R';
        if (isRamachandran && !p.calcPhiPsiAngles()) {
            return;
        }
        Atom aprev = null;
        Quaternion qprev = null;
        Quaternion dq = null;
        Quaternion dqprev = null;
        Quaternion qref = null;
        float factor = ctype == 'R' ? 1.0f : 10.0f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float w = 0.0f;
        String strExtra = "";
        float val1 = Float.NaN;
        float val2 = Float.NaN;
        boolean isAmino = p instanceof AminoPolymer;
        boolean isRelativeAlias = ctype == 'r';
        boolean bl2 = straightness = ctype == 's' || ctype == 'S';
        if (derivType == 2 && isRelativeAlias) {
            ctype = (char)119;
        }
        if (straightness) {
            derivType = 2;
        }
        boolean bl3 = useQuaternionStraightness = ctype == 'S';
        if (straightness && Logger.debugging) {
            Logger.debug("For straightness calculation: useQuaternionStraightness = " + useQuaternionStraightness + " and quaternionFrame = " + qtype);
        }
        String prefix = derivType > 0 ? "dq" + (derivType == 2 ? "2" : "") : "q";
        float psiLast = Float.NaN;
        if (addHeader && !isDraw) {
            pdbATOM.append("REMARK   6    AT GRP CH RESNO  ");
            switch (ctype) {
                default: {
                    pdbATOM.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    pdbATOM.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    pdbATOM.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    pdbATOM.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (qtype == 'r') {
                        pdbATOM.append("phi____ psi____ theta        PartialCharge");
                        break;
                    }
                    pdbATOM.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            pdbATOM.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            pdbATOM.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (ctype != 'R') {
                pdbATOM.append("  centerX___ centerY___ centerZ___");
            }
            if (qtype == 'n') {
                pdbATOM.append("  NHX_______ NHY_______ NHZ_______");
            }
            pdbATOM.append("\n\n");
        }
        for (int m = 0; m < p.monomerCount; ++m) {
            Quaternion q;
            Monomer monomer = p.monomers[m];
            if (bsAtoms != null && !bsAtoms.get(monomer.getLeadAtomIndex())) continue;
            Atom a = monomer.getLeadAtom();
            String id = monomer.getUniqueID();
            if (isRamachandran) {
                x = monomer.getPhi();
                y = monomer.getPsi();
                z = monomer.getOmega();
                if (z < -90.0f) {
                    z += 360.0f;
                }
                if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z -= 180.0f)) {
                    bsAtoms.clear(a.getAtomIndex());
                    continue;
                }
                if (isDraw) {
                    if (bsSelected != null && !bsSelected.get(a.getAtomIndex())) continue;
                    AminoMonomer aa = (AminoMonomer)monomer;
                    pdbATOM.append("draw phi" + id + " arrow arc scale 0.25 ").append(Escape.escape(aa.getNitrogenAtomPoint())).append(Escape.escape(a)).append(Escape.escape(aa.getCarbonylCarbonAtomPoint())).append("{" + -x + " " + x + " 0.5} \"phi = " + (int)x + "\"").append(" color ").append(qColor[2]).append('\n');
                    pdbATOM.append("draw psi" + id + " arrow arc scale 0.25 ").append(Escape.escape(a)).append(Escape.escape(aa.getCarbonylCarbonAtomPoint())).append(Escape.escape(aa.getNitrogenAtomPoint())).append("{0 " + y + " 0.5} \"psi = " + (int)y + "\"").append(" color ").append(qColor[1]).append('\n');
                    pdbATOM.append("draw planeNCC" + id + " ").append(Escape.escape(aa.getNitrogenAtomPoint())).append(Escape.escape(a)).append(Escape.escape(aa.getCarbonylCarbonAtomPoint())).append(" color ").append(qColor[0]).append('\n');
                    pdbATOM.append("draw planeCNC" + id + " ").append(Escape.escape(((AminoMonomer)p.monomers[m - 1]).getCarbonylCarbonAtomPoint())).append(Escape.escape(aa.getNitrogenAtomPoint())).append(Escape.escape(a)).append(" color ").append(qColor[1]).append('\n');
                    pdbATOM.append("draw planeCCN" + id + " ").append(Escape.escape(a)).append(Escape.escape(aa.getCarbonylCarbonAtomPoint())).append(Escape.escape(((AminoMonomer)p.monomers[m + 1]).getNitrogenAtomPoint())).append(" color ").append(qColor[2]).append('\n');
                    continue;
                }
                w = a.getPartialCharge();
                float phiNext = m == p.monomerCount - 1 ? Float.NaN : p.monomers[m + 1].getPhi();
                float angle = Math.abs(y + phiNext - psiLast - x);
                psiLast = y;
                if (Float.isNaN(angle)) {
                    strExtra = "";
                    if (qtype == 'r') {
                        continue;
                    }
                } else {
                    q = new Quaternion(new Point3f(1.0f, 0.0f, 0.0f), angle);
                    strExtra = q.getInfo();
                    if (qtype == 'r') {
                        z = angle;
                    }
                }
            } else {
                Point3f ptCenter;
                q = monomer.getQuaternion(qtype);
                if (q != null) {
                    q.setRef(qref);
                    qref = new Quaternion(q);
                }
                if (derivType == 2) {
                    a.getGroup().setStraightness(Float.NaN);
                }
                if (q == null) {
                    qprev = null;
                    qref = null;
                } else if (derivType > 0) {
                    Atom anext = a;
                    Quaternion qnext = q;
                    if (qprev == null) {
                        q = null;
                        dqprev = null;
                    } else {
                        a = aprev;
                        q = qprev;
                        monomer = (Monomer)a.getGroup();
                        dq = isRelativeAlias ? q.leftDifference(qnext) : qnext.rightDifference(q);
                        if (derivType == 1) {
                            q = dq;
                        } else if (dqprev == null) {
                            q = null;
                        } else {
                            q = dq.rightDifference(dqprev);
                            val1 = BioPolymer.getQuaternionStraightness(id, dqprev, dq);
                            val2 = BioPolymer.getStraightness(id, dqprev, dq);
                            if (useQuaternionStraightness) {
                                aprev.getGroup().setStraightness(val1);
                            } else {
                                a.getGroup().setStraightness(val2);
                            }
                        }
                        dqprev = dq;
                    }
                    aprev = anext;
                    qprev = qnext;
                }
                if (q == null) {
                    atomno = Integer.MIN_VALUE;
                    continue;
                }
                switch (ctype) {
                    default: {
                        x = q.q1;
                        y = q.q2;
                        z = q.q3;
                        w = q.q0;
                        break;
                    }
                    case 'x': {
                        x = q.q0;
                        y = q.q1;
                        z = q.q2;
                        w = q.q3;
                        break;
                    }
                    case 'y': {
                        x = q.q3;
                        y = q.q0;
                        z = q.q1;
                        w = q.q2;
                        break;
                    }
                    case 'z': {
                        x = q.q2;
                        y = q.q3;
                        z = q.q0;
                        w = q.q1;
                    }
                }
                Point3f point3f = isAmino ? ((AminoMonomer)monomer).getQuaternionFrameCenter(qtype) : (ptCenter = p instanceof NucleicPolymer ? ((NucleicMonomer)monomer).getQuaternionFrameCenter(qtype) : new Point3f());
                if (isDraw) {
                    if (bsSelected != null && !bsSelected.get(a.getAtomIndex())) continue;
                    int deg = (int)(Math.acos(w) * 360.0 / Math.PI);
                    if (derivType == 0) {
                        Point3f ptH;
                        pdbATOM.append(q.draw(prefix, id, ptCenter, 1.0f));
                        if (qtype == 'n' && isAmino && (ptH = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            pdbATOM.append("draw " + prefix + "nh" + id + " width 0.1 " + Escape.escape(ptH) + "\n");
                        }
                    }
                    if (derivType == 1 && isAmino) {
                        pdbATOM.append(monomer.getHelixData(4112, qtype) + " color " + qColor[1]).append('\n');
                        continue;
                    }
                    pdbATOM.append("draw " + prefix + "a" + id + " VECTOR " + Escape.escape(ptCenter) + " {" + x * 2.0f + "," + y * 2.0f + "," + z * 2.0f + "}" + " \">" + deg + "\"").append(" color ").append(qColor[derivType]).append('\n');
                    continue;
                }
                strExtra = q.getInfo() + TextFormat.sprintf("  %10.5p %10.5p %10.5p", new Object[]{ptCenter});
                if (qtype == 'n' && isAmino) {
                    strExtra = strExtra + TextFormat.sprintf("  %10.5p %10.5p %10.5p", new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (derivType == 2 && !Float.isNaN(val1)) {
                    strExtra = strExtra + TextFormat.sprintf(" %10.5f %10.5f", new Object[]{new float[]{val1, val2}});
                }
            }
            if (pdbATOM == null) continue;
            pdbATOM.append(LabelToken.formatLabel(a, "ATOM  %5i %4a%1A%3n %1c%4R%1E   "));
            pdbATOM.append(TextFormat.sprintf("%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", new Object[]{a.getElementSymbol(false).toUpperCase(), strExtra, new float[]{x * factor, y * factor, z * factor, w * factor}}));
            if (atomno != Integer.MIN_VALUE) {
                pdbCONECT.append("CONECT");
                pdbCONECT.append(TextFormat.formatString("%5i", "i", atomno));
                pdbCONECT.append(TextFormat.formatString("%5i", "i", a.getAtomNumber()));
                pdbCONECT.append('\n');
                bsWritten.set(((Monomer)a.getGroup()).getLeadAtomIndex());
            }
            atomno = a.getAtomNumber();
        }
    }

    private static float getStraightness(String id, Quaternion dqprev, Quaternion dq) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(dqprev.dot(dq))) / Math.PI);
    }

    private static float getQuaternionStraightness(String id, Quaternion dqprev, Quaternion dq) {
        if (Logger.debugging) {
            Logger.debug(id + " getQuaternionStraightness " + dqprev + " " + dq + " " + (1.0 - 2.0 * Math.acos(Math.abs(dqprev.dot(dq))) / Math.PI));
        }
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(dqprev.dot(dq))) / Math.PI);
    }
}

