/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5Pr = 19;
    private static final byte H3T = 20;
    private static final byte O3Pr = 21;
    private static final byte C3Pr = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77};
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};

    public static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = NucleicMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingNucleicAtomIDs);
        if (offsets == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(offsets, (byte)19, firstAtomIndex, specialAtomIndexes[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(offsets, (byte)20, firstAtomIndex, specialAtomIndexes[89]);
        NucleicMonomer.checkOptional(offsets, (byte)18, firstAtomIndex, specialAtomIndexes[90]);
        NucleicMonomer.checkOptional(offsets, (byte)23, firstAtomIndex, specialAtomIndexes[75]);
        NucleicMonomer.checkOptional(offsets, (byte)24, firstAtomIndex, specialAtomIndexes[77]);
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (offsets[15] == -1 && (offsets[0] = offsets[18]) == -1) {
            offsets[0] = offsets[19];
        }
        this.hasRnaO2Prime = offsets[2] != -1;
        this.isPyrimidine = offsets[8] != -1;
        this.isPurine = offsets[9] != -1 && offsets[10] != -1 && offsets[11] != -1;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return this.offsets[17] != -1;
    }

    public byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[20] != -1 ? 20 : 21);
    }

    public void getBaseRing6Points(Point3f[] ring6Points) {
        int i = 6;
        while (--i >= 0) {
            ring6Points[i] = this.getAtomFromOffsetIndex(ring6OffsetIndexes[i]);
        }
    }

    public boolean maybeGetBaseRing5Points(Point3f[] ring5Points) {
        if (this.isPurine) {
            int i = 5;
            while (--i >= 0) {
                ring5Points[i] = this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]);
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        Atom myPhosphorusAtom = this.getAtomFromOffsetIndex(15);
        if (myPhosphorusAtom == null) {
            return false;
        }
        if (!(possiblyPreviousMonomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer other = (NucleicMonomer)possiblyPreviousMonomer;
        if (other.getAtomFromOffsetIndex(21).isBonded(myPhosphorusAtom)) {
            return true;
        }
        return super.isConnectedAfter(possiblyPreviousMonomer);
    }

    public void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
        int radius;
        Atom competitor = closest[0];
        Atom lead = this.getLeadAtom();
        Atom o5prime = this.getAtomFromOffsetIndex(19);
        Atom c3prime = this.getAtomFromOffsetIndex(22);
        int mar = madBegin / 2;
        if (mar < 1900) {
            mar = 1900;
        }
        if ((radius = this.scaleToScreen(lead.screenZ, mar)) < 4) {
            radius = 4;
        }
        if (this.isCursorOnTopOf(lead, x, y, radius, competitor) || this.isCursorOnTopOf(o5prime, x, y, radius, competitor) || this.isCursorOnTopOf(c3prime, x, y, radius, competitor)) {
            closest[0] = lead;
        }
    }

    public void setModelClickability() {
        Atom atom;
        if (this.isAtomHidden(this.getLeadAtomIndex())) {
            return;
        }
        int i = 6;
        while (--i >= 0) {
            atom = this.getAtomFromOffsetIndex(ring6OffsetIndexes[i]);
            atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
        }
        if (this.isPurine) {
            i = 5;
            while (--i >= 0) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]);
                atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
            }
        }
    }

    Point3f getQuaternionFrameCenter(char qType) {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    public Quaternion getQuaternion(char qType) {
        Atom ptB;
        Atom ptA;
        Point3f ptN = this.getQuaternionFrameCenter(qType);
        if (this.isPurine) {
            ptA = this.getAtomFromOffsetIndex(7);
            ptB = this.getAtomFromOffsetIndex(10);
        } else {
            ptA = this.getAtomFromOffsetIndex(5);
            ptB = this.getAtomFromOffsetIndex(1);
        }
        if (ptN == null || ptA == null || ptB == null) {
            return null;
        }
        Vector3f vA = new Vector3f(ptA);
        vA.sub(ptN);
        Vector3f vB = new Vector3f(ptB);
        vB.sub(ptN);
        return Quaternion.getQuaternionFrame(vA, vB, null);
    }
}

