/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;

public class PhosphorusMonomer
extends Monomer {
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0f;
    protected boolean isPurine;
    protected boolean isPyrimidine;

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes, Atom[] atoms) {
        if (firstIndex != lastIndex || specialAtomIndexes[13] != firstIndex) {
            return null;
        }
        return new PhosphorusMonomer(chain, group3, seqcode, firstIndex, lastIndex, phosphorusOffsets);
    }

    protected PhosphorusMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (group3.indexOf(84) >= 0) {
            chain.setIsDna(true);
        }
        if (group3.indexOf(85) + group3.indexOf(73) > -2) {
            chain.setIsRna(true);
        }
        this.isPurine = group3.indexOf(65) + group3.indexOf(71) + group3.indexOf(73) > -3;
        this.isPyrimidine = group3.indexOf(84) + group3.indexOf(67) + group3.indexOf(85) > -3;
    }

    boolean isPhosphorusMonomer() {
        return true;
    }

    public boolean isDna() {
        return this.chain.isDna();
    }

    public boolean isRna() {
        return this.chain.isRna();
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public Object getStructure() {
        return this.chain;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof PhosphorusMonomer)) {
            return false;
        }
        float distance = this.getLeadAtomPoint().distance(possiblyPreviousMonomer.getLeadAtomPoint());
        return distance <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }
}

