/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ProteinStructure {
    static int globalSerialID = 1000;
    AlphaPolymer apolymer;
    byte type;
    int monomerIndexFirst;
    int monomerIndexLast;
    int monomerCount;
    Point3f axisA;
    Point3f axisB;
    Vector3f axisUnitVector;
    final Vector3f vectorProjection = new Vector3f();
    Point3f[] segments;
    int uniqueID = ++globalSerialID;

    ProteinStructure(AlphaPolymer apolymer, byte type, int monomerIndex, int monomerCount, int id) {
        this.apolymer = apolymer;
        this.type = type;
        this.monomerIndexFirst = monomerIndex;
        this.addMonomer(monomerIndex + monomerCount - 1);
        if (Logger.debugging) {
            Logger.debug("Creating ProteinStructure " + this.uniqueID + " " + JmolConstants.getProteinStructureName(type) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + apolymer);
        }
    }

    void addMonomer(int index) {
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, index);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, index);
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    int removeMonomer(int monomerIndex) {
        if (monomerIndex > this.monomerIndexLast || monomerIndex < this.monomerIndexFirst) {
            return 0;
        }
        int ret = this.monomerIndexLast - monomerIndex;
        this.monomerIndexLast = Math.max(this.monomerIndexFirst, monomerIndex) - 1;
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
        return ret;
    }

    public void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new Point3f[this.monomerCount + 1];
        this.segments[this.monomerCount] = this.axisB;
        this.segments[0] = this.axisA;
        Vector3f axis = new Vector3f(this.axisUnitVector);
        axis.scale(this.axisB.distance(this.axisA) / (float)this.monomerCount);
        for (int i = 1; i < this.monomerCount; ++i) {
            Point3f point = this.segments[i] = new Point3f();
            point.set(this.segments[i - 1]);
            point.add(axis);
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndexFirst == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndexFirst - 1].isHelix() || this.apolymer.monomers[this.monomerIndexFirst - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int upperNeighborIndex = this.monomerIndexFirst + this.monomerCount;
        if (upperNeighborIndex == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[upperNeighborIndex].isHelix() || this.apolymer.monomers[upperNeighborIndex].isSheet();
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    public int getMonomerIndex() {
        return this.monomerIndexFirst;
    }

    public int getIndex(Monomer monomer) {
        Monomer[] monomers = this.apolymer.monomers;
        int i = this.monomerCount;
        while (--i >= 0 && monomers[this.monomerIndexFirst + i] != monomer) {
        }
        return i;
    }

    public Point3f[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    public Point3f getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public Point3f getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    Point3f getStructureMidPoint(int index) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[index];
    }

    public void getInfo(Hashtable info) {
        info.put("type", JmolConstants.getProteinStructureName(this.type));
        int[] leadAtomIndices = this.apolymer.getLeadAtomIndices();
        int[] iArray = new int[this.monomerCount];
        System.arraycopy(leadAtomIndices, this.monomerIndexFirst, iArray, 0, this.monomerCount);
        info.put("leadAtomIndices", iArray);
        this.calcAxis();
        if (this.axisA == null) {
            return;
        }
        info.put("axisA", this.axisA);
        info.put("axisB", this.axisB);
        info.put("axisUnitVector", this.axisUnitVector);
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }
}

