/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.viewer.JmolConstants;

public final class Resolver
implements JmolBioResolver {
    public Group distinguishAndPropagateGroup(Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex, int modelIndex, int[] specialAtomIndexes, byte[] specialAtomIDs, Atom[] atoms) {
        int lastAtomIndex = maxAtomIndex - 1;
        int distinguishingBits = 0;
        int i = JmolConstants.ATOMID_MAX;
        while (--i >= 0) {
            specialAtomIndexes[i] = Integer.MIN_VALUE;
        }
        if (specialAtomIDs != null) {
            i = maxAtomIndex;
            while (--i >= firstAtomIndex) {
                byte specialAtomID = specialAtomIDs[i];
                if (specialAtomID <= 0) continue;
                if (specialAtomID < 14) {
                    distinguishingBits |= 1 << specialAtomID;
                }
                specialAtomIndexes[specialAtomID] = i;
            }
        }
        if (lastAtomIndex < firstAtomIndex) {
            throw new NullPointerException();
        }
        if ((distinguishingBits & 0xE) == 14) {
            return AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        }
        if (distinguishingBits == 4) {
            return AlphaMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        }
        if ((distinguishingBits & 0x1FC0) == 8128) {
            return NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        }
        if (distinguishingBits == 8192) {
            return PhosphorusMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        }
        if (JmolConstants.checkCarbohydrate(group3)) {
            return CarbohydrateMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        }
        return null;
    }

    public Polymer buildBioPolymer(Group group, Group[] groups, int i, boolean checkPolymerConnections) {
        return group instanceof Monomer && ((Monomer)group).getBioPolymer() == null ? BioPolymer.allocateBioPolymer(groups, i, checkPolymerConnections) : null;
    }

    public void clearBioPolymers(Group[] groups, int groupCount, BitSet alreadyDefined) {
        for (int i = 0; i < groupCount; ++i) {
            Monomer monomer;
            Group group = groups[i];
            if (!(group instanceof Monomer) || (monomer = (Monomer)group).getBioPolymer() == null || alreadyDefined != null && alreadyDefined.get(monomer.getModelIndex())) continue;
            monomer.setBioPolymer(null, -1);
        }
    }
}

