/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jmol.api.JmolViewer;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Logger;

public class JmolPopupSwing
extends JmolPopup {
    JPopupMenu swingPopup;
    JMenu elementComputedMenu;
    JMenu mainMenu;
    static int MENUITEM_HEIGHT = 20;

    public JmolPopupSwing(JmolViewer viewer, boolean asPopup) {
        super(viewer, asPopup);
        if (asPopup) {
            this.swingPopup = new JPopupMenu("Jmol");
            this.build(this.swingPopup);
        } else {
            this.mainMenu = new JMenu("Jmol");
            this.build(this.mainMenu);
        }
    }

    void showPopupMenu(int x, int y) {
        if (this.display == null) {
            return;
        }
        try {
            this.swingPopup.show(this.display, x, y);
        }
        catch (Exception e) {
            System.out.println("popup error: " + e.getMessage());
        }
    }

    public void installMainMenu(Object objMenuBar) {
        if (objMenuBar instanceof JMenuBar) {
            JMenuBar mb = (JMenuBar)objMenuBar;
            mb.remove(0);
            mb.add((Component)this.mainMenu, 0);
        }
    }

    Object getParent(Object menu) {
        return ((JMenu)menu).getParent();
    }

    int getMenuItemHeight() {
        return MENUITEM_HEIGHT;
    }

    int getPosition(Object menu) {
        Object p = this.getParent(menu);
        if (p instanceof JPopupMenu) {
            int i = ((JPopupMenu)p).getComponentCount();
            while (--i >= 0) {
                if (((JPopupMenu)p).getComponent(i) != menu) continue;
                return i;
            }
        } else {
            int i = ((JMenu)p).getItemCount();
            while (--i >= 0) {
                if (((JMenu)p).getItem(i) != menu) continue;
                return i;
            }
        }
        return -1;
    }

    void insertMenuSubMenu(Object menu, Object subMenu, int index) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).insert((JMenu)subMenu, index);
        } else {
            ((JMenu)menu).insert((JMenu)subMenu, index);
        }
    }

    void createFrankPopup() {
        this.frankPopup = new JPopupMenu("Frank");
    }

    void showFrankMenu(int x, int y) {
        if (this.display == null) {
            return;
        }
        try {
            ((JPopupMenu)this.frankPopup).show(this.display, x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void resetFrankMenu() {
        JPopupMenu menu = (JPopupMenu)this.frankPopup;
        menu.removeAll();
    }

    void addToMenu(Object menu, JComponent item) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(item);
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).add(item);
        } else {
            Logger.warn("cannot add object to menu: " + menu);
        }
    }

    void addMenuSeparator(Object menu) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).addSeparator();
        } else {
            ((JMenu)menu).addSeparator();
        }
    }

    Object addMenuItem(Object menu, String entry, String script, String id) {
        JMenuItem jmi = new JMenuItem(entry);
        this.updateMenuItem(jmi, entry, script);
        jmi.addActionListener(this.mil);
        jmi.setName(id == null ? ((Component)menu).getName() + "." : id);
        this.addToMenu(menu, jmi);
        return jmi;
    }

    void setLabel(Object menu, String entry) {
        if (menu instanceof JMenuItem) {
            ((JMenuItem)menu).setLabel(entry);
        } else {
            ((JMenu)menu).setLabel(entry);
        }
    }

    String getId(Object menu) {
        return ((Component)menu).getName();
    }

    void setCheckBoxValue(Object source) {
        JCheckBoxMenuItem jcmi = (JCheckBoxMenuItem)source;
        this.setCheckBoxValue(jcmi.getActionCommand(), jcmi.getState());
    }

    void setCheckBoxState(Object item, boolean state) {
        ((JCheckBoxMenuItem)item).setState(state);
    }

    void updateMenuItem(Object menuItem, String entry, String script) {
        JMenuItem jmi = (JMenuItem)menuItem;
        jmi.setLabel(entry);
        jmi.setActionCommand(script);
    }

    Object addCheckboxMenuItem(Object menu, String entry, String basename, String id, boolean state) {
        JCheckBoxMenuItem jcmi = new JCheckBoxMenuItem(entry);
        jcmi.setState(state);
        jcmi.addItemListener(this.cmil);
        jcmi.setActionCommand(basename);
        jcmi.setName(id == null ? ((Component)menu).getName() + "." : id);
        this.addToMenu(menu, jcmi);
        return jcmi;
    }

    Object cloneMenu(Object menu) {
        return null;
    }

    void addMenuSubMenu(Object menu, Object subMenu) {
        this.addToMenu(menu, (JMenu)subMenu);
    }

    Object newMenu(String menuName, String id) {
        JMenu jm = new JMenu(menuName);
        jm.setName(id);
        jm.setAutoscrolls(true);
        return jm;
    }

    void setAutoscrolls(Object menu) {
        ((JMenu)menu).setAutoscrolls(true);
    }

    void renameMenu(Object menu, String newMenuName) {
        ((JMenu)menu).setLabel(newMenuName);
    }

    Object newComputedMenu(String key, String word) {
        if ("elementComputedMenu".equals(key)) {
            this.elementComputedMenu = new JMenu(word);
            return this.elementComputedMenu;
        }
        return new JMenu("unrecognized ComputedMenu:" + key);
    }

    int getMenuItemCount(Object menu) {
        return ((JMenu)menu).getItemCount();
    }

    void removeMenuItem(Object menu, int index) {
        ((JMenu)menu).remove(index);
    }

    void removeAll(Object menu) {
        ((JMenu)menu).removeAll();
    }

    void enableMenu(Object menu, boolean enable) {
        if (menu instanceof JMenuItem) {
            this.enableMenuItem(menu, enable);
            return;
        }
        try {
            ((JMenu)menu).setEnabled(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void enableMenuItem(Object item, boolean enable) {
        try {
            ((JMenuItem)item).setEnabled(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    long maxMemoryForNewerJvm() {
        return Runtime.getRuntime().maxMemory();
    }

    int availableProcessorsForNewerJvm() {
        return Runtime.getRuntime().availableProcessors();
    }

    String getMenuCurrent() {
        StringBuffer sb = new StringBuffer();
        Object menu = this.htMenus.get("popupMenu");
        this.getMenuCurrent(sb, 0, menu, "PopupMenu");
        return sb.toString();
    }

    private void getMenuCurrent(StringBuffer sb, int level, Object menu, String menuName) {
        String name = menuName;
        Component[] subMenus = menu instanceof JPopupMenu ? ((JPopupMenu)menu).getComponents() : ((JMenu)menu).getPopupMenu().getComponents();
        for (int i = 0; i < subMenus.length; ++i) {
            String flags;
            Component m = subMenus[i];
            if (m instanceof JMenu) {
                JMenu jm = (JMenu)m;
                name = jm.getName();
                flags = "enabled:" + jm.isEnabled();
                JmolPopupSwing.addCurrentItem(sb, 'M', level, name, jm.getText(), null, flags);
                this.getMenuCurrent(sb, level + 1, ((JMenu)m).getPopupMenu(), name);
                continue;
            }
            if (m instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)m;
                flags = "enabled:" + jmi.isEnabled();
                if (m instanceof JCheckBoxMenuItem) {
                    flags = flags + ";checked:" + ((JCheckBoxMenuItem)m).getState();
                }
                String script = this.fixScript(jmi.getName(), jmi.getActionCommand());
                JmolPopupSwing.addCurrentItem(sb, 'I', level, jmi.getName(), jmi.getText(), script, flags);
                continue;
            }
            JmolPopupSwing.addCurrentItem(sb, 'S', level, name, null, null, null);
        }
    }
}

