/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.MepCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.quantum.QuantumCalculation;

public class MepCalculation
extends QuantumCalculation
implements MepCalculationInterface {
    public MepCalculation() {
        this.rangeBohr = 15.0f;
    }

    public void calculate(VolumeDataInterface volumeData, BitSet bsSelected, Point3f[] atomCoordAngstroms, float[] charges) {
        this.voxelData = volumeData.getVoxelData();
        int[] countsXYZ = volumeData.getVoxelCounts();
        this.initialize(countsXYZ[0], countsXYZ[1], countsXYZ[2]);
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bsSelected, atomCoordAngstroms);
        this.processMep(charges);
    }

    private void processMep(float[] charges) {
        int atomIndex = this.qmAtoms.length;
        while (--atomIndex >= 0) {
            this.thisAtom = this.qmAtoms[atomIndex];
            if (this.thisAtom == null) continue;
            float charge = charges[atomIndex];
            System.out.println("process map for atom " + atomIndex + " nX,nY,nZ=" + this.nX + "," + this.nY + "," + this.nZ + " charge=" + charge);
            this.thisAtom.setXYZ(true);
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                float dX = this.X2[ix];
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    float dXY = dX + this.Y2[iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float d2 = dXY + this.Z2[iz];
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (d2 == 0.0f ? charge * Float.POSITIVE_INFINITY : charge / (float)Math.sqrt(d2));
                        if (iy != 2 || iz != 4 || ix != 0 && ix != 7) continue;
                        System.out.println("atom " + atomIndex + " " + this.thisAtom + " ix=" + ix + " data:" + this.voxelData[ix][iy][iz] + " x2 y2 z2 d2=" + this.X2[ix] + " " + this.Y2[iy] + " " + this.Z2[iz] + " " + d2);
                    }
                }
            }
        }
    }
}

