/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.FontLineShape;

public class Axes
extends FontLineShape {
    Point3f axisXY = new Point3f();
    float scale;
    private static final Point3f[] unitAxisPoints = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f)};
    final Point3f originPoint = new Point3f();
    final Point3f[] axisPoints = new Point3f[6];
    static final Point3f pt0 = new Point3f();
    final Point3f ptTemp;
    private static final float MIN_AXIS_LEN = 1.5f;
    Vector3f corner;

    public Axes() {
        int i = 6;
        while (--i >= 0) {
            this.axisPoints[i] = new Point3f();
        }
        this.ptTemp = new Point3f();
        this.corner = new Vector3f();
    }

    Point3f getOriginPoint(boolean isDataFrame) {
        return isDataFrame ? pt0 : this.originPoint;
    }

    Point3f getAxisPoint(int i, boolean isDataFrame) {
        if (!isDataFrame && this.axisXY.z == 0.0f) {
            return this.axisPoints[i];
        }
        this.ptTemp.set(this.axisPoints[i]);
        this.ptTemp.sub(this.originPoint);
        this.ptTemp.scale(0.5f);
        return this.ptTemp;
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if ("position" == propertyName) {
            this.axisXY = (Point3f)value;
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    public void initShape() {
        super.initShape();
        this.myType = "axes";
        this.font3d = this.g3d.getFont3D(14.0f);
        int axesMode = this.viewer.getAxesMode();
        if (axesMode == 2 && this.modelSet.getCellInfos() != null) {
            SymmetryInterface unitcell = this.viewer.getCurrentUnitCell();
            if (unitcell == null) {
                return;
            }
            Point3f[] vectors = unitcell.getUnitCellVertices();
            Point3f offset = unitcell.getCartesianOffset();
            this.originPoint.set(offset);
            this.scale = this.viewer.getAxesScale() / 2.0f;
            this.axisPoints[0].scaleAdd(this.scale, vectors[4], offset);
            this.axisPoints[1].scaleAdd(this.scale, vectors[2], offset);
            this.axisPoints[2].scaleAdd(this.scale, vectors[1], offset);
            return;
        }
        if (axesMode == 1) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.set(this.viewer.getBoundBoxCenter());
        }
        this.setScale(this.viewer.getAxesScale() / 2.0f);
    }

    public Object getProperty(String property, int index) {
        if (property.equals("axisPoints")) {
            return this.axisPoints;
        }
        if (property == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float scale) {
        this.scale = scale;
        this.corner.set(this.viewer.getBoundBoxCornerVector());
        int i = 6;
        while (--i >= 0) {
            Point3f axisPoint = this.axisPoints[i];
            axisPoint.set(unitAxisPoints[i]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                axisPoint.x *= this.corner.x * scale;
                axisPoint.y *= this.corner.y * scale;
                axisPoint.z *= this.corner.z * scale;
            }
            axisPoint.add(this.originPoint);
        }
    }

    public String getShapeState() {
        String axisState = this.axisXY.z == 0.0f ? "" : "  axes position [" + (int)this.axisXY.x + " " + (int)this.axisXY.y + (this.axisXY.z < 0.0f ? " %" : "") + "];\n";
        return super.getShapeState() + "  axisScale = " + this.viewer.getAxesScale() + ";\n" + axisState;
    }
}

