/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.shape.ShapeRenderer;

public class BallsRenderer
extends ShapeRenderer {
    int minZ;
    int maxZ;

    protected void render() {
        int z;
        int i;
        boolean renderBalls = !this.viewer.getWireframeRotation() || !this.viewer.getInMotion();
        this.slabbing = this.viewer.getSlabEnabled();
        if (this.slabbing) {
            this.minZ = this.g3d.getSlab();
            this.maxZ = this.g3d.getDepth();
        }
        Atom[] atoms = this.modelSet.atoms;
        int atomCount = this.modelSet.getAtomCount();
        for (i = 0; i < atomCount; ++i) {
            Group group = atoms[i].getGroup();
            group.setMinZ(Integer.MAX_VALUE);
            i = Math.max(group.getLastAtomIndex(), i);
        }
        i = atomCount;
        while (--i >= 0) {
            Group group;
            Atom atom = atoms[i];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            atom.transform(this.viewer);
            if (this.slabbing && this.g3d.isClippedZ(atom.screenZ)) {
                atom.setClickable(0);
                int r = atom.screenDiameter / 2;
                if (atom.screenZ < this.minZ - r || atom.screenZ > this.maxZ + r || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            }
            if ((group = atom.getGroup()) != null && (z = atom.screenZ - atom.screenDiameter / 2 - 2) < group.getMinZ()) {
                group.setMinZ(Math.max(1, z));
            }
            if (!renderBalls || atom.screenDiameter <= 0 || (atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || !this.g3d.setColix(atom.getColix())) continue;
            this.renderBall(atom);
        }
        if (this.modelSet.getAtomCount() > 0 && this.viewer.getShowNavigationPoint() && !this.isGenerator && this.g3d.setColix(this.viewer.getNavigationCentered() ? (short)23 : 10)) {
            Point3f T = new Point3f(this.viewer.getNavigationOffset());
            int x = Math.max(Math.min(this.viewer.getScreenWidth(), (int)T.x), 0);
            int y = Math.max(Math.min(this.viewer.getScreenHeight(), (int)T.y), 0);
            z = (int)T.z + 1;
            this.g3d.drawRect(x - 10, y, z, 0, 20, 1);
            this.g3d.drawRect(x, y - 10, z, 0, 1, 20);
            this.g3d.drawRect(x - 4, y - 4, z, 0, 10, 10);
        }
    }

    protected void renderBall(Atom atom) {
        this.g3d.fillSphereCentered(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }
}

