/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Halos;
import org.jmol.shape.ShapeRenderer;

public class HalosRenderer
extends ShapeRenderer {
    boolean isAntialiased;

    protected void render() {
        boolean showHiddenSelections;
        Halos halos = (Halos)this.shape;
        boolean selectDisplayTrue = this.viewer.getSelectionHaloEnabled();
        boolean bl = showHiddenSelections = selectDisplayTrue && this.viewer.getShowHiddenSelectionHalos();
        if (halos.mads == null && !selectDisplayTrue) {
            return;
        }
        this.isAntialiased = this.g3d.isAntialiased();
        Atom[] atoms = this.modelSet.atoms;
        BitSet bsSelected = selectDisplayTrue ? this.viewer.getSelectionSet() : null;
        int i = this.modelSet.getAtomCount();
        while (--i >= 0) {
            Atom atom = atoms[i];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            short mad = halos.mads == null ? (short)0 : halos.mads[i];
            short colix = halos.colixes == null || i >= halos.colixes.length ? (short)0 : halos.colixes[i];
            boolean isHidden = this.modelSet.isAtomHidden(i);
            if (selectDisplayTrue && bsSelected.get(i)) {
                if (isHidden && !showHiddenSelections) continue;
                if (mad == 0) {
                    mad = -1;
                }
                if (colix == 0) {
                    colix = halos.colixSelection;
                }
                if (colix == 2) {
                    colix = 23;
                } else if (colix == 0) {
                    colix = Graphics3D.getColixInherited(colix, atom.getColix());
                }
            } else {
                if (isHidden) continue;
                colix = Graphics3D.getColixInherited(colix, atom.getColix());
            }
            if (mad == 0) continue;
            this.render1(atom, mad, colix);
        }
    }

    void render1(Atom atom, short mad, short colix) {
        int haloWidth;
        float haloDiameter;
        int z = atom.screenZ;
        short diameter = mad;
        if (diameter < 0) {
            diameter = atom.screenDiameter;
            if (diameter == 0) {
                float ellipsemax = atom.getADPMinMax(true);
                if (ellipsemax > 0.0f) {
                    diameter = this.viewer.scaleToScreen(z, (int)(ellipsemax * 2000.0f));
                }
                if (diameter == 0) {
                    diameter = this.viewer.scaleToScreen(z, 500);
                }
            }
        } else {
            diameter = this.viewer.scaleToScreen(z, mad);
        }
        float d = diameter;
        if (this.isAntialiased) {
            d /= 2.0f;
        }
        if ((haloDiameter = d / 4.0f) < 4.0f) {
            haloDiameter = 4.0f;
        }
        if (haloDiameter > 10.0f) {
            haloDiameter = 10.0f;
        }
        haloDiameter = d + 2.0f * haloDiameter;
        if (this.isAntialiased) {
            haloDiameter *= 2.0f;
        }
        if ((haloWidth = (int)haloDiameter) <= 0) {
            return;
        }
        this.g3d.fillScreenedCircleCentered(colix, haloWidth, atom.screenX, atom.screenY, atom.screenZ);
    }
}

