/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Hover
extends TextShape {
    private static final String FONTFACE = "SansSerif";
    private static final String FONTSTYLE = "Plain";
    private static final int FONTSIZE = 12;
    Text hoverText;
    int atomIndex = -1;
    Point3i xy;
    String text;
    String labelFormat = "%U";
    String[] atomFormats;

    public void initShape() {
        super.initShape();
        this.isHover = true;
        Font3D font3d = this.g3d.getFont3D(FONTFACE, FONTSTYLE, 12.0f);
        short bgcolix = Graphics3D.getColix("#FFFFC3");
        short colix = 4;
        this.hoverText = new Text(this.g3d, font3d, null, colix, bgcolix, 0, 0, 1, Integer.MIN_VALUE, 1, 0.0f);
        this.currentObject = this.hoverText;
        this.hoverText.setAdjustForWindow(true);
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (Logger.debugging) {
            Logger.debug("Hover.setProperty(" + propertyName + "," + value + ")");
        }
        if ("target" == propertyName) {
            if (value == null) {
                this.atomIndex = -1;
            } else {
                this.atomIndex = (Integer)value;
                this.viewer.setStatusAtomHovered(this.atomIndex, this.viewer.getAtomInfoXYZ(this.atomIndex, false));
            }
            return;
        }
        if ("text" == propertyName) {
            this.text = (String)value;
            if (this.text != null && this.text.length() == 0) {
                this.text = null;
            }
            return;
        }
        if ("atomLabel" == propertyName) {
            String text = (String)value;
            if (text != null && text.length() == 0) {
                text = null;
            }
            int count = this.viewer.getAtomCount();
            if (this.atomFormats == null) {
                this.atomFormats = new String[count];
            }
            int i = count;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.atomFormats[i] = text;
            }
            return;
        }
        if ("xy" == propertyName) {
            this.xy = (Point3i)value;
            return;
        }
        if ("label" == propertyName) {
            this.labelFormat = (String)value;
            if (this.labelFormat != null && this.labelFormat.length() == 0) {
                this.labelFormat = null;
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.atomIndex = -1;
            return;
        }
        super.setProperty(propertyName, value, null);
    }

    public String getShapeState() {
        Hashtable temp = new Hashtable();
        int atomCount = this.viewer.getAtomCount();
        if (this.atomFormats != null) {
            int i = atomCount;
            while (--i >= 0) {
                if (this.atomFormats[i] == null) continue;
                Hover.setStateInfo(temp, i, "set hoverLabel " + Escape.escape(this.atomFormats[i]));
            }
        }
        return "\n  hover " + Escape.escape(this.labelFormat == null ? "" : this.labelFormat) + ";\n" + Hover.getShapeCommands(temp, null, atomCount);
    }
}

