/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.shape.Labels;
import org.jmol.shape.Object2d;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shape.Text;

public class LabelsRenderer
extends ShapeRenderer {
    byte fidPrevious;
    protected Font3D font3d;
    protected int ascent;
    protected int descent;
    private final float[] boxXY = new float[2];

    protected void render() {
        this.fidPrevious = 0;
        Labels labels = (Labels)this.shape;
        String[] labelStrings = labels.strings;
        short[] colixes = labels.colixes;
        short[] bgcolixes = labels.bgcolixes;
        byte[] fids = labels.fids;
        int[] offsets = labels.offsets;
        if (labelStrings == null) {
            return;
        }
        Atom[] atoms = this.modelSet.atoms;
        short backgroundColixContrast = this.viewer.getColixBackgroundContrast();
        int backgroundColor = this.viewer.getBackgroundArgb();
        float scalePixelsPerMicron = this.viewer.getFontScaling() ? this.viewer.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        float imageFontScaling = this.viewer.getImageFontScaling();
        int i = labelStrings.length;
        while (--i >= 0) {
            Text text;
            Group group;
            int zBox;
            short bgcolix;
            String label;
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(i) || (label = labelStrings[i]) == null || label.length() == 0) continue;
            short colix = colixes == null || i >= colixes.length ? (short)0 : colixes[i];
            if (Graphics3D.isColixTranslucent(colix = Graphics3D.getColixInherited(colix, atom.getColix()))) {
                colix = Graphics3D.getColixTranslucent(colix, false, 0.0f);
            }
            short s = bgcolix = bgcolixes == null || i >= bgcolixes.length ? (short)0 : bgcolixes[i];
            if (bgcolix == 0 && this.g3d.getColixArgb(colix) == backgroundColor) {
                colix = backgroundColixContrast;
            }
            if (!this.g3d.setColix(colix)) continue;
            byte fid = fids == null || i >= fids.length || fids[i] == 0 ? labels.zeroFontId : fids[i];
            int offsetFull = offsets == null || i >= offsets.length ? 0 : offsets[i];
            boolean labelsFront = (offsetFull & 0x20) != 0;
            boolean labelsGroup = (offsetFull & 0x10) != 0;
            int offset = offsetFull >> 8;
            int textAlign = Labels.getAlignment(offsetFull);
            int pointer = offsetFull & 3;
            int zSlab = atom.screenZ - atom.getScreenRadius() - 3;
            if (zSlab < 1) {
                zSlab = 1;
            }
            int n = labelsFront ? 1 : (zBox = labelsGroup && (group = atom.getGroup()) != null ? group.getMinZ() : zSlab);
            if (zBox < 1) {
                zBox = 1;
            }
            if ((text = labels.getLabel(i)) != null) {
                if (text.font == null) {
                    text.setFid(fid);
                }
                text.setXYZs(atom.screenX, atom.screenY, zBox, zSlab);
                text.setColix(colix);
                text.setBgColix(bgcolix);
            } else {
                boolean isSimple;
                boolean isLeft;
                boolean bl = isLeft = textAlign == 1 || textAlign == 0;
                if (fid != this.fidPrevious || this.ascent == 0) {
                    this.g3d.setFont(fid);
                    this.fidPrevious = fid;
                    this.font3d = this.g3d.getFont3DCurrent();
                    if (isLeft) {
                        FontMetrics fontMetrics = this.font3d.fontMetrics;
                        this.ascent = fontMetrics.getAscent();
                        this.descent = fontMetrics.getDescent();
                    }
                }
                boolean bl2 = isSimple = isLeft && imageFontScaling == 1.0f && scalePixelsPerMicron == 0.0f && label.indexOf("|") < 0 && label.indexOf("<su") < 0;
                if (isSimple) {
                    boolean doPointer = (pointer & 1) != 0;
                    short pointerColix = (pointer & 2) != 0 && bgcolix != 0 ? bgcolix : colix;
                    this.boxXY[0] = atom.screenX;
                    this.boxXY[1] = atom.screenY;
                    Text.renderSimpleLabel(this.g3d, this.font3d, label, colix, bgcolix, this.boxXY, zBox, zSlab, Object2d.getXOffset(offset), Object2d.getYOffset(offset), this.ascent, this.descent, doPointer, pointerColix);
                    continue;
                }
                text = new Text(this.g3d, this.font3d, label, colix, bgcolix, atom.screenX, atom.screenY, zBox, zSlab, textAlign, 0.0f);
                labels.putLabel(i, text);
            }
            text.setOffset(offset);
            if (textAlign != 0) {
                text.setAlignment(textAlign);
            }
            text.setPointer(pointer);
            text.render(this.g3d, scalePixelsPerMicron, imageFontScaling);
        }
    }
}

