/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.shape.Measures;
import org.jmol.util.Point3fi;

public class MeasuresRenderer
extends FontLineShapeRenderer {
    private short measurementMad;
    private Font3D font3d;
    private Measurement measurement;
    private boolean doJustify;
    Point3fi atomA;
    Point3fi atomB;
    Point3fi atomC;
    Point3fi atomD;
    private Point3i ptA = new Point3i();
    private Point3i ptB = new Point3i();
    private AxisAngle4f aaT = new AxisAngle4f();
    private Matrix3f matrixT = new Matrix3f();
    private Point3f pointT = new Point3f();

    protected void render() {
        if (!this.g3d.checkTranslucent(false)) {
            return;
        }
        this.imageFontScaling = this.viewer.getImageFontScaling();
        Measures measures = (Measures)this.shape;
        this.doJustify = this.viewer.getJustifyMeasurements();
        this.measurementMad = measures.mad;
        this.font3d = this.g3d.getFont3DScaled(measures.font3d, this.imageFontScaling);
        this.renderPendingMeasurement(measures.measurementPending);
        if (!this.viewer.getShowMeasurements()) {
            return;
        }
        boolean showMeasurementLabels = this.viewer.getShowMeasurementLabels();
        boolean dynamicMeasurements = this.viewer.getDynamicMeasurements();
        measures.setVisibilityInfo();
        int i = measures.measurementCount;
        while (--i >= 0) {
            Measurement m = measures.measurements[i];
            if (dynamicMeasurements || m.isDynamic()) {
                m.refresh();
            }
            if (!m.isVisible()) continue;
            this.colix = m.getColix();
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.viewer.getColixBackgroundContrast();
            }
            this.g3d.setColix(this.colix);
            this.renderMeasurement(m.getCount(), m, showMeasurementLabels);
        }
    }

    private Point3fi getAtom(int i) {
        Point3fi a = this.measurement.getAtom(i);
        if (a.screenDiameter < 0) {
            this.viewer.transformPoint((Point3f)a, this.ptA);
            a.screenX = this.ptA.x;
            a.screenY = this.ptA.y;
            a.screenZ = this.ptA.z;
        }
        return a;
    }

    private void renderMeasurement(int count, Measurement measurement, boolean renderLabel) {
        this.measurement = measurement;
        switch (count) {
            case 2: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.renderDistance(renderLabel);
                break;
            }
            case 3: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.renderAngle(renderLabel);
                break;
            }
            case 4: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.atomD = this.getAtom(4);
                this.renderTorsion(renderLabel);
            }
        }
        this.atomD = null;
        this.atomC = null;
        this.atomB = null;
        this.atomA = null;
    }

    private int drawSegment(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.ptA.set(x1, y1, z1);
        this.ptB.set(x2, y2, z2);
        if (this.measurementMad < 0) {
            this.g3d.drawDashedLine(4, 2, this.ptA, this.ptB);
            return 1;
        }
        short widthPixels = this.measurementMad;
        if (this.measurementMad >= 20) {
            widthPixels = this.viewer.scaleToScreen((z1 + z2) / 2, this.measurementMad);
        }
        this.g3d.fillCylinder((byte)2, widthPixels, this.ptA, this.ptB);
        return (widthPixels + 1) / 2;
    }

    void renderDistance(boolean renderLabel) {
        int y;
        int x;
        int zA = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int zB = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int radius = this.drawSegment(this.atomA.screenX, this.atomA.screenY, zA, this.atomB.screenX, this.atomB.screenY, zB);
        if (!renderLabel) {
            return;
        }
        int z = (zA + zB) / 2;
        if (z < 1) {
            z = 1;
        }
        this.paintMeasurementString(x, y, z, radius, ((x = (this.atomA.screenX + this.atomB.screenX) / 2) - this.atomA.screenX) * ((y = (this.atomA.screenY + this.atomB.screenY) / 2) - this.atomA.screenY) > 0, 0);
    }

    private void renderAngle(boolean renderLabel) {
        int zOffset = this.atomB.screenDiameter + 10;
        int zA = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int zB = this.atomB.screenZ - zOffset;
        int zC = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int radius = this.drawSegment(this.atomA.screenX, this.atomA.screenY, zA, this.atomB.screenX, this.atomB.screenY, zB);
        radius += this.drawSegment(this.atomB.screenX, this.atomB.screenY, zB, this.atomC.screenX, this.atomC.screenY, zC);
        if (!renderLabel) {
            return;
        }
        radius = (radius + 1) / 2;
        AxisAngle4f aa = this.measurement.getAxisAngle();
        if (aa == null) {
            int offset = (int)(5.0f * this.imageFontScaling);
            this.paintMeasurementString(this.atomB.screenX + offset, this.atomB.screenY - offset, zB, radius, false, 0);
            return;
        }
        int dotCount = (int)((double)aa.angle / (Math.PI * 2) * 64.0);
        float stepAngle = aa.angle / (float)dotCount;
        this.aaT.set(aa);
        int iMid = dotCount / 2;
        Point3f ptArc = this.measurement.getPointArc();
        int i = dotCount;
        while (--i >= 0) {
            this.aaT.angle = (float)i * stepAngle;
            this.matrixT.set(this.aaT);
            this.pointT.set(ptArc);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            Point3i point3iScreenTemp = this.viewer.transformPoint(this.pointT);
            int zArc = point3iScreenTemp.z - zOffset;
            if (zArc < 0) {
                zArc = 0;
            }
            this.g3d.drawPixel(point3iScreenTemp.x, point3iScreenTemp.y, zArc);
            if (i != iMid) continue;
            this.pointT.set(ptArc);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            this.viewer.transformPoint(this.pointT);
            int zLabel = point3iScreenTemp.z - zOffset;
            this.paintMeasurementString(point3iScreenTemp.x, point3iScreenTemp.y, zLabel, radius, point3iScreenTemp.x < this.atomB.screenX, this.atomB.screenY);
        }
    }

    private void renderTorsion(boolean renderLabel) {
        int zA = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int zB = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int zC = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int zD = this.atomD.screenZ - this.atomD.screenDiameter - 10;
        int radius = this.drawSegment(this.atomA.screenX, this.atomA.screenY, zA, this.atomB.screenX, this.atomB.screenY, zB);
        radius += this.drawSegment(this.atomB.screenX, this.atomB.screenY, zB, this.atomC.screenX, this.atomC.screenY, zC);
        radius += this.drawSegment(this.atomC.screenX, this.atomC.screenY, zC, this.atomD.screenX, this.atomD.screenY, zD);
        if (!renderLabel) {
            return;
        }
        this.paintMeasurementString((this.atomA.screenX + this.atomB.screenX + this.atomC.screenX + this.atomD.screenX) / 4, (this.atomA.screenY + this.atomB.screenY + this.atomC.screenY + this.atomD.screenY) / 4, (zA + zB + zC + zD) / 4, radius /= 3, false, 0);
    }

    private void paintMeasurementString(int x, int y, int z, int radius, boolean rightJustify, int yRef) {
        String strMeasurement;
        if (!this.doJustify) {
            rightJustify = false;
            yRef = y;
        }
        if ((strMeasurement = this.measurement.getString()) == null) {
            return;
        }
        int width = this.font3d.fontMetrics.stringWidth(strMeasurement);
        int height = this.font3d.fontMetrics.getAscent();
        int xT = x;
        xT = rightJustify ? (xT -= radius / 2 + 2 + width) : (xT += radius / 2 + 2);
        int yT = y + (yRef == 0 || yRef < y ? height : -radius / 2);
        int zT = z - radius - 2;
        if (zT < 1) {
            zT = 1;
        }
        this.g3d.drawString(strMeasurement, this.font3d, xT, yT, zT, zT);
    }

    private void renderPendingMeasurement(MeasurementPending measurementPending) {
        if (this.isGenerator || measurementPending == null) {
            return;
        }
        int count = measurementPending.getCount();
        if (count == 0) {
            return;
        }
        this.g3d.setColix(this.viewer.getColixRubberband());
        measurementPending.refresh();
        if (measurementPending.haveTarget()) {
            this.renderMeasurement(count, measurementPending, true);
        } else {
            this.renderPendingWithCursor(count, measurementPending);
        }
    }

    private void renderPendingWithCursor(int count, MeasurementPending measurementPending) {
        if (count > 1) {
            this.renderMeasurement(count, measurementPending, false);
        }
        this.measurement = measurementPending;
        Point3fi atomLast = this.getAtom(count);
        int lastZ = atomLast.screenZ - atomLast.screenDiameter - 10;
        int x = this.viewer.getCursorX();
        int y = this.viewer.getCursorY();
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        this.drawSegment(atomLast.screenX, atomLast.screenY, lastZ, x, y, 0);
    }
}

