/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;

public class Mesh {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    private JmolRendererInterface g3d;
    public String[] title = null;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public boolean visible = true;
    public short colix;
    public int vertexCount;
    public Point3f[] vertices;
    public short[] normixes;
    public int polygonCount;
    public int[][] polygonIndexes = null;
    public float scale = 1.0f;
    public boolean haveXyPoints;
    public int diameter;
    public float width;
    public Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    public String meshType = null;
    public Mesh linkedMesh = null;
    public BitSet[] bitsets;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean isColorSolid = true;
    public boolean havePlanarContours = false;
    public static final int SEED_COUNT = 25;
    public int lighting = 1073741843;
    public final Vector3f vAB = new Vector3f();
    public final Vector3f vAC = new Vector3f();
    public final Vector3f vTemp = new Vector3f();
    protected boolean haveCheckByte;
    public Vector data1;
    public Vector data2;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh() {
    }

    public Mesh(String thisID, JmolRendererInterface g3d, short colix) {
        if (PREVIOUS_MESH_ID.equals(thisID)) {
            thisID = null;
        }
        this.thisID = thisID;
        this.g3d = g3d;
        this.colix = colix;
    }

    public void clear(String meshType) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.vertices = null;
        this.polygonIndexes = null;
        this.havePlanarContours = false;
        this.showPoints = false;
        this.showContourLines = false;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.showTriangles = false;
        this.frontOnly = false;
        this.meshType = meshType;
    }

    public void initialize(int lighting) {
        Vector3f[] vectorSums = this.getVertexNormals();
        this.normixes = new short[this.vertexCount];
        this.initializeNormixes(lighting, vectorSums);
    }

    public Vector3f[] getVertexNormals() {
        Vector3f[] vectorSums = new Vector3f[this.vertexCount];
        int i = this.vertexCount;
        while (--i >= 0) {
            vectorSums[i] = new Vector3f();
        }
        this.sumVertexNormals(vectorSums);
        i = this.vertexCount;
        while (--i >= 0) {
            vectorSums[i].normalize();
        }
        return vectorSums;
    }

    public void initializeNormixes(int lighting, Vector3f[] vectorSums) {
        this.isTwoSided = lighting == 1073741845;
        this.normixes = new short[this.vertexCount];
        int i = this.vertexCount;
        while (--i >= 0) {
            this.normixes[i] = this.g3d.getNormix(vectorSums[i]);
        }
        this.lighting = 1073741843;
        if (this.insideOut) {
            this.invertNormixes();
        }
        this.setLighting(lighting);
    }

    public void setLighting(int lighting) {
        if (lighting == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = lighting;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int lighting) {
        if (lighting == 1073741845) {
            int i = this.vertexCount;
            while (--i >= 0) {
                this.normixes[i] = ~this.normixes[i];
            }
        } else if (lighting == 1073741843 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        int i = this.vertexCount;
        while (--i >= 0) {
            this.normixes[i] = this.g3d.getInverseNormix(this.normixes[i]);
        }
    }

    public void setTranslucent(boolean isTranslucent, float iLevel) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, isTranslucent, iLevel);
    }

    public void sumVertexNormals(Vector3f[] vectorSums) {
        int adjustment = this.haveCheckByte ? 1 : 0;
        int i = this.polygonCount;
        while (--i >= 0) {
            int[] pi = this.polygonIndexes[i];
            try {
                if (pi == null) continue;
                Graphics3D.calcNormalizedNormal(this.vertices[pi[0]], this.vertices[pi[1]], this.vertices[pi[2]], this.vTemp, this.vAB, this.vAC);
                float l = this.vTemp.length();
                if (!((double)l > 0.9) || !((double)l < 1.1)) continue;
                int j = pi.length - adjustment;
                while (--j >= 0) {
                    int k = pi[j];
                    vectorSums[k].add(this.vTemp);
                }
            }
            catch (Exception e) {
            }
        }
    }

    public void setPolygonCount(int polygonCount) {
        this.polygonCount = polygonCount;
        if (polygonCount < 0) {
            return;
        }
        if (this.polygonIndexes == null || polygonCount > this.polygonIndexes.length) {
            this.polygonIndexes = new int[polygonCount][];
        }
    }

    public int addVertexCopy(Point3f vertex) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(vertex);
        return this.vertexCount++;
    }

    public void addTriangle(int vertexA, int vertexB, int vertexC) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC};
    }

    public void addQuad(int vertexA, int vertexB, int vertexC, int vertexD) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC, vertexD};
    }

    public void setColix(short colix) {
        this.colix = colix;
    }

    public String getState(String type) {
        StringBuffer s = new StringBuffer(type);
        if (!type.equals("mo")) {
            s.append(" ID ").append(Escape.escape(this.thisID));
        }
        s.append(this.fillTriangles ? " fill" : " noFill");
        s.append(this.drawTriangles ? " mesh" : " noMesh");
        s.append(this.showPoints ? " dots" : " noDots");
        s.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            s.append(" contourlines");
        }
        if (this.showTriangles) {
            s.append(" triangles");
        }
        s.append(this.lighting == 0x40000006 ? " backlit" : (this.lighting == 1073741845 ? " fullylit" : " frontlit"));
        if (!this.visible) {
            s.append(" hidden");
        }
        return s.toString();
    }
}

