/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.ShapeRenderer;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected Point3f[] vertices;
    protected short[] normixes;
    protected Point3i[] screens;
    protected Vector3f[] transformedVectors;
    protected int vertexCount;
    protected boolean frontOnly;
    protected boolean antialias;
    protected Mesh mesh;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected final Point3f pt1f = new Point3f();
    protected final Point3f pt2f = new Point3f();
    protected final Point3i pt1i = new Point3i();
    protected final Point3i pt2i = new Point3i();
    protected BitSet bsFaces = new BitSet();

    protected void render() {
        this.antialias = this.g3d.isAntialiased();
        MeshCollection mc = (MeshCollection)this.shape;
        int i = mc.meshCount;
        while (--i >= 0) {
            this.render1(mc.meshes[i]);
        }
    }

    public boolean render1(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.g3d.setColix(this.colix) && !mesh.showContourLines) {
            return mesh.title != null;
        }
        this.transform();
        this.render2();
        this.viewer.freeTempScreens(this.screens);
        return true;
    }

    private boolean setVariables() {
        this.slabbing = this.viewer.getSlabEnabled();
        this.vertices = this.mesh.vertices;
        this.colix = this.mesh.colix;
        if (this.mesh == null || this.mesh.visibilityFlags == 0 || (this.vertexCount = this.mesh.vertexCount) == 0 || this.mesh.polygonCount == 0) {
            return false;
        }
        this.normixes = this.mesh.normixes;
        if (this.normixes == null || this.vertices == null) {
            return false;
        }
        this.frontOnly = !this.slabbing && this.mesh.frontOnly && !this.mesh.isTwoSided;
        this.screens = this.viewer.allocTempScreens(this.vertexCount);
        this.transformedVectors = this.g3d.getTransformedVertexVectors();
        this.isTranslucent = Graphics3D.isColixTranslucent(this.mesh.colix);
        return true;
    }

    protected void transform() {
        int i = this.vertexCount;
        while (--i >= 0) {
            this.viewer.transformPoint(this.vertices[i], this.screens[i]);
        }
    }

    protected boolean isPolygonDisplayable(int i) {
        return true;
    }

    protected void render2() {
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (this.mesh.showPoints) {
            this.renderPoints();
        }
        if (this.mesh.drawTriangles) {
            this.renderTriangles(false, false);
        }
        if (this.mesh.fillTriangles) {
            this.renderTriangles(true, this.mesh.showTriangles);
        }
    }

    protected void renderPoints() {
        int i = this.vertexCount;
        while (--i >= 0) {
            if (this.frontOnly && !(this.transformedVectors[this.normixes[i]].z >= 0.0f)) continue;
            this.g3d.fillSphereCentered(4, this.screens[i]);
        }
    }

    protected void renderTriangles(boolean fill, boolean iShowTriangles) {
        boolean generateSet;
        int[][] polygonIndexes = this.mesh.polygonIndexes;
        this.colix = this.mesh.colix;
        this.g3d.setColix(this.colix);
        boolean bl = generateSet = this.isGenerator && fill;
        if (generateSet) {
            this.frontOnly = false;
            this.bsFaces.clear();
        }
        int i = this.mesh.polygonCount;
        while (--i >= 0) {
            if (!this.isPolygonDisplayable(i)) continue;
            int[] vertexIndexes = polygonIndexes[i];
            int iA = vertexIndexes[0];
            int iB = vertexIndexes[1];
            int iC = vertexIndexes[2];
            if (iB == iC) {
                this.drawLine(iA, iB, fill);
                continue;
            }
            switch (vertexIndexes.length) {
                case 3: {
                    if (this.frontOnly && this.transformedVectors[this.normixes[iA]].z < 0.0f && this.transformedVectors[this.normixes[iB]].z < 0.0f && this.transformedVectors[this.normixes[iC]].z < 0.0f) break;
                    if (fill) {
                        if (generateSet) {
                            this.bsFaces.set(i);
                            break;
                        }
                        if (iShowTriangles) {
                            this.g3d.fillTriangle(this.screens[iA], this.colix, this.normixes[iA], this.screens[iB], this.colix, this.normixes[iB], this.screens[iC], this.colix, this.normixes[iC], 0.1f);
                            break;
                        }
                        this.g3d.fillTriangle(this.screens[iA], this.colix, this.normixes[iA], this.screens[iB], this.colix, this.normixes[iB], this.screens[iC], this.colix, this.normixes[iC]);
                        break;
                    }
                    this.g3d.drawTriangle(this.screens[iA], this.screens[iB], this.screens[iC], 7);
                    break;
                }
                case 4: {
                    int iD = vertexIndexes[3];
                    if (this.frontOnly && this.transformedVectors[this.normixes[iA]].z < 0.0f && this.transformedVectors[this.normixes[iB]].z < 0.0f && this.transformedVectors[this.normixes[iC]].z < 0.0f && this.transformedVectors[this.normixes[iD]].z < 0.0f) break;
                    if (fill) {
                        if (generateSet) {
                            this.bsFaces.set(i);
                            break;
                        }
                        this.g3d.fillQuadrilateral(this.screens[iA], this.colix, this.normixes[iA], this.screens[iB], this.colix, this.normixes[iB], this.screens[iC], this.colix, this.normixes[iC], this.screens[iD], this.colix, this.normixes[iD]);
                        break;
                    }
                    this.g3d.drawQuadrilateral(this.colix, this.screens[iA], this.screens[iB], this.screens[iC], this.screens[iD]);
                }
            }
        }
        if (generateSet) {
            this.renderExport();
        }
    }

    protected void drawLine(int iA, int iB, boolean fill) {
        byte endCap;
        byte by = iA != iB && !fill ? (byte)0 : (endCap = this.width < 0.0f || iA != iB && this.isTranslucent ? (byte)2 : 3);
        if (this.diameter == 0) {
            int n = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = iA == iB ? 6 : 3);
        }
        if (this.width == 0.0f) {
            this.g3d.fillCylinder(endCap, this.diameter, this.screens[iA], this.screens[iB]);
        } else {
            this.pt1f.set(this.vertices[iA]);
            this.pt1f.add(this.vertices[iB]);
            this.pt1f.scale(0.5f);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            this.diameter = this.viewer.scaleToScreen(this.pt1i.z, (int)(Math.abs(this.width) * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
            this.viewer.transformPoint(this.vertices[iA], this.pt1f);
            this.viewer.transformPoint(this.vertices[iB], this.pt2f);
            if (this.mesh.scale == 0.0f || this.mesh.haveXyPoints) {
                // empty if block
            }
            this.g3d.fillCylinderBits(endCap, this.diameter, this.pt1f, this.pt2f);
        }
    }

    protected void renderExport() {
        this.g3d.renderIsosurface(this.mesh.vertices, this.mesh.colix, null, this.mesh.getVertexNormals(), this.mesh.polygonIndexes, this.bsFaces, this.mesh.vertexCount, 4, null, this.mesh.polygonCount);
    }
}

