/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shape.Stars;

public class StarsRenderer
extends ShapeRenderer {
    protected void render() {
        Stars stars = (Stars)this.shape;
        if (stars.mads == null) {
            return;
        }
        Atom[] atoms = this.modelSet.atoms;
        int i = this.modelSet.getAtomCount();
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(i)) continue;
            this.colix = Shape.getColix(stars.colixes, i, atom);
            if (!this.g3d.setColix(this.colix)) continue;
            this.render1(atom, stars.mads[i]);
        }
    }

    void render1(Atom atom, short mad) {
        int x = atom.screenX;
        int y = atom.screenY;
        int z = atom.screenZ;
        int d = this.viewer.scaleToScreen(z, mad);
        d -= d & 1 ^ 1;
        int r = d / 2;
        this.g3d.drawLine(x - r, y, z, x - r + d, y, z);
        this.g3d.drawLine(x, y - r, z, x, y - r + d, z);
    }
}

