/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.HBond;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Sticks
extends Shape {
    short myMask;
    boolean reportAll;
    BitSet bsOrderSet;
    BitSet bsSizeSet;
    BitSet bsColixSet;
    BitSet selectedBonds;
    private static final int MAX_BOND_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();

    public void initShape() {
        super.initShape();
        this.myMask = (short)1023;
        this.reportAll = false;
    }

    public void setSize(int size, BitSet bsSelected) {
        if (size == Integer.MAX_VALUE) {
            this.selectedBonds = bsSelected == null ? null : BitSetUtil.copy(bsSelected);
            return;
        }
        if (size == Integer.MIN_VALUE) {
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            this.bsOrderSet.or(bsSelected);
            return;
        }
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        BondIterator iter = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bsSelected);
        short mad = (short)size;
        while (iter.hasNext()) {
            this.bsSizeSet.set(iter.nextIndex());
            iter.next().setMad(mad);
        }
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (Logger.debugging) {
            Logger.debug(propertyName + " " + value + " " + bsSelected);
        }
        if ("type" == propertyName) {
            this.myMask = ((Integer)value).shortValue();
            return;
        }
        if ("reportAll" == propertyName) {
            this.reportAll = true;
            return;
        }
        if ("reset" == propertyName) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            this.selectedBonds = null;
            return;
        }
        if ("bondOrder" == propertyName) {
            BondIterator iter;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            short order = (Short)value;
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator((short)16383, bsSelected);
            while (iter.hasNext()) {
                this.bsOrderSet.set(iter.nextIndex());
                iter.next().setOrder(order);
            }
            return;
        }
        if ("color" == propertyName) {
            BondIterator iter;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short colix = Graphics3D.getColix(value);
            byte pid = JmolConstants.pidOf(value);
            if (pid == 18 || pid == 19) {
                BondIterator iter2;
                boolean isEnergy = pid == 19;
                BondIterator bondIterator = iter2 = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bsSelected);
                while (iter2.hasNext()) {
                    this.bsColixSet.set(iter2.nextIndex());
                    Bond bond = iter2.next();
                    if (isEnergy) {
                        bond.setColix(this.setColix(colix, pid, bond));
                        ((HBond)bond).setPaletteID(pid);
                        continue;
                    }
                    bond.setColix(Graphics3D.getColix(JmolConstants.getArgbHbondType(bond.getOrder())));
                }
                return;
            }
            if (colix == 2 && pid != 1) {
                return;
            }
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bsSelected);
            while (iter.hasNext()) {
                int iBond = iter.nextIndex();
                Bond bond = iter.next();
                bond.setColix(colix);
                this.bsColixSet.set(iBond, colix != 0 && colix != 2);
            }
            return;
        }
        if ("translucency" == propertyName) {
            BondIterator iter;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            boolean isTranslucent = ((String)value).equals("translucent");
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bsSelected);
            while (iter.hasNext()) {
                this.bsColixSet.set(iter.nextIndex());
                iter.next().setTranslucent(isTranslucent, this.translucentLevel);
            }
            return;
        }
        if ("deleteModelAtoms" == propertyName) {
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    public Object getProperty(String property, int index) {
        if (property.equals("selectionState")) {
            return this.selectedBonds != null ? "select BONDS " + Escape.escape(this.selectedBonds) + "\n" : "";
        }
        if (property.equals("sets")) {
            return new BitSet[]{this.bsOrderSet, this.bsSizeSet, this.bsColixSet};
        }
        return null;
    }

    public void setModelClickability() {
        Bond[] bonds = this.modelSet.getBonds();
        int i = this.modelSet.getBondCount();
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(bond.getAtomIndex1()) || this.modelSet.isAtomHidden(bond.getAtomIndex2())) continue;
            bond.getAtom1().setClickable(this.myVisibilityFlag);
            bond.getAtom2().setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        boolean haveTainted = false;
        Bond[] bonds = this.modelSet.getBonds();
        int i = this.modelSet.getBondCount();
        while (--i >= 0) {
            Bond bond = bonds[i];
            if (this.reportAll || this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                short r;
                Sticks.setStateInfo(temp, i, "wireframe " + ((r = bond.getMad()) == 1 ? "on" : "" + (float)r / 2000.0f));
            }
            if (this.reportAll || this.bsOrderSet != null && this.bsOrderSet.get(i) && (bond.getOrder() & Short.MIN_VALUE) == 0) {
                Sticks.setStateInfo(temp, i, "bondOrder " + JmolConstants.getBondOrderNameFromOrder(bond.getOrder()));
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            short colix = bond.getColix();
            if ((colix & 0xFFFF87FF) == 2) {
                Sticks.setStateInfo(temp, i, this.getColorCommand("bonds", (byte)1, colix));
                continue;
            }
            Sticks.setStateInfo(temp, i, this.getColorCommand("bonds", colix));
        }
        return Sticks.getShapeCommands(temp, null, -1, "select BONDS") + "\n" + (haveTainted ? Sticks.getShapeCommands(temp2, null, -1, "select BONDS") + "\n" : "");
    }

    public Point3f checkObjectClicked(int x, int y, int modifiers, BitSet bsVisible) {
        Point3f pt = new Point3f();
        Bond bond = this.findPickedBond(x, y, bsVisible, pt);
        if (bond == null) {
            return null;
        }
        this.viewer.setStatusAtomPicked(-3, "[\"bond\",\"" + bond.getIdentity() + "\"," + pt.x + "," + pt.y + "," + pt.z + "]");
        return pt;
    }

    private Bond findPickedBond(int x, int y, BitSet bsVisible, Point3f pt) {
        int dmin2 = 100;
        if (this.g3d.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        Bond pickedBond = null;
        Point3f v = new Point3f();
        Bond[] bonds = this.modelSet.getBonds();
        int i = this.modelSet.getBondCount();
        while (--i >= 0) {
            Bond bond = bonds[i];
            if (bond.getShapeVisibilityFlags() == 0) continue;
            Atom atom1 = bond.getAtom1();
            Atom atom2 = bond.getAtom2();
            if (!atom1.isVisible() || !atom2.isVisible()) continue;
            v.set(atom1);
            v.add(atom2);
            v.scale(0.5f);
            int d2 = this.coordinateInRange(x, y, v, dmin2);
            if (d2 < 0) continue;
            dmin2 = d2;
            pickedBond = bond;
            pt.set(v);
        }
        return pickedBond;
    }

    private int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        this.viewer.transformPoint(vertex, this.ptXY);
        int d2 = (x - this.ptXY.x) * (x - this.ptXY.x) + (y - this.ptXY.y) * (y - this.ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }
}

