/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import java.awt.Image;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Object2d;
import org.jmol.shape.Shape;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class Text
extends Object2d {
    private float fontScale;
    private String text;
    private String textUnformatted;
    private boolean doFormatText;
    private String[] lines;
    Font3D font;
    private FontMetrics fm;
    private byte fid;
    private int ascent;
    private int descent;
    private int lineHeight;
    private int textWidth;
    private int textHeight;
    private int[] widths;
    Image image;

    public void setScalePixelsPerMicron(float scalePixelsPerMicron) {
        this.fontScale = 0.0f;
        super.setScalePixelsPerMicron(scalePixelsPerMicron);
    }

    Text(JmolRendererInterface g3d, Font3D font, String text, short colix, short bgcolix, int x, int y, int z, int zSlab, int textAlign, float scalePixelsPerMicron) {
        this.scalePixelsPerMicron = scalePixelsPerMicron;
        this.viewer = null;
        this.g3d = g3d;
        this.isLabelOrHover = true;
        this.setText(text);
        this.colix = colix;
        this.bgcolix = bgcolix;
        this.setXYZs(x, y, z, zSlab);
        this.align = textAlign;
        this.setFont(font);
    }

    Text(Viewer viewer, Graphics3D g3d, Font3D font, String target, short colix, int valign, int align, float scalePixelsPerMicron) {
        super(viewer, g3d, target, colix, valign, align, scalePixelsPerMicron);
        this.font = font;
        this.getFontMetrics();
    }

    private void getFontMetrics() {
        this.fm = this.font.fontMetrics;
        this.descent = this.fm.getDescent();
        this.ascent = this.fm.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    void setFid(byte fid) {
        if (this.fid == fid) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(Font3D.getFont3D(fid));
    }

    void setText(String text) {
        this.image = null;
        text = this.fixText(text);
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.textUnformatted = text;
        boolean bl = this.doFormatText = this.viewer != null && text != null && (text.indexOf("%{") >= 0 || text.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.recalc();
    }

    void setFont(Font3D f3d) {
        this.font = f3d;
        if (this.font == null) {
            return;
        }
        this.fid = this.font.fid;
        this.getFontMetrics();
        this.recalc();
    }

    void setFontScale(float scale) {
        if (this.fontScale == scale) {
            return;
        }
        this.fontScale = scale;
        if (this.fontScale != 0.0f) {
            this.setFont(this.g3d.getFont3DScaled(this.font, scale));
        }
    }

    String fixText(String text) {
        int pt;
        if (text == null || text.length() == 0) {
            return null;
        }
        while ((pt = text.indexOf("\n")) >= 0) {
            text = text.substring(0, pt) + "|" + text.substring(pt + 1);
        }
        return text;
    }

    protected void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (float)this.image.getWidth(null) * this.fontScale;
            this.boxHeight = (float)this.image.getHeight(null) * this.fontScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.fm == null) {
            return;
        }
        this.lines = TextFormat.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int i = this.lines.length;
        while (--i >= 0) {
            this.widths[i] = this.stringWidth(this.lines[i]);
            this.textWidth = Math.max(this.textWidth, this.widths[i]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    private void formatText() {
        this.text = this.viewer == null ? this.textUnformatted : this.viewer.formatText(this.textUnformatted);
        this.recalc();
    }

    void render(JmolRendererInterface g3d, float scalePixelsPerMicron, float imageFontScaling) {
        if (this.text == null) {
            return;
        }
        this.setWindow(g3d, scalePixelsPerMicron);
        if (scalePixelsPerMicron != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(scalePixelsPerMicron / this.scalePixelsPerMicron);
        } else if (this.fontScale != imageFontScaling) {
            this.setFontScale(imageFontScaling);
        }
        if (this.doFormatText) {
            this.formatText();
        }
        if (this.isLabelOrHover) {
            this.boxXY[0] = this.movableX;
            this.boxXY[1] = this.movableY;
            Text.setBoxXY(this.boxWidth, this.boxHeight, (float)this.offsetX * imageFontScaling, (float)this.offsetY * imageFontScaling, this.boxXY);
        } else {
            this.setPosition(this.fontScale);
        }
        this.boxX = this.boxXY[0];
        this.boxY = this.boxXY[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0f, this.isLabelOrHover ? 16.0f * this.fontScale + (float)this.lineHeight : 0.0f, this.boxY - (float)this.textHeight);
        }
        if (this.image == null && this.bgcolix != 0 && g3d.setColix(this.bgcolix)) {
            Text.showBox(g3d, this.colix, this.bgcolix, (int)this.boxX, (int)this.boxY, this.z + 2, this.zSlab, (int)this.boxWidth, (int)this.boxHeight, this.fontScale, this.isLabelOrHover);
        }
        if (g3d.setColix(this.colix)) {
            if (this.image != null) {
                g3d.drawImage(this.image, (int)this.boxX, (int)this.boxY, this.z, this.zSlab, this.bgcolix, (int)this.boxWidth, (int)this.boxHeight);
            } else {
                int adj = this.fontScale >= 2.0f ? 8 : 4;
                int x0 = (int)this.boxX;
                switch (this.align) {
                    case 2: {
                        x0 = (int)((float)x0 + this.boxWidth / 2.0f);
                        break;
                    }
                    case 3: {
                        x0 = (int)((float)x0 + (this.boxWidth - (float)adj));
                        break;
                    }
                    default: {
                        x0 += adj;
                    }
                }
                float x = x0;
                float y = this.boxY + (float)this.ascent + (float)adj;
                for (int i = 0; i < this.lines.length; ++i) {
                    switch (this.align) {
                        case 2: {
                            x = x0 - this.widths[i] / 2;
                            break;
                        }
                        case 3: {
                            x = x0 - this.widths[i];
                        }
                    }
                    g3d.drawString(this.lines[i], this.font, (int)x, (int)y, this.z, this.zSlab);
                    y += (float)this.lineHeight;
                }
            }
        }
        this.drawPointer(g3d);
    }

    private void setPosition(float scale) {
        float xLeft;
        float xRight;
        float xCenter;
        boolean is3dEcho;
        boolean bl = is3dEcho = this.xyz != null;
        if (this.valign == 0 || this.valign == 4) {
            float x = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (is3dEcho ? (float)this.movableX : (float)this.movableX * scale);
            float offsetX = (float)this.offsetX * scale;
            xRight = xCenter = x + offsetX;
            xLeft = xCenter;
        } else {
            xLeft = 5.0f * scale;
            xCenter = this.windowWidth / 2;
            xRight = (float)this.windowWidth - xLeft;
        }
        this.boxXY[0] = xLeft;
        switch (this.align) {
            case 2: {
                this.boxXY[0] = xCenter - this.boxWidth / 2.0f;
                break;
            }
            case 3: {
                this.boxXY[0] = xRight - this.boxWidth;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                float y = this.movableYPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (is3dEcho ? (float)this.movableY : (float)this.movableY * scale);
                this.boxXY[1] = (is3dEcho ? y : (float)this.windowHeight - y) + (float)this.offsetY * scale;
            }
        }
        if (this.align == 2) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (float)this.ascent - this.boxHeight)) / 2.0f;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0f;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (float)(this.ascent / 2);
        }
    }

    private static void setBoxXY(float boxWidth, float boxHeight, float xOffset, float yOffset, float[] boxXY) {
        float xBoxOffset;
        if (xOffset > 0.0f) {
            xBoxOffset = xOffset;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = xOffset == 0.0f ? (xBoxOffset /= 2.0f) : (xBoxOffset += xOffset);
        }
        float yBoxOffset = yOffset > 0.0f ? yOffset : (yOffset == 0.0f ? -boxHeight / 2.0f : -boxHeight + yOffset);
        boxXY[0] = boxXY[0] + xBoxOffset;
        boxXY[1] = boxXY[1] + yBoxOffset;
    }

    private static void showBox(JmolRendererInterface g3d, short colix, short bgcolix, int x, int y, int z, int zSlab, int boxWidth, int boxHeight, float imageFontScaling, boolean atomBased) {
        g3d.fillRect(x, y, z, zSlab, boxWidth, boxHeight);
        g3d.setColix(colix);
        if (!atomBased) {
            return;
        }
        if (imageFontScaling >= 2.0f) {
            g3d.drawRect(x + 3, y + 3, z - 1, zSlab, boxWidth - 6, boxHeight - 6);
            g3d.drawRect(x + 4, y + 4, z - 1, zSlab, boxWidth - 8, boxHeight - 8);
        } else {
            g3d.drawRect(x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
        }
    }

    static final void renderSimpleLabel(JmolRendererInterface g3d, Font3D font, String strLabel, short colix, short bgcolix, float[] boxXY, int z, int zSlab, int xOffset, int yOffset, float ascent, int descent, boolean doPointer, short pointerColix) {
        float boxWidth = font.fontMetrics.stringWidth(strLabel) + 8;
        float boxHeight = ascent + (float)descent + 8.0f;
        int x0 = (int)boxXY[0];
        int y0 = (int)boxXY[1];
        Text.setBoxXY(boxWidth, boxHeight, xOffset, yOffset, boxXY);
        float x = boxXY[0];
        float y = boxXY[1];
        if (bgcolix != 0 && g3d.setColix(bgcolix)) {
            Text.showBox(g3d, colix, bgcolix, (int)x, (int)y, z, zSlab, (int)boxWidth, (int)boxHeight, 1.0f, true);
        } else {
            g3d.setColix(colix);
        }
        g3d.drawString(strLabel, font, (int)(x + 4.0f), (int)(y + 4.0f + ascent), z - 1, zSlab);
        if (doPointer) {
            g3d.setColix(pointerColix);
            if (xOffset > 0) {
                g3d.drawLine(x0, y0, zSlab, (int)x, (int)(y + boxHeight / 2.0f), zSlab);
            } else if (xOffset < 0) {
                g3d.drawLine(x0, y0, zSlab, (int)(x + boxWidth), (int)(y + boxHeight / 2.0f), zSlab);
            }
        }
    }

    public String getState() {
        StringBuffer s = new StringBuffer();
        if (this.text == null || this.isLabelOrHover || this.target.equals("error")) {
            return "";
        }
        boolean isImage = this.image != null;
        String strOff = null;
        switch (this.valign) {
            case 0: {
                strOff = this.movableXPercent == Integer.MAX_VALUE || this.movableYPercent == Integer.MAX_VALUE ? (this.movableXPercent == Integer.MAX_VALUE ? this.movableX + " " : this.movableXPercent + "% ") + (this.movableYPercent == Integer.MAX_VALUE ? this.movableY + "" : this.movableYPercent + "%") : "[" + this.movableXPercent + " " + this.movableYPercent + "%]";
            }
            case 4: {
                if (strOff == null) {
                    strOff = Escape.escape(this.xyz);
                }
                s.append("  set echo ").append(this.target).append(" ").append(strOff);
                if (this.align == 1) break;
                s.append(";  set echo ").append(this.target).append(" ").append(hAlignNames[this.align]);
                break;
            }
            default: {
                s.append("  set echo ").append(vAlignNames[this.valign]).append(" ").append(hAlignNames[this.align]);
            }
        }
        if (this.valign == 0 && this.movableZPercent != Integer.MAX_VALUE) {
            s.append(";  set echo ").append(this.target).append(" depth ").append(this.movableZPercent);
        }
        if (isImage) {
            s.append("; set echo ").append(this.target).append(" IMAGE /*file*/");
        } else {
            s.append("; echo ");
        }
        s.append(Escape.escape(this.textUnformatted));
        s.append(";\n");
        if (this.script != null) {
            s.append("  set echo ").append(this.target).append(" script ").append(Escape.escape(this.script)).append(";\n");
        }
        if (this.modelIndex >= 0) {
            s.append("  set echo ").append(this.target).append(" model ").append(this.viewer.getModelNumberDotted(this.modelIndex)).append(";\n");
        }
        s.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            s.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
        s.append("; color echo");
        if (Graphics3D.isColixTranslucent(this.colix)) {
            s.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.colix));
        }
        s.append(" [x").append(this.g3d.getHexColorFromIndex(this.colix)).append("]");
        if (this.bgcolix != 0) {
            s.append("; color echo background");
            if (Graphics3D.isColixTranslucent(this.bgcolix)) {
                s.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.bgcolix));
            }
            s.append(" [x").append(this.g3d.getHexColorFromIndex(this.bgcolix)).append("]");
        }
        s.append(";\n");
        return s.toString();
    }

    private int stringWidth(String str) {
        int w = 0;
        int f = 1;
        int subscale = 1;
        if (str == null) {
            return 0;
        }
        if (str.indexOf("<su") < 0) {
            return this.fm.stringWidth(str);
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == '<') {
                String s;
                if (i + 4 < len && ((s = str.substring(i, i + 5)).equals("<sub>") || s.equals("<sup>"))) {
                    i += 4;
                    f = subscale;
                    continue;
                }
                if (i + 5 < len && ((s = str.substring(i, i + 6)).equals("</sub>") || s.equals("</sup>"))) {
                    i += 5;
                    f = 1;
                    continue;
                }
            }
            w += this.fm.stringWidth(str.substring(i, i + 1)) * f;
        }
        return w;
    }
}

