/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.util.TextFormat;

public class UccageRenderer
extends FontLineShapeRenderer {
    NumberFormat nf;
    byte fid;
    boolean doLocalize;
    final Point3f[] screens = new Point3f[8];
    final Point3f[] verticesT = new Point3f[8];

    public UccageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screens[i] = new Point3f();
            this.verticesT[i] = new Point3f();
        }
    }

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        int mad = this.viewer.getObjectMad(5);
        this.colix = this.viewer.getObjectColix(5);
        if (mad == 0 || !this.g3d.setColix(this.colix) || this.viewer.isJmolDataFrame()) {
            return;
        }
        this.doLocalize = this.viewer.getUseNumberLocalization();
        this.render1(mad);
    }

    void render1(int mad) {
        SymmetryInterface[] cellInfos = this.modelSet.getCellInfos();
        if (cellInfos == null) {
            return;
        }
        SymmetryInterface symmetry = this.viewer.getCurrentUnitCell();
        if (symmetry == null) {
            return;
        }
        Point3f[] vertices = symmetry.getUnitCellVertices();
        Point3f offset = symmetry.getCartesianOffset();
        int i = 8;
        while (--i >= 0) {
            this.verticesT[i].add(vertices[i], offset);
        }
        Point3f[] axisPoints = this.viewer.getAxisPoints();
        boolean drawAllLines = this.viewer.getObjectMad(1) == 0 || this.viewer.getAxesScale() < 2.0f || axisPoints == null;
        this.render(mad, this.verticesT, this.screens, axisPoints, drawAllLines ? 0 : 3);
        if (this.viewer.getDisplayCellParameters() && !symmetry.isPeriodic()) {
            this.renderInfo(symmetry);
        }
    }

    private String nfformat(float x) {
        return this.doLocalize && this.nf != null ? this.nf.format(x) : TextFormat.formatDecimal(x, 3);
    }

    private void renderInfo(SymmetryInterface symmetry) {
        if (this.isGenerator || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
        }
        this.fid = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int lineheight = (int)(15.0f * this.imageFontScaling);
        int x = (int)(5.0f * this.imageFontScaling);
        int y = lineheight;
        String spaceGroup = symmetry.getSpaceGroupName();
        if (spaceGroup != null) {
            this.g3d.drawStringNoSlab(spaceGroup, null, x, y += lineheight, 0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(symmetry.getUnitCellInfo(0)) + "\u00c5", null, x, y += lineheight, 0);
        this.g3d.drawStringNoSlab("b=" + this.nfformat(symmetry.getUnitCellInfo(1)) + "\u00c5", null, x, y += lineheight, 0);
        this.g3d.drawStringNoSlab("c=" + this.nfformat(symmetry.getUnitCellInfo(2)) + "\u00c5", null, x, y += lineheight, 0);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(symmetry.getUnitCellInfo(3)) + "\u00b0", null, x, y += lineheight, 0);
        this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(symmetry.getUnitCellInfo(4)) + "\u00b0", null, x, y += lineheight, 0);
        this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(symmetry.getUnitCellInfo(5)) + "\u00b0", null, x, y += lineheight, 0);
    }
}

