/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public class Backbone
extends BioShapeCollection {
    BitSet bsSelected;

    public void initShape() {
        super.initShape();
        this.madOn = 1;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)2000;
        this.isActive = true;
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if ("bitset" == propertyName) {
            this.bsSelected = (BitSet)value;
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    public void setSize(int size, BitSet bsSelected) {
        boolean useThisBsSelected;
        short mad = (short)size;
        this.initialize();
        boolean bl = useThisBsSelected = this.bsSelected != null;
        if (useThisBsSelected) {
            bsSelected = this.bsSelected;
        }
        int iShape = this.bioShapes.length;
        while (--iShape >= 0) {
            boolean isVisible;
            BioShape bioShape = this.bioShapes[iShape];
            if (bioShape.monomerCount == 0) continue;
            boolean bondSelectionModeOr = this.viewer.getBondSelectionModeOr();
            int[] atomIndices = bioShape.bioPolymer.getLeadAtomIndices();
            boolean bl2 = isVisible = mad != 0;
            if (bioShape.bsSizeSet == null) {
                bioShape.bsSizeSet = new BitSet();
            }
            bioShape.isActive = true;
            int i = bioShape.monomerCount - 1;
            while (--i >= 0) {
                boolean wasVisible;
                int index1 = atomIndices[i];
                int index2 = atomIndices[i + 1];
                boolean isAtom1 = bsSelected.get(index1);
                boolean isAtom2 = bsSelected.get(index2);
                if (!(isAtom1 && isAtom2 || useThisBsSelected && isAtom1) && (!bondSelectionModeOr || !isAtom1 && !isAtom2)) continue;
                bioShape.monomers[i].setShapeVisibility(this.myVisibilityFlag, isVisible);
                Atom atomA = this.modelSet.getAtomAt(index1);
                Atom atomB = this.modelSet.getAtomAt(index2);
                boolean bl3 = wasVisible = bioShape.mads[i] != 0;
                if (wasVisible != isVisible) {
                    atomA.addDisplayedBackbone(this.myVisibilityFlag, isVisible);
                    atomB.addDisplayedBackbone(this.myVisibilityFlag, isVisible);
                }
                bioShape.mads[i] = mad;
                bioShape.bsSizeSet.set(i, isVisible);
                bioShape.bsSizeDefault.set(i, mad == -1);
            }
        }
        if (useThisBsSelected) {
            this.bsSelected = null;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int iShape = this.bioShapes.length;
        while (--iShape >= 0) {
            BioShape bioShape = this.bioShapes[iShape];
            int[] atomIndices = bioShape.bioPolymer.getLeadAtomIndices();
            int i = bioShape.monomerCount;
            while (--i >= 0) {
                Atom atom = this.modelSet.getAtomAt(atomIndices[i]);
                if (atom.getNBackbonesDisplayed() <= 0 || this.modelSet.isAtomHidden(i)) continue;
                atom.setClickable(this.myVisibilityFlag);
            }
        }
    }
}

