/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeRenderer;

public class BackboneRenderer
extends BioShapeRenderer {
    protected void renderBioShape(BioShape bioShape) {
        int i = this.monomerCount - 1;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            Atom atomA = this.modelSet.getAtomAt(this.leadAtomIndices[i]);
            Atom atomB = this.modelSet.getAtomAt(this.leadAtomIndices[i + 1]);
            if (atomA.getNBackbonesDisplayed() == 0 || atomB.getNBackbonesDisplayed() == 0 || this.modelSet.isAtomHidden(atomB.getAtomIndex())) continue;
            int xA = atomA.screenX;
            int yA = atomA.screenY;
            int zA = atomA.screenZ;
            int xB = atomB.screenX;
            int yB = atomB.screenY;
            int zB = atomB.screenZ;
            short colixA = Graphics3D.getColixInherited(this.colixes[i], atomA.getColix());
            short colixB = Graphics3D.getColixInherited(this.colixes[i + 1], atomB.getColix());
            this.mad = this.mads[i];
            if (this.mad < 0) {
                this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
                continue;
            }
            short width = this.isGenerator ? this.mad : this.viewer.scaleToScreen((zA + zB) / 2, this.mad);
            this.g3d.fillCylinder(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }
}

