/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.JmolConstants;

public abstract class BioShapeCollection
extends Shape {
    Atom[] atoms;
    short madOn = (short)-2;
    short madHelixSheet = (short)3000;
    short madTurnRandom = (short)800;
    short madDnaRna = (short)5000;
    boolean isActive = false;
    BioShape[] bioShapes;

    public final void initModelSet() {
        this.isBioShape = true;
        this.atoms = this.modelSet.atoms;
        this.initialize();
    }

    public void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.initialize();
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape bioShape = this.bioShapes[i];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setMad(mad, bsSelected);
        }
    }

    public void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (propertyName == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])value)[1];
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape b = this.bioShapes[i];
                if (b.modelIndex > modelIndex) {
                    --b.modelIndex;
                    b.leadAtomIndices = b.bioPolymer.getLeadAtomIndices();
                    continue;
                }
                if (b.modelIndex != modelIndex) continue;
                this.bioShapes = (BioShape[])ArrayUtil.deleteElements(this.bioShapes, i, 1);
            }
            return;
        }
        this.initialize();
        if ("color" == propertyName) {
            byte pid = JmolConstants.pidOf(value);
            short colix = Graphics3D.getColix(value);
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape bioShape = this.bioShapes[i];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColix(colix, pid, bsSelected);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent".equals(value);
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape bioShape = this.bioShapes[i];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setTranslucent(isTranslucent, bsSelected, this.translucentLevel);
            }
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    public String getShapeState() {
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape bioShape = this.bioShapes[i];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setShapeState(temp, temp2);
        }
        return "\n" + BioShapeCollection.getShapeCommands(temp, temp2, this.modelSet.getAtomCount(), this.shapeID == 9 ? "Backbone" : "select");
    }

    void initialize() {
        int modelCount = this.modelSet.getModelCount();
        Model[] models = this.modelSet.getModels();
        int n = this.modelSet.getBioPolymerCount();
        BioShape[] shapes = new BioShape[n--];
        int i = modelCount;
        while (--i >= 0) {
            int j = this.modelSet.getBioPolymerCountInModel(i);
            while (--j >= 0) {
                shapes[n] = this.bioShapes == null || this.bioShapes.length <= n || this.bioShapes[n] == null ? new BioShape(this, i, (BioPolymer)models[i].getBioPolymer(j)) : this.bioShapes[n];
                --n;
            }
        }
        this.bioShapes = shapes;
    }

    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest) {
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape b = this.bioShapes[i];
            b.bioPolymer.findNearestAtomIndex(xMouse, yMouse, closest, this.bioShapes[i].mads, this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bs) {
        if (this.bioShapes == null) {
            return;
        }
        bs = BitSetUtil.copy(bs);
        int i = this.modelSet.getModelCount();
        while (--i >= 0) {
            if (!bs.get(i) || !this.modelSet.isTrajectory(i)) continue;
            bs.set(this.modelSet.getTrajectoryIndex(i));
        }
        i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape b = this.bioShapes[i];
            b.modelVisibilityFlags = bs.get(b.modelIndex) ? this.myVisibilityFlag : 0;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int i = this.bioShapes.length;
        while (--i >= 0) {
            this.bioShapes[i].setModelClickability();
        }
    }

    int getMpsShapeCount() {
        return this.bioShapes.length;
    }

    BioShape getBioShape(int i) {
        return this.bioShapes[i];
    }
}

