/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.shapebio.TraceRenderer;

abstract class BioShapeRenderer
extends MeshRenderer {
    private boolean invalidateMesh;
    private boolean invalidateSheets;
    private boolean isHighRes;
    private boolean isTraceAlpha;
    private boolean ribbonBorder = false;
    private boolean haveControlPointScreens;
    private int aspectRatio;
    private int hermiteLevel;
    private float sheetSmoothing;
    private Mesh[] meshes;
    private boolean[] meshReady;
    protected int monomerCount;
    protected Monomer[] monomers;
    protected boolean isNucleic;
    protected boolean isCarbohydrate;
    protected BitSet bsVisible = new BitSet();
    protected Point3i[] ribbonTopScreens;
    protected Point3i[] ribbonBottomScreens;
    protected Point3f[] controlPoints;
    protected Point3i[] controlPointScreens;
    protected int[] leadAtomIndices;
    protected Vector3f[] wingVectors;
    protected short[] mads;
    protected short[] colixes;
    protected byte[] structureTypes;
    private final Point3f pointT = new Point3f();
    private int iPrev;
    private int iNext;
    private int iNext2;
    private int iNext3;
    private int diameterBeg;
    private int diameterMid;
    private int diameterEnd;
    private boolean doCap0;
    private boolean doCap1;
    private final Point3i screenArrowTop = new Point3i();
    private final Point3i screenArrowTopPrev = new Point3i();
    private final Point3i screenArrowBot = new Point3i();
    private final Point3i screenArrowBotPrev = new Point3i();
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private Point3f[] controlHermites;
    private Vector3f[] wingHermites;
    private Point3f[] radiusHermites;
    private Vector3f norm = new Vector3f();
    private final Vector3f Z = new Vector3f(0.1345f, 0.5426f, 0.3675f);
    private final Vector3f wing = new Vector3f();
    private final Vector3f wing0 = new Vector3f();
    private final Vector3f wing1 = new Vector3f();
    private final Vector3f wingT = new Vector3f();
    private final AxisAngle4f aa = new AxisAngle4f();
    private final Point3f pt = new Point3f();
    private final Point3f pt1 = new Point3f();
    private final Point3f ptPrev = new Point3f();
    private final Point3f ptNext = new Point3f();
    private final Matrix3f mat = new Matrix3f();

    BioShapeRenderer() {
    }

    protected abstract void renderBioShape(BioShape var1);

    protected void render() {
        boolean TF;
        if (this.shape == null) {
            return;
        }
        this.invalidateMesh = false;
        boolean bl = TF = this.isGenerator || this.viewer.getHighResolution();
        if (TF != this.isHighRes) {
            this.invalidateMesh = true;
        }
        this.isHighRes = TF;
        int val = this.viewer.getRibbonAspectRatio();
        if ((val = Math.min(Math.max(0, val), 20)) != this.aspectRatio && val != 0) {
            this.invalidateMesh = true;
        }
        this.aspectRatio = val;
        val = this.viewer.getHermiteLevel();
        if (val == 0 && !this.g3d.canDoTriangles()) {
            val = 1;
        }
        int n = val <= 0 ? -val : (val = this.viewer.getInMotion() ? 0 : val);
        if (val != this.hermiteLevel && val != 0) {
            this.invalidateMesh = true;
        }
        this.hermiteLevel = Math.min(val, 8);
        if (this.hermiteLevel == 0) {
            this.aspectRatio = 0;
        }
        if ((TF = this.viewer.getTraceAlpha()) != this.isTraceAlpha) {
            this.invalidateMesh = true;
        }
        this.isTraceAlpha = TF;
        this.invalidateSheets = false;
        float fval = this.viewer.getSheetSmoothing();
        if (fval != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = fval;
            this.invalidateMesh = true;
            this.invalidateSheets = true;
        }
        BioShapeCollection mps = (BioShapeCollection)this.shape;
        this.g3d.startShapeBuffer();
        int c = mps.bioShapes.length;
        while (--c >= 0) {
            BioShape bioShape = mps.getBioShape(c);
            if ((bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || bioShape.monomerCount < 2 || !this.initializePolymer(bioShape)) continue;
            this.renderBioShape(bioShape);
            this.freeTempArrays();
        }
        this.g3d.endShapeBuffer();
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.viewer.freeTempScreens(this.controlPointScreens);
        }
        this.viewer.freeTempBytes(this.structureTypes);
    }

    private boolean initializePolymer(BioShape bioShape) {
        this.controlPoints = this.viewer.isJmolDataFrame(bioShape.modelIndex) ? bioShape.bioPolymer.getControlPoints(true, 0.0f, false) : bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing, this.invalidateSheets);
        this.monomerCount = bioShape.monomerCount;
        this.monomers = bioShape.monomers;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clear();
        boolean haveVisible = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            if (this.invalidateMesh) {
                bioShape.falsifyMesh(i, false);
            }
            if ((this.monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(this.leadAtomIndices[i])) continue;
            Atom lead = this.modelSet.atoms[this.leadAtomIndices[i]];
            if (!this.g3d.isInDisplayRange(lead.screenX, lead.screenY)) continue;
            this.bsVisible.set(i);
            haveVisible = true;
        }
        if (!haveVisible) {
            return false;
        }
        this.ribbonBorder = this.viewer.getRibbonBorder();
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.viewer.allocTempBytes(this.monomerCount + 1);
        int i = this.monomerCount;
        while (--i >= 0) {
            this.structureTypes[i] = this.monomers[i].getProteinStructureType();
            if (this.structureTypes[i] != 1) continue;
            this.structureTypes[i] = 0;
        }
        this.structureTypes[this.monomerCount] = this.structureTypes[this.monomerCount - 1];
    }

    protected boolean isHelix(int i) {
        return this.structureTypes[i] == 3;
    }

    protected void calcScreenControlPoints() {
        this.calcScreenControlPoints(this.controlPoints);
    }

    protected void calcScreenControlPoints(Point3f[] points) {
        int count = this.monomerCount + 1;
        this.controlPointScreens = this.viewer.allocTempScreens(count);
        int i = count;
        while (--i >= 0) {
            this.viewer.transformPoint(points[i], this.controlPointScreens[i]);
        }
        this.haveControlPointScreens = true;
    }

    protected Point3i[] calcScreens(float offsetFraction) {
        int count = this.controlPoints.length;
        Point3i[] screens = this.viewer.allocTempScreens(count);
        if (offsetFraction == 0.0f) {
            int i = count;
            while (--i >= 0) {
                this.viewer.transformPoint(this.controlPoints[i], screens[i]);
            }
        } else {
            float offset_1000 = offsetFraction / 1000.0f;
            int i = count;
            while (--i >= 0) {
                this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.mads[i] == 0 && i > 0 ? this.mads[i - 1] : this.mads[i], offset_1000, screens[i]);
            }
        }
        return screens;
    }

    private void calc1Screen(Point3f center, Vector3f vector, short mad, float offset_1000, Point3i screen) {
        this.pointT.set(vector);
        float scale = (float)mad * offset_1000;
        this.pointT.scaleAdd(scale, center);
        this.viewer.transformPoint(this.pointT, screen);
    }

    protected short getLeadColix(int i) {
        return Graphics3D.getColixInherited(this.colixes[i], this.monomers[i].getLeadAtom().getColix());
    }

    private void setNeighbors(int i) {
        this.iPrev = Math.max(i - 1, 0);
        this.iNext = Math.min(i + 1, this.monomerCount);
        this.iNext2 = Math.min(i + 2, this.monomerCount);
        this.iNext3 = Math.min(i + 3, this.monomerCount);
    }

    protected void renderHermiteCylinder(Point3i[] screens, int i) {
        this.colix = this.getLeadColix(i);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.setNeighbors(i);
        this.g3d.drawHermite(this.isNucleic ? 4 : 7, screens[this.iPrev], screens[i], screens[this.iNext], screens[this.iNext2]);
    }

    private boolean setMads(int i, boolean thisTypeOnly) {
        this.madBeg = this.madEnd = this.mads[i];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.doCap0 = i == this.iPrev || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iPrev];
        this.doCap1 = this.iNext == this.iNext2 || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iNext];
        this.diameterBeg = this.viewer.scaleToScreen(this.controlPointScreens[i].z, this.madBeg);
        this.diameterMid = this.viewer.scaleToScreen(this.monomers[i].getLeadAtom().screenZ, this.madMid);
        this.diameterEnd = this.viewer.scaleToScreen(this.controlPointScreens[this.iNext].z, this.madEnd);
        return this.aspectRatio > 0 && (this.checkDiameter(this.diameterBeg) || this.checkDiameter(this.diameterMid) || this.checkDiameter(this.diameterEnd));
    }

    private boolean checkDiameter(int d) {
        return this.isHighRes & d > 3 || d >= 8;
    }

    protected void renderHermiteConic(int i, boolean thisTypeOnly) {
        this.setNeighbors(i);
        this.colix = this.getLeadColix(i);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (this.setMads(i, thisTypeOnly)) {
            try {
                if (!(this.meshes[i] != null && this.meshReady[i] || this.createMeshCylinder(i, this.madBeg, this.madMid, this.madEnd, 1))) {
                    return;
                }
                this.meshes[i].setColix(this.colix);
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error hermiteConic: " + e.toString());
            }
        }
        this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[i], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
    }

    protected void renderHermiteRibbon(boolean doFill, int i, boolean thisTypeOnly) {
        this.setNeighbors(i);
        this.colix = this.getLeadColix(i);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (doFill && this.aspectRatio != 0 && this.setMads(i, thisTypeOnly)) {
            try {
                if (!(this.meshes[i] != null && this.meshReady[i] || this.createMeshCylinder(i, this.madBeg, this.madMid, this.madEnd, this.aspectRatio))) {
                    return;
                }
                this.meshes[i].setColix(this.colix);
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error hermiteRibbon: " + e.toString());
            }
        }
        this.g3d.drawHermite(doFill, this.ribbonBorder, this.isNucleic ? 4 : 7, this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[i], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[i], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], this.aspectRatio);
    }

    protected void renderHermiteArrowHead(int i) {
        this.colix = this.getLeadColix(i);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.setNeighbors(i);
        if (this.setMads(i, false)) {
            try {
                this.doCap0 = true;
                this.doCap1 = false;
                if (!(this.meshes[i] != null && this.meshReady[i] || this.createMeshCylinder(i, (int)((double)this.madBeg * 1.2), (int)((double)this.madBeg * 0.6), 0, this.aspectRatio >> 1))) {
                    return;
                }
                this.meshes[i].setColix(this.colix);
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error hermiteArrowHead: " + e.toString());
            }
        }
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.aspectRatio);
        if (this.ribbonBorder && this.aspectRatio == 0) {
            this.g3d.fillCylinder(this.colix, this.colix, (byte)3, this.isGenerator ? 50 : 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
    }

    protected void renderCone(int i, Point3f pointBegin, Point3f pointEnd, Point3f screenPtBegin, Point3f screenPtEnd) {
        int coneDiameter = this.mad + (this.mad >> 2);
        coneDiameter = this.viewer.scaleToScreen((int)Math.floor(screenPtBegin.z), coneDiameter);
        this.g3d.fillCone((byte)2, coneDiameter, screenPtBegin, screenPtEnd);
    }

    private boolean createMeshCylinder(int i, int madBeg, int madMid, int madEnd, int aspectRatio) {
        int k;
        boolean variableRadius;
        this.setNeighbors(i);
        if (this.controlPoints[i].distance(this.controlPoints[this.iNext]) == 0.0f) {
            return false;
        }
        if (this.isHelix(i)) {
            ProteinStructure p = ((AlphaMonomer)this.monomers[i]).getProteinStructure();
            p.calcAxis();
        }
        boolean isEccentric = aspectRatio != 1 && this.wingVectors != null;
        int nHermites = (this.hermiteLevel + 1) * 2 + 1;
        int nPer = (nHermites - 1) * 2 - 2;
        Mesh mesh = this.meshes[i] = new Mesh("mesh_" + this.shapeID + "_" + i, this.g3d, 0);
        boolean bl = variableRadius = madBeg != madMid || madMid != madEnd;
        if (this.controlHermites == null || this.controlHermites.length < nHermites + 1) {
            this.controlHermites = new Point3f[nHermites + 1];
        }
        Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.controlPoints[this.iPrev], this.controlPoints[i], this.controlPoints[this.iNext], this.controlPoints[this.iNext2], this.controlPoints[this.iNext3], this.controlHermites, 0, nHermites);
        if (isEccentric) {
            if (this.wingHermites == null || this.wingHermites.length < nHermites + 1) {
                this.wingHermites = new Vector3f[nHermites + 1];
            }
            this.wing.set(this.wingVectors[this.iPrev]);
            if (madEnd == 0) {
                this.wing.scale(2.0f);
            }
            Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.wing, this.wingVectors[i], this.wingVectors[this.iNext], this.wingVectors[this.iNext2], this.wingVectors[this.iNext3], this.wingHermites, 0, nHermites);
        }
        float radius1 = (float)madBeg / 2000.0f;
        float radius2 = (float)madMid / 2000.0f;
        float radius3 = (float)madEnd / 2000.0f;
        if (variableRadius) {
            if (this.radiusHermites == null || this.radiusHermites.length < (nHermites + 1 >> 1) + 1) {
                this.radiusHermites = new Point3f[(nHermites + 1 >> 1) + 1];
            }
            this.ptPrev.set(radius1, radius1, 0.0f);
            this.pt.set(radius1, radius2, 0.0f);
            this.pt1.set(radius2, radius3, 0.0f);
            this.ptNext.set(radius3, radius3, 0.0f);
            Graphics3D.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, nHermites + 1 >> 1);
        }
        if (!isEccentric) {
            this.norm.sub(this.controlHermites[1], this.controlHermites[0]);
            this.wing0.cross(this.norm, this.Z);
            this.wing0.cross(this.norm, this.wing0);
        }
        int nPoints = 0;
        int iMid = nHermites >> 1;
        for (int p = 0; p < nHermites; ++p) {
            int k2;
            this.norm.sub(this.controlHermites[p + 1], this.controlHermites[p]);
            if (isEccentric) {
                this.wing.set(this.wingHermites[p]);
                this.wing1.set(this.wing);
                this.wing.scale(2.0f / (float)aspectRatio);
            } else {
                this.wing.cross(this.norm, this.wing0);
                this.wing.normalize();
            }
            float scale = !variableRadius ? radius1 : (p < iMid ? this.radiusHermites[p].x : this.radiusHermites[p - iMid].y);
            this.wing.scale(scale);
            this.wing1.scale(scale);
            this.aa.set(this.norm, (float)(Math.PI * 2 / (double)nPer));
            this.mat.set(this.aa);
            this.pt1.set(this.controlHermites[p]);
            for (k2 = 0; k2 < nPer; ++k2) {
                this.mat.transform(this.wing);
                this.wingT.set(this.wing);
                if (isEccentric) {
                    if (k2 == (nPer + 2) / 4 || k2 == (3 * nPer + 2) / 4) {
                        this.wing1.scale(-1.0f);
                    }
                    this.wingT.add(this.wing1);
                }
                this.pt.add(this.pt1, this.wingT);
                if (isEccentric) {
                    // empty if block
                }
                mesh.addVertexCopy(this.pt);
            }
            if (p > 0) {
                for (k2 = 0; k2 < nPer; ++k2) {
                    mesh.addQuad(nPoints - nPer + k2, nPoints - nPer + (k2 + 1) % nPer, nPoints + (k2 + 1) % nPer, nPoints + k2);
                }
            }
            nPoints += nPer;
        }
        if (this.doCap0) {
            k = this.hermiteLevel * 2;
            while (--k >= 0) {
                mesh.addQuad(k + 2, k + 1, (nPer - k) % nPer, nPer - k - 1);
            }
        }
        if (this.doCap1) {
            k = this.hermiteLevel * 2;
            while (--k >= 0) {
                mesh.addQuad(nPoints - k - 1, nPoints - nPer + (nPer - k) % nPer, nPoints - nPer + k + 1, nPoints - nPer + k + 2);
            }
        }
        mesh.initialize(1073741843);
        mesh.setVisibilityFlags(1);
        this.meshReady[i] = true;
        return true;
    }
}

