/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.util.ArrayUtil;

public class DrawMesh
extends Mesh {
    BitSet modelFlags;
    int drawType = 3;
    int[] drawTypes;
    Point3f[] ptCenters;
    Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    Vector3f[] axes;
    int drawVertexCount;
    int[] drawVertexCounts;
    boolean isFixed;
    boolean isVector;
    float drawArrowScale;
    boolean nohead;

    DrawMesh(String thisID, Graphics3D g3d, short colix) {
        super(thisID, g3d, colix);
    }

    final void setCenter(int iModel) {
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        int iptlast = -1;
        int ipt = 0;
        int n = 0;
        int i = this.polygonCount;
        while (--i >= 0) {
            if (iModel >= 0 && i != iModel || this.polygonIndexes[i] == null) continue;
            iptlast = -1;
            int iV = this.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = this.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                center.add(this.vertices[ipt]);
                ++n;
            }
            if (n <= 0 || i != iModel && i != 0) continue;
            center.scale(1.0f / (float)n);
            break;
        }
        if (iModel < 0) {
            this.ptCenter = center;
        } else {
            this.ptCenters[iModel] = center;
        }
    }

    void offset(Vector3f offset) {
        int i = this.vertexCount;
        while (--i >= 0) {
            this.vertices[i].add(offset);
        }
        if (this.ptCenters != null) {
            i = this.ptCenters.length;
            while (--i >= 0) {
                this.ptCenters[i].add(offset);
            }
        }
        if (this.ptCenter != null) {
            this.ptCenter.add(offset);
        }
    }

    public void deleteAtoms(int modelIndex) {
        if (modelIndex >= this.polygonCount) {
            return;
        }
        --this.polygonCount;
        this.polygonIndexes = (int[][])ArrayUtil.deleteElements(this.polygonIndexes, modelIndex, 1);
        this.drawTypes = (int[])ArrayUtil.deleteElements(this.drawTypes, modelIndex, 1);
        this.drawVertexCounts = (int[])ArrayUtil.deleteElements(this.drawVertexCounts, modelIndex, 1);
        this.ptCenters = (Point3f[])ArrayUtil.deleteElements(this.ptCenters, modelIndex, 1);
        this.axes = (Vector3f[])ArrayUtil.deleteElements(this.axes, modelIndex, 1);
        this.title = (String[])ArrayUtil.deleteElements(this.title, modelIndex, 1);
    }
}

