/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.AtomShape;
import org.jmol.util.Escape;
import org.jmol.util.Quadric;

public class Ellipsoids
extends AtomShape {
    Hashtable htEllipsoids = new Hashtable();
    boolean haveEllipsoids;
    Ellipsoid ellipsoid;
    private static float[] crtval = new float[]{0.3389f, 0.4299f, 0.4951f, 0.5479f, 0.5932f, 0.6334f, 0.6699f, 0.7035f, 0.7349f, 0.7644f, 0.7924f, 0.8192f, 0.8447f, 0.8694f, 0.8932f, 0.9162f, 0.9386f, 0.9605f, 0.9818f, 1.0026f, 1.023f, 1.043f, 1.0627f, 1.0821f, 1.1012f, 1.12f, 1.1386f, 1.157f, 1.1751f, 1.1932f, 1.211f, 1.2288f, 1.2464f, 1.2638f, 1.2812f, 1.2985f, 1.3158f, 1.333f, 1.3501f, 1.3672f, 1.3842f, 1.4013f, 1.4183f, 1.4354f, 1.4524f, 1.4695f, 1.4866f, 1.5037f, 1.5209f, 1.5382f, 1.5555f, 1.5729f, 1.5904f, 1.608f, 1.6257f, 1.6436f, 1.6616f, 1.6797f, 1.698f, 1.7164f, 1.7351f, 1.754f, 1.773f, 1.7924f, 1.8119f, 1.8318f, 1.8519f, 1.8724f, 1.8932f, 1.9144f, 1.936f, 1.958f, 1.9804f, 2.0034f, 2.0269f, 2.051f, 2.0757f, 2.1012f, 2.1274f, 2.1544f, 2.1824f, 2.2114f, 2.2416f, 2.273f, 2.3059f, 2.3404f, 2.3767f, 2.4153f, 2.4563f, 2.5003f, 2.5478f, 2.5997f, 2.6571f, 2.7216f, 2.7955f, 2.8829f, 2.9912f, 3.1365f, 3.3682f};

    public int getIndexFromName(String thisID) {
        this.ellipsoid = (Ellipsoid)this.htEllipsoids.get(thisID);
        return this.ellipsoid == null ? -1 : 1;
    }

    public void setSize(int size, BitSet bsSelected) {
        super.setSize(size, bsSelected);
        if (size == 0) {
            return;
        }
        float factor = Ellipsoids.getRadius(size);
        int i = this.atomCount;
        while (--i >= 0) {
            Object[] ellipsoid;
            if (bsSelected != null && !bsSelected.get(i) || (ellipsoid = this.atoms[i].getEllipsoid()) == null) continue;
            float[] lengths = (float[])ellipsoid[1];
            int j = 3;
            while (--j >= 0) {
                lengths[j + 3] = lengths[j] * factor;
            }
            if (ellipsoid[0] != null) continue;
            lengths[3] = lengths[5] = lengths[4];
        }
    }

    public void setProperty(String propertyName, Object value, BitSet bs) {
        if (propertyName == "thisID") {
            Ellipsoid ellipsoid = this.ellipsoid = value == null ? null : (Ellipsoid)this.htEllipsoids.get((String)value);
            if (value == null) {
                return;
            }
            if (this.ellipsoid == null) {
                String id = (String)value;
                this.ellipsoid = new Ellipsoid(id, this.viewer.getCurrentModelIndex());
                this.htEllipsoids.put(id, this.ellipsoid);
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            Enumeration e = this.htEllipsoids.keys();
            while (e.hasMoreElements()) {
                String id = (String)e.nextElement();
                Ellipsoid ellipsoid = (Ellipsoid)this.htEllipsoids.get(id);
                if (ellipsoid.modelIndex > modelIndex) {
                    --ellipsoid.modelIndex;
                    continue;
                }
                if (ellipsoid.modelIndex != modelIndex) continue;
                this.htEllipsoids.remove(id);
            }
            this.ellipsoid = null;
            return;
        }
        if (this.ellipsoid != null) {
            this.haveEllipsoids = true;
            if ("delete" == propertyName) {
                this.htEllipsoids.remove(this.ellipsoid.id);
                return;
            }
            if ("modelindex" == propertyName) {
                this.ellipsoid.modelIndex = (Integer)value;
                return;
            }
            if ("on" == propertyName) {
                this.ellipsoid.isOn = (Boolean)value;
                return;
            }
            if ("axes" == propertyName) {
                int i;
                this.ellipsoid.isValid = false;
                this.ellipsoid.axes = (Vector3f[])value;
                this.ellipsoid.lengths = new float[3];
                this.ellipsoid.scale = 1.0f;
                for (i = 0; i < 2; ++i) {
                    if (!(this.ellipsoid.axes[i].length() > this.ellipsoid.axes[i + 1].length())) continue;
                    Vector3f v = this.ellipsoid.axes[i];
                    this.ellipsoid.axes[i] = this.ellipsoid.axes[i + 1];
                    this.ellipsoid.axes[i + 1] = v;
                    if (i != 1) continue;
                    i = -1;
                }
                for (i = 0; i < 3; ++i) {
                    this.ellipsoid.lengths[i] = this.ellipsoid.axes[i].length();
                    if (this.ellipsoid.lengths[i] == 0.0f) {
                        return;
                    }
                    this.ellipsoid.axes[i].normalize();
                }
                if (Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f) {
                    return;
                }
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("equation" == propertyName) {
                this.ellipsoid.coef = (double[])value;
                this.ellipsoid.axes = new Vector3f[3];
                this.ellipsoid.lengths = new float[3];
                Quadric.getAxesForEllipsoid(this.ellipsoid.coef, this.ellipsoid.axes, this.ellipsoid.lengths);
                return;
            }
            if ("center" == propertyName) {
                this.ellipsoid.center = (Point3f)value;
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("scale" == propertyName) {
                float scale = ((Float)value).floatValue();
                if (scale <= 0.0f || this.ellipsoid.lengths == null) {
                    this.ellipsoid.isValid = false;
                } else {
                    int i = 0;
                    while (i < 3) {
                        int n = i++;
                        this.ellipsoid.lengths[n] = this.ellipsoid.lengths[n] * (scale / this.ellipsoid.scale);
                    }
                    this.ellipsoid.scale = scale;
                    this.updateEquation(this.ellipsoid);
                }
                return;
            }
            if ("color" == propertyName) {
                this.ellipsoid.colix = Graphics3D.getColix(value);
                return;
            }
            if ("translucentLevel" == propertyName) {
                super.setProperty(propertyName, value, bs);
                return;
            }
            if ("translucency" == propertyName) {
                boolean isTranslucent = value.equals("translucent");
                this.ellipsoid.colix = Graphics3D.getColixTranslucent(this.ellipsoid.colix, isTranslucent, this.translucentLevel);
                return;
            }
        }
        super.setProperty(propertyName, value, bs);
    }

    private void updateEquation(Ellipsoid ellipsoid) {
        if (ellipsoid.axes == null || ellipsoid.lengths == null) {
            return;
        }
        Matrix3f mat = new Matrix3f();
        Matrix3f mTemp = new Matrix3f();
        Vector3f v1 = new Vector3f();
        ellipsoid.coef = new double[10];
        Quadric.getEquationForQuadricWithCenter(ellipsoid.center.x, ellipsoid.center.y, ellipsoid.center.z, mat, v1, mTemp, ellipsoid.coef, null);
        ellipsoid.isValid = true;
    }

    public String getShapeState() {
        Enumeration e = this.htEllipsoids.elements();
        StringBuffer sb = new StringBuffer();
        Vector3f v1 = new Vector3f();
        while (e.hasMoreElements()) {
            Ellipsoid ellipsoid = (Ellipsoid)e.nextElement();
            if (ellipsoid.axes == null || ellipsoid.lengths == null) continue;
            sb.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").append(ellipsoid.modelIndex).append(" center ").append(Escape.escape(ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                v1.set(ellipsoid.axes[i]);
                v1.scale(ellipsoid.lengths[i]);
                sb.append(" ").append(Escape.escape(v1));
            }
            sb.append(" " + this.getColorCommand("", (byte)-1, ellipsoid.colix));
            if (!ellipsoid.isOn) {
                sb.append(" off");
            }
            sb.append(";\n");
        }
        if (this.isActive) {
            Hashtable temp = new Hashtable();
            Hashtable temp2 = new Hashtable();
            int i = this.atomCount;
            while (--i >= 0) {
                if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                    Ellipsoids.setStateInfo(temp, i, "Ellipsoids " + this.mads[i]);
                }
                if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
                Ellipsoids.setStateInfo(temp2, i, this.getColorCommand("Ellipsoids", this.paletteIDs[i], this.colixes[i]));
            }
            sb.append(Ellipsoids.getShapeCommands(temp, temp2, this.atomCount));
        }
        return sb.toString();
    }

    public void setVisibilityFlags(BitSet bs) {
        Enumeration e = this.htEllipsoids.elements();
        while (e.hasMoreElements()) {
            Ellipsoid ellipsoid = (Ellipsoid)e.nextElement();
            ellipsoid.visible = ellipsoid.isOn && (ellipsoid.modelIndex < 0 || bs.get(ellipsoid.modelIndex));
        }
    }

    static final float getRadius(int prob) {
        return crtval[prob < 1 ? 0 : (prob > 99 ? 98 : prob - 1)];
    }

    static class Ellipsoid {
        String id;
        Vector3f[] axes;
        float[] lengths;
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        double[] coef;
        short colix = (short)23;
        int modelIndex;
        float scale = 1.0f;
        boolean visible;
        boolean isValid;
        boolean isOn = true;

        Ellipsoid(String id, int modelIndex) {
            this.id = id;
            this.modelIndex = modelIndex;
        }
    }
}

