/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3i;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.geodesic.Geodesic;
import org.jmol.shape.DotsRenderer;
import org.jmol.shapespecial.GeoSurface;

public class GeoSurfaceRenderer
extends DotsRenderer {
    private Point3i facePt1 = new Point3i();
    private Point3i facePt2 = new Point3i();
    private Point3i facePt3 = new Point3i();

    protected void render() {
        GeoSurface gs = (GeoSurface)this.shape;
        boolean bl = this.iShowSolid = !this.viewer.getInMotion() || gs.ec.getDotsConvexMax() <= 100;
        if (!this.iShowSolid && !this.g3d.setColix((short)4)) {
            return;
        }
        if (this.iShowSolid && this.faceMap == null) {
            this.faceMap = new int[this.screenDotCount];
        }
        this.render1(gs);
    }

    protected void renderConvex(short colix, int[] visibilityMap, int nPoints) {
        this.colix = colix;
        if (this.iShowSolid) {
            if (this.g3d.setColix(colix)) {
                this.renderSurface(visibilityMap);
            }
            return;
        }
        this.renderDots(nPoints);
    }

    private void renderSurface(int[] points) {
        if (this.faceMap == null) {
            return;
        }
        short[] faces = Geodesic.getFaceVertexes(this.screenLevel);
        int[] coords = this.screenCoordinates;
        int mapMax = points.length << 5;
        if (this.screenDotCount < mapMax) {
            mapMax = this.screenDotCount;
        }
        int f = 0;
        while (f < faces.length) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            if (p1 >= mapMax || p2 >= mapMax || p3 >= mapMax || !EnvelopeCalculation.getBit(points, p1) || !EnvelopeCalculation.getBit(points, p2) || !EnvelopeCalculation.getBit(points, p3)) continue;
            this.facePt1.set(coords[this.faceMap[p1]], coords[this.faceMap[p1] + 1], coords[this.faceMap[p1] + 2]);
            this.facePt2.set(coords[this.faceMap[p2]], coords[this.faceMap[p2] + 1], coords[this.faceMap[p2] + 2]);
            this.facePt3.set(coords[this.faceMap[p3]], coords[this.faceMap[p3] + 1], coords[this.faceMap[p3] + 2]);
            if (!this.isGenerator) {
                this.g3d.calcSurfaceShade(this.facePt1, this.facePt2, this.facePt3);
            }
            this.g3d.fillTriangle(this.facePt1, this.colix, p1, this.facePt2, this.colix, p2, this.facePt3, this.colix, p3);
        }
    }
}

